/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.core.CollectingNameValidator;
import org.jetbrains.kotlin.idea.core.KotlinNameSuggester;
import org.jetbrains.kotlin.idea.core.NewDeclarationNameValidator;
import org.jetbrains.kotlin.idea.inspections.IncompleteDestructuringInspectionKt;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/IncompleteDestructuringQuickfix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "Companion", "kotlin.idea"})
public final class IncompleteDestructuringQuickfix
implements LocalQuickFix {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("incomplete.destructuring.fix.family.name", new Object[0]);
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement2 = descriptor2.getPsiElement();
        if (!(psiElement2 instanceof KtDestructuringDeclaration)) {
            psiElement2 = null;
        }
        KtDestructuringDeclaration ktDestructuringDeclaration = (KtDestructuringDeclaration)psiElement2;
        if (ktDestructuringDeclaration == null) {
            return;
        }
        KtDestructuringDeclaration destructuringDeclaration = ktDestructuringDeclaration;
        Companion.addMissingEntries(destructuringDeclaration);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/IncompleteDestructuringQuickfix$Companion;", "", "()V", "addMissingEntries", "", "destructuringDeclaration", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "kotlin.idea"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        public final void addMissingEntries(@NotNull KtDestructuringDeclaration destructuringDeclaration) {
            String name2;
            void $this$mapTo$iv$iv;
            List $this$map$iv;
            Object element$iv2;
            boolean bl;
            List currentEntries;
            KtPsiFactory psiFactory;
            CollectingNameValidator nameValidator2;
            List primaryParameters;
            block10: {
                Intrinsics.checkNotNullParameter((Object)destructuringDeclaration, (String)"destructuringDeclaration");
                List list2 = IncompleteDestructuringInspectionKt.access$primaryParameters(destructuringDeclaration);
                if (list2 == null) {
                    return;
                }
                primaryParameters = list2;
                PsiElement psiElement2 = destructuringDeclaration.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"destructuringDeclaration.parent");
                nameValidator2 = new CollectingNameValidator(null, new NewDeclarationNameValidator(psiElement2, null, NewDeclarationNameValidator.Target.VARIABLES, null, 8, null), 1, null);
                psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)destructuringDeclaration), (boolean)false, (int)2, null);
                List list3 = destructuringDeclaration.getEntries();
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"destructuringDeclaration.entries");
                currentEntries = list3;
                Iterable $this$any$iv = currentEntries;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        KtDestructuringDeclarationEntry it = (KtDestructuringDeclarationEntry)element$iv2;
                        boolean bl2 = false;
                        KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry = it;
                        Intrinsics.checkNotNullExpressionValue((Object)ktDestructuringDeclarationEntry, (String)"it");
                        if (!(ktDestructuringDeclarationEntry.getTypeReference() != null)) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            }
            boolean hasType = bl;
            Iterable $i$f$any = CollectionsKt.drop((Iterable)primaryParameters, (int)currentEntries.size());
            boolean $i$f$map = false;
            element$iv2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Object object;
                void it;
                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                String string = it.getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name.asString()");
                name2 = KotlinNameSuggester.INSTANCE.suggestNameByName(string, (Function1<? super String, Boolean>)((Function1)nameValidator2));
                if (hasType) {
                    KotlinType kotlinType = it.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"it.type");
                    String type2 = IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_NO_ANNOTATIONS.renderType(kotlinType);
                    object = name2 + ": " + type2;
                } else {
                    object = name2;
                }
                String string2 = object;
                collection.add(string2);
            }
            List it = $this$map$iv = (List)destination$iv$iv;
            boolean bl4 = false;
            List list4 = psiFactory.createDestructuringDeclaration("val (" + CollectionsKt.joinToString$default((Iterable)it, null, null, null, (int)0, null, null, (int)63, null) + ") = TODO()").getEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"primaryParameters\n      \u2026()}) = TODO()\").entries }");
            List additionalEntries = list4;
            PsiElement rPar = destructuringDeclaration.getRPar();
            boolean hasTrailingComma = destructuringDeclaration.getTrailingComma() != null;
            boolean currentEntriesIsEmpty = currentEntries.isEmpty();
            Iterable $this$forEachIndexed$iv = additionalEntries;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void entry;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                name2 = (KtDestructuringDeclarationEntry)item$iv;
                int index2 = n;
                boolean bl5 = false;
                if (index2 != 0 || !hasTrailingComma && !currentEntriesIsEmpty) {
                    destructuringDeclaration.addBefore(psiFactory.createComma(), rPar);
                }
                destructuringDeclaration.addBefore((PsiElement)entry, rPar);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

