/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.intentions.AddNamesInCommentToJavaCallArgumentsIntention;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/InconsistentCommentForJavaParameterInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "CorrectNamesInCommentsToJavaCallArgumentsFix", "kotlin.idea"})
public final class InconsistentCommentForJavaParameterInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new KtVisitorVoid(holder){
            final /* synthetic */ ProblemsHolder $holder;

            public void visitCallExpression(@NotNull KtCallExpression callExpression2) {
                Intrinsics.checkNotNullParameter((Object)callExpression2, (String)"callExpression");
                this.check((KtCallElement)callExpression2);
            }

            public void visitSuperTypeCallEntry(@NotNull KtSuperTypeCallEntry call) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                this.check((KtCallElement)call);
            }

            public void visitConstructorDelegationCall(@NotNull KtConstructorDelegationCall call) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                this.check((KtCallElement)call);
            }

            public void visitAnnotationEntry(@NotNull KtAnnotationEntry annotationEntry2) {
                Intrinsics.checkNotNullParameter((Object)annotationEntry2, (String)"annotationEntry");
                this.check((KtCallElement)annotationEntry2);
            }

            /*
             * WARNING - void declaration
             */
            private final void check(KtCallElement $this$check) {
                List<Pair<KtValueArgument, ValueParameterDescriptor>> list2 = AddNamesInCommentToJavaCallArgumentsIntention.Companion.resolveValueParameterDescriptors($this$check, false);
                if (list2 == null) {
                    return;
                }
                List<Pair<KtValueArgument, ValueParameterDescriptor>> valueDescriptorByValueArgument = list2;
                for (Pair<KtValueArgument, ValueParameterDescriptor> pair : valueDescriptorByValueArgument) {
                    PsiComment comment2;
                    void argument2;
                    KtValueArgument ktValueArgument = (KtValueArgument)pair.component1();
                    ValueParameterDescriptor descriptor2 = (ValueParameterDescriptor)pair.component2();
                    if (AddNamesInCommentToJavaCallArgumentsIntention.Companion.blockCommentWithName((KtValueArgument)argument2) == null) {
                        continue;
                    }
                    String commentedParameterName = AddNamesInCommentToJavaCallArgumentsIntention.Companion.toCommentedParameterName(descriptor2);
                    if (Intrinsics.areEqual((Object)commentedParameterName, (Object)comment2.getText())) continue;
                    PsiElement psiElement2 = (PsiElement)comment2;
                    Object[] objectArray = new Object[1];
                    String string = descriptor2.getName().asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"descriptor.name.asString()");
                    objectArray[0] = string;
                    this.$holder.registerProblem(psiElement2, KotlinBundle.message("inspection.message.inconsistent.parameter.name.for.0", objectArray), new LocalQuickFix[]{new CorrectNamesInCommentsToJavaCallArgumentsFix(commentedParameterName)});
                }
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/InconsistentCommentForJavaParameterInspection$CorrectNamesInCommentsToJavaCallArgumentsFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "commentedParameterName", "", "(Ljava/lang/String;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "kotlin.idea"})
    public static final class CorrectNamesInCommentsToJavaCallArgumentsFix
    implements LocalQuickFix {
        private final String commentedParameterName;

        @NotNull
        public String getName() {
            return KotlinBundle.message("intention.name.correct.parameter.name", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement $this$safeAs$iv = descriptor2.getPsiElement();
            boolean $i$f$safeAs = false;
            PsiElement psiElement2 = $this$safeAs$iv;
            if (!(psiElement2 instanceof PsiComment)) {
                psiElement2 = null;
            }
            PsiComment psiComment = (PsiComment)psiElement2;
            if (psiComment == null) {
                return;
            }
            PsiComment comment2 = psiComment;
            KtPsiFactory factory2 = new KtPsiFactory(project2, false, 2, null);
            comment2.replace((PsiElement)factory2.createComment(this.commentedParameterName));
        }

        public CorrectNamesInCommentsToJavaCallArgumentsFix(@NotNull String commentedParameterName) {
            Intrinsics.checkNotNullParameter((Object)commentedParameterName, (String)"commentedParameterName");
            this.commentedParameterName = commentedParameterName;
        }
    }
}

