/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LanguageInspectionSuppressors;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.KotlinInspectionSuppressor;
import org.jetbrains.kotlin.idea.inspections.KotlinRedundantDiagnosticSuppressInspectionKt;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/KotlinRedundantDiagnosticSuppressInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "kotlin.idea"})
public final class KotlinRedundantDiagnosticSuppressInspection
extends AbstractKotlinInspection {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        if (!(file2 instanceof KtFile)) {
            return null;
        }
        InspectionSuppressor suppressor = (InspectionSuppressor)LanguageInspectionSuppressors.INSTANCE.forLanguage(file2.getLanguage());
        if (!(suppressor instanceof KotlinInspectionSuppressor)) {
            return null;
        }
        MultiMap allSuppressedPlaces = KotlinRedundantDiagnosticSuppressInspectionKt.access$findAllSuppressedPlaces((KtFile)file2, (KotlinInspectionSuppressor)suppressor);
        if (allSuppressedPlaces.isEmpty()) {
            return null;
        }
        MultiMap allDiagnostics = KotlinRedundantDiagnosticSuppressInspectionKt.access$findAllDiagnostics((KtFile)file2, allSuppressedPlaces);
        List problems = new ArrayList();
        Iterator iterator = allSuppressedPlaces.entrySet().iterator();
        while (iterator.hasNext()) {
            void factoryName;
            Map.Entry entry;
            Map.Entry entry2 = entry = (Map.Entry)iterator.next();
            String string = (String)entry2.getKey();
            entry2 = entry;
            Collection suppressedPlaces = (Collection)entry2.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)allDiagnostics.get((Object)factoryName), (String)"allDiagnostics[factoryName]");
            for (PsiElement suppressedPlace : suppressedPlaces) {
                TextRange highlightingRange;
                boolean bl;
                block9: {
                    Collection elementsWithDiagnostics;
                    Iterable $this$any$iv = elementsWithDiagnostics;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            PsiElement it = (PsiElement)element$iv;
                            boolean bl2 = false;
                            KotlinInspectionSuppressor kotlinInspectionSuppressor = (KotlinInspectionSuppressor)suppressor;
                            PsiElement psiElement2 = suppressedPlace;
                            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"suppressedPlace");
                            PsiElement psiElement3 = it;
                            Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"it");
                            void v4 = factoryName;
                            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"factoryName");
                            if (!kotlinInspectionSuppressor.isSuppressionFor(psiElement2, psiElement3, (String)v4)) continue;
                            bl = true;
                            break block9;
                        }
                        bl = false;
                    }
                }
                if (bl) continue;
                if (((KotlinInspectionSuppressor)suppressor).getHighlightingRange(suppressedPlace, (String)factoryName) == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)highlightingRange, (String)"suppressor.getHighlighti\u2026 factoryName) ?: continue");
                Collection collection = problems;
                String string2 = InspectionsBundle.message((String)"inspection.redundant.suppression.description", (Object[])new Object[0]);
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[1];
                KotlinInspectionSuppressor kotlinInspectionSuppressor = (KotlinInspectionSuppressor)suppressor;
                void v8 = factoryName;
                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"factoryName");
                localQuickFixArray[0] = kotlinInspectionSuppressor.createRemoveRedundantSuppressionFix((String)v8);
                ProblemDescriptor problemDescriptor = manager.createProblemDescriptor(suppressedPlace, highlightingRange, string2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, localQuickFixArray);
                collection.add(problemDescriptor);
            }
        }
        Collection $this$toTypedArray$iv = problems;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ProblemDescriptor[] problemDescriptorArray = thisCollection$iv.toArray(new ProblemDescriptor[0]);
        Intrinsics.checkNotNull((Object)problemDescriptorArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        return problemDescriptorArray;
    }
}

