/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.maven.inspections;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import java.util.Iterator;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.inspections.PluginVersionDependentInspection;
import org.jetbrains.kotlin.idea.maven.KotlinMavenBundle;
import org.jetbrains.kotlin.idea.maven.PomFile;
import org.jetbrains.kotlin.idea.maven.inspections.DifferentKotlinMavenVersionInspection;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR(\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f@WX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/DifferentKotlinMavenVersionInspection;", "Lcom/intellij/util/xml/highlighting/DomElementsInspection;", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "Lorg/jetbrains/kotlin/idea/inspections/PluginVersionDependentInspection;", "()V", "idePluginVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "getIdePluginVersion", "()Lorg/jetbrains/kotlin/config/LanguageVersion;", "idePluginVersion$delegate", "Lkotlin/Lazy;", "<set-?>", "", "testVersionMessage", "getTestVersionMessage", "()Ljava/lang/String;", "setTestVersionMessage", "(Ljava/lang/String;)V", "checkFileElement", "", "domFileElement", "Lcom/intellij/util/xml/DomFileElement;", "holder", "Lcom/intellij/util/xml/highlighting/DomElementAnnotationHolder;", "createProblem", "plugin", "Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "kotlin.maven"})
public final class DifferentKotlinMavenVersionInspection
extends DomElementsInspection<MavenDomProjectModel>
implements PluginVersionDependentInspection {
    private final Lazy idePluginVersion$delegate = LazyKt.lazy((Function0)idePluginVersion.2.INSTANCE);
    @Nullable
    private String testVersionMessage;

    private final LanguageVersion getIdePluginVersion() {
        Lazy lazy = this.idePluginVersion$delegate;
        DifferentKotlinMavenVersionInspection differentKotlinMavenVersionInspection = this;
        Object var3_3 = null;
        return (LanguageVersion)lazy.getValue();
    }

    @Override
    @Nullable
    public String getTestVersionMessage() {
        return this.testVersionMessage;
    }

    @Override
    @TestOnly
    public void setTestVersionMessage(@Nullable String string) {
        this.testVersionMessage = string;
    }

    public void checkFileElement(@Nullable DomFileElement<MavenDomProjectModel> domFileElement, @Nullable DomElementAnnotationHolder holder) {
        block11: {
            block10: {
                if (domFileElement == null || holder == null) {
                    return;
                }
                Module module2 = domFileElement.getModule();
                if (module2 == null || (module2 = module2.getProject()) == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"domFileElement.module?.project ?: return");
                Module project2 = module2;
                MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)project2);
                if (mavenProjectsManager == null) {
                    return;
                }
                MavenProjectsManager mavenManager = mavenProjectsManager;
                if (!mavenManager.isMavenizedProject()) break block10;
                XmlFile xmlFile = domFileElement.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)xmlFile, (String)"domFileElement.file");
                if (mavenManager.isManagedFile(xmlFile.getVirtualFile())) break block11;
            }
            return;
        }
        XmlFile xmlFile = domFileElement.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)xmlFile, (String)"domFileElement.file");
        PomFile pomFile = PomFile.Companion.forFileOrNull(xmlFile);
        if (pomFile == null) {
            return;
        }
        PomFile pomFile2 = pomFile;
        Iterator<MavenDomPlugin> iterator = pomFile2.findKotlinPlugins().iterator();
        while (iterator.hasNext()) {
            Object mavenPluginVersion;
            MavenDomPlugin plugin;
            MavenDomPlugin mavenDomPlugin = plugin = iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)mavenDomPlugin, (String)"plugin");
            if (!mavenDomPlugin.getVersion().exists()) continue;
            GenericDomValue genericDomValue = plugin.getVersion();
            Intrinsics.checkNotNullExpressionValue((Object)genericDomValue, (String)"plugin.version");
            String string = genericDomValue.getStringValue();
            if (string == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"plugin.version.stringValue ?: continue");
            Object object = mavenPluginVersion = IdeKotlinVersion.Companion.parse-IoAF18A(string);
            IdeKotlinVersion ideKotlinVersion = (IdeKotlinVersion)(Result.isFailure-impl((Object)object) ? null : object);
            if (ideKotlinVersion == null || (ideKotlinVersion = ideKotlinVersion.getLanguageVersion()) == null) {
                continue;
            }
            IdeKotlinVersion mavenPluginLanguageVersion = ideKotlinVersion;
            if (this.getIdePluginVersion().compareTo((Enum)((Object)mavenPluginLanguageVersion)) >= 0 && mavenPluginLanguageVersion.compareTo((Enum)LanguageVersion.FIRST_SUPPORTED) >= 0) continue;
            this.createProblem(holder, plugin);
        }
    }

    private final void createProblem(DomElementAnnotationHolder holder, MavenDomPlugin plugin) {
        GenericDomValue genericDomValue = plugin.getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)genericDomValue, (String)"plugin.version");
        String versionFromMaven = genericDomValue.getStringValue();
        String string = this.getTestVersionMessage();
        if (string == null) {
            string = this.getIdePluginVersion();
        }
        String versionFromIde = string;
        holder.createProblem((DomElement)plugin.getVersion(), HighlightSeverity.WARNING, KotlinMavenBundle.message("version.different.maven.ide", String.valueOf(versionFromMaven), versionFromIde));
    }

    public DifferentKotlinMavenVersionInspection() {
        super(MavenDomProjectModel.class, new Class[0]);
    }
}

