/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.testIntegration.framework;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.testIntegration.TestFramework;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.idea.testIntegration.framework.KotlinTestFramework;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0005\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/testIntegration/framework/KotlinDelegatingTestFramework;", "Lorg/jetbrains/kotlin/idea/testIntegration/framework/KotlinTestFramework;", "()V", "isSlow", "", "()Z", "detectFramework", "Lcom/intellij/testIntegration/TestFramework;", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "isIgnoredMethod", "isTestClass", "declaration", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "isTestMethod", "qualifiedName", "", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "responsibleFor", "kotlin.idea"})
public final class KotlinDelegatingTestFramework
implements KotlinTestFramework {
    private final boolean isSlow;

    @Override
    public boolean isSlow() {
        return this.isSlow;
    }

    @Override
    public boolean responsibleFor(@NotNull KtNamedDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        KtNamedDeclaration ktNamedDeclaration = declaration2;
        if (ktNamedDeclaration instanceof KtClassOrObject) {
            return this.isTestClass((KtClassOrObject)declaration2);
        }
        if (ktNamedDeclaration instanceof KtNamedFunction) {
            return this.isTestMethod((KtNamedFunction)declaration2);
        }
        return false;
    }

    @Override
    public boolean isTestClass(@NotNull KtClassOrObject declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        KtLightClass ktLightClass = LightClassUtilsKt.toLightClass((KtClassOrObject)declaration2);
        if (ktLightClass == null) {
            return false;
        }
        KtLightClass lightClass = ktLightClass;
        TestFramework testFramework2 = TestFrameworks.detectFramework((PsiClass)((PsiClass)lightClass));
        if (testFramework2 == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)testFramework2, (String)"TestFrameworks.detectFra\u2026ghtClass) ?: return false");
        TestFramework framework = testFramework2;
        return framework.isTestClass((PsiElement)lightClass);
    }

    @Override
    public boolean isTestMethod(@NotNull KtNamedFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        TestFramework testFramework2 = this.detectFramework(function2);
        if (testFramework2 == null) {
            return false;
        }
        TestFramework framework = testFramework2;
        PsiMethod psiMethod = (PsiMethod)CollectionsKt.firstOrNull((List)LightClassUtilsKt.toLightMethods((PsiElement)((PsiElement)function2)));
        if (psiMethod == null) {
            return false;
        }
        PsiMethod lightMethod = psiMethod;
        return framework.isTestMethod((PsiElement)lightMethod, false);
    }

    @Override
    public boolean isIgnoredMethod(@NotNull KtNamedFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        TestFramework testFramework2 = this.detectFramework(function2);
        if (testFramework2 == null) {
            return false;
        }
        TestFramework framework = testFramework2;
        PsiMethod psiMethod = (PsiMethod)CollectionsKt.firstOrNull((List)LightClassUtilsKt.toLightMethods((PsiElement)((PsiElement)function2)));
        if (psiMethod == null) {
            return false;
        }
        PsiMethod lightMethod = psiMethod;
        return framework.isIgnoredMethod((PsiElement)lightMethod);
    }

    @Override
    @Nullable
    public String qualifiedName(@NotNull KtNamedDeclaration declaration2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        KtNamedDeclaration ktNamedDeclaration = declaration2;
        if (ktNamedDeclaration instanceof KtClassOrObject) {
            KtLightClass ktLightClass = LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)declaration2));
            string = ktLightClass != null ? ktLightClass.getQualifiedName() : null;
        } else if (ktNamedDeclaration instanceof KtNamedFunction) {
            PsiMethod lightMethod;
            PsiMethod psiMethod = lightMethod = (PsiMethod)CollectionsKt.firstOrNull((List)LightClassUtilsKt.toLightMethods((PsiElement)((PsiElement)declaration2)));
            PsiClass $this$safeAs$iv = psiMethod != null ? psiMethod.getContainingClass() : null;
            boolean $i$f$safeAs = false;
            PsiClass psiClass2 = $this$safeAs$iv;
            if (!(psiClass2 instanceof KtLightClass)) {
                psiClass2 = null;
            }
            KtLightClass ktLightClass = (KtLightClass)psiClass2;
            string = ktLightClass != null ? ktLightClass.getQualifiedName() : null;
        } else {
            string = null;
        }
        return string;
    }

    private final TestFramework detectFramework(KtNamedFunction function2) {
        PsiMethod psiMethod = (PsiMethod)CollectionsKt.firstOrNull((List)LightClassUtilsKt.toLightMethods((PsiElement)((PsiElement)function2)));
        if (psiMethod == null) {
            return null;
        }
        PsiMethod lightMethod = psiMethod;
        PsiClass $this$safeAs$iv = lightMethod.getContainingClass();
        boolean $i$f$safeAs = false;
        PsiClass psiClass2 = $this$safeAs$iv;
        if (!(psiClass2 instanceof KtLightClass)) {
            psiClass2 = null;
        }
        KtLightClass ktLightClass = (KtLightClass)psiClass2;
        if (ktLightClass == null) {
            return null;
        }
        KtLightClass lightClass = ktLightClass;
        return TestFrameworks.detectFramework((PsiClass)((PsiClass)lightClass));
    }

    public KotlinDelegatingTestFramework() {
        this.isSlow = true;
    }
}

