/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.dependencyView.ClassFileRepr;
import org.jetbrains.jps.builders.java.dependencyView.ClassfileAnalyzer;
import org.jetbrains.jps.builders.java.dependencyView.DependencyContext;
import org.jetbrains.jps.builders.java.dependencyView.UsageRepr;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.org.objectweb.asm.ClassReader;

public class ClassFileDependenciesAnalyzer {
    private final DependencyContext myContext;

    public ClassFileDependenciesAnalyzer(File dependenciesDataDir, PathRelativizerService relativizer) throws IOException {
        this.myContext = new DependencyContext(dependenciesDataDir, relativizer);
    }

    @NotNull
    public Set<String> collectDependencies(String className, ClassReader classReader) {
        ClassFileRepr classFileRepr = new ClassfileAnalyzer(this.myContext).analyze(this.myContext.get(className), classReader, false);
        if (classFileRepr == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                ClassFileDependenciesAnalyzer.$$$reportNull$$$0(0);
            }
            return set;
        }
        int classNameId = classFileRepr.name;
        LinkedHashSet<String> classDependencies = new LinkedHashSet<String>();
        for (UsageRepr.Usage usage : classFileRepr.getUsages()) {
            int owner = usage.getOwner();
            if (owner == classNameId) continue;
            classDependencies.add(this.myContext.getValue(owner));
        }
        LinkedHashSet<String> linkedHashSet = classDependencies;
        if (linkedHashSet == null) {
            ClassFileDependenciesAnalyzer.$$$reportNull$$$0(1);
        }
        return linkedHashSet;
    }

    public void close() {
        this.myContext.close();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/java/dependencyView/ClassFileDependenciesAnalyzer", "collectDependencies"));
    }
}

