/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FileCollectionFactory;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.ModuleBasedBuildTargetType;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.module.JpsModule;

public abstract class JVMModuleBuildTarget<R extends BuildRootDescriptor>
extends ModuleBasedTarget<R> {
    public JVMModuleBuildTarget(ModuleBasedBuildTargetType<? extends JVMModuleBuildTarget<R>> targetType, JpsModule module) {
        super(targetType, module);
    }

    @Override
    public String getId() {
        return this.getModule().getName();
    }

    @NotNull
    protected Set<File> computeRootExcludes(File root, ModuleExcludeIndex index) {
        Collection<File> moduleExcludes = index.getModuleExcludes(this.getModule());
        if (moduleExcludes.isEmpty()) {
            Set<File> set = Collections.emptySet();
            if (set == null) {
                JVMModuleBuildTarget.$$$reportNull$$$0(0);
            }
            return set;
        }
        Set excludes = FileCollectionFactory.createCanonicalFileSet();
        for (File excluded : moduleExcludes) {
            if (!FileUtil.isAncestor((File)root, (File)excluded, (boolean)true)) continue;
            excludes.add(excluded);
        }
        Set set = excludes;
        if (set == null) {
            JVMModuleBuildTarget.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    public R findRootDescriptor(String rootId, BuildRootIndex rootIndex) {
        List descriptors = rootIndex.getRootDescriptors(new File(rootId), Collections.singletonList(this.getTargetType()), null);
        return (R)((BuildRootDescriptor)ContainerUtil.getFirstItem(descriptors));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/JVMModuleBuildTarget", "computeRootExcludes"));
    }
}

