/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessorEx;
import com.intellij.openapi.command.CommandToken;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;

public final class ShuffleNamesAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShuffleNamesAction.$$$reportNull$$$0(0);
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        e.getPresentation().setEnabled(editor != null && file != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ShuffleNamesAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ShuffleNamesAction.$$$reportNull$$$0(2);
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (editor == null || file == null) {
            return;
        }
        Project project = file.getProject();
        if (!ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])new VirtualFile[]{file.getVirtualFile()})) {
            return;
        }
        CommandProcessorEx commandProcessor = (CommandProcessorEx)CommandProcessorEx.getInstance();
        CommandToken commandToken = commandProcessor.startCommand(project, e.getPresentation().getText(), (Object)e.getPresentation().getText(), UndoConfirmationPolicy.DEFAULT);
        try {
            WriteAction.run(() -> ShuffleNamesAction.shuffleIds(file, editor));
        }
        finally {
            commandProcessor.finishCommand(commandToken, null);
        }
    }

    private static boolean shuffleIds(PsiFile file, Editor editor) {
        final HashMap map = new HashMap();
        final StringBuilder sb = new StringBuilder();
        final StringBuilder quote = new StringBuilder();
        final ArrayList split = new ArrayList(100);
        file.acceptChildren((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof LeafPsiElement) {
                    char c;
                    String type2 = ((LeafPsiElement)element).getElementType().toString();
                    String text2 = element.getText();
                    if (text2.isEmpty()) {
                        return;
                    }
                    int len = text2.length();
                    for (int i = 0; i < len / 2 && (c = text2.charAt(i)) == text2.charAt(len - i - 1) && !Character.isLetter(c); ++i) {
                        quote.append(c);
                    }
                    boolean isQuoted = quote.length() > 0;
                    boolean isNumber = false;
                    if (isQuoted || type2.equals("ID") || type2.equals("word") || type2.contains("IDENT") && !"ts".equals(text2) || (isNumber = text2.matches("[0-9]+"))) {
                        Object replacement = (String)map.get(text2);
                        if (replacement == null) {
                            split.addAll(Arrays.asList((isQuoted ? text2.substring(quote.length(), text2.length() - quote.length()).replace("''", "") : text2).split("")));
                            if (!isNumber) {
                                ListIterator<String> it = split.listIterator();
                                while (it.hasNext()) {
                                    int cap;
                                    String s = (String)it.next();
                                    if (s.isEmpty()) {
                                        it.remove();
                                        continue;
                                    }
                                    int c2 = s.charAt(0);
                                    c2 = (char)((c2 &= ~(cap = c2 & 0x20)) >= 65 && c2 <= 90 ? (c2 - 65 + 7) % 26 + 65 : c2) | cap;
                                    it.set(String.valueOf((char)c2));
                                }
                            }
                            Collections.shuffle(split);
                            if (isNumber && "0".equals(split.get(0))) {
                                split.set(0, "1");
                            }
                            replacement = StringUtil.join((Collection)split, (String)"");
                            if (isQuoted) {
                                replacement = quote + (String)replacement + quote.reverse();
                            }
                            map.put(text2, replacement);
                        }
                        text2 = replacement;
                    }
                    sb.append(text2);
                    quote.setLength(0);
                    split.clear();
                }
                super.visitElement(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/devkit/actions/ShuffleNamesAction$1", "visitElement"));
            }
        });
        editor.getDocument().setText((CharSequence)sb.toString());
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/actions/ShuffleNamesAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/actions/ShuffleNamesAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

