/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.intellij.codeInsight.completion.CompletionConfidenceEP;
import com.intellij.codeInsight.completion.CompletionContributorEP;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ProjectIconsAccessor;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.uast.UastModificationTracker;
import com.intellij.ui.IconManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomJavaUtil;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.util.PsiUtil;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UObjectLiteralExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

final class LanguageResolvingUtil {
    private static final String ANY_LANGUAGE_DEFAULT_ID = Language.ANY.getID();
    private static final Set<String> EP_WITH_ANY_LANGUAGE_ID = Collections.unmodifiableSet(ContainerUtil.set((Object[])new String[]{CompletionContributorEP.class.getName(), CompletionConfidenceEP.class.getName()}));

    LanguageResolvingUtil() {
    }

    static Collection<LanguageDefinition> getAllLanguageDefinitions(ConvertContext context) {
        List<LanguageDefinition> languageDefinitions = LanguageResolvingUtil.collectLanguageDefinitions(context);
        ContainerUtil.addIfNotNull(languageDefinitions, (Object)LanguageResolvingUtil.createAnyLanguageDefinition(context));
        return languageDefinitions;
    }

    static boolean processAllLanguageDefinitions(ConvertContext context, Processor<? super LanguageDefinition> processor) {
        if (!LanguageResolvingUtil.processLanguageDefinitions(context, processor)) {
            return false;
        }
        LanguageDefinition any = LanguageResolvingUtil.createAnyLanguageDefinition(context);
        return any != null && processor.process((Object)any);
    }

    private static boolean processLanguageDefinitions(ConvertContext context, Processor<? super LanguageDefinition> processor) {
        List<Object> libraryDefinitions;
        Query allLanguages;
        Project project = context.getProject();
        GlobalSearchScope projectProductionScope = GlobalSearchScopesCore.projectProductionScope((Project)project);
        GlobalSearchScope librariesScope = ProjectScope.getLibrariesScope((Project)project);
        PsiClass languageClass = JavaPsiFacade.getInstance((Project)project).findClass(Language.class.getName(), projectProductionScope);
        if (languageClass == null) {
            languageClass = JavaPsiFacade.getInstance((Project)project).findClass(Language.class.getName(), librariesScope);
        }
        if (languageClass == null) {
            allLanguages = Collections.emptyList();
            libraryDefinitions = Collections.emptyList();
        } else {
            GlobalSearchScope allScope = projectProductionScope.union((SearchScope)librariesScope);
            allLanguages = ClassInheritorsSearch.search((PsiClass)languageClass, (SearchScope)allScope, (boolean)true);
            libraryDefinitions = LanguageResolvingUtil.collectLibraryLanguages(context, allScope);
        }
        if (!ContainerUtil.process(libraryDefinitions, processor)) {
            return false;
        }
        return StreamSupport.stream(allLanguages.spliterator(), false).filter(aClass -> PsiSearchScopeUtil.isInScope((GlobalSearchScope)projectProductionScope, (PsiElement)aClass)).map(language -> LanguageResolvingUtil.getDefinition(language, libraryDefinitions)).filter(Objects::nonNull).allMatch(arg_0 -> processor.process(arg_0));
    }

    private static List<LanguageDefinition> collectLanguageDefinitions(ConvertContext context) {
        Project project = context.getProject();
        Collection allLanguages = (Collection)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            GlobalSearchScope projectProductionScope = GlobalSearchScopesCore.projectProductionScope((Project)project);
            GlobalSearchScope librariesScope = ProjectScope.getLibrariesScope((Project)project);
            GlobalSearchScope allScope = projectProductionScope.union((SearchScope)librariesScope);
            PsiClass languageClass = JavaPsiFacade.getInstance((Project)project).findClass(Language.class.getName(), projectProductionScope);
            if (languageClass == null) {
                languageClass = JavaPsiFacade.getInstance((Project)project).findClass(Language.class.getName(), librariesScope);
            }
            if (languageClass == null) {
                return CachedValueProvider.Result.create(Collections.emptyList(), (Object[])new Object[]{UastModificationTracker.getInstance((Project)project)});
            }
            HashSet allInheritors = new HashSet(ClassInheritorsSearch.search((PsiClass)languageClass, (SearchScope)allScope, (boolean)true).findAll());
            return CachedValueProvider.Result.create(allInheritors, (Object[])new Object[]{UastModificationTracker.getInstance((Project)project)});
        });
        if (allLanguages.isEmpty()) {
            return new SmartList();
        }
        GlobalSearchScope projectProductionScope = GlobalSearchScopesCore.projectProductionScope((Project)project);
        GlobalSearchScope librariesScope = ProjectScope.getLibrariesScope((Project)project);
        GlobalSearchScope allScope = projectProductionScope.union((SearchScope)librariesScope);
        List<LanguageDefinition> libraryDefinitions = LanguageResolvingUtil.collectLibraryLanguages(context, allScope);
        List projectLanguages = ContainerUtil.filter((Collection)allLanguages, aClass -> PsiSearchScopeUtil.isInScope((GlobalSearchScope)projectProductionScope, (PsiElement)aClass));
        List<LanguageDefinition> projectDefinitions = LanguageResolvingUtil.mapToProjectDefinitions(projectLanguages, libraryDefinitions);
        ArrayList<LanguageDefinition> all = new ArrayList<LanguageDefinition>(libraryDefinitions);
        all.addAll(projectDefinitions);
        return all;
    }

    private static List<LanguageDefinition> collectLibraryLanguages(ConvertContext context, GlobalSearchScope scope) {
        return ContainerUtil.mapNotNull((Collection)Language.getRegisteredLanguages(), language -> LanguageResolvingUtil.getLibraryDefinition(context, language, scope));
    }

    @Nullable
    private static LanguageDefinition getLibraryDefinition(ConvertContext context, Language language, @NotNull GlobalSearchScope scope) {
        if (scope == null) {
            LanguageResolvingUtil.$$$reportNull$$$0(0);
        }
        if (language.getID().isEmpty()) {
            return null;
        }
        PsiClass psiClass = DomJavaUtil.findClass((String)language.getClass().getName(), (DomElement)context.getInvocationElement(), (boolean)true);
        if (psiClass == null || !PsiSearchScopeUtil.isInScope((GlobalSearchScope)scope, (PsiElement)psiClass)) {
            return null;
        }
        return new LanguageDefinition(language.getID(), psiClass, () -> {
            LanguageFileType type2 = language.getAssociatedFileType();
            return type2 == null ? null : type2.getIcon();
        }, () -> language.getDisplayName());
    }

    private static List<LanguageDefinition> mapToProjectDefinitions(Collection<? extends PsiClass> projectLanguages, List<? extends LanguageDefinition> libraryDefinitions) {
        return ContainerUtil.mapNotNull(projectLanguages, language -> LanguageResolvingUtil.getDefinition(language, libraryDefinitions));
    }

    private static LanguageDefinition getDefinition(@NotNull PsiClass language, List<? extends LanguageDefinition> libraryLanguages) {
        if (language == null) {
            LanguageResolvingUtil.$$$reportNull$$$0(1);
        }
        if (language.hasModifierProperty("abstract")) {
            return null;
        }
        if (ContainerUtil.exists(libraryLanguages, definition -> definition.clazz.equals(language))) {
            return null;
        }
        return (LanguageDefinition)CachedValuesManager.getCachedValue((PsiElement)language, () -> {
            String languageId = LanguageResolvingUtil.computeConstantSuperCtorCallParameter(language, 0);
            if (languageId == null) {
                languageId = LanguageResolvingUtil.computeConstantSuperCtorCallParameter(language, 1);
            }
            if (languageId == null) {
                languageId = LanguageResolvingUtil.computeConstantReturnValue(language, "getID");
            }
            if (StringUtil.isEmpty((String)languageId)) {
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{language});
            }
            LanguageDefinition definition = new LanguageDefinition(languageId, language, () -> LanguageResolvingUtil.computeIconForProjectLanguage(language), () -> LanguageResolvingUtil.computeConstantReturnValue(language, "getDisplayName"));
            return CachedValueProvider.Result.createSingleDependency((Object)definition, (Object)language);
        });
    }

    @Nullable
    private static Icon computeIconForProjectLanguage(PsiClass language) {
        UExpression icon;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)language);
        if (module == null) {
            return null;
        }
        Project project = language.getProject();
        PsiClass languageFileType = JavaPsiFacade.getInstance((Project)project).findClass(LanguageFileType.class.getName(), language.getResolveScope());
        if (languageFileType == null) {
            return null;
        }
        PsiClass fileType = LanguageResolvingUtil.findLanguageFileType(language, module, languageFileType);
        if (fileType == null) {
            return null;
        }
        ProjectIconsAccessor iconsAccessor = ProjectIconsAccessor.getInstance((Project)project);
        VirtualFile iconFile = iconsAccessor.resolveIconFile((UElement)(icon = LanguageResolvingUtil.getReturnExpression(fileType, "getIcon")));
        return iconFile == null ? null : iconsAccessor.getIcon(iconFile);
    }

    @Nullable
    private static PsiClass findLanguageFileType(PsiClass language, Module module, PsiClass languageFileType) {
        UExpression associatedFileTypeExpression = LanguageResolvingUtil.getReturnExpression(language, "getAssociatedFileType");
        if (associatedFileTypeExpression != null) {
            return PsiTypesUtil.getPsiClass((PsiType)associatedFileTypeExpression.getExpressionType());
        }
        GlobalSearchScope currentModuleScope = GlobalSearchScope.moduleWithDependenciesScope((Module)module);
        PsiClass matchingFileType = LanguageResolvingUtil.findMatchingFileType(languageFileType, language, (SearchScope)currentModuleScope);
        if (matchingFileType != null) {
            return matchingFileType;
        }
        return LanguageResolvingUtil.findMatchingFileType(languageFileType, language, language.getUseScope());
    }

    @Nullable
    private static PsiClass findMatchingFileType(PsiClass languageFileType, PsiClass language, SearchScope scope) {
        return (PsiClass)ClassInheritorsSearch.search((PsiClass)languageFileType, (SearchScope)scope, (boolean)true).filtering(psiClass -> {
            UClass uClass = (UClass)UastContextKt.toUElement((PsiElement)psiClass, UClass.class);
            if (uClass == null) {
                return false;
            }
            UCallExpression expression = LanguageResolvingUtil.getSuperConstructorParameterExpression(uClass);
            if (expression == null) {
                return false;
            }
            UExpression languageParam = expression.getArgumentForParameter(0);
            if (languageParam == null) {
                return false;
            }
            PsiClass paramPsiClass = PsiTypesUtil.getPsiClass((PsiType)languageParam.getExpressionType());
            return language.getManager().areElementsEquivalent((PsiElement)language, (PsiElement)paramPsiClass);
        }).findFirst();
    }

    @Nullable
    private static String computeConstantReturnValue(PsiClass psiClass, String methodName) {
        UExpression expression = LanguageResolvingUtil.getReturnExpression(psiClass, methodName);
        if (expression == null) {
            return null;
        }
        return UastUtils.evaluateString((UExpression)expression);
    }

    @Nullable
    private static UExpression getReturnExpression(PsiClass psiClass, String methodName) {
        PsiMethod[] methods = psiClass.findMethodsByName(methodName, false);
        if (methods.length != 1) {
            return null;
        }
        return PsiUtil.getReturnedExpression(methods[0]);
    }

    private static String computeConstantSuperCtorCallParameter(PsiClass languagePsiClass, int index) {
        UClass languageClass = (UClass)UastContextKt.toUElement((PsiElement)languagePsiClass, UClass.class);
        if (languageClass == null) {
            return null;
        }
        if (languageClass instanceof UAnonymousClass) {
            return LanguageResolvingUtil.getStringConstantExpression((UCallExpression)UastUtils.findContaining((PsiElement)languageClass.getSourcePsi(), UObjectLiteralExpression.class), index);
        }
        UCallExpression methodCallExpression = LanguageResolvingUtil.getSuperConstructorParameterExpression(languageClass);
        return LanguageResolvingUtil.getStringConstantExpression(methodCallExpression, index);
    }

    @Nullable
    private static UCallExpression getSuperConstructorParameterExpression(UClass languageClass) {
        UMethod defaultConstructor = (UMethod)ContainerUtil.find((Object[])languageClass.getMethods(), method -> method.isConstructor() && method.getUastParameters().isEmpty());
        if (defaultConstructor == null) {
            return null;
        }
        UExpression body = defaultConstructor.getUastBody();
        if (!(body instanceof UBlockExpression)) {
            return null;
        }
        List expressions = ((UBlockExpression)body).getExpressions();
        UExpression expression = (UExpression)ContainerUtil.getFirstItem((List)expressions);
        return (UCallExpression)ObjectUtils.tryCast((Object)expression, UCallExpression.class);
    }

    @Nullable
    private static String getStringConstantExpression(@Nullable UCallExpression callExpression, int index) {
        if (callExpression == null) {
            return null;
        }
        UExpression argument = callExpression.getArgumentForParameter(index);
        if (argument == null) {
            return null;
        }
        return UastUtils.evaluateString((UExpression)argument);
    }

    @Nullable
    private static LanguageDefinition createAnyLanguageDefinition(ConvertContext context) {
        PsiClass languageClass = DomJavaUtil.findClass((String)Language.class.getName(), (DomElement)context.getInvocationElement());
        if (languageClass == null) {
            return null;
        }
        String anyLanguageId = LanguageResolvingUtil.calculateAnyLanguageId(context);
        return new LanguageDefinition(anyLanguageId, languageClass, () -> AllIcons.FileTypes.Any_type, () -> DevKitBundle.message("plugin.xml.convert.language.id.any.language.display.name", new Object[0]));
    }

    @NlsSafe
    private static String calculateAnyLanguageId(@NotNull ConvertContext context) {
        Extension extension;
        if (context == null) {
            LanguageResolvingUtil.$$$reportNull$$$0(2);
        }
        if ((extension = (Extension)context.getInvocationElement().getParentOfType(Extension.class, true)) == null) {
            return ANY_LANGUAGE_DEFAULT_ID;
        }
        ExtensionPoint extensionPoint = extension.getExtensionPoint();
        if (extensionPoint == null) {
            return ANY_LANGUAGE_DEFAULT_ID;
        }
        GenericAttributeValue<PsiClass> epBeanClass = extensionPoint.getBeanClass();
        if (EP_WITH_ANY_LANGUAGE_ID.contains(epBeanClass.getStringValue())) {
            return "any";
        }
        return ANY_LANGUAGE_DEFAULT_ID;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/devkit/dom/impl/LanguageResolvingUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLibraryDefinition";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getDefinition";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateAnyLanguageId";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class LanguageDefinition {
        final String id;
        final PsiClass clazz;
        final Icon icon;
        final Supplier<String> displayName;
        final String type;

        LanguageDefinition(@NotNull String id, @NotNull PsiClass clazz, @NotNull Supplier<? extends @Nullable Icon> iconSupplier, Supplier<String> displayName) {
            if (id == null) {
                LanguageDefinition.$$$reportNull$$$0(0);
            }
            if (clazz == null) {
                LanguageDefinition.$$$reportNull$$$0(1);
            }
            if (iconSupplier == null) {
                LanguageDefinition.$$$reportNull$$$0(2);
            }
            this.id = id;
            this.clazz = clazz;
            this.type = clazz instanceof PsiAnonymousClass ? ((PsiAnonymousClass)clazz).getBaseClassReference().getQualifiedName() : clazz.getQualifiedName();
            this.icon = IconManager.getInstance().createDeferredIcon(EmptyIcon.ICON_16, iconSupplier, supplier -> (Icon)supplier.get());
            this.displayName = displayName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LanguageDefinition)) {
                return false;
            }
            return this.clazz.equals(((LanguageDefinition)o).clazz);
        }

        public int hashCode() {
            return this.clazz.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "id";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "clazz";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "iconSupplier";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/devkit/dom/impl/LanguageResolvingUtil$LanguageDefinition";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

