/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.uast.UastHintedVisitorAdapter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UObjectLiteralExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class MissingAccessibleContextInspection
extends DevKitUastInspectionBase {
    public static final int MAX_EXPRESSIONS_TO_PROCESS = 16;

    @Override
    protected PsiElementVisitor buildInternalVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            MissingAccessibleContextInspection.$$$reportNull$$$0(0);
        }
        Class[] hint = new Class[]{UMethod.class, ULambdaExpression.class};
        return UastHintedVisitorAdapter.create((Language)holder.getFile().getLanguage(), (AbstractUastNonRecursiveVisitor)new MissingAccessibleContextVisitor(holder), (Class[])hint);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/idea/devkit/inspections/MissingAccessibleContextInspection", "buildInternalVisitor"));
    }

    static class MissingAccessibleContextVisitor
    extends AbstractUastNonRecursiveVisitor {
        private final ProblemsHolder myHolder;

        MissingAccessibleContextVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public boolean visitLambdaExpression(@NotNull ULambdaExpression lambda2) {
            String qualifiedName;
            PsiClass lambdaClass;
            List parameters;
            if (lambda2 == null) {
                MissingAccessibleContextVisitor.$$$reportNull$$$0(0);
            }
            if (((parameters = lambda2.getValueParameters()).size() == 5 || parameters.size() == 6) && (lambdaClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)lambda2.getFunctionalInterfaceType())) != null && ("javax.swing.ListCellRenderer".equals(qualifiedName = lambdaClass.getQualifiedName()) || "javax.swing.table.TableCellRenderer".equals(qualifiedName))) {
                this.processBody(lambda2.getBody(), (UElement)lambda2);
            }
            return true;
        }

        public boolean visitMethod(@NotNull UMethod method) {
            String qualifiedName;
            PsiClass aClass;
            PsiMethod psi;
            PsiMethod[] methods;
            if (method == null) {
                MissingAccessibleContextVisitor.$$$reportNull$$$0(1);
            }
            if ((method.getName().equals("getListCellRendererComponent") || method.getName().equals("getTableCellRendererComponent")) && (methods = (psi = method.getJavaPsi()).findDeepestSuperMethods()).length == 1 && (aClass = methods[0].getContainingClass()) != null && ("javax.swing.ListCellRenderer".equals(qualifiedName = aClass.getQualifiedName()) || "javax.swing.table.TableCellRenderer".equals(qualifiedName))) {
                this.processBody(method.getUastBody(), (UElement)method);
            }
            return true;
        }

        private void processBody(UExpression body, UElement context) {
            ArrayList anchors = new ArrayList();
            for (UExpression expression : MissingAccessibleContextVisitor.findReturnedExpressions(body, context)) {
                PsiClass panelClass = MissingAccessibleContextVisitor.findReturnedClass(expression);
                if (panelClass == null || MissingAccessibleContextVisitor.hasRedefinedContext(panelClass)) continue;
                ContainerUtil.addIfNotNull(anchors, (Object)expression.getSourcePsi());
            }
            if (!anchors.isEmpty() && !MissingAccessibleContextVisitor.hasAccessibilityMethodCalls(body)) {
                for (PsiElement anchor : anchors) {
                    this.myHolder.registerProblem(anchor, DevKitBundle.message("inspection.message.accessible.context.not.defined.for.jpanel", new Object[0]), new LocalQuickFix[0]);
                }
            }
        }

        private static boolean hasAccessibilityMethodCalls(UExpression body) {
            var visitor = new AbstractUastVisitor(){
                boolean myHasAccessibilityMethodCall = false;

                private boolean isAccessibilityMethod(@NotNull UCallExpression call) {
                    PsiClass aClass;
                    String methodName;
                    if (call == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((methodName = call.getMethodName()) == null) {
                        return false;
                    }
                    if (methodName.equals("setAccessibleName") || methodName.equals("setAccessibleDescription")) {
                        return true;
                    }
                    PsiMethod target = call.resolve();
                    return target != null && (aClass = target.getContainingClass()) != null && "com.intellij.util.ui.accessibility.AccessibleContextUtil".equals(aClass.getQualifiedName());
                }

                public boolean visitCallExpression(@NotNull UCallExpression call) {
                    if (call == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (this.isAccessibilityMethod(call)) {
                        this.myHasAccessibilityMethodCall = true;
                        return false;
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "call";
                    objectArray2[1] = "org/jetbrains/idea/devkit/inspections/MissingAccessibleContextInspection$MissingAccessibleContextVisitor$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isAccessibilityMethod";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitCallExpression";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            body.accept((UastVisitor)visitor);
            return visitor.myHasAccessibilityMethodCall;
        }

        private static Set<UExpression> findReturnedExpressions(@NotNull UExpression body, @NotNull UElement context) {
            if (body == null) {
                MissingAccessibleContextVisitor.$$$reportNull$$$0(2);
            }
            if (context == null) {
                MissingAccessibleContextVisitor.$$$reportNull$$$0(3);
            }
            Queue<UExpression> workList = MissingAccessibleContextVisitor.findDirectExpressions(body, context);
            HashSet<UExpression> processed = new HashSet<UExpression>();
            HashSet<UExpression> leafs = new HashSet<UExpression>();
            while (!workList.isEmpty() && processed.size() < 16) {
                UExpression next = workList.poll();
                if (!processed.add(next = UastUtils.skipParenthesizedExprDown((UExpression)next))) continue;
                if (next instanceof UIfExpression) {
                    ContainerUtil.addIfNotNull(workList, (Object)((UIfExpression)next).getThenExpression());
                    ContainerUtil.addIfNotNull(workList, (Object)((UIfExpression)next).getElseExpression());
                    continue;
                }
                if (next instanceof UBlockExpression) {
                    ContainerUtil.addIfNotNull(workList, (Object)((UExpression)ContainerUtil.getLastItem((List)((UBlockExpression)next).getExpressions())));
                    continue;
                }
                if (next instanceof UReferenceExpression) {
                    PsiElement psiVar = ((UReferenceExpression)next).resolve();
                    ULocalVariable uVar = (ULocalVariable)UastContextKt.toUElement((PsiElement)psiVar, ULocalVariable.class);
                    if (uVar == null) continue;
                    ContainerUtil.addIfNotNull(workList, (Object)uVar.getUastInitializer());
                    PsiElement bodyPsi = body.getSourcePsi();
                    if (bodyPsi == null) continue;
                    for (PsiReference ref : ReferencesSearch.search((PsiElement)psiVar, (SearchScope)new LocalSearchScope(bodyPsi))) {
                        UBinaryExpression parent;
                        UExpression lValue = (UExpression)UastContextKt.toUElement((PsiElement)ref.getElement(), UExpression.class);
                        if (lValue == null || (parent = (UBinaryExpression)ObjectUtils.tryCast((Object)lValue.getUastParent(), UBinaryExpression.class)) == null || parent.getOperator() != UastBinaryOperator.ASSIGN || !lValue.equals(parent.getLeftOperand())) continue;
                        ContainerUtil.addIfNotNull(workList, (Object)parent.getRightOperand());
                    }
                    continue;
                }
                if (!(next instanceof UCallExpression)) continue;
                leafs.add(next);
            }
            return leafs;
        }

        @NotNull
        private static Queue<UExpression> findDirectExpressions(@NotNull UExpression body, final @NotNull UElement context) {
            if (body == null) {
                MissingAccessibleContextVisitor.$$$reportNull$$$0(4);
            }
            if (context == null) {
                MissingAccessibleContextVisitor.$$$reportNull$$$0(5);
            }
            final ArrayDeque<UExpression> direct = new ArrayDeque<UExpression>();
            if (body instanceof UBlockExpression) {
                body.accept((UastVisitor)new AbstractUastVisitor(){

                    public boolean visitReturnExpression(@NotNull UReturnExpression node) {
                        if (node == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (context.equals(node.getJumpTarget())) {
                            ContainerUtil.addIfNotNull((Collection)direct, (Object)node.getReturnExpression());
                        }
                        return true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/idea/devkit/inspections/MissingAccessibleContextInspection$MissingAccessibleContextVisitor$2", "visitReturnExpression"));
                    }
                });
            } else if (body instanceof UReturnExpression) {
                direct.add(((UReturnExpression)body).getReturnExpression());
            }
            ArrayDeque<UExpression> arrayDeque = direct;
            if (arrayDeque == null) {
                MissingAccessibleContextVisitor.$$$reportNull$$$0(6);
            }
            return arrayDeque;
        }

        private static boolean hasRedefinedContext(PsiClass panelClass) {
            PsiClass containingClass;
            MethodSignature signature = MethodSignatureUtil.createMethodSignature((String)"getAccessibleContext", (PsiType[])PsiType.EMPTY_ARRAY, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            PsiMethod found = MethodSignatureUtil.findMethodBySignature((PsiClass)panelClass, (MethodSignature)signature, (boolean)true);
            return found != null && (containingClass = found.getContainingClass()) != null && !"javax.swing.JPanel".equals(containingClass.getQualifiedName());
        }

        @Nullable
        private static PsiClass findReturnedClass(UExpression result) {
            UReferenceExpression ref;
            UCallExpression call;
            PsiClass panelClass = null;
            if (result instanceof UObjectLiteralExpression) {
                panelClass = ((UObjectLiteralExpression)result).getDeclaration().getJavaPsi();
            } else if (result instanceof UCallExpression && (call = (UCallExpression)result).getKind() == UastCallKind.CONSTRUCTOR_CALL && (ref = call.getClassReference()) != null) {
                panelClass = (PsiClass)ObjectUtils.tryCast((Object)ref.resolve(), PsiClass.class);
            }
            return panelClass;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lambda";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "body";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/inspections/MissingAccessibleContextInspection$MissingAccessibleContextVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/inspections/MissingAccessibleContextInspection$MissingAccessibleContextVisitor";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findDirectExpressions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "visitLambdaExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitMethod";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "findReturnedExpressions";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "findDirectExpressions";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

