/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations;

import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.w3c.dom.Element;

public class SingleKeyResolver
extends KeyResolverSpi {
    private static final Logger LOG = LoggerFactory.getLogger(SingleKeyResolver.class);
    private String keyName;
    private PublicKey publicKey;
    private PrivateKey privateKey;
    private SecretKey secretKey;

    public SingleKeyResolver(String string, PublicKey publicKey) {
        this.keyName = string;
        this.publicKey = publicKey;
    }

    public SingleKeyResolver(String string, PrivateKey privateKey) {
        this.keyName = string;
        this.privateKey = privateKey;
    }

    public SingleKeyResolver(String string, SecretKey secretKey) {
        this.keyName = string;
        this.secretKey = secretKey;
    }

    @Override
    public boolean engineCanResolve(Element element, String string, StorageResolver storageResolver) {
        return XMLUtils.elementIsInSignatureSpace(element, "KeyName");
    }

    @Override
    public PublicKey engineLookupAndResolvePublicKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        String string2;
        LOG.debug("Can I resolve {}?", element.getTagName());
        if (this.publicKey != null && XMLUtils.elementIsInSignatureSpace(element, "KeyName") && this.keyName.equals(string2 = element.getFirstChild().getNodeValue())) {
            return this.publicKey;
        }
        LOG.debug("I can't");
        return null;
    }

    @Override
    public X509Certificate engineLookupResolveX509Certificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        return null;
    }

    @Override
    public SecretKey engineResolveSecretKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        String string2;
        LOG.debug("Can I resolve {}?", element.getTagName());
        if (this.secretKey != null && XMLUtils.elementIsInSignatureSpace(element, "KeyName") && this.keyName.equals(string2 = element.getFirstChild().getNodeValue())) {
            return this.secretKey;
        }
        LOG.debug("I can't");
        return null;
    }

    @Override
    public PrivateKey engineLookupAndResolvePrivateKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        String string2;
        LOG.debug("Can I resolve {}?", element.getTagName());
        if (this.privateKey != null && XMLUtils.elementIsInSignatureSpace(element, "KeyName") && this.keyName.equals(string2 = element.getFirstChild().getNodeValue())) {
            return this.privateKey;
        }
        LOG.debug("I can't");
        return null;
    }
}

