<!--- Provide a general summary of your changes in the Title above -->

## Description

Describe your changes in detail.

## Motivation and context

Why is this change required? What problem does it solve?

If it fixes an open issue, please link to the issue here (if you write `fixes #num`
or `closes #num`, the issue will be automatically closed when the pull is accepted.)

## How has this been tested?

Please describe in detail how you tested your changes.

Include details of your testing environment, and the tests you ran to
see how your change affects other areas of the code, etc.

## Screenshots (if appropriate)

## Types of changes

What types of changes does your code introduce? Put an `x` in all the boxes that apply:
- [ ] Bug fix (non-breaking change which fixes an issue)
- [ ] New feature (non-breaking change which adds functionality)
- [ ] Breaking change (fix or feature that would cause existing functionality to change)

## Checklist:

Go over all the following points, and put an `x` in all the boxes that apply.

Please, please, please, don't send your pull request until all of the boxes are ticked. Once your pull request is created, it will trigger a build on our [continuous integration](http://www.phptherightway.com/#continuous-integration) server to make sure your [tests and code style pass](https://help.github.com/articles/about-required-status-checks/).

- [ ] I have read the **[CONTRIBUTING](CONTRIBUTING.md)** document.
- [ ] My pull request addresses exactly one patch/feature.
- [ ] I have created a branch for this patch/feature.
- [ ] Each individual commit in the pull request is meaningful.
- [ ] I have added tests to cover my changes.
- [ ] If my change requires a change to the documentation, I have updated it accordingly.

If you're unsure about any of these, don't hesitate to ask. We're here to help!
