/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.visualeditor.querybuilder;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilder;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.NbBundle;

public class QueryBuilderSqlTextArea
extends JEditorPane
implements ActionListener,
KeyListener {
    public static final boolean SYNTAX_HIGHLIGHT = true;
    String _lastGoodQuery = null;
    private boolean DEBUG = false;
    private QueryBuilder _queryBuilder;
    private JMenuItem runQueryMenuItem;
    private JMenuItem parseQueryMenuItem;
    private SimpleAttributeSet keyword = new SimpleAttributeSet();
    private SimpleAttributeSet schema = new SimpleAttributeSet();
    private SimpleAttributeSet column = new SimpleAttributeSet();
    private static ArrayList keywords = null;
    private static final String[] sqlReservedWords = new String[]{"ABSOLUTE", "ACTION", "ADD", "ALL", "ALLOCATE", "ALTER", "AND", "ANY", "ARE", "AS", "ASC", "ASSERTION", "AT", "AUTHORIZATION", "AVG", "BEGIN", "BETWEEN", "BIT", "BIT_LENGTH", "BOTH", "BY", "CASCADE", "CASCADED", "CASE", "CAST", "CATALOG", "CHAR", "CHARACTER", "CHAR_LENGTH", "CHARACTER_LENGTH", "CHECK", "CLOSE", "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMIT", "CONNECT", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONTINUE", "CONVERT", "CORRESPONDING", "COUNT", "CREATE", "CROSS", "CURRENT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DATE", "DAY", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DESC", "DESCRIBE", "DESCRIPTOR", "DIAGNOSTICS", "DISCONNECT", "DISTINCT", "DOMAIN", "DOUBLE", "DROP", "ELSE", "END", "END-EXEC", "ESCAPE", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXISTS", "EXTERNAL", "EXTRACT", "FALSE", "FETCH", "FIRST", "FLOAT", "FOR", "FOREIGN", "FOUND", "FROM", "FULL", "GET", "GLOBAL", "GO", "GOTO", "GRANT", "GROUP", "HAVING", "HOUR", "IDENTITY", "IMMEDIATE", "IN", "INDICATOR", "INITIALLY", "INNER", "INPUT", "INSENSITIVE", "INSERT", "INT", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "IS", "ISOLATION", "JOIN", "KEY", "LANGUAGE", "LAST", "LEADING", "LEFT", "LEVEL", "LIKE", "LOCAL", "LOWER", "MATCH", "MAX", "MIN", "MINUTE", "MODULE", "MONTH", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NEXT", "NO", "NOT", "NULL", "NULLIF", "NUMERIC", "OCTET_LENGTH", "OF", "ON", "ONLY", "OPEN", "OPTION", "OR", "ORDER", "OUTER", "OUTPUT", "OVERLAPS", "PAD", "PARTIAL", "POSITION", "PRECISION", "PREPARE", "PRESERVE", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURE", "PUBLIC", "READ", "REAL", "REFERENCES", "RELATIVE", "RESTRICT", "REVOKE", "RIGHT", "ROLLBACK", "ROWS", "SCHEMA", "SCROLL", "SECOND", "SECTION", "SELECT", "SESSION", "SESSION_USER", "SET", "SIZE", "SMALLINT", "SOME", "SPACE", "SQL", "SQLCODE", "SQLERROR", "SQLSTATE", "SUBSTRING", "SUM", "SYSTEM_USER", "TABLE", "TEMPORARY", "THEN", "TIME", "TIMESTAMP", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRAILING", "TRANSACTION", "TRANSLATE", "TRANSLATION", "TRIM", "TRUE", "UNION", "UNIQUE", "UNKNOWN", "UPDATE", "UPPER", "USAGE", "USER", "USING", "VALUE", "VALUES", "VARCHAR", "VARYING", "VIEW", "WHEN", "WHENEVER", "WHERE", "WITH", "WORK", "WRITE", "YEAR", "ZONE"};

    public QueryBuilderSqlTextArea(QueryBuilder queryBuilder) {
        this._queryBuilder = queryBuilder;
        this.createSqlTextPopup();
        this.setEditorKit(CloneableEditorSupport.getEditorKit((String)"text/x-sql"));
        this.addKeyListener(this);
        StyleConstants.setForeground(this.keyword, new Color(0, 0, 153));
        StyleConstants.setForeground(this.schema, new Color(0, 111, 0));
        StyleConstants.setForeground(this.column, new Color(120, 0, 0));
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    void createSqlTextPopup() {
        JPopupMenu sqlTextPopup = new JPopupMenu();
        this.parseQueryMenuItem = new JMenuItem(NbBundle.getMessage(QueryBuilderSqlTextArea.class, (String)"PARSE_QUERY"));
        this.parseQueryMenuItem.addActionListener(this);
        sqlTextPopup.add(this.parseQueryMenuItem);
        this.runQueryMenuItem = new JMenuItem(NbBundle.getMessage(QueryBuilderSqlTextArea.class, (String)"RUN_QUERY"));
        this.runQueryMenuItem.addActionListener(this);
        sqlTextPopup.add(this.runQueryMenuItem);
        sqlTextListener popupListener = new sqlTextListener(sqlTextPopup);
        super.addMouseListener(popupListener);
    }

    public void setParseQueryMenuEnabled(boolean onOff) {
        this.parseQueryMenuItem.setEnabled(onOff);
    }

    public void setRunQueryMenuEnabled(boolean onOff) {
        this.runQueryMenuItem.setEnabled(onOff);
    }

    public boolean queryChanged() {
        return !this.getText().equals(this._lastGoodQuery);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem source = (JMenuItem)e.getSource();
        if (source.getText().equals(NbBundle.getMessage(QueryBuilder.class, (String)"PARSE_QUERY"))) {
            String currentQuery = this.getText();
            if (currentQuery != null && currentQuery.trim().length() != 0) {
                QueryBuilder.showBusyCursor(true);
                this._queryBuilder.populate(currentQuery, true);
                QueryBuilder.showBusyCursor(false);
            }
        } else if (source.getText().equals(NbBundle.getMessage(QueryBuilder.class, (String)"RUN_QUERY"))) {
            String currentQuery = this.getText();
            if (currentQuery != null && currentQuery.trim().length() != 0) {
                if (!currentQuery.trim().equals(this._lastGoodQuery)) {
                    QueryBuilder.showBusyCursor(true);
                    this._queryBuilder.populate(this.getText(), true);
                    QueryBuilder.showBusyCursor(false);
                }
            } else {
                return;
            }
            this._queryBuilder.executeQuery(this.getText());
        }
    }

    @Override
    public void setText(String str) {
        if (this.DEBUG) {
            System.out.println("setQueryText called with " + str + "\n");
        }
        String text = str.trim();
        super.setText(text);
        if (!text.equals(this._lastGoodQuery)) {
            this._lastGoodQuery = text;
        }
    }

    public void restoreLastGoodQuery() {
        super.setText(this._lastGoodQuery);
    }

    public void saveLastGoodQuery() {
        this._lastGoodQuery = this.getText();
    }

    void clear() {
        this.setText("");
    }

    static {
        keywords = new ArrayList();
        for (int i = 0; i < sqlReservedWords.length; ++i) {
            keywords.add(sqlReservedWords[i]);
        }
    }

    class sqlTextListener
    extends MouseAdapter {
        JPopupMenu popup;

        sqlTextListener(JPopupMenu popupMenu) {
            this.popup = popupMenu;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.mousePressed(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                if (((JEditorPane)e.getComponent()).getText().trim().length() != 0) {
                    QueryBuilderSqlTextArea.this.parseQueryMenuItem.setEnabled(true);
                    QueryBuilderSqlTextArea.this.runQueryMenuItem.setEnabled(true);
                } else {
                    QueryBuilderSqlTextArea.this.parseQueryMenuItem.setEnabled(false);
                    QueryBuilderSqlTextArea.this.runQueryMenuItem.setEnabled(false);
                }
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

