/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.RegExpPrototypeBuiltins;
import com.oracle.truffle.js.builtins.RegExpPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.StringPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.helper.JSRegExpExecIntlNode;
import com.oracle.truffle.js.builtins.helper.ReplaceStringParser;
import com.oracle.truffle.js.nodes.CompileRegexNode;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.CreateObjectNode;
import com.oracle.truffle.js.nodes.access.GetMethodNode;
import com.oracle.truffle.js.nodes.access.IsRegExpNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.access.RequireObjectCoercibleNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerAsIntNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToRegExpNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.cast.JSToUInt32Node;
import com.oracle.truffle.js.nodes.cast.JSTrimWhitespaceNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.intl.CreateRegExpNode;
import com.oracle.truffle.js.nodes.intl.InitializeCollatorNode;
import com.oracle.truffle.js.nodes.intl.JSToCanonicalizedLocaleListNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSRegExp;
import com.oracle.truffle.js.runtime.builtins.JSString;
import com.oracle.truffle.js.runtime.builtins.intl.JSCollator;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.IntlUtil;
import com.oracle.truffle.js.runtime.util.SimpleArrayList;
import com.oracle.truffle.js.runtime.util.StringBuilderProfile;
import com.oracle.truffle.js.runtime.util.TRegexUtil;
import java.text.Collator;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Locale;

public final class StringPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<StringPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new StringPrototypeBuiltins();
    public static final JSBuiltinsContainer EXTENSION_BUILTINS = new StringPrototypeExtensionBuiltins();

    protected StringPrototypeBuiltins() {
        super("String.prototype", StringPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, StringPrototype builtinEnum) {
        switch (builtinEnum) {
            case charAt: {
                return StringPrototypeBuiltinsFactory.JSStringCharAtNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case charCodeAt: {
                return StringPrototypeBuiltinsFactory.JSStringCharCodeAtNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case concat: {
                return StringPrototypeBuiltinsFactory.JSStringConcatNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().varArgs().createArgumentNodes(context));
            }
            case indexOf: {
                return StringPrototypeBuiltinsFactory.JSStringIndexOfNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case lastIndexOf: {
                return StringPrototypeBuiltinsFactory.JSStringLastIndexOfNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(2).varArgs().createArgumentNodes(context));
            }
            case localeCompare: {
                if (context.isOptionIntl402()) {
                    return StringPrototypeBuiltinsFactory.JSStringLocaleCompareIntlNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(3).createArgumentNodes(context));
                }
                return StringPrototypeBuiltinsFactory.JSStringLocaleCompareNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case match: {
                if (context.getEcmaScriptVersion() >= 6) {
                    return StringPrototypeBuiltinsFactory.JSStringMatchNodeGen.create(context, builtin, false, StringPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
                }
                return StringPrototypeBuiltinsFactory.JSStringMatchES5NodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case replace: {
                if (context.getEcmaScriptVersion() >= 6) {
                    return StringPrototypeBuiltinsFactory.JSStringReplaceNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
                }
                return StringPrototypeBuiltinsFactory.JSStringReplaceES5NodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case replaceAll: {
                return StringPrototypeBuiltinsFactory.JSStringReplaceAllNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case search: {
                if (context.getEcmaScriptVersion() >= 6) {
                    return StringPrototypeBuiltinsFactory.JSStringSearchNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
                }
                return StringPrototypeBuiltinsFactory.JSStringSearchES5NodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().varArgs().createArgumentNodes(context));
            }
            case slice: {
                return StringPrototypeBuiltinsFactory.JSStringSliceNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case split: {
                return StringPrototypeBuiltinsFactory.JSStringSplitNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case substr: {
                return StringPrototypeBuiltinsFactory.JSStringSubstrNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case substring: {
                return StringPrototypeBuiltinsFactory.JSStringSubstringNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case toLowerCase: {
                return StringPrototypeBuiltinsFactory.JSStringToLowerCaseNodeGen.create(context, builtin, false, StringPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case toLocaleLowerCase: {
                if (context.isOptionIntl402()) {
                    return StringPrototypeBuiltinsFactory.JSStringToLocaleLowerCaseIntlNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
                }
                return StringPrototypeBuiltinsFactory.JSStringToLowerCaseNodeGen.create(context, builtin, true, StringPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case toUpperCase: {
                return StringPrototypeBuiltinsFactory.JSStringToUpperCaseNodeGen.create(context, builtin, false, StringPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case toLocaleUpperCase: {
                if (context.isOptionIntl402()) {
                    return StringPrototypeBuiltinsFactory.JSStringToLocaleUpperCaseIntlNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
                }
                return StringPrototypeBuiltinsFactory.JSStringToUpperCaseNodeGen.create(context, builtin, true, StringPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case toString: {
                return StringPrototypeBuiltinsFactory.JSStringToStringNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case valueOf: {
                return StringPrototypeBuiltinsFactory.JSStringToStringNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case trim: {
                return StringPrototypeBuiltinsFactory.JSStringTrimNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case startsWith: {
                return StringPrototypeBuiltinsFactory.JSStringStartsWithNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case endsWith: {
                return StringPrototypeBuiltinsFactory.JSStringEndsWithNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case includes: {
                return StringPrototypeBuiltinsFactory.JSStringIncludesNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case repeat: {
                return StringPrototypeBuiltinsFactory.JSStringRepeatNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case codePointAt: {
                return StringPrototypeBuiltinsFactory.JSStringCodePointAtNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case _iterator: {
                return StringPrototypeBuiltinsFactory.CreateStringIteratorNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case normalize: {
                return StringPrototypeBuiltinsFactory.JSStringNormalizeNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case matchAll: {
                return StringPrototypeBuiltinsFactory.JSStringMatchNodeGen.create(context, builtin, true, StringPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case padStart: {
                return StringPrototypeBuiltinsFactory.JSStringPadNodeGen.create(context, builtin, true, StringPrototypeBuiltins.args().withThis().varArgs().createArgumentNodes(context));
            }
            case padEnd: {
                return StringPrototypeBuiltinsFactory.JSStringPadNodeGen.create(context, builtin, false, StringPrototypeBuiltins.args().withThis().varArgs().createArgumentNodes(context));
            }
            case anchor: {
                return StringPrototypeBuiltins.createHTMLNode(context, builtin, "a", "name");
            }
            case big: {
                return StringPrototypeBuiltins.createHTMLNode(context, builtin, "big", "");
            }
            case blink: {
                return StringPrototypeBuiltins.createHTMLNode(context, builtin, "blink", "");
            }
            case bold: {
                return StringPrototypeBuiltins.createHTMLNode(context, builtin, "b", "");
            }
            case fixed: {
                return StringPrototypeBuiltins.createHTMLNode(context, builtin, "tt", "");
            }
            case fontcolor: {
                return StringPrototypeBuiltins.createHTMLNode(context, builtin, "font", "color");
            }
            case fontsize: {
                return StringPrototypeBuiltins.createHTMLNode(context, builtin, "font", "size");
            }
            case italics: {
                return StringPrototypeBuiltins.createHTMLNode(context, builtin, "i", "");
            }
            case link: {
                return StringPrototypeBuiltins.createHTMLNode(context, builtin, "a", "href");
            }
            case small: {
                return StringPrototypeBuiltins.createHTMLNode(context, builtin, "small", "");
            }
            case strike: {
                return StringPrototypeBuiltins.createHTMLNode(context, builtin, "strike", "");
            }
            case sub: {
                return StringPrototypeBuiltins.createHTMLNode(context, builtin, "sub", "");
            }
            case sup: {
                return StringPrototypeBuiltins.createHTMLNode(context, builtin, "sup", "");
            }
        }
        return null;
    }

    static CreateHTMLNode createHTMLNode(JSContext context, JSBuiltin builtin, String tag, String attribute) {
        return StringPrototypeBuiltinsFactory.CreateHTMLNodeGen.create(context, builtin, tag, attribute, StringPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
    }

    static abstract class CreateHTMLNode
    extends JSBuiltinNode {
        private final String tag;
        private final String attribute;

        CreateHTMLNode(JSContext context, JSBuiltin builtin, String tag, String attribute) {
            super(context, builtin);
            this.tag = tag;
            this.attribute = attribute;
        }

        @Specialization
        protected String createHTML(Object thisObj, Object value, @Cached(value="create()") RequireObjectCoercibleNode requireObjectCoercibleNode, @Cached(value="create()") JSToStringNode toStringNode) {
            String string = toStringNode.executeString(requireObjectCoercibleNode.execute(thisObj));
            if (!this.attribute.isEmpty()) {
                String attrVal = toStringNode.executeString(value);
                return this.wrapInTagWithAttribute(string, attrVal);
            }
            return this.wrapInTag(string);
        }

        @CompilerDirectives.TruffleBoundary
        private String wrapInTag(String string) {
            return "<" + this.tag + ">" + string + "</" + this.tag + ">";
        }

        @CompilerDirectives.TruffleBoundary
        private String wrapInTagWithAttribute(String string, String attrVal) {
            String escapedVal = attrVal.replace("\"", "&quot;");
            return "<" + this.tag + " " + this.attribute + "=\"" + escapedVal + "\">" + string + "</" + this.tag + ">";
        }
    }

    public static abstract class CreateStringIteratorNode
    extends JSBuiltinNode {
        @Node.Child
        private CreateObjectNode.CreateObjectWithPrototypeNode createObjectNode;
        @Node.Child
        private PropertySetNode setNextIndexNode;
        @Node.Child
        private PropertySetNode setIteratedObjectNode;

        public CreateStringIteratorNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.createObjectNode = CreateObjectNode.createOrdinaryWithPrototype(context);
            this.setIteratedObjectNode = PropertySetNode.createSetHidden(JSString.ITERATED_STRING_ID, context);
            this.setNextIndexNode = PropertySetNode.createSetHidden(JSString.STRING_ITERATOR_NEXT_INDEX_ID, context);
        }

        @Specialization
        protected DynamicObject doString(VirtualFrame frame, String string) {
            DynamicObject iterator = this.createObjectNode.execute(frame, this.getContext().getRealm().getStringIteratorPrototype());
            this.setIteratedObjectNode.setValue(iterator, string);
            this.setNextIndexNode.setValueInt(iterator, 0);
            return iterator;
        }

        @Specialization(guards={"!isString(thisObj)"})
        protected DynamicObject doCoerce(VirtualFrame frame, Object thisObj, @Cached(value="create()") RequireObjectCoercibleNode requireObjectCoercibleNode, @Cached(value="create()") JSToStringNode toStringNode) {
            return this.doString(frame, toStringNode.executeString(requireObjectCoercibleNode.execute(thisObj)));
        }
    }

    public static class CreateRegExpStringIteratorNode
    extends JavaScriptBaseNode {
        private final JSContext context;
        @Node.Child
        private CreateObjectNode.CreateObjectWithPrototypeNode createObjectNode;
        @Node.Child
        private PropertySetNode setIteratingRegExpNode;
        @Node.Child
        private PropertySetNode setIteratedStringNode;
        @Node.Child
        private PropertySetNode setGlobalNode;
        @Node.Child
        private PropertySetNode setUnicodeNode;
        @Node.Child
        private PropertySetNode setDoneNode;

        public CreateRegExpStringIteratorNode(JSContext context) {
            this.context = context;
            this.createObjectNode = CreateObjectNode.createOrdinaryWithPrototype(context);
            this.setIteratingRegExpNode = PropertySetNode.createSetHidden(JSString.REGEXP_ITERATOR_ITERATING_REGEXP_ID, context);
            this.setIteratedStringNode = PropertySetNode.createSetHidden(JSString.REGEXP_ITERATOR_ITERATED_STRING_ID, context);
            this.setGlobalNode = PropertySetNode.createSetHidden(JSString.REGEXP_ITERATOR_GLOBAL_ID, context);
            this.setUnicodeNode = PropertySetNode.createSetHidden(JSString.REGEXP_ITERATOR_UNICODE_ID, context);
            this.setDoneNode = PropertySetNode.createSetHidden(JSString.REGEXP_ITERATOR_DONE_ID, context);
            this.adoptChildren();
        }

        public DynamicObject createIterator(VirtualFrame frame, Object regex, String string, Boolean global, Boolean fullUnicode) {
            DynamicObject regExpStringIteratorPrototype = this.context.getRealm().getRegExpStringIteratorPrototype();
            DynamicObject iterator = this.createObjectNode.execute(frame, regExpStringIteratorPrototype);
            this.setIteratingRegExpNode.setValue(iterator, regex);
            this.setIteratedStringNode.setValue(iterator, string);
            this.setGlobalNode.setValueBoolean(iterator, global);
            this.setUnicodeNode.setValueBoolean(iterator, fullUnicode);
            this.setDoneNode.setValueBoolean(iterator, false);
            return iterator;
        }
    }

    public static abstract class JSStringPadNode
    extends JSStringOperation {
        private final boolean atStart;

        public JSStringPadNode(JSContext context, JSBuiltin builtin, boolean atStart) {
            super(context, builtin);
            this.atStart = atStart;
        }

        @Specialization
        protected String pad(Object thisObj, Object[] args, @Cached(value="create()") JSToStringNode toString2Node) {
            String fillStr;
            this.requireObjectCoercible(thisObj);
            String thisStr = this.toString(thisObj);
            if (args.length == 0) {
                return thisStr;
            }
            int len = this.toIntegerAsInt(args[0]);
            if (len <= thisStr.length()) {
                return thisStr;
            }
            if (args.length <= 1 || args[1] == Undefined.instance) {
                fillStr = " ";
            } else {
                fillStr = toString2Node.executeString(args[1]);
                if (fillStr.isEmpty()) {
                    return thisStr;
                }
            }
            if (len > this.getContext().getStringLengthLimit()) {
                CompilerDirectives.transferToInterpreter();
                throw Errors.createRangeErrorInvalidStringLength();
            }
            return this.padIntl(thisStr, fillStr, len);
        }

        @CompilerDirectives.TruffleBoundary
        private String padIntl(String str, String fillStr, int len) {
            assert (!fillStr.isEmpty());
            int pos = len - str.length();
            int fillLen = fillStr.length();
            StringBuilder sb = new StringBuilder(len);
            if (!this.atStart) {
                sb.append(str);
            }
            while (pos >= fillLen) {
                sb.append(fillStr);
                pos -= fillLen;
            }
            if (pos > 0) {
                sb.append(fillStr, 0, pos);
            }
            if (this.atStart) {
                sb.append(str);
            }
            return sb.toString();
        }
    }

    public static abstract class JSStringNormalizeNode
    extends JSStringOperation {
        public JSStringNormalizeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected String normalize(Object thisObj, Object form) {
            this.requireObjectCoercible(thisObj);
            String thisStr = this.toString(thisObj);
            String formStr = this.toString(form);
            return JSStringNormalizeNode.doNormalize(thisStr, form, formStr);
        }

        @CompilerDirectives.TruffleBoundary
        private static String doNormalize(String thisStr, Object form, String formStr) {
            Normalizer.Form useForm = null;
            if (form == Undefined.instance || formStr.length() <= 0 || formStr.equals("NFC")) {
                useForm = Normalizer.Form.NFC;
            } else if (formStr.equals("NFD")) {
                useForm = Normalizer.Form.NFD;
            } else if (formStr.equals("NFKC")) {
                useForm = Normalizer.Form.NFKC;
            } else if (formStr.equals("NFKD")) {
                useForm = Normalizer.Form.NFKD;
            } else {
                throw Errors.createRangeError("invalid form string");
            }
            return Normalizer.normalize(thisStr, useForm);
        }
    }

    public static abstract class JSStringCodePointAtNode
    extends JSStringOperation {
        private final BranchProfile undefinedBranch = BranchProfile.create();
        private final BranchProfile needSecondBranch = BranchProfile.create();
        private final BranchProfile needCalculationBranch = BranchProfile.create();

        public JSStringCodePointAtNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object codePointAt(Object thisObj, Object position) {
            boolean isEnd;
            this.requireObjectCoercible(thisObj);
            String thisStr = this.toString(thisObj);
            int pos = this.toIntegerAsInt(position);
            if (pos < 0 || thisStr.length() <= pos) {
                this.undefinedBranch.enter();
                return Undefined.instance;
            }
            int first = Boundaries.stringCodePointAt(thisStr, pos);
            boolean bl = isEnd = pos + 1 == thisStr.length();
            if (isEnd || first < 55296 || first > 56319) {
                return first;
            }
            this.needSecondBranch.enter();
            int second = Boundaries.stringCodePointAt(thisStr, pos + 1);
            if (second < 56320 || second > 57343) {
                return first;
            }
            this.needCalculationBranch.enter();
            return (first - 55296) * 1024 + (second - 56320) + 65536;
        }
    }

    public static abstract class JSStringRepeatNode
    extends JSStringOperation {
        private final BranchProfile errorBranch = BranchProfile.create();

        public JSStringRepeatNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected String repeat(Object thisObj, Object count, @Cached(value="create()") JSToNumberNode toNumberNode) {
            this.requireObjectCoercible(thisObj);
            String thisStr = this.toString(thisObj);
            Number repeatCountN = toNumberNode.executeNumber(count);
            long repeatCount = JSRuntime.toInteger(repeatCountN);
            if (repeatCount < 0L || repeatCountN instanceof Double && Double.isInfinite(repeatCountN.doubleValue())) {
                this.errorBranch.enter();
                throw Errors.createRangeError("illegal repeat count");
            }
            if (repeatCount == 1L) {
                return thisStr;
            }
            if (repeatCount == 0L || thisStr.length() == 0) {
                return "";
            }
            int repeatCountInt = (int)repeatCount;
            if ((long)repeatCountInt != repeatCount || repeatCount * (long)thisStr.length() > (long)this.getContext().getStringLengthLimit()) {
                this.errorBranch.enter();
                throw Errors.createRangeErrorInvalidStringLength();
            }
            return JSStringRepeatNode.repeatImpl(thisStr, repeatCountInt);
        }

        @CompilerDirectives.TruffleBoundary
        private static String repeatImpl(String str, int repeatCount) {
            StringBuilder sb = new StringBuilder(str.length() * repeatCount);
            for (int i = 0; i < repeatCount; ++i) {
                sb.append(str);
            }
            return sb.toString();
        }
    }

    public static abstract class JSStringIncludesNode
    extends JSStringOperation {
        private final BranchProfile noStringBranch = BranchProfile.create();

        public JSStringIncludesNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isUndefined(position)"})
        protected boolean includesString(String thisStr, String searchStr, Object position) {
            return Boundaries.stringIndexOf(thisStr, searchStr) != -1;
        }

        @Specialization
        protected boolean includesGeneric(Object thisObj, Object searchString, Object position, @Cached(value="create()") JSToStringNode toString2Node, @Cached(value="create(getContext())") IsRegExpNode isRegExpNode) {
            int fromIndex;
            this.requireObjectCoercible(thisObj);
            String thisStr = this.toString(thisObj);
            if (isRegExpNode.executeBoolean(searchString)) {
                this.noStringBranch.enter();
                throw Errors.createTypeError("First argument to String.prototype.includes must not be a regular expression");
            }
            String searchStr = toString2Node.executeString(searchString);
            return Boundaries.stringIndexOf(thisStr, searchStr, fromIndex = this.toIntegerAsInt(position)) != -1;
        }
    }

    public static abstract class JSStringEndsWithNode
    extends JSStringOperation {
        private final BranchProfile noStringBranch = BranchProfile.create();

        public JSStringEndsWithNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isUndefined(position)"})
        protected boolean endsWithStringUndefined(String thisStr, String searchStr, Object position) {
            int fromIndex = thisStr.length();
            if (searchStr.length() <= 0) {
                return true;
            }
            if (fromIndex >= thisStr.length()) {
                fromIndex = thisStr.length();
            } else if (fromIndex < 0) {
                return false;
            }
            return JSStringEndsWithNode.endsWithIntl(thisStr, searchStr, fromIndex);
        }

        @Specialization
        protected boolean endsWithGeneric(Object thisObj, Object searchString, Object position, @Cached(value="create()") JSToStringNode toString2Node, @Cached(value="create(getContext())") IsRegExpNode isRegExpNode) {
            this.requireObjectCoercible(thisObj);
            String thisStr = this.toString(thisObj);
            if (isRegExpNode.executeBoolean(searchString)) {
                this.noStringBranch.enter();
                throw Errors.createTypeError("First argument to String.prototype.endsWith must not be a regular expression");
            }
            String searchStr = toString2Node.executeString(searchString);
            int fromIndex = this.toIntegerAsInt(position);
            if (searchStr.length() <= 0) {
                return true;
            }
            if (fromIndex >= thisStr.length() || position == Undefined.instance) {
                fromIndex = thisStr.length();
            } else if (fromIndex < 0) {
                return false;
            }
            return JSStringEndsWithNode.endsWithIntl(thisStr, searchStr, fromIndex);
        }

        private static boolean endsWithIntl(String thisStr, String searchStr, int fromIndex) {
            int foundIndex = Boundaries.stringLastIndexOf(thisStr, searchStr, fromIndex);
            return foundIndex >= 0 && foundIndex == fromIndex - searchStr.length();
        }
    }

    public static abstract class JSStringStartsWithNode
    extends JSStringOperation {
        private final BranchProfile noStringBranch = BranchProfile.create();

        public JSStringStartsWithNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isUndefined(position)"})
        protected boolean startsWithString(String thisObj, String searchStr, DynamicObject position) {
            if (searchStr.length() <= 0) {
                return true;
            }
            if (thisObj.length() < searchStr.length()) {
                return false;
            }
            for (int i = 0; i < searchStr.length(); ++i) {
                if (thisObj.charAt(i) == searchStr.charAt(i)) continue;
                return false;
            }
            return true;
        }

        @Specialization
        protected boolean startsWithGeneric(Object thisObj, Object searchString, Object position, @Cached(value="create()") JSToStringNode toString2Node, @Cached(value="create(getContext())") IsRegExpNode isRegExpNode) {
            this.requireObjectCoercible(thisObj);
            String thisStr = this.toString(thisObj);
            if (isRegExpNode.executeBoolean(searchString)) {
                this.noStringBranch.enter();
                throw Errors.createTypeError("First argument to String.prototype.startsWith must not be a regular expression");
            }
            String searchStr = toString2Node.executeString(searchString);
            int fromIndex = this.toIntegerAsInt(position);
            if (fromIndex < 0) {
                fromIndex = 0;
            }
            if (searchStr.length() <= 0) {
                return true;
            }
            return Boundaries.stringStartsWith(thisStr, searchStr, fromIndex);
        }
    }

    public static abstract class JSStringSliceNode
    extends JSStringOperation {
        private final ConditionProfile canReturnEmpty = ConditionProfile.createBinaryProfile();
        private final ConditionProfile offsetProfile1 = ConditionProfile.createBinaryProfile();
        private final ConditionProfile offsetProfile2 = ConditionProfile.createBinaryProfile();

        public JSStringSliceNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected String sliceStringIntInt(String str, int start, int end) {
            int len = str.length();
            int istart = JSRuntime.getOffset(start, len, this.offsetProfile1);
            int iend = JSRuntime.getOffset(end, len, this.offsetProfile2);
            if (this.canReturnEmpty.profile(iend > istart)) {
                return Boundaries.substring(str, istart, iend);
            }
            return "";
        }

        @Specialization(replaces={"sliceStringIntInt"})
        protected String sliceObjectIntInt(Object thisObj, int start, int end) {
            this.requireObjectCoercible(thisObj);
            return this.sliceStringIntInt(this.toString(thisObj), start, end);
        }

        @Specialization(guards={"isUndefined(end)"})
        protected String sliceStringIntUndefined(String str, int start, Object end) {
            int istart;
            int len = str.length();
            if (this.canReturnEmpty.profile(len > (istart = JSRuntime.getOffset(start, len, this.offsetProfile1)))) {
                return Boundaries.substring(str, istart, len);
            }
            return "";
        }

        @Specialization(replaces={"sliceStringIntInt", "sliceObjectIntInt", "sliceStringIntUndefined"})
        protected String sliceGeneric(Object thisObj, Object start, Object end, @Cached(value="createBinaryProfile()") ConditionProfile isUndefined) {
            this.requireObjectCoercible(thisObj);
            String s = this.toString(thisObj);
            long len = s.length();
            long istart = JSRuntime.getOffset((long)this.toIntegerAsInt(start), len, this.offsetProfile1);
            long iend = isUndefined.profile(end == Undefined.instance) ? len : JSRuntime.getOffset((long)this.toIntegerAsInt(end), len, this.offsetProfile2);
            if (this.canReturnEmpty.profile(iend > istart)) {
                return Boundaries.substring(s, (int)istart, (int)iend);
            }
            return "";
        }
    }

    public static abstract class JSStringLocaleCompareIntlNode
    extends JSStringOperation {
        @Node.Child
        InitializeCollatorNode initCollatorNode;

        public JSStringLocaleCompareIntlNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.initCollatorNode = InitializeCollatorNode.createInitalizeCollatorNode(context);
        }

        @CompilerDirectives.TruffleBoundary
        private DynamicObject createCollator(Object locales, Object options) {
            DynamicObject collatorObj = JSCollator.create(this.getContext());
            this.initCollatorNode.executeInit(collatorObj, locales, options);
            return collatorObj;
        }

        @Specialization
        protected int localeCompare(Object thisObj, Object thatObj, Object locales, Object options, @Cached(value="create()") JSToStringNode toString2Node) {
            this.requireObjectCoercible(thisObj);
            String thisStr = this.toString(thisObj);
            String thatStr = toString2Node.executeString(thatObj);
            DynamicObject collator = this.createCollator(locales, options);
            return JSCollator.compare(collator, thisStr, thatStr);
        }
    }

    public static abstract class JSStringLocaleCompareNode
    extends JSStringOperation {
        private static Collator collator;

        public JSStringLocaleCompareNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @CompilerDirectives.TruffleBoundary
        private static Collator getCollator() {
            if (collator == null) {
                collator = Collator.getInstance(Locale.ROOT);
                collator.setStrength(2);
                collator.setDecomposition(2);
            }
            return collator;
        }

        @Specialization
        protected int localeCompare(Object thisObj, Object thatObj, @Cached(value="create()") JSToStringNode toString2Node) {
            this.requireObjectCoercible(thisObj);
            String thisStr = this.toString(thisObj);
            String thatStr = toString2Node.executeString(thatObj);
            return JSStringLocaleCompareNode.doLocaleCompare(thisStr, thatStr);
        }

        @CompilerDirectives.TruffleBoundary
        private static int doLocaleCompare(String thisStr, String thatStr) {
            return JSStringLocaleCompareNode.getCollator().compare(thisStr, thatStr);
        }
    }

    public static abstract class JSStringTrimRightNode
    extends JSStringOperation {
        private final ConditionProfile lengthExceeded = ConditionProfile.createBinaryProfile();

        public JSStringTrimRightNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected String trimRight(Object thisObj) {
            this.requireObjectCoercible(thisObj);
            String string = this.toString(thisObj);
            int lastIdx = JSRuntime.lastNonWhitespaceIndex(string, true);
            if (this.lengthExceeded.profile(lastIdx >= string.length())) {
                return string;
            }
            return Boundaries.substring(string, 0, lastIdx + 1);
        }
    }

    public static abstract class JSStringTrimLeftNode
    extends JSStringOperation {
        private final ConditionProfile lengthExceeded = ConditionProfile.createBinaryProfile();
        private final ConditionProfile lengthZero = ConditionProfile.createBinaryProfile();

        public JSStringTrimLeftNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected String trimLeft(Object thisObj) {
            this.requireObjectCoercible(thisObj);
            String string = this.toString(thisObj);
            int firstIdx = JSRuntime.firstNonWhitespaceIndex(string, true);
            if (this.lengthZero.profile(firstIdx == 0)) {
                return string;
            }
            if (this.lengthExceeded.profile(firstIdx >= string.length())) {
                return "";
            }
            return Boundaries.substring(string, firstIdx);
        }
    }

    public static abstract class JSStringTrimNode
    extends JSStringOperation {
        public JSStringTrimNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected String trimString(String thisStr, @Cached.Shared(value="trimWhitespace") @Cached JSTrimWhitespaceNode trimWhitespaceNode) {
            return trimWhitespaceNode.executeString(thisStr);
        }

        @Specialization
        protected String trimObject(Object thisObj, @Cached.Shared(value="trimWhitespace") @Cached JSTrimWhitespaceNode trimWhitespaceNode) {
            this.requireObjectCoercible(thisObj);
            return trimWhitespaceNode.executeString(this.toString(thisObj));
        }
    }

    public static abstract class JSStringMatchES5Node
    extends JSStringOperationWithRegExpArgument {
        @Node.Child
        private PropertySetNode setLastIndexNode;
        @Node.Child
        private JSToRegExpNode toRegExpNode;
        @Node.Child
        private RegExpPrototypeBuiltins.JSRegExpExecES5Node regExpExecNode;
        @Node.Child
        private TRegexUtil.TRegexCompiledRegexSingleFlagAccessor globalFlagAccessor = TRegexUtil.TRegexCompiledRegexSingleFlagAccessor.create("global");
        @Node.Child
        private TRegexUtil.TRegexResultAccessor resultAccessor = TRegexUtil.TRegexResultAccessor.create();
        @Node.Child
        private TRegexUtil.TRegexMaterializeResultNode resultMaterializer = TRegexUtil.TRegexMaterializeResultNode.create();
        private final ConditionProfile match = ConditionProfile.createCountingProfile();
        private final ConditionProfile isGlobalRegExp = ConditionProfile.createCountingProfile();

        public JSStringMatchES5Node(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            assert (context.getEcmaScriptVersion() < 6);
            this.toRegExpNode = JSToRegExpNode.create(context);
            this.regExpExecNode = RegExpPrototypeBuiltinsFactory.JSRegExpExecES5NodeGen.create(context, null, null);
        }

        private void setLastIndex(DynamicObject regExp, int value) {
            if (this.setLastIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.setLastIndexNode = (PropertySetNode)this.insert(PropertySetNode.create("lastIndex", false, this.getContext(), true));
            }
            this.setLastIndexNode.setValue(regExp, value);
        }

        @Specialization
        protected DynamicObject matchRegExpNotGlobal(Object thisObj, Object searchObj) {
            this.requireObjectCoercible(thisObj);
            if (this.isGlobalRegExp.profile(JSRegExp.isJSRegExp(searchObj) && this.globalFlagAccessor.get(JSRegExp.getCompiledRegex((DynamicObject)searchObj)))) {
                String thisStr = this.toString(thisObj);
                return this.matchAll((DynamicObject)searchObj, thisStr);
            }
            return this.matchNotRegExpIntl(thisObj, searchObj);
        }

        private DynamicObject matchNotRegExpIntl(Object thisObj, Object searchObj) {
            String thisStr = this.toString(thisObj);
            DynamicObject regExp = this.toRegExpNode.execute(searchObj);
            return this.regExpExecNode.exec(regExp, (Object)thisStr);
        }

        private DynamicObject matchAll(DynamicObject regExp, String input) {
            this.setLastIndex(regExp, 0);
            Object result = this.matchIgnoreLastIndex(regExp, input, 0);
            if (this.match.profile(!this.resultAccessor.isMatch(result))) {
                return Null.instance;
            }
            ArrayList matches = new ArrayList();
            int lastIndex = 0;
            while (this.resultAccessor.isMatch(result)) {
                Boundaries.listAdd(matches, (String)this.resultMaterializer.materializeGroup(result, 0, input));
                int thisIndex = this.resultAccessor.captureGroupEnd(result, 0);
                lastIndex = thisIndex + (thisIndex == lastIndex ? 1 : 0);
                result = this.matchIgnoreLastIndex(regExp, input, lastIndex);
            }
            return JSArray.createConstant(this.getContext(), Boundaries.listToArray(matches));
        }
    }

    public static abstract class JSStringMatchNode
    extends JSStringOperationWithRegExpArgument {
        @Node.Child
        private CompileRegexNode compileRegexNode;
        @Node.Child
        private CreateRegExpNode createRegExpNode;
        @Node.Child
        private IsRegExpNode isRegExpNode;
        @Node.Child
        private PropertyGetNode getFlagsNode;
        private final BranchProfile errorBranch;
        private final boolean matchAll;

        protected JSStringMatchNode(JSContext context, JSBuiltin builtin, boolean matchAll) {
            super(context, builtin);
            this.matchAll = matchAll;
            this.errorBranch = matchAll ? BranchProfile.create() : null;
        }

        @Specialization
        protected Object match(Object thisObj, Object regex) {
            this.requireObjectCoercible(thisObj);
            if (this.isSpecialProfile.profile(regex != Undefined.instance && regex != Null.instance)) {
                Object matcher;
                if (this.matchAll && this.getIsRegExpNode().executeBoolean(regex)) {
                    Object flags = this.getFlags(regex);
                    this.requireObjectCoercible(flags);
                    if (this.toString(flags).indexOf(103) == -1) {
                        this.errorBranch.enter();
                        throw Errors.createTypeError("Regular expression passed to matchAll() is missing 'g' flag.");
                    }
                }
                if (this.callSpecialProfile.profile((matcher = this.getMethod(regex, this.matchSymbol())) != Undefined.instance)) {
                    return this.call(matcher, regex, new Object[]{thisObj});
                }
            }
            return this.builtinMatch(thisObj, regex);
        }

        private Symbol matchSymbol() {
            return this.matchAll ? Symbol.SYMBOL_MATCH_ALL : Symbol.SYMBOL_MATCH;
        }

        private Object builtinMatch(Object thisObj, Object regex) {
            String thisStr = this.toString(thisObj);
            Object cRe = this.getCompileRegexNode().compile(regex == Undefined.instance ? "" : this.toString(regex), this.matchAll ? "g" : "");
            DynamicObject regExp = this.getCreateRegExpNode().createRegExp(cRe);
            return this.invoke(regExp, this.matchSymbol(), thisStr);
        }

        private CompileRegexNode getCompileRegexNode() {
            if (this.compileRegexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.compileRegexNode = (CompileRegexNode)this.insert(CompileRegexNode.create(this.getContext()));
            }
            return this.compileRegexNode;
        }

        private CreateRegExpNode getCreateRegExpNode() {
            if (this.createRegExpNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.createRegExpNode = (CreateRegExpNode)this.insert(CreateRegExpNode.create(this.getContext()));
            }
            return this.createRegExpNode;
        }

        private IsRegExpNode getIsRegExpNode() {
            if (this.isRegExpNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isRegExpNode = (IsRegExpNode)this.insert(IsRegExpNode.create(this.getContext()));
            }
            return this.isRegExpNode;
        }

        private Object getFlags(Object regexp) {
            if (this.getFlagsNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getFlagsNode = (PropertyGetNode)this.insert(PropertyGetNode.create("flags", this.getContext()));
            }
            return this.getFlagsNode.getValue(regexp);
        }
    }

    public static abstract class JSStringSubstrNode
    extends JSStringOperation {
        private final BranchProfile startNegativeBranch = BranchProfile.create();
        private final BranchProfile finalLenEmptyBranch = BranchProfile.create();

        public JSStringSubstrNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected String substrInt(String thisStr, int start, int length) {
            return this.substrIntl(thisStr, start, length);
        }

        @Specialization(guards={"isUndefined(length)"})
        protected String substrLenUndef(String thisStr, int start, Object length) {
            return this.substrIntl(thisStr, start, thisStr.length());
        }

        @Specialization(replaces={"substrInt", "substrLenUndef"})
        protected String substrGeneric(Object thisObj, Object start, Object length) {
            this.requireObjectCoercible(thisObj);
            String thisStr = this.toString(thisObj);
            int startInt = this.toIntegerAsInt(start);
            int len = length == Undefined.instance ? thisStr.length() : this.toIntegerAsInt(length);
            return this.substrIntl(thisStr, startInt, len);
        }

        private String substrIntl(String thisStr, int start, int length) {
            int finalLen;
            int startInt = start;
            if (startInt < 0) {
                this.startNegativeBranch.enter();
                startInt = Math.max(startInt + thisStr.length(), 0);
            }
            if ((finalLen = JSStringSubstrNode.within(length, 0, Math.max(0, thisStr.length() - startInt))) <= 0) {
                this.finalLenEmptyBranch.enter();
                return "";
            }
            return Boundaries.substring(thisStr, startInt, startInt + finalLen);
        }
    }

    public static abstract class JSStringSearchES5Node
    extends JSStringOperationWithRegExpArgument {
        @Node.Child
        private TRegexUtil.TRegexResultAccessor resultAccessor = TRegexUtil.TRegexResultAccessor.create();

        public JSStringSearchES5Node(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected int search(Object thisObj, Object[] args, @Cached(value="create(getContext())") JSToRegExpNode toRegExpNode) {
            assert (this.getContext().getEcmaScriptVersion() < 6);
            Object searchObj = JSRuntime.getArgOrUndefined(args, 0);
            this.requireObjectCoercible(thisObj);
            String thisStr = this.toString(thisObj);
            DynamicObject regExp = toRegExpNode.execute(searchObj);
            Object result = this.matchIgnoreLastIndex(regExp, thisStr, 0);
            return this.resultAccessor.isMatch(result) ? this.resultAccessor.captureGroupStart(result, 0) : -1;
        }
    }

    public static abstract class JSStringSearchNode
    extends JSStringOperationWithRegExpArgument {
        @Node.Child
        private CompileRegexNode compileRegexNode;
        @Node.Child
        private CreateRegExpNode createRegExpNode;

        public JSStringSearchNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object search(Object thisObj, Object regex) {
            Object searcher;
            assert (this.getContext().getEcmaScriptVersion() >= 6);
            this.requireObjectCoercible(thisObj);
            if (this.isSpecialProfile.profile(regex != Undefined.instance && regex != Null.instance) && this.callSpecialProfile.profile((searcher = this.getMethod(regex, Symbol.SYMBOL_SEARCH)) != Undefined.instance)) {
                return this.call(searcher, regex, new Object[]{thisObj});
            }
            return this.builtinSearch(thisObj, regex);
        }

        private Object builtinSearch(Object thisObj, Object regex) {
            String thisStr = this.toString(thisObj);
            Object cRe = this.getCompileRegexNode().compile(regex == Undefined.instance ? "" : this.toString(regex));
            DynamicObject regExp = this.getCreateRegExpNode().createRegExp(cRe);
            return this.invoke(regExp, Symbol.SYMBOL_SEARCH, thisStr);
        }

        private CompileRegexNode getCompileRegexNode() {
            if (this.compileRegexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.compileRegexNode = (CompileRegexNode)this.insert(CompileRegexNode.create(this.getContext()));
            }
            return this.compileRegexNode;
        }

        private CreateRegExpNode getCreateRegExpNode() {
            if (this.createRegExpNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.createRegExpNode = (CreateRegExpNode)this.insert(CreateRegExpNode.create(this.getContext()));
            }
            return this.createRegExpNode;
        }
    }

    public static abstract class JSStringToUpperCaseNode
    extends JSStringOperation {
        private final boolean locale;

        public JSStringToUpperCaseNode(JSContext context, JSBuiltin builtin, boolean locale) {
            super(context, builtin);
            this.locale = locale;
        }

        @Specialization
        protected String toUpperCaseString(String thisStr) {
            return this.toUpperCaseIntl(thisStr);
        }

        @Specialization(replaces={"toUpperCaseString"})
        protected String toUpperCaseGeneric(Object thisObj) {
            this.requireObjectCoercible(thisObj);
            String thisStr = this.toString(thisObj);
            return this.toUpperCaseIntl(thisStr);
        }

        private String toUpperCaseIntl(String str) {
            return Boundaries.stringToUpperCase(str, this.locale ? this.getContext().getLocale() : Locale.US);
        }
    }

    public static abstract class JSStringToLocaleUpperCaseIntlNode
    extends JSStringToLocaleXCaseIntl {
        public JSStringToLocaleUpperCaseIntlNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Override
        protected String toXCase(String thisStr, String[] locales) {
            return IntlUtil.toUpperCase(this.getContext(), thisStr, locales);
        }
    }

    public static abstract class JSStringToLocaleLowerCaseIntlNode
    extends JSStringToLocaleXCaseIntl {
        public JSStringToLocaleLowerCaseIntlNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Override
        protected String toXCase(String thisStr, String[] locales) {
            return IntlUtil.toLowerCase(this.getContext(), thisStr, locales);
        }
    }

    public static abstract class JSStringToLocaleXCaseIntl
    extends JSStringOperation {
        @Node.Child
        JSToCanonicalizedLocaleListNode toCanonicalizedLocaleListNode;

        public JSStringToLocaleXCaseIntl(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.toCanonicalizedLocaleListNode = JSToCanonicalizedLocaleListNode.create(context);
        }

        @Specialization
        protected String toDesiredCase(Object thisObj, Object locale) {
            this.requireObjectCoercible(thisObj);
            String thisStr = this.toString(thisObj);
            if (thisStr == null || thisStr.isEmpty()) {
                return thisStr;
            }
            String[] locales = this.toCanonicalizedLocaleListNode.executeLanguageTags(locale);
            return this.toXCase(thisStr, locales);
        }

        protected String toXCase(String thisStr, String[] locales) {
            throw new UnsupportedOperationException();
        }
    }

    public static abstract class JSStringToLowerCaseNode
    extends JSStringOperation {
        private final boolean locale;

        public JSStringToLowerCaseNode(JSContext context, JSBuiltin builtin, boolean locale) {
            super(context, builtin);
            this.locale = locale;
        }

        @Specialization
        protected String toLowerCaseString(String thisStr) {
            return this.toLowerCaseIntl(thisStr);
        }

        @Specialization(replaces={"toLowerCaseString"})
        protected String toLowerCase(Object thisObj) {
            this.requireObjectCoercible(thisObj);
            String thisStr = this.toString(thisObj);
            return this.toLowerCaseIntl(thisStr);
        }

        private String toLowerCaseIntl(String str) {
            return Boundaries.stringToLowerCase(str, this.locale ? this.getContext().getLocale() : Locale.US);
        }
    }

    public static abstract class JSStringToStringNode
    extends JSBuiltinNode {
        public JSStringToStringNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        public static JSStringToStringNode createStringToString(JSContext context) {
            return StringPrototypeBuiltinsFactory.JSStringToStringNodeGen.create(context, null, null);
        }

        protected abstract String executeString(Object var1);

        private String executeString(CharSequence charSequence) {
            return this.executeString((Object)charSequence);
        }

        @Specialization(guards={"isJSString(thisStr)"})
        protected String toStringString(DynamicObject thisStr, @Cached(value="createStringToString(getContext())") JSStringToStringNode nestedToString) {
            return nestedToString.executeString(JSString.getCharSequence(thisStr));
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected String toStringCharseq(CharSequence thisStr) {
            return thisStr.toString();
        }

        @Specialization(guards={"!isString(thisObj)", "!isJSString(thisObj)"})
        protected String toStringGeneric(Object thisObj) {
            throw Errors.createTypeError("string object expected");
        }
    }

    public static abstract class JSStringReplaceES5Node
    extends JSStringOperationWithRegExpArgument {
        @Node.Child
        private PropertySetNode setLastIndexNode;
        @Node.Child
        private StringReplacer stringReplacerNode;
        @Node.Child
        private FunctionReplacer functionReplacerNode;
        @Node.Child
        private JSToStringNode toString2Node;
        @Node.Child
        private JSToStringNode toString3Node;
        @Node.Child
        private TRegexUtil.TRegexCompiledRegexSingleFlagAccessor globalFlagAccessor = TRegexUtil.TRegexCompiledRegexSingleFlagAccessor.create("global");
        @Node.Child
        private TRegexUtil.TRegexCompiledRegexAccessor compiledRegexAccessor = TRegexUtil.TRegexCompiledRegexAccessor.create();
        @Node.Child
        private TRegexUtil.TRegexResultAccessor resultAccessor = TRegexUtil.TRegexResultAccessor.create();
        private final ConditionProfile match = ConditionProfile.createCountingProfile();
        private final ConditionProfile isRegExp = ConditionProfile.createCountingProfile();
        private final ConditionProfile isFnRepl = ConditionProfile.createCountingProfile();

        public JSStringReplaceES5Node(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            assert (context.getEcmaScriptVersion() < 6);
        }

        @Specialization
        protected String replace(Object thisObj, Object searchValue, Object replaceValue) {
            this.requireObjectCoercible(thisObj);
            String thisStr = this.toString(thisObj);
            if (thisStr.length() > this.getContext().getStringLengthLimit()) {
                CompilerDirectives.transferToInterpreter();
                throw Errors.createRangeErrorInvalidStringLength();
            }
            if (this.isRegExp.profile(JSRegExp.isJSRegExp(searchValue))) {
                DynamicObject searchRegExp = (DynamicObject)searchValue;
                int groupCount = this.compiledRegexAccessor.groupCount(JSRegExp.getCompiledRegex(searchRegExp));
                if (this.isFnRepl.profile(JSFunction.isJSFunction(replaceValue))) {
                    DynamicObject replaceFunc = (DynamicObject)replaceValue;
                    if (this.globalFlagAccessor.get(JSRegExp.getCompiledRegex(searchRegExp))) {
                        return this.replaceAll(searchRegExp, thisStr, groupCount, this.getFunctionReplacerNode(), replaceFunc);
                    }
                    return this.replaceFirst(thisStr, searchRegExp, this.getFunctionReplacerNode(), replaceFunc);
                }
                String replaceStr = this.toString3(replaceValue);
                if (this.globalFlagAccessor.get(JSRegExp.getCompiledRegex(searchRegExp))) {
                    return this.replaceAll(searchRegExp, thisStr, groupCount, this.getStringReplacerNode(), replaceStr);
                }
                return this.replaceFirst(thisStr, searchRegExp, this.getStringReplacerNode(), replaceStr);
            }
            String searchStr = this.toString2(searchValue);
            if (this.isFnRepl.profile(JSFunction.isJSFunction(replaceValue))) {
                return this.replaceFirst(thisStr, searchStr, this.getFunctionReplacerNode(), (DynamicObject)replaceValue);
            }
            String replaceStr = this.toString3(replaceValue);
            return this.replaceFirst(thisStr, searchStr, this.getStringReplacerNode(), replaceStr);
        }

        private String toString2(Object obj) {
            if (this.toString2Node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toString2Node = (JSToStringNode)this.insert(JSToStringNode.create());
            }
            return this.toString2Node.executeString(obj);
        }

        private String toString3(Object obj) {
            if (this.toString3Node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toString3Node = (JSToStringNode)this.insert(JSToStringNode.create());
            }
            return this.toString3Node.executeString(obj);
        }

        private void setLastIndex(DynamicObject regExp, int value) {
            if (this.setLastIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.setLastIndexNode = (PropertySetNode)this.insert(PropertySetNode.create("lastIndex", false, this.getContext(), true));
            }
            this.setLastIndexNode.setValueInt(regExp, value);
        }

        private StringReplacer getStringReplacerNode() {
            if (this.stringReplacerNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.stringReplacerNode = (StringReplacer)this.insert(StringReplacer.create());
            }
            return this.stringReplacerNode;
        }

        private FunctionReplacer getFunctionReplacerNode() {
            if (this.functionReplacerNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.functionReplacerNode = (FunctionReplacer)this.insert(FunctionReplacer.create());
            }
            return this.functionReplacerNode;
        }

        private <T> String replaceFirst(String thisStr, String searchStr, Replacer<T> replacer, T replaceValue) {
            int start = thisStr.indexOf(searchStr);
            if (this.match.profile(start < 0)) {
                return thisStr;
            }
            int end = start + searchStr.length();
            StringBuilder sb = new StringBuilder(thisStr.length() * 2);
            Boundaries.builderAppend(sb, thisStr, 0, start);
            replacer.appendReplacement(sb, thisStr, searchStr, start, replaceValue);
            Boundaries.builderAppend(sb, thisStr, end, thisStr.length());
            return Boundaries.builderToString(sb);
        }

        private <T> String replaceFirst(String thisStr, DynamicObject regExp, Replacer<T> replacer, T replaceValue) {
            Object result = this.match(regExp, thisStr);
            if (this.match.profile(!this.resultAccessor.isMatch(result))) {
                return thisStr;
            }
            return this.replace(thisStr, result, this.compiledRegexAccessor.groupCount(JSRegExp.getCompiledRegex(regExp)), replacer, replaceValue);
        }

        protected final Object match(DynamicObject regExp, String input) {
            assert (this.getContext().getEcmaScriptVersion() <= 5);
            return this.getRegExpNode().execute(regExp, input);
        }

        private <T> String replace(String thisStr, Object result, int groupCount, Replacer<T> replacer, T replaceValue) {
            StringBuilder sb = new StringBuilder(replacer.guessResultLength(result, replaceValue, thisStr));
            Boundaries.builderAppend(sb, thisStr, 0, this.resultAccessor.captureGroupStart(result, 0));
            replacer.appendReplacement(sb, thisStr, result, groupCount, replaceValue);
            Boundaries.builderAppend(sb, thisStr, this.resultAccessor.captureGroupEnd(result, 0), thisStr.length());
            return Boundaries.builderToString(sb);
        }

        private <T> String replaceAll(DynamicObject regExp, String input, int groupCount, Replacer<T> replacer, T replaceValue) {
            this.setLastIndex(regExp, 0);
            Object result = this.matchIgnoreLastIndex(regExp, input, 0);
            if (this.match.profile(!this.resultAccessor.isMatch(result))) {
                return input;
            }
            StringBuilder sb = new StringBuilder(replacer.guessResultLength(result, replaceValue, input));
            int thisIndex = 0;
            int lastIndex = 0;
            while (this.resultAccessor.isMatch(result)) {
                Boundaries.builderAppend(sb, input, thisIndex, this.resultAccessor.captureGroupStart(result, 0));
                replacer.appendReplacement(sb, input, result, groupCount, replaceValue);
                if (sb.length() > this.getContext().getStringLengthLimit()) {
                    CompilerDirectives.transferToInterpreter();
                    throw Errors.createRangeErrorInvalidStringLength();
                }
                thisIndex = this.resultAccessor.captureGroupEnd(result, 0);
                if (thisIndex == input.length() && this.resultAccessor.captureGroupLength(result, 0) == 0) break;
                lastIndex = thisIndex + (thisIndex == lastIndex ? 1 : 0);
                result = this.matchIgnoreLastIndex(regExp, input, lastIndex);
            }
            Boundaries.builderAppend(sb, input, thisIndex, input.length());
            return Boundaries.builderToString(sb);
        }

        protected static final class FunctionReplacer
        extends Replacer<DynamicObject> {
            @Node.Child
            private JSFunctionCallNode functionCallNode = JSFunctionCallNode.createCall();
            @Node.Child
            private JSToStringNode toStringNode = JSToStringNode.create();

            private FunctionReplacer() {
            }

            public static FunctionReplacer create() {
                return new FunctionReplacer();
            }

            @Override
            void appendReplacement(StringBuilder sb, String input, Object result, int groupCount, DynamicObject replaceFunc) {
                String replaceStr = this.callReplaceValueFunc(result, input, groupCount, replaceFunc);
                Boundaries.builderAppend(sb, replaceStr);
            }

            @Override
            void appendReplacement(StringBuilder sb, String input, String matchedString, int pos, DynamicObject replaceFunc) {
                Object[] arguments = FunctionReplacer.createArguments(new Object[]{matchedString}, pos, input, replaceFunc);
                Object replaceValue = this.functionCallNode.executeCall(arguments);
                String replaceStr = this.toStringNode.executeString(replaceValue);
                Boundaries.builderAppend(sb, replaceStr);
            }

            private String callReplaceValueFunc(Object result, String input, int groupCount, DynamicObject replaceFunc) {
                Object[] matches = this.resultMaterializer.materializeFull(result, groupCount, input);
                Object[] arguments = FunctionReplacer.createArguments(matches, this.resultAccessor.captureGroupStart(result, 0), input, replaceFunc);
                Object replaceValue = this.functionCallNode.executeCall(arguments);
                return this.toStringNode.executeString(replaceValue);
            }

            private static Object[] createArguments(Object[] matches, int matchIndex, CharSequence input, DynamicObject replaceFunc) {
                JSDynamicObject target = Undefined.instance;
                Object[] arguments = JSArguments.createInitial((Object)target, replaceFunc, matches.length + 2);
                JSArguments.setUserArguments(arguments, 0, matches);
                JSArguments.setUserArgument(arguments, matches.length, matchIndex);
                JSArguments.setUserArgument(arguments, matches.length + 1, input);
                return arguments;
            }
        }

        protected static final class StringReplacer
        extends Replacer<String> {
            private final BranchProfile dollarProfile = BranchProfile.create();

            private StringReplacer() {
            }

            public static StringReplacer create() {
                return new StringReplacer();
            }

            @Override
            int guessResultLength(Object result, String replaceStr, String input) {
                if (replaceStr.isEmpty()) {
                    return input.length() - this.resultAccessor.captureGroupLength(result, 0);
                }
                return input.length() * 2;
            }

            @Override
            void appendReplacement(StringBuilder sb, String input, Object result, int groupCount, String replaceStr) {
                if (this.emptyReplace.profile(!replaceStr.isEmpty())) {
                    int pos = StringReplacer.nextDollar(sb, 0, replaceStr);
                    while (pos != -1) {
                        this.replaceDollar.enter();
                        pos = this.appendSubstitution(sb, input, pos + 1, groupCount, result, replaceStr);
                        pos = StringReplacer.nextDollar(sb, pos, replaceStr);
                    }
                }
            }

            @Override
            void appendReplacement(StringBuilder sb, String input, String matchedString, int pos, String replaceValue) {
                JSStringReplaceNode.appendSubstitution(sb, input, replaceValue, matchedString, pos, this.dollarProfile);
            }

            private int appendSubstitution(StringBuilder sb, String input, int pos, int groupCount, Object result, String replaceStr) {
                if (pos == replaceStr.length()) {
                    Boundaries.builderAppend(sb, '$');
                    return pos;
                }
                char ch = replaceStr.charAt(pos);
                switch (ch) {
                    case '$': {
                        Boundaries.builderAppend(sb, '$');
                        break;
                    }
                    case '&': {
                        Boundaries.builderAppend(sb, (String)this.resultMaterializer.materializeGroup(result, 0, input));
                        break;
                    }
                    case '`': {
                        Boundaries.builderAppend(sb, input, 0, this.resultAccessor.captureGroupStart(result, 0));
                        break;
                    }
                    case '\'': {
                        Boundaries.builderAppend(sb, input, this.resultAccessor.captureGroupEnd(result, 0), input.length());
                        break;
                    }
                    default: {
                        if (this.groups.profile(Boundaries.characterIsDigit(ch))) {
                            return pos + this.appendGroup(sb, input, pos + 1, ch, groupCount, result, replaceStr);
                        }
                        Boundaries.builderAppend(sb, '$');
                        Boundaries.builderAppend(sb, ch);
                    }
                }
                return pos + 1;
            }

            private static int nextDollar(StringBuilder sb, int start, String replaceStr) {
                int pos = replaceStr.indexOf(36, start);
                int end = pos == -1 ? replaceStr.length() : pos;
                Boundaries.builderAppend(sb, replaceStr, start, end);
                return pos;
            }

            private int appendGroup(StringBuilder sb, String input, int pos, char digit, int groupCount, Object result, String replaceStr) {
                int groupNr = StringReplacer.parseGroupNr(replaceStr, pos, digit, groupCount - 1);
                if (groupNr == -1) {
                    Boundaries.builderAppend(sb, '$');
                    Boundaries.builderAppend(sb, digit);
                    return 1;
                }
                String group = (String)this.resultMaterializer.materializeGroup(result, groupNr, input);
                Boundaries.builderAppend(sb, group);
                return groupNr > 9 ? 2 : 1;
            }

            private static int parseGroupNr(String str, int pos, char digit, int groupCount) {
                int nn;
                char ch;
                int n = StringReplacer.toInt(digit);
                if (n > groupCount) {
                    return -1;
                }
                if (pos < str.length() && Boundaries.characterIsDigit(ch = str.charAt(pos)) && (nn = n * 10 + StringReplacer.toInt(ch)) < groupCount) {
                    return nn;
                }
                return n;
            }

            private static int toInt(char digit) {
                return digit - 48;
            }
        }

        private static abstract class Replacer<T>
        extends JavaScriptBaseNode {
            @Node.Child
            TRegexUtil.TRegexCompiledRegexAccessor compiledRegexAccessor = TRegexUtil.TRegexCompiledRegexAccessor.create();
            @Node.Child
            TRegexUtil.TRegexResultAccessor resultAccessor = TRegexUtil.TRegexResultAccessor.create();
            @Node.Child
            TRegexUtil.TRegexMaterializeResultNode resultMaterializer = TRegexUtil.TRegexMaterializeResultNode.create();
            protected final ConditionProfile emptyReplace = ConditionProfile.createBinaryProfile();
            protected final ConditionProfile groups = ConditionProfile.createBinaryProfile();
            protected final BranchProfile replaceDollar = BranchProfile.create();

            private Replacer() {
            }

            int guessResultLength(Object result, T replaceValue, String input) {
                return input.length() * 2;
            }

            abstract void appendReplacement(StringBuilder var1, String var2, Object var3, int var4, T var5);

            abstract void appendReplacement(StringBuilder var1, String var2, String var3, int var4, T var5);
        }
    }

    public static abstract class JSStringReplaceAllNode
    extends JSStringReplaceBaseNode {
        private final ConditionProfile isSearchValueEmpty = ConditionProfile.createBinaryProfile();
        private final ConditionProfile isRegExp = ConditionProfile.createBinaryProfile();
        private final BranchProfile errorBranch = BranchProfile.create();
        @Node.Child
        private IsRegExpNode isRegExpNode;
        @Node.Child
        private PropertyGetNode getFlagsNode;

        public JSStringReplaceAllNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"cachedReplaceValue.equals(replaceValue)"})
        protected Object replaceStringCached(Object thisObj, String searchValue, String replaceValue, @Cached(value="replaceValue") String cachedReplaceValue, @Cached(value="parseReplaceValue(replaceValue)", dimensions=1) ReplaceStringParser.Token[] cachedParsedReplaceValue) {
            this.requireObjectCoercible(thisObj);
            return this.performReplaceAll(searchValue, cachedReplaceValue, thisObj, cachedParsedReplaceValue);
        }

        @Specialization(replaces={"replaceStringCached"})
        protected Object replaceString(Object thisObj, String searchValue, String replaceValue) {
            this.requireObjectCoercible(thisObj);
            return this.performReplaceAll(searchValue, replaceValue, thisObj, null);
        }

        protected Object performReplaceAll(String searchValue, String replaceValue, Object thisObj, ReplaceStringParser.Token[] parsedReplaceParam) {
            String thisStr = this.toString(thisObj);
            if (this.isSearchValueEmpty.profile(searchValue.isEmpty())) {
                return Boundaries.stringReplaceAll(thisStr, "", replaceValue);
            }
            StringBuilder result = new StringBuilder();
            int position = 0;
            while (position < thisStr.length()) {
                position = this.builtinReplaceString(searchValue, replaceValue, thisStr, parsedReplaceParam, position, result);
            }
            return Boundaries.builderToString(result);
        }

        @Specialization(replaces={"replaceString", "replaceStringCached"})
        protected Object replaceGeneric(Object thisObj, Object searchValue, Object replaceValue) {
            this.requireObjectCoercible(thisObj);
            Object searchVal = this.searchValueProfile.profile(searchValue);
            Object replaceVal = this.replaceValueProfile.profile(replaceValue);
            if (this.isSpecialProfile.profile(searchVal != Undefined.instance && searchVal != Null.instance)) {
                Object replacer;
                if (this.isRegExp.profile(this.getIsRegExpNode().executeBoolean(searchValue))) {
                    Object flags = this.getFlags(searchValue);
                    this.requireObjectCoercible(flags);
                    if (this.toString(flags).indexOf(103) == -1) {
                        this.errorBranch.enter();
                        throw Errors.createTypeError("Only global regexps allowed");
                    }
                }
                if (this.callSpecialProfile.profile((replacer = this.getMethod(searchVal, Symbol.SYMBOL_REPLACE)) != Undefined.instance)) {
                    return this.call(replacer, searchVal, new Object[]{thisObj, replaceVal});
                }
            }
            if (this.toString2Node == null || this.toString3Node == null || this.isCallableNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toString2Node = (JSToStringNode)this.insert(JSToStringNode.create());
                this.toString3Node = (JSToStringNode)this.insert(JSToStringNode.create());
                this.isCallableNode = (IsCallableNode)this.insert(IsCallableNode.create());
            }
            return this.performReplaceAllGeneric(searchVal, replaceVal, thisObj);
        }

        protected Object performReplaceAllGeneric(Object searchValue, Object replParam, Object thisObj) {
            int position;
            String thisStr = this.toString(thisObj);
            String searchString = this.toString2Node.executeString(searchValue);
            StringBuilder result = new StringBuilder();
            boolean functionalReplace = this.isCallableNode.executeBoolean(replParam);
            Object replaceValue = this.functionalReplaceProfile.profile(functionalReplace) ? replParam : this.toString3Node.executeString(replParam);
            if (this.isSearchValueEmpty.profile(searchString.isEmpty())) {
                for (position = 0; position <= thisStr.length(); ++position) {
                    this.builtinReplace(searchString, functionalReplace, replaceValue, thisStr, position, result);
                    if (position >= thisStr.length()) continue;
                    Boundaries.builderAppend(result, thisStr.charAt(position));
                }
                return Boundaries.builderToString(result);
            }
            while (position < thisStr.length()) {
                position = this.builtinReplace(searchString, functionalReplace, replaceValue, thisStr, position, result);
            }
            return Boundaries.builderToString(result);
        }

        private int builtinReplace(String searchString, boolean functionalReplace, Object replParam, String input, int position, StringBuilder result) {
            int pos = input.indexOf(searchString, position);
            if (this.replaceNecessaryProfile.profile(pos < 0)) {
                Boundaries.builderAppend(result, input, position, input.length());
                return input.length();
            }
            Boundaries.builderAppend(result, input, position, pos);
            if (this.functionalReplaceProfile.profile(functionalReplace)) {
                Object replValue = this.functionReplaceCall(replParam, (Object)Undefined.instance, new Object[]{searchString, pos, input});
                Boundaries.builderAppend(result, this.toString3Node.executeString(replValue));
            } else {
                JSStringReplaceAllNode.appendSubstitution(result, input, (String)replParam, searchString, pos, this.dollarProfile);
            }
            return pos + searchString.length();
        }

        private int builtinReplaceString(String searchString, String replaceString, String input, ReplaceStringParser.Token[] parsedReplaceParam, int position, StringBuilder result) {
            int pos = input.indexOf(searchString, position);
            if (this.replaceNecessaryProfile.profile(pos < 0)) {
                Boundaries.builderAppend(result, input, position, input.length());
                return input.length();
            }
            Boundaries.builderAppend(result, input, position, pos);
            if (parsedReplaceParam == null) {
                JSStringReplaceAllNode.appendSubstitution(result, input, replaceString, searchString, pos, this.dollarProfile);
            } else {
                ReplaceStringParser.processParsed(parsedReplaceParam, new JSStringReplaceBaseNode.ReplaceStringConsumer(result, input, replaceString, searchString, pos), null);
            }
            return pos + searchString.length();
        }

        private IsRegExpNode getIsRegExpNode() {
            if (this.isRegExpNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isRegExpNode = (IsRegExpNode)this.insert(IsRegExpNode.create(this.getContext()));
            }
            return this.isRegExpNode;
        }

        private Object getFlags(Object regexp) {
            if (this.getFlagsNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getFlagsNode = (PropertyGetNode)this.insert(PropertyGetNode.create("flags", this.getContext()));
            }
            return this.getFlagsNode.getValue(regexp);
        }
    }

    public static abstract class JSStringReplaceNode
    extends JSStringReplaceBaseNode {
        public JSStringReplaceNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"cachedReplaceValue.equals(replaceValue)"})
        protected Object replaceStringCached(Object thisObj, String searchValue, String replaceValue, @Cached(value="replaceValue") String cachedReplaceValue, @Cached(value="parseReplaceValue(replaceValue)", dimensions=1) ReplaceStringParser.Token[] cachedParsedReplaceValue) {
            this.requireObjectCoercible(thisObj);
            return this.builtinReplaceString(searchValue, cachedReplaceValue, thisObj, cachedParsedReplaceValue);
        }

        @Specialization(replaces={"replaceStringCached"})
        protected Object replaceString(Object thisObj, String searchValue, String replaceValue) {
            this.requireObjectCoercible(thisObj);
            return this.builtinReplaceString(searchValue, replaceValue, thisObj, null);
        }

        protected boolean isStringString(Object arg1, Object arg2) {
            return JSRuntime.isString(arg1) && JSRuntime.isString(arg2);
        }

        @Specialization(guards={"!isStringString(searchValue, replaceValue)"})
        protected Object replaceGeneric(Object thisObj, Object searchValue, Object replaceValue) {
            Object replacer;
            this.requireObjectCoercible(thisObj);
            Object searchVal = this.searchValueProfile.profile(searchValue);
            Object replaceVal = this.replaceValueProfile.profile(replaceValue);
            if (this.isSpecialProfile.profile(searchVal != Undefined.instance && searchVal != Null.instance) && this.callSpecialProfile.profile((replacer = this.getMethod(searchVal, Symbol.SYMBOL_REPLACE)) != Undefined.instance)) {
                return this.call(replacer, searchVal, new Object[]{thisObj, replaceVal});
            }
            if (this.toString2Node == null || this.toString3Node == null || this.isCallableNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toString2Node = (JSToStringNode)this.insert(JSToStringNode.create());
                this.toString3Node = (JSToStringNode)this.insert(JSToStringNode.create());
                this.isCallableNode = (IsCallableNode)this.insert(IsCallableNode.create());
            }
            return this.builtinReplace(searchVal, replaceVal, thisObj);
        }

        private String builtinReplace(Object searchValue, Object replParam, Object o) {
            int pos;
            String string = this.toString(o);
            String searchString = this.toString2Node.executeString(searchValue);
            boolean functionalReplace = this.isCallableNode.executeBoolean(replParam);
            String replaceString = null;
            if (!this.functionalReplaceProfile.profile(functionalReplace)) {
                replaceString = this.toString3Node.executeString(replParam);
            }
            if (this.replaceNecessaryProfile.profile((pos = string.indexOf(searchString)) < 0)) {
                return string;
            }
            StringBuilder sb = new StringBuilder(pos + (string.length() - (pos + searchString.length())) + 20);
            Boundaries.builderAppend(sb, string, 0, pos);
            if (this.functionalReplaceProfile.profile(functionalReplace)) {
                Object replValue = this.functionReplaceCall(replParam, (Object)Undefined.instance, new Object[]{searchString, pos, string});
                Boundaries.builderAppend(sb, this.toString3Node.executeString(replValue));
            } else {
                JSStringReplaceNode.appendSubstitution(sb, string, replaceString, searchString, pos, this.dollarProfile);
            }
            Boundaries.builderAppend(sb, string, pos + searchString.length(), string.length());
            return Boundaries.builderToString(sb);
        }

        private String builtinReplaceString(String searchString, String replaceString, Object o, ReplaceStringParser.Token[] parsedReplaceParam) {
            String input = this.toString(o);
            int pos = input.indexOf(searchString);
            if (this.replaceNecessaryProfile.profile(pos < 0)) {
                return input;
            }
            StringBuilder sb = new StringBuilder(pos + (input.length() - (pos + searchString.length())) + 20);
            Boundaries.builderAppend(sb, input, 0, pos);
            if (parsedReplaceParam == null) {
                JSStringReplaceNode.appendSubstitution(sb, input, replaceString, searchString, pos, this.dollarProfile);
            } else {
                ReplaceStringParser.processParsed(parsedReplaceParam, new JSStringReplaceBaseNode.ReplaceStringConsumer(sb, input, replaceString, searchString, pos), null);
            }
            Boundaries.builderAppend(sb, input, pos + searchString.length(), input.length());
            return Boundaries.builderToString(sb);
        }
    }

    public static abstract class JSStringReplaceBaseNode
    extends JSStringOperationWithRegExpArgument {
        @Node.Child
        protected JSFunctionCallNode functionReplaceCallNode;
        @Node.Child
        protected JSToStringNode toString2Node;
        @Node.Child
        protected JSToStringNode toString3Node;
        @Node.Child
        protected IsCallableNode isCallableNode;
        protected final ConditionProfile functionalReplaceProfile = ConditionProfile.createBinaryProfile();
        protected final ConditionProfile replaceNecessaryProfile = ConditionProfile.createBinaryProfile();
        protected final BranchProfile dollarProfile = BranchProfile.create();
        protected final ValueProfile searchValueProfile = ValueProfile.createIdentityProfile();
        protected final ValueProfile replaceValueProfile = ValueProfile.createIdentityProfile();

        public JSStringReplaceBaseNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected static ReplaceStringParser.Token[] parseReplaceValue(String replaceValue) {
            return ReplaceStringParser.parse(replaceValue, 0, false);
        }

        protected static void appendSubstitution(StringBuilder sb, String input, String replaceStr, String matched, int pos, BranchProfile dollarProfile) {
            ReplaceStringParser.process(replaceStr, 0, false, dollarProfile, new ReplaceStringConsumer(sb, input, replaceStr, matched, pos), null);
        }

        protected final Object functionReplaceCall(Object splitter, Object separator, Object[] args) {
            if (this.functionReplaceCallNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.functionReplaceCallNode = (JSFunctionCallNode)this.insert(JSFunctionCallNode.createCall());
            }
            return this.functionReplaceCallNode.executeCall(JSArguments.create(separator, splitter, args));
        }

        protected static final class ReplaceStringConsumer
        implements ReplaceStringParser.Consumer<Void> {
            private final StringBuilder sb;
            private final String input;
            private final String replaceStr;
            private final String matched;
            private final int matchedPos;

            private ReplaceStringConsumer(StringBuilder sb, String input, String replaceStr, String matched, int matchedPos) {
                this.sb = sb;
                this.input = input;
                this.replaceStr = replaceStr;
                this.matched = matched;
                this.matchedPos = matchedPos;
            }

            @Override
            public void literal(Void node, int start, int end) {
                Boundaries.builderAppend(this.sb, this.replaceStr, start, end);
            }

            @Override
            public void match(Void node) {
                Boundaries.builderAppend(this.sb, this.matched);
            }

            @Override
            public void matchHead(Void node) {
                Boundaries.builderAppend(this.sb, this.input, 0, this.matchedPos);
            }

            @Override
            public void matchTail(Void node) {
                Boundaries.builderAppend(this.sb, this.input, this.matchedPos + this.matched.length(), this.input.length());
            }

            @Override
            public void captureGroup(Void node, int groupNumber, int literalStart, int literalEnd) {
                throw Errors.shouldNotReachHere();
            }

            @Override
            public void namedCaptureGroup(Void node, String groupName) {
                throw Errors.shouldNotReachHere();
            }
        }
    }

    public static abstract class JSStringConcatNode
    extends JSStringOperation {
        private final StringBuilderProfile stringBuilderProfile;

        public JSStringConcatNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.stringBuilderProfile = StringBuilderProfile.create(context.getStringLengthLimit());
        }

        @Specialization
        protected String concat(Object thisObj, Object[] args, @Cached(value="create()") JSToStringNode toString2Node) {
            this.requireObjectCoercible(thisObj);
            StringBuilder builder = this.stringBuilderProfile.newStringBuilder();
            this.stringBuilderProfile.append(builder, this.toString(thisObj));
            for (Object o : args) {
                this.stringBuilderProfile.append(builder, toString2Node.executeString(o));
            }
            return this.stringBuilderProfile.toString(builder);
        }
    }

    public static abstract class JSStringSplitNode
    extends JSStringOperationWithRegExpArgument {
        private final ConditionProfile emptyInput = ConditionProfile.createBinaryProfile();
        private final ConditionProfile emptySeparator = ConditionProfile.createBinaryProfile();
        private final ConditionProfile zeroLimit = ConditionProfile.createBinaryProfile();
        private final ConditionProfile matchProfile = ConditionProfile.createCountingProfile();
        private final BranchProfile isUndefinedBranch = BranchProfile.create();
        private final BranchProfile isStringBranch = BranchProfile.create();
        private final BranchProfile isRegexpBranch = BranchProfile.create();
        private final BranchProfile growProfile = BranchProfile.create();
        @Node.Child
        private JSToUInt32Node toUInt32Node;
        @Node.Child
        private JSToStringNode toString2Node;
        @Node.Child
        private TRegexUtil.TRegexCompiledRegexAccessor compiledRegexAccessor;
        @Node.Child
        private TRegexUtil.TRegexResultAccessor resultAccessor;
        private static final Splitter<Void> NOP_SPLITTER = (input, limit, separator, parent) -> new Object[]{input};
        private static final Splitter<String> STRING_SPLITTER = new StringSplitter();
        private static final Splitter<DynamicObject> REGEXP_SPLITTER = new RegExpSplitter();

        public JSStringSplitNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        private int toUInt32(Object target) {
            if (this.toUInt32Node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toUInt32Node = (JSToUInt32Node)this.insert(JSToUInt32Node.create());
            }
            return (int)Math.min(Integer.MAX_VALUE, JSRuntime.toInteger((Number)this.toUInt32Node.execute(target)));
        }

        private String toString2(Object obj) {
            if (this.toString2Node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toString2Node = (JSToStringNode)this.insert(JSToStringNode.create());
            }
            return this.toString2Node.executeString(obj);
        }

        protected boolean isES6OrNewer() {
            return this.getContext().getEcmaScriptVersion() >= 6;
        }

        @Specialization(guards={"!isES6OrNewer()"})
        protected Object splitES5(Object thisObj, Object separator, Object limitObj) {
            this.requireObjectCoercible(thisObj);
            String thisStr = this.toString(thisObj);
            int limit = this.getLimit(limitObj);
            if (separator == Undefined.instance) {
                this.isUndefinedBranch.enter();
                return this.split(thisStr, limit, NOP_SPLITTER, null);
            }
            if (JSRegExp.isJSRegExp(separator)) {
                this.isRegexpBranch.enter();
                return this.split(thisStr, limit, REGEXP_SPLITTER, (DynamicObject)separator);
            }
            this.isStringBranch.enter();
            String separatorStr = this.toString2(separator);
            return this.split(thisStr, limit, STRING_SPLITTER, separatorStr);
        }

        protected boolean isFastPath(Object thisObj, Object separator, Object limit) {
            return JSRuntime.isString(thisObj) && JSRuntime.isString(separator) && limit == Undefined.instance;
        }

        @Specialization(guards={"isES6OrNewer()", "isFastPath(thisStr, sepStr, limit)"})
        protected Object splitES6StrStrUndefined(String thisStr, String sepStr, DynamicObject limit) {
            return this.split(thisStr, Integer.MAX_VALUE, STRING_SPLITTER, sepStr);
        }

        @Specialization(guards={"isES6OrNewer()", "!isFastPath(thisObj, separator, limit)"})
        protected Object splitES6Generic(Object thisObj, Object separator, Object limit) {
            Object splitter;
            this.requireObjectCoercible(thisObj);
            if (this.isSpecialProfile.profile(separator != Undefined.instance && separator != Null.instance) && this.callSpecialProfile.profile((splitter = this.getMethod(separator, Symbol.SYMBOL_SPLIT)) != Undefined.instance)) {
                return this.call(splitter, separator, new Object[]{thisObj, limit});
            }
            return this.builtinSplit(thisObj, separator, limit);
        }

        private Object builtinSplit(Object thisObj, Object separator, Object limit) {
            String thisStr = this.toString(thisObj);
            int lim = this.getLimit(limit);
            String sepStr = this.toString2(separator);
            if (separator == Undefined.instance) {
                return this.split(thisStr, lim, NOP_SPLITTER, null);
            }
            return this.split(thisStr, lim, STRING_SPLITTER, sepStr);
        }

        private int getLimit(Object limit) {
            return limit == Undefined.instance ? Integer.MAX_VALUE : this.toUInt32(limit);
        }

        private <T> DynamicObject split(String thisStr, int limit, Splitter<T> splitter, T separator) {
            if (this.zeroLimit.profile(limit == 0)) {
                return JSArray.createEmptyZeroLength(this.getContext());
            }
            Object[] splits = splitter.split(thisStr, limit, separator, this);
            return JSArray.createConstant(this.getContext(), splits);
        }

        public TRegexUtil.TRegexCompiledRegexAccessor getCompiledRegexAccessor() {
            if (this.compiledRegexAccessor == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.compiledRegexAccessor = (TRegexUtil.TRegexCompiledRegexAccessor)this.insert(TRegexUtil.TRegexCompiledRegexAccessor.create());
            }
            return this.compiledRegexAccessor;
        }

        public TRegexUtil.TRegexResultAccessor getResultAccessor() {
            if (this.resultAccessor == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.resultAccessor = (TRegexUtil.TRegexResultAccessor)this.insert(TRegexUtil.TRegexResultAccessor.create());
            }
            return this.resultAccessor;
        }

        private static final class RegExpSplitter
        implements Splitter<DynamicObject> {
            private static final Object[] EMPTY_SPLITS = new Object[0];
            private static final Object[] SINGLE_ZERO_LENGTH_SPLIT = new Object[]{""};

            private RegExpSplitter() {
            }

            @Override
            public Object[] split(String input, int limit, DynamicObject regExp, JSStringSplitNode parent) {
                if (parent.emptyInput.profile(input.isEmpty())) {
                    return RegExpSplitter.splitEmptyString(regExp, parent);
                }
                return RegExpSplitter.splitNonEmptyString(input, limit, regExp, parent);
            }

            private static Object[] splitEmptyString(DynamicObject regExp, JSStringSplitNode parent) {
                Object result = parent.matchIgnoreLastIndex(regExp, "", 0);
                return parent.matchProfile.profile(parent.getResultAccessor().isMatch(result)) ? EMPTY_SPLITS : SINGLE_ZERO_LENGTH_SPLIT;
            }

            private static Object[] splitNonEmptyString(String input, int limit, DynamicObject regExp, JSStringSplitNode parent) {
                Object result = parent.matchIgnoreLastIndex(regExp, input, 0);
                if (parent.matchProfile.profile(!parent.getResultAccessor().isMatch(result))) {
                    return new Object[]{input};
                }
                SimpleArrayList<Object> splits = new SimpleArrayList<Object>();
                int start = 0;
                while (parent.getResultAccessor().isMatch(result)) {
                    int matchStart = parent.getResultAccessor().captureGroupStart(result, 0);
                    int matchEnd = parent.getResultAccessor().captureGroupEnd(result, 0);
                    if (matchEnd - matchStart == 0 && matchStart == start) {
                        if (matchStart == input.length() - 1) break;
                        result = parent.matchIgnoreLastIndex(regExp, input, start + 1);
                        continue;
                    }
                    String split = Boundaries.substring(input, start, matchStart);
                    splits.add(split, parent.growProfile);
                    int count = Math.min(parent.getCompiledRegexAccessor().groupCount(JSRegExp.getCompiledRegex(regExp)) - 1, limit - splits.size());
                    for (int i = 1; i <= count; ++i) {
                        int groupStart = parent.getResultAccessor().captureGroupStart(result, i);
                        if (groupStart == -1) {
                            splits.add((Object)Undefined.instance, parent.growProfile);
                            continue;
                        }
                        splits.add(Boundaries.substring(input, groupStart, parent.getResultAccessor().captureGroupEnd(result, i)), parent.growProfile);
                    }
                    if (splits.size() == limit) {
                        return splits.toArray();
                    }
                    start = matchEnd + (matchEnd == start ? 1 : 0);
                    result = parent.matchIgnoreLastIndex(regExp, input, start);
                }
                splits.add(Boundaries.substring(input, start), parent.growProfile);
                return splits.toArray();
            }
        }

        private static final class StringSplitter
        implements Splitter<String> {
            private StringSplitter() {
            }

            @Override
            public Object[] split(String input, int limit, String separator, JSStringSplitNode parent) {
                if (parent.emptySeparator.profile(separator.isEmpty())) {
                    return StringSplitter.individualCharSplit(input, limit);
                }
                return StringSplitter.regularSplit(input, limit, separator, parent);
            }

            private static Object[] regularSplit(String input, int limit, String separator, JSStringSplitNode parent) {
                int end = input.indexOf(separator);
                if (parent.matchProfile.profile(end == -1)) {
                    return new Object[]{input};
                }
                return StringSplitter.regularSplitIntl(input, limit, separator, end, parent);
            }

            @CompilerDirectives.TruffleBoundary
            private static Object[] regularSplitIntl(String input, int limit, String separator, int endParam, JSStringSplitNode parent) {
                SimpleArrayList<String> splits = SimpleArrayList.create(limit);
                int start = 0;
                int end = endParam;
                while (end != -1) {
                    splits.add(input.substring(start, end), parent.growProfile);
                    if (splits.size() == limit) {
                        return splits.toArray();
                    }
                    start = end + separator.length();
                    end = input.indexOf(separator, start);
                }
                splits.add(input.substring(start), parent.growProfile);
                return splits.toArray();
            }

            private static Object[] individualCharSplit(String input, int limit) {
                int len = Math.min(input.length(), limit);
                Object[] array = new Object[len];
                for (int i = 0; i < len; ++i) {
                    array[i] = String.valueOf(input.charAt(i));
                }
                return array;
            }
        }

        private static interface Splitter<T> {
            public Object[] split(String var1, int var2, T var3, JSStringSplitNode var4);
        }
    }

    public static abstract class JSStringLastIndexOfNode
    extends JSStringOperation {
        public JSStringLastIndexOfNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected boolean isStringLength1(String str) {
            return str.length() == 1;
        }

        @Specialization(guards={"isStringLength1(searchString)", "isUndefined(position)"})
        protected int lastIndexOfChar(String thisObj, String searchString, Object position) {
            return JSStringLastIndexOfNode.lastIndexOfChar(thisObj, searchString, thisObj.length());
        }

        private static int lastIndexOfChar(String thisStr, String searchStr, int startPos) {
            int start;
            assert (searchStr.length() == 1);
            char searchChar = searchStr.charAt(0);
            for (int i = start = startPos < thisStr.length() ? startPos : thisStr.length() - 1; i >= 0; --i) {
                if (thisStr.charAt(i) != searchChar) continue;
                return i;
            }
            return -1;
        }

        @Specialization(guards={"isUndefined(position)"})
        protected int lastIndexOfString(String thisObj, String searchString, Object position, @Cached(value="createBinaryProfile()") @Cached.Shared(value="searchStrZero") ConditionProfile searchStrZero, @Cached(value="createBinaryProfile()") @Cached.Shared(value="searchStrOne") ConditionProfile searchStrOne) {
            int len;
            int pos = len = thisObj.length();
            return JSStringLastIndexOfNode.lastIndexOfImpl(thisObj, searchString, pos, searchStrZero, searchStrOne);
        }

        @Specialization
        protected int lastIndexOfString(String thisObj, String searchString, int position, @Cached(value="createBinaryProfile()") @Cached.Shared(value="searchStrZero") ConditionProfile searchStrZero, @Cached(value="createBinaryProfile()") @Cached.Shared(value="searchStrOne") ConditionProfile searchStrOne) {
            int len = thisObj.length();
            int pos = JSStringLastIndexOfNode.within(position, 0, len);
            return JSStringLastIndexOfNode.lastIndexOfImpl(thisObj, searchString, pos, searchStrZero, searchStrOne);
        }

        @Specialization(replaces={"lastIndexOfChar", "lastIndexOfString"})
        protected int lastIndexOf(Object thisObj, Object searchString, Object position, @Cached(value="create()") JSToStringNode toString2Node, @Cached(value="create()") JSToNumberNode toNumberNode, @Cached(value="createBinaryProfile()") ConditionProfile posNaN, @Cached(value="createBinaryProfile()") @Cached.Shared(value="searchStrZero") ConditionProfile searchStrZero, @Cached(value="createBinaryProfile()") @Cached.Shared(value="searchStrOne") ConditionProfile searchStrOne) {
            this.requireObjectCoercible(thisObj);
            String thisStr = this.toString(thisObj);
            String searchStr = toString2Node.executeString(searchString);
            Number numPos = toNumberNode.executeNumber(position);
            int len = thisStr.length();
            double dVal = JSRuntime.doubleValue(numPos);
            int pos = posNaN.profile(Double.isNaN(dVal)) ? len : JSStringLastIndexOfNode.within((int)dVal, 0, len);
            return JSStringLastIndexOfNode.lastIndexOfImpl(thisStr, searchStr, pos, searchStrZero, searchStrOne);
        }

        private static int lastIndexOfImpl(String thisStr, String searchStr, int pos, ConditionProfile searchStrZero, ConditionProfile searchStrOne) {
            if (searchStrZero.profile(searchStr.length() == 0)) {
                return pos;
            }
            if (searchStrOne.profile(searchStr.length() == 1)) {
                return JSStringLastIndexOfNode.lastIndexOfChar(thisStr, searchStr, pos);
            }
            return Boundaries.stringLastIndexOf(thisStr, searchStr, pos);
        }
    }

    public static abstract class JSStringIndexOfNode
    extends JSStringOperation {
        private final ConditionProfile hasPos = ConditionProfile.createBinaryProfile();

        public JSStringIndexOfNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isUndefined(position)"})
        protected int indexOfStringUndefined(String thisStr, String searchStr, Object position) {
            return Boundaries.stringIndexOf(thisStr, searchStr);
        }

        @Specialization
        protected int indexOfStringInt(String thisStr, String searchStr, int position) {
            return this.indexOfIntl(thisStr, searchStr, position);
        }

        @Specialization(replaces={"indexOfStringInt"})
        protected int indexOfGeneric(Object thisObj, Object searchObj, Object position, @Cached(value="create()") JSToStringNode toString2Node) {
            this.requireObjectCoercible(thisObj);
            String thisStr = this.toString(thisObj);
            String searchStr = toString2Node.executeString(searchObj);
            return this.indexOfIntl(thisStr, searchStr, position);
        }

        private int indexOfIntl(String thisStr, String searchStr, Object position) {
            int startPos = this.hasPos.profile(position != Undefined.instance) ? Math.min(this.toIntegerAsInt(position), thisStr.length()) : 0;
            return Boundaries.stringIndexOf(thisStr, searchStr, startPos);
        }
    }

    public static abstract class JSStringSubstringNode
    extends JSStringOperation
    implements JSBuiltinNode.Inlineable {
        private final ConditionProfile startLowerEnd = ConditionProfile.createBinaryProfile();

        public JSStringSubstringNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected String substring(String thisStr, int start, int end) {
            int len = thisStr.length();
            int finalStart = JSStringSubstringNode.within(start, 0, len);
            int finalEnd = JSStringSubstringNode.within(end, 0, len);
            return this.substringIntl(thisStr, finalStart, finalEnd);
        }

        @Specialization(guards={"isUndefined(end)"})
        protected String substringStart(String thisStr, int start, Object end) {
            int len = thisStr.length();
            int finalStart = JSStringSubstringNode.within(start, 0, len);
            int finalEnd = len;
            return this.substringIntl(thisStr, finalStart, finalEnd);
        }

        private String substringIntl(String thisStr, int start, int end) {
            if (this.startLowerEnd.profile(start <= end)) {
                return Boundaries.substring(thisStr, start, end);
            }
            return Boundaries.substring(thisStr, end, start);
        }

        @Specialization(replaces={"substring", "substringStart"})
        protected String substringGeneric(Object thisObj, Object start, Object end, @Cached(value="create()") JSToNumberNode toNumberNode, @Cached(value="create()") JSToNumberNode toNumber2Node, @Cached(value="createBinaryProfile()") ConditionProfile startUndefined, @Cached(value="createBinaryProfile()") ConditionProfile endUndefined) {
            this.requireObjectCoercible(thisObj);
            String thisStr = this.toString(thisObj);
            int len = thisStr.length();
            int intStart = startUndefined.profile(start == Undefined.instance) ? 0 : JSStringSubstringNode.withinNumber(toNumberNode.executeNumber(start), 0, len);
            int intEnd = endUndefined.profile(end == Undefined.instance) ? len : JSStringSubstringNode.withinNumber(toNumber2Node.executeNumber(end), 0, len);
            return this.substringIntl(thisStr, intStart, intEnd);
        }

        @Override
        public Inlined createInlined() {
            return StringPrototypeBuiltinsFactory.JSStringSubstringNodeGen.InlinedNodeGen.create(this.getContext(), this.getBuiltin(), this.getArguments());
        }

        public static abstract class Inlined
        extends JSStringSubstringNode
        implements JSBuiltinNode.Inlined {
            public Inlined(JSContext context, JSBuiltin builtin) {
                super(context, builtin);
            }

            @Override
            @Specialization
            protected String substringGeneric(Object thisObj, Object start, Object end, @Cached(value="create()") JSToNumberNode toNumberNode, @Cached(value="create()") JSToNumberNode toNumber2Node, @Cached(value="createBinaryProfile()") ConditionProfile startUndefined, @Cached(value="createBinaryProfile()") ConditionProfile endUndefined) {
                throw this.rewriteToCall();
            }

            protected abstract Object executeWithArguments(Object var1, Object var2, Object var3);

            @Override
            public Object callInlined(Object[] arguments) {
                if (JSArguments.getUserArgumentCount(arguments) < 1) {
                    throw this.rewriteToCall();
                }
                Object thisObj = JSArguments.getThisObject(arguments);
                Object start = JSArguments.getUserArgument(arguments, 0);
                JSDynamicObject end = JSArguments.getUserArgumentCount(arguments) >= 2 ? JSArguments.getUserArgument(arguments, 1) : Undefined.instance;
                return this.executeWithArguments(thisObj, start, (Object)end);
            }
        }
    }

    public static abstract class JSStringCharCodeAtNode
    extends JSStringOperation
    implements JSBuiltinNode.Inlineable {
        private final ConditionProfile indexOutOfBounds = ConditionProfile.createBinaryProfile();

        public JSStringCharCodeAtNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected static boolean posInBounds(String thisStr, int pos) {
            return pos >= 0 && pos < thisStr.length();
        }

        @Specialization
        protected Object charCodeAtLazyString(JSLazyString thisStr, int index, @Cached(value="createBinaryProfile()") ConditionProfile flatten) {
            if (this.indexOutOfBounds.profile(0 > index || index >= thisStr.length())) {
                return Double.NaN;
            }
            String s = thisStr.toString(flatten);
            return (int)s.charAt(index);
        }

        @Specialization(guards={"posInBounds(thisStr, pos)"})
        protected int charCodeAtInBounds(String thisStr, int pos) {
            return thisStr.charAt(pos);
        }

        @Specialization(guards={"!posInBounds(thisStr, pos)"})
        protected double charCodeAtOutOfBounds(String thisStr, int pos) {
            return Double.NaN;
        }

        @Specialization(replaces={"charCodeAtLazyString", "charCodeAtInBounds", "charCodeAtOutOfBounds"})
        protected Object charCodeAtGeneric(Object thisObj, Object indexObj, @Cached(value="create()") JSToNumberNode toNumberNode) {
            this.requireObjectCoercible(thisObj);
            String s = this.toString(thisObj);
            Number index = toNumberNode.executeNumber(indexObj);
            long lIndex = JSRuntime.toInteger(index);
            if (this.indexOutOfBounds.profile(0L > lIndex || lIndex >= (long)s.length())) {
                return Double.NaN;
            }
            return (int)s.charAt((int)lIndex);
        }

        @Override
        public Inlined createInlined() {
            return StringPrototypeBuiltinsFactory.JSStringCharCodeAtNodeGen.InlinedNodeGen.create(this.getContext(), this.getBuiltin(), this.getArguments());
        }

        public static abstract class Inlined
        extends JSStringCharCodeAtNode
        implements JSBuiltinNode.Inlined {
            public Inlined(JSContext context, JSBuiltin builtin) {
                super(context, builtin);
            }

            @Override
            @Specialization
            protected Object charCodeAtGeneric(Object thisObj, Object indexObj, @Cached(value="create()") JSToNumberNode toNumberNode) {
                throw this.rewriteToCall();
            }

            protected abstract Object executeWithArguments(Object var1, Object var2);

            @Override
            public Object callInlined(Object[] arguments) {
                if (JSArguments.getUserArgumentCount(arguments) < 1) {
                    throw this.rewriteToCall();
                }
                return this.executeWithArguments(JSArguments.getThisObject(arguments), JSArguments.getUserArgument(arguments, 0));
            }
        }
    }

    public static abstract class JSStringCharAtNode
    extends JSStringOperation
    implements JSBuiltinNode.Inlineable {
        private final ConditionProfile indexOutOfBounds = ConditionProfile.createBinaryProfile();

        public JSStringCharAtNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected String stringCharAt(String thisStr, int pos) {
            if (this.indexOutOfBounds.profile(pos < 0 || pos >= thisStr.length())) {
                return "";
            }
            return String.valueOf(thisStr.charAt(pos));
        }

        @Specialization
        protected String charAt(Object thisObj, Object index) {
            this.requireObjectCoercible(thisObj);
            return this.stringCharAt(this.toString(thisObj), this.toIntegerAsInt(index));
        }

        @Override
        public Inlined createInlined() {
            return StringPrototypeBuiltinsFactory.JSStringCharAtNodeGen.InlinedNodeGen.create(this.getContext(), this.getBuiltin(), this.getArguments());
        }

        public static abstract class Inlined
        extends JSStringCharAtNode
        implements JSBuiltinNode.Inlined {
            public Inlined(JSContext context, JSBuiltin builtin) {
                super(context, builtin);
            }

            @Override
            @Specialization
            protected String charAt(Object thisObj, Object indexObj) {
                throw this.rewriteToCall();
            }

            protected abstract Object executeWithArguments(Object var1, Object var2);

            @Override
            public Object callInlined(Object[] arguments) {
                if (JSArguments.getUserArgumentCount(arguments) < 1) {
                    throw this.rewriteToCall();
                }
                return this.executeWithArguments(JSArguments.getThisObject(arguments), JSArguments.getUserArgument(arguments, 0));
            }
        }
    }

    public static abstract class JSStringOperationWithRegExpArgument
    extends JSStringOperation {
        @Node.Child
        protected JSRegExpExecIntlNode regExpNode;
        @Node.Child
        protected JSRegExpExecIntlNode.JSRegExpExecIntlIgnoreLastIndexNode regExpIgnoreLastIndexNode;
        @Node.Child
        private JSFunctionCallNode callNode;
        @Node.Child
        private PropertyGetNode getSymbolNode;
        @Node.Child
        private GetMethodNode getMethodNode;
        protected final ConditionProfile isSpecialProfile = ConditionProfile.createBinaryProfile();
        protected final ConditionProfile callSpecialProfile = ConditionProfile.createBinaryProfile();

        public JSStringOperationWithRegExpArgument(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected final Object matchIgnoreLastIndex(DynamicObject regExp, String input, int fromIndex) {
            assert (this.getContext().getEcmaScriptVersion() <= 5);
            return this.getRegExpIgnoreLastIndexNode().execute(regExp, input, fromIndex);
        }

        protected JSRegExpExecIntlNode getRegExpNode() {
            if (this.regExpNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.regExpNode = (JSRegExpExecIntlNode)this.insert(JSRegExpExecIntlNode.create(this.getContext()));
            }
            return this.regExpNode;
        }

        protected JSRegExpExecIntlNode.JSRegExpExecIntlIgnoreLastIndexNode getRegExpIgnoreLastIndexNode() {
            if (this.regExpIgnoreLastIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.regExpIgnoreLastIndexNode = (JSRegExpExecIntlNode.JSRegExpExecIntlIgnoreLastIndexNode)this.insert(JSRegExpExecIntlNode.JSRegExpExecIntlIgnoreLastIndexNode.create(this.getContext(), true));
            }
            return this.regExpIgnoreLastIndexNode;
        }

        protected final Object call(Object function, Object target, Object[] args) {
            if (this.callNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callNode = (JSFunctionCallNode)this.insert(JSFunctionCallNode.createCall());
            }
            return this.callNode.executeCall(JSArguments.create(target, function, args));
        }

        protected final Object invoke(DynamicObject regExp, Symbol symbol, String thisStr) {
            assert (JSRuntime.isPropertyKey(symbol));
            if (this.getSymbolNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getSymbolNode = (PropertyGetNode)this.insert(PropertyGetNode.create(symbol, false, this.getContext()));
            }
            Object func = this.getSymbolNode.getValue(regExp);
            return this.call(func, regExp, new Object[]{thisStr});
        }

        protected final Object getMethod(Object target, Object key) {
            if (this.getMethodNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getMethodNode = (GetMethodNode)this.insert(GetMethodNode.create(this.getContext(), null, key));
            }
            return this.getMethodNode.executeWithTarget(target);
        }
    }

    static abstract class JSStringOperation
    extends JSBuiltinNode {
        @Node.Child
        private RequireObjectCoercibleNode requireObjectCoercibleNode;
        @Node.Child
        private JSToStringNode toStringNode;
        @Node.Child
        private JSToIntegerAsIntNode toIntegerNode;

        JSStringOperation(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected static int within(int value, int min, int max) {
            assert (min <= max);
            if (value >= max) {
                return max;
            }
            if (value <= min) {
                return min;
            }
            return value;
        }

        protected static int withinNumber(Number value, int min, int max) {
            assert (min <= max);
            double dValue = JSRuntime.doubleValue(value);
            if (Double.isInfinite(dValue)) {
                return dValue < 0.0 ? min : max;
            }
            long lValue = JSRuntime.intValue(value);
            if (lValue >= (long)max) {
                return max;
            }
            if (lValue <= (long)min) {
                return min;
            }
            return (int)lValue;
        }

        protected final void requireObjectCoercible(Object target) {
            if (this.requireObjectCoercibleNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.requireObjectCoercibleNode = (RequireObjectCoercibleNode)this.insert(RequireObjectCoercibleNode.create());
            }
            this.requireObjectCoercibleNode.executeVoid(target);
        }

        protected String toString(Object target) {
            if (this.toStringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toStringNode = (JSToStringNode)this.insert(JSToStringNode.create());
            }
            return this.toStringNode.executeString(target);
        }

        protected int toIntegerAsInt(Object target) {
            if (this.toIntegerNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toIntegerNode = (JSToIntegerAsIntNode)this.insert(JSToIntegerAsIntNode.create());
            }
            return this.toIntegerNode.executeInt(target);
        }
    }

    public static final class StringPrototypeExtensionBuiltins
    extends JSBuiltinsContainer.SwitchEnum<StringExtensionBuiltins> {
        protected StringPrototypeExtensionBuiltins() {
            super("StringExtensions", StringExtensionBuiltins.class);
        }

        @Override
        protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, StringExtensionBuiltins builtinEnum) {
            switch (builtinEnum) {
                case trimStart: {
                    return StringPrototypeBuiltinsFactory.JSStringTrimLeftNodeGen.create(context, builtin, StringPrototypeExtensionBuiltins.args().withThis().createArgumentNodes(context));
                }
                case trimEnd: {
                    return StringPrototypeBuiltinsFactory.JSStringTrimRightNodeGen.create(context, builtin, StringPrototypeExtensionBuiltins.args().withThis().createArgumentNodes(context));
                }
            }
            return null;
        }

        public static enum StringExtensionBuiltins implements BuiltinEnum<StringExtensionBuiltins>
        {
            trimStart(0),
            trimEnd(0);

            private final int length;

            private StringExtensionBuiltins(int length) {
                this.length = length;
            }

            @Override
            public int getLength() {
                return this.length;
            }
        }
    }

    public static enum StringPrototype implements BuiltinEnum<StringPrototype>
    {
        charAt(1),
        charCodeAt(1),
        concat(1),
        indexOf(1),
        lastIndexOf(1),
        localeCompare(1),
        match(1),
        replace(2),
        search(1),
        slice(2),
        split(2),
        substring(2),
        toLowerCase(0),
        toLocaleLowerCase(0),
        toUpperCase(0),
        toLocaleUpperCase(0),
        toString(0),
        valueOf(0),
        trim(0),
        substr(2),
        anchor(1),
        big(0),
        blink(0),
        bold(0),
        fixed(0),
        fontcolor(1),
        fontsize(1),
        italics(0),
        link(1),
        small(0),
        strike(0),
        sub(0),
        sup(0),
        startsWith(1),
        endsWith(1),
        includes(1),
        repeat(1),
        codePointAt(1),
        _iterator(0),
        normalize(0),
        padStart(1),
        padEnd(1),
        matchAll(1),
        replaceAll(2);

        private final int length;

        private StringPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isAnnexB() {
            return EnumSet.range(substr, sup).contains(this);
        }

        @Override
        public int getECMAScriptVersion() {
            if (EnumSet.range(startsWith, normalize).contains(this)) {
                return 6;
            }
            if (EnumSet.range(padStart, padEnd).contains(this)) {
                return 8;
            }
            if (matchAll == this) {
                return 11;
            }
            if (replaceAll == this) {
                return 12;
            }
            return BuiltinEnum.super.getECMAScriptVersion();
        }

        @Override
        public Object getKey() {
            return this == _iterator ? Symbol.SYMBOL_ITERATOR : BuiltinEnum.super.getKey();
        }
    }
}

