/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSWriteScopeFrameSlotNode;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.oracle.truffle.js.runtime.SafeInteger;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSWriteScopeFrameSlotNode.class)
final class JSWriteScopeFrameSlotNodeGen
extends JSWriteScopeFrameSlotNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;

    private JSWriteScopeFrameSlotNodeGen(FrameSlot frameSlot, ScopeFrameNode scopeFrameNode, JavaScriptNode rhsNode, FrameDescriptor frameDescriptor) {
        super(frameSlot, scopeFrameNode, rhsNode, frameDescriptor);
    }

    @Override
    Object executeEvaluated(VirtualFrame frameValue, Frame scopeFrameNodeValue, Object rhsNodeValue) {
        int state = this.state_;
        if ((state & 0x3F) != 0) {
            int rhsNodeValue_;
            if ((state & 1) != 0 && rhsNodeValue instanceof Boolean) {
                rhsNodeValue_ = ((Boolean)rhsNodeValue).booleanValue();
                if (this.isBooleanKind(scopeFrameNodeValue)) {
                    return this.doBoolean(scopeFrameNodeValue, rhsNodeValue_ != 0);
                }
            }
            if ((state & 2) != 0 && rhsNodeValue instanceof Integer) {
                rhsNodeValue_ = (Integer)rhsNodeValue;
                if (this.isIntegerKind(scopeFrameNodeValue) || this.isLongKind(scopeFrameNodeValue) || this.isDoubleKind(scopeFrameNodeValue)) {
                    return this.doInteger(scopeFrameNodeValue, rhsNodeValue_);
                }
            }
            if ((state & 4) != 0 && rhsNodeValue instanceof SafeInteger) {
                SafeInteger rhsNodeValue_2 = (SafeInteger)rhsNodeValue;
                if (this.isLongKind(scopeFrameNodeValue)) {
                    return this.doSafeInteger(scopeFrameNodeValue, rhsNodeValue_2);
                }
            }
            if ((state & 8) != 0 && rhsNodeValue instanceof Long) {
                long rhsNodeValue_3 = (Long)rhsNodeValue;
                return this.doLong(scopeFrameNodeValue, rhsNodeValue_3);
            }
            if ((state & 0x10) != 0 && JSTypesGen.isImplicitDouble((state & 0x3C0) >>> 6, rhsNodeValue)) {
                double rhsNodeValue_4 = JSTypesGen.asImplicitDouble((state & 0x3C0) >>> 6, rhsNodeValue);
                if (this.isDoubleKind(scopeFrameNodeValue)) {
                    return this.doDouble(scopeFrameNodeValue, rhsNodeValue_4);
                }
            }
            if ((state & 0x20) != 0) {
                return this.doObject(scopeFrameNodeValue, rhsNodeValue);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(scopeFrameNodeValue, rhsNodeValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = this.state_;
        Frame scopeFrameNodeValue_ = this.scopeFrameNode.executeFrame((Frame)frameValue);
        if ((state & 0x3E) == 0 && (state & 0x3F) != 0) {
            return this.execute_boolean0(frameValue, state, scopeFrameNodeValue_);
        }
        if ((state & 0x3D) == 0 && (state & 0x3F) != 0) {
            return this.execute_int1(frameValue, state, scopeFrameNodeValue_);
        }
        if ((state & 0x37) == 0 && (state & 0x3F) != 0) {
            return this.execute_long2(frameValue, state, scopeFrameNodeValue_);
        }
        if ((state & 0x2F) == 0 && (state & 0x3F) != 0) {
            return this.execute_double3(frameValue, state, scopeFrameNodeValue_);
        }
        return this.execute_generic4(frameValue, state, scopeFrameNodeValue_);
    }

    private Object execute_boolean0(VirtualFrame frameValue, int state, Frame scopeFrameNodeValue_) {
        boolean rhsNodeValue_;
        try {
            rhsNodeValue_ = this.rhsNode.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(scopeFrameNodeValue_, ex.getResult());
        }
        assert ((state & 1) != 0);
        if (this.isBooleanKind(scopeFrameNodeValue_)) {
            return this.doBoolean(scopeFrameNodeValue_, rhsNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(scopeFrameNodeValue_, rhsNodeValue_);
    }

    private Object execute_int1(VirtualFrame frameValue, int state, Frame scopeFrameNodeValue_) {
        int rhsNodeValue_;
        try {
            rhsNodeValue_ = this.rhsNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(scopeFrameNodeValue_, ex.getResult());
        }
        assert ((state & 2) != 0);
        if (this.isIntegerKind(scopeFrameNodeValue_) || this.isLongKind(scopeFrameNodeValue_) || this.isDoubleKind(scopeFrameNodeValue_)) {
            return this.doInteger(scopeFrameNodeValue_, rhsNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(scopeFrameNodeValue_, rhsNodeValue_);
    }

    private Object execute_long2(VirtualFrame frameValue, int state, Frame scopeFrameNodeValue_) {
        long rhsNodeValue_;
        try {
            rhsNodeValue_ = this.rhsNode.executeLong(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(scopeFrameNodeValue_, ex.getResult());
        }
        assert ((state & 8) != 0);
        return this.doLong(scopeFrameNodeValue_, rhsNodeValue_);
    }

    private Object execute_double3(VirtualFrame frameValue, int state, Frame scopeFrameNodeValue_) {
        double rhsNodeValue_;
        int rhsNodeValue_int = 0;
        long rhsNodeValue_long = 0L;
        try {
            if ((state & 0x380) == 0 && (state & 0x3F) != 0) {
                rhsNodeValue_long = this.rhsNode.executeLong(frameValue);
                rhsNodeValue_ = JSTypes.longToDouble(rhsNodeValue_long);
            } else if ((state & 0x340) == 0 && (state & 0x3F) != 0) {
                rhsNodeValue_int = this.rhsNode.executeInt(frameValue);
                rhsNodeValue_ = JSTypes.intToDouble(rhsNodeValue_int);
            } else if ((state & 0x2C0) == 0 && (state & 0x3F) != 0) {
                rhsNodeValue_ = this.rhsNode.executeDouble(frameValue);
            } else {
                Object rhsNodeValue__ = this.rhsNode.execute(frameValue);
                rhsNodeValue_ = JSTypesGen.expectImplicitDouble((state & 0x3C0) >>> 6, rhsNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(scopeFrameNodeValue_, ex.getResult());
        }
        assert ((state & 0x10) != 0);
        if (this.isDoubleKind(scopeFrameNodeValue_)) {
            return this.doDouble(scopeFrameNodeValue_, rhsNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(scopeFrameNodeValue_, (state & 0x380) == 0 && (state & 0x3F) != 0 ? (Number)rhsNodeValue_long : (Number)((state & 0x340) == 0 && (state & 0x3F) != 0 ? (Number)rhsNodeValue_int : (Number)rhsNodeValue_));
    }

    private Object execute_generic4(VirtualFrame frameValue, int state, Frame scopeFrameNodeValue_) {
        Object rhsNodeValue_ = this.rhsNode.execute(frameValue);
        if ((state & 0x3F) != 0) {
            int rhsNodeValue__;
            if ((state & 1) != 0 && rhsNodeValue_ instanceof Boolean) {
                rhsNodeValue__ = ((Boolean)rhsNodeValue_).booleanValue();
                if (this.isBooleanKind(scopeFrameNodeValue_)) {
                    return this.doBoolean(scopeFrameNodeValue_, rhsNodeValue__ != 0);
                }
            }
            if ((state & 2) != 0 && rhsNodeValue_ instanceof Integer) {
                rhsNodeValue__ = (Integer)rhsNodeValue_;
                if (this.isIntegerKind(scopeFrameNodeValue_) || this.isLongKind(scopeFrameNodeValue_) || this.isDoubleKind(scopeFrameNodeValue_)) {
                    return this.doInteger(scopeFrameNodeValue_, rhsNodeValue__);
                }
            }
            if ((state & 4) != 0 && rhsNodeValue_ instanceof SafeInteger) {
                SafeInteger rhsNodeValue__2 = (SafeInteger)rhsNodeValue_;
                if (this.isLongKind(scopeFrameNodeValue_)) {
                    return this.doSafeInteger(scopeFrameNodeValue_, rhsNodeValue__2);
                }
            }
            if ((state & 8) != 0 && rhsNodeValue_ instanceof Long) {
                long rhsNodeValue__3 = (Long)rhsNodeValue_;
                return this.doLong(scopeFrameNodeValue_, rhsNodeValue__3);
            }
            if ((state & 0x10) != 0 && JSTypesGen.isImplicitDouble((state & 0x3C0) >>> 6, rhsNodeValue_)) {
                double rhsNodeValue__4 = JSTypesGen.asImplicitDouble((state & 0x3C0) >>> 6, rhsNodeValue_);
                if (this.isDoubleKind(scopeFrameNodeValue_)) {
                    return this.doDouble(scopeFrameNodeValue_, rhsNodeValue__4);
                }
            }
            if ((state & 0x20) != 0) {
                return this.doObject(scopeFrameNodeValue_, rhsNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(scopeFrameNodeValue_, rhsNodeValue_);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
        boolean rhsNodeValue_;
        int state = this.state_;
        if ((state & 0x20) != 0) {
            return JSTypesGen.expectBoolean(this.execute(frameValue));
        }
        Frame scopeFrameNodeValue_ = this.scopeFrameNode.executeFrame((Frame)frameValue);
        try {
            rhsNodeValue_ = this.rhsNode.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return JSTypesGen.expectBoolean(this.executeAndSpecialize(scopeFrameNodeValue_, ex.getResult()));
        }
        if ((state & 1) != 0 && this.isBooleanKind(scopeFrameNodeValue_)) {
            return this.doBoolean(scopeFrameNodeValue_, rhsNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectBoolean(this.executeAndSpecialize(scopeFrameNodeValue_, rhsNodeValue_));
    }

    @Override
    public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
        double rhsNodeValue_;
        int state = this.state_;
        if ((state & 0x20) != 0) {
            return JSTypesGen.expectDouble(this.execute(frameValue));
        }
        Frame scopeFrameNodeValue_ = this.scopeFrameNode.executeFrame((Frame)frameValue);
        int rhsNodeValue_int = 0;
        long rhsNodeValue_long = 0L;
        try {
            if ((state & 0x380) == 0 && (state & 0x3F) != 0) {
                rhsNodeValue_long = this.rhsNode.executeLong(frameValue);
                rhsNodeValue_ = JSTypes.longToDouble(rhsNodeValue_long);
            } else if ((state & 0x340) == 0 && (state & 0x3F) != 0) {
                rhsNodeValue_int = this.rhsNode.executeInt(frameValue);
                rhsNodeValue_ = JSTypes.intToDouble(rhsNodeValue_int);
            } else if ((state & 0x2C0) == 0 && (state & 0x3F) != 0) {
                rhsNodeValue_ = this.rhsNode.executeDouble(frameValue);
            } else {
                Object rhsNodeValue__ = this.rhsNode.execute(frameValue);
                rhsNodeValue_ = JSTypesGen.expectImplicitDouble((state & 0x3C0) >>> 6, rhsNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return JSTypesGen.expectDouble(this.executeAndSpecialize(scopeFrameNodeValue_, ex.getResult()));
        }
        if ((state & 0x10) != 0 && this.isDoubleKind(scopeFrameNodeValue_)) {
            return this.doDouble(scopeFrameNodeValue_, rhsNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectDouble(this.executeAndSpecialize(scopeFrameNodeValue_, (state & 0x380) == 0 && (state & 0x3F) != 0 ? (Number)rhsNodeValue_long : (Number)((state & 0x340) == 0 && (state & 0x3F) != 0 ? (Number)rhsNodeValue_int : (Number)rhsNodeValue_)));
    }

    @Override
    public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
        int rhsNodeValue_;
        int state = this.state_;
        if ((state & 0x20) != 0) {
            return JSTypesGen.expectInteger(this.execute(frameValue));
        }
        Frame scopeFrameNodeValue_ = this.scopeFrameNode.executeFrame((Frame)frameValue);
        try {
            rhsNodeValue_ = this.rhsNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return JSTypesGen.expectInteger(this.executeAndSpecialize(scopeFrameNodeValue_, ex.getResult()));
        }
        if ((state & 2) != 0 && (this.isIntegerKind(scopeFrameNodeValue_) || this.isLongKind(scopeFrameNodeValue_) || this.isDoubleKind(scopeFrameNodeValue_))) {
            return this.doInteger(scopeFrameNodeValue_, rhsNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(this.executeAndSpecialize(scopeFrameNodeValue_, rhsNodeValue_));
    }

    @Override
    public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
        long rhsNodeValue_;
        int state = this.state_;
        if ((state & 0x20) != 0) {
            return JSTypesGen.expectLong(this.execute(frameValue));
        }
        Frame scopeFrameNodeValue_ = this.scopeFrameNode.executeFrame((Frame)frameValue);
        try {
            rhsNodeValue_ = this.rhsNode.executeLong(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return JSTypesGen.expectLong(this.executeAndSpecialize(scopeFrameNodeValue_, ex.getResult()));
        }
        if ((state & 8) != 0) {
            return this.doLong(scopeFrameNodeValue_, rhsNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectLong(this.executeAndSpecialize(scopeFrameNodeValue_, rhsNodeValue_));
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state = this.state_;
        try {
            if ((state & 0x37) == 0 && (state & 0x3F) != 0) {
                this.executeLong(frameValue);
                return;
            }
            if ((state & 0x3D) == 0 && (state & 0x3F) != 0) {
                this.executeInt(frameValue);
                return;
            }
            if ((state & 0x2F) == 0 && (state & 0x3F) != 0) {
                this.executeDouble(frameValue);
                return;
            }
            if ((state & 0x3E) == 0 && (state & 0x3F) != 0) {
                this.executeBoolean(frameValue);
                return;
            }
            this.execute(frameValue);
            return;
        }
        catch (UnexpectedResultException ex) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(Frame scopeFrameNodeValue, Object rhsNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            int doubleCast1;
            int rhsNodeValue_;
            if ((exclude & 1) == 0 && rhsNodeValue instanceof Boolean) {
                rhsNodeValue_ = ((Boolean)rhsNodeValue).booleanValue();
                if (this.isBooleanKind(scopeFrameNodeValue)) {
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    Boolean bl = this.doBoolean(scopeFrameNodeValue, rhsNodeValue_ != 0);
                    return bl;
                }
            }
            if ((exclude & 2) == 0 && rhsNodeValue instanceof Integer) {
                rhsNodeValue_ = (Integer)rhsNodeValue;
                if (this.isIntegerKind(scopeFrameNodeValue) || this.isLongKind(scopeFrameNodeValue) || this.isDoubleKind(scopeFrameNodeValue)) {
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    Integer n = this.doInteger(scopeFrameNodeValue, rhsNodeValue_);
                    return n;
                }
            }
            if ((exclude & 4) == 0 && rhsNodeValue instanceof SafeInteger) {
                SafeInteger rhsNodeValue_2 = (SafeInteger)rhsNodeValue;
                if (this.isLongKind(scopeFrameNodeValue)) {
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    SafeInteger safeInteger = this.doSafeInteger(scopeFrameNodeValue, rhsNodeValue_2);
                    return safeInteger;
                }
            }
            if ((exclude & 8) == 0 && rhsNodeValue instanceof Long) {
                long rhsNodeValue_3 = (Long)rhsNodeValue;
                this.state_ = state |= 8;
                lock.unlock();
                hasLock = false;
                Long l = this.doLong(scopeFrameNodeValue, rhsNodeValue_3);
                return l;
            }
            if ((exclude & 0x10) == 0 && (doubleCast1 = JSTypesGen.specializeImplicitDouble(rhsNodeValue)) != 0) {
                double rhsNodeValue_4 = JSTypesGen.asImplicitDouble(doubleCast1, rhsNodeValue);
                if (this.isDoubleKind(scopeFrameNodeValue)) {
                    this.exclude_ = exclude |= 6;
                    state &= 0xFFFFFFF9;
                    state |= doubleCast1 << 6;
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    Double d = this.doDouble(scopeFrameNodeValue, rhsNodeValue_4);
                    return d;
                }
            }
            this.exclude_ = exclude |= 0x1F;
            state &= 0xFFFFFFE0;
            this.state_ = state |= 0x20;
            lock.unlock();
            hasLock = false;
            Object object = this.doObject(scopeFrameNodeValue, rhsNodeValue);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if ((state & 0x3F) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0x3F & (state & 0x3F) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        Object[] data = new Object[7];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doBoolean";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : ((exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[1] = s;
        s = new Object[3];
        s[0] = "doInteger";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : ((exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[2] = s;
        s = new Object[3];
        s[0] = "doSafeInteger";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : ((exclude & 4) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[3] = s;
        s = new Object[3];
        s[0] = "doLong";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : ((exclude & 8) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[4] = s;
        s = new Object[3];
        s[0] = "doDouble";
        s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : ((exclude & 0x10) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[5] = s;
        s = new Object[3];
        s[0] = "doObject";
        s[1] = (state & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[6] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static JSWriteScopeFrameSlotNode create(FrameSlot frameSlot, ScopeFrameNode scopeFrameNode, JavaScriptNode rhsNode, FrameDescriptor frameDescriptor) {
        return new JSWriteScopeFrameSlotNodeGen(frameSlot, scopeFrameNode, rhsNode, frameDescriptor);
    }
}

