/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.ui.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.websvc.saas.model.Saas;
import org.netbeans.modules.websvc.saas.model.WadlSaas;
import org.netbeans.modules.websvc.saas.model.WadlSaasMethod;
import org.netbeans.modules.websvc.saas.model.WadlSaasResource;
import org.netbeans.modules.websvc.saas.ui.nodes.ResourceNode;
import org.netbeans.modules.websvc.saas.ui.nodes.SaasNodeChildren;
import org.netbeans.modules.websvc.saas.ui.nodes.WadlMethodNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

public class WadlSaasNodeChildren
extends SaasNodeChildren<Object> {
    public WadlSaasNodeChildren(WadlSaas wadlSaas) {
        super((Saas)wadlSaas);
    }

    public WadlSaas getSaas() {
        return (WadlSaas)super.getSaas();
    }

    @Override
    protected void updateKeys() {
        Saas.State state = this.getSaas().getState();
        if (state == Saas.State.READY) {
            ArrayList keys = new ArrayList();
            List resources = this.getSaas().getResources();
            Collections.sort(resources);
            keys.addAll(resources);
            List methods = this.getSaas().getMethods();
            Collections.sort(methods);
            keys.addAll(methods);
            this.setKeys(keys);
        } else if (state == Saas.State.INITIALIZING) {
            this.setKeys(WAIT_HOLDER);
        } else {
            this.setKeys(Collections.emptyList());
        }
    }

    protected Node[] createNodes(Object key) {
        if (key == WAIT_HOLDER[0]) {
            return WadlSaasNodeChildren.getWaitNode();
        }
        try {
            if (key instanceof WadlSaasMethod) {
                WadlSaasMethod wsm = (WadlSaasMethod)key;
                return new Node[]{new WadlMethodNode(wsm)};
            }
            if (key instanceof WadlSaasResource) {
                return new Node[]{new ResourceNode((WadlSaasResource)key)};
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return new Node[0];
    }
}

