/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.wizard.components.actions;

import java.io.File;
import java.io.IOException;
import org.netbeans.installer.product.Registry;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.FileUtils;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.helper.Platform;
import org.netbeans.installer.utils.progress.Progress;
import org.netbeans.installer.utils.system.launchers.LauncherProperties;
import org.netbeans.installer.utils.system.launchers.LauncherResource;
import org.netbeans.installer.wizard.components.WizardAction;

public class CreateNativeLauncherAction
extends WizardAction {
    public static final String DEFAULT_TITLE = ResourceUtils.getString(CreateNativeLauncherAction.class, "CNLA.title");
    public static final String DEFAULT_DESCRIPTION = ResourceUtils.getString(CreateNativeLauncherAction.class, "CNLA.description");
    public static final String DEFAULT_ERROR_FAILED_CREATE_LAUNCHER = ResourceUtils.getString(CreateNativeLauncherAction.class, "CNLA.error.failed.create.launcher");
    public static final String ERROR_FAILED_CREATE_LAUNCHER_PROPERTY = "error.failed.create.launcher";
    public static final String BUNDLED_JVM_FILE_PROPERTY = "nbi.bundled.jvm.file";

    public CreateNativeLauncherAction() {
        this.setProperty("title", DEFAULT_TITLE);
        this.setProperty("description", DEFAULT_DESCRIPTION);
        this.setProperty(ERROR_FAILED_CREATE_LAUNCHER_PROPERTY, DEFAULT_ERROR_FAILED_CREATE_LAUNCHER);
    }

    @Override
    public void execute() {
        LogManager.logEntry("creating the native launcher");
        String targetPath = System.getProperty("nbi.create.bundle.path");
        File targetFile = new File(targetPath);
        Progress progress = new Progress();
        this.getWizardUi().setProgress(progress);
        try {
            File file;
            Platform platform = Registry.getInstance().getTargetPlatform();
            LauncherProperties properties = new LauncherProperties();
            properties.addJar(new LauncherResource(new File(targetPath)));
            properties.setJvmArguments(new String[]{"-Xmx256m", "-Xms64m"});
            if (System.getProperty(BUNDLED_JVM_FILE_PROPERTY) != null) {
                LauncherResource jvm = new LauncherResource(new File(System.getProperty(BUNDLED_JVM_FILE_PROPERTY)));
                properties.addJVM(jvm);
                properties.getJvmArguments().add("-Dnbi.bundled.jvm.file=" + jvm.getAbsolutePath());
            }
            if (!targetFile.equals(file = SystemUtils.createLauncher(properties, platform, progress).getOutputFile())) {
                FileUtils.deleteFile(targetFile);
                System.setProperty("nbi.create.bundle.path", file.getPath());
            }
        }
        catch (IOException e) {
            ErrorManager.notifyError(this.getProperty(ERROR_FAILED_CREATE_LAUNCHER_PROPERTY), e);
        }
        LogManager.logExit("finished creating the native launcher");
    }

    @Override
    public boolean canExecuteForward() {
        return !Boolean.getBoolean("nbi.create.bundle.skip.native.launcher");
    }
}

