/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.launcher;

import com.sun.source.util.JavacTask;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.resources.LauncherProperties;
import com.sun.tools.javac.util.JCDiagnostic;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.tools.DiagnosticListener;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import nbjavac.VMWrapper;

public class Main {
    private PrintWriter out;
    private static final String bundleName = "com.sun.tools.javac.resources.launcher";
    private ResourceBundle resourceBundle = null;
    private String errorPrefix;

    public static void main(String ... args) throws Throwable {
        try {
            new Main(System.err).run(VMWrapper.getRuntimeArguments(), args);
        }
        catch (Fault f) {
            System.err.println(f.getMessage());
            System.exit(1);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public Main(PrintStream out) {
        this(new PrintWriter((Writer)new OutputStreamWriter(out), true));
    }

    public Main(PrintWriter out) {
        this.out = out;
    }

    public void run(String[] runtimeArgs, String[] args) throws Fault, InvocationTargetException {
        Path file = this.getFile(args);
        Context context = new Context(file.toAbsolutePath());
        String mainClassName = this.compile(file, this.getJavacOpts(runtimeArgs), context);
        String[] appArgs = Arrays.copyOfRange(args, 1, args.length);
        this.execute(mainClassName, appArgs, context);
    }

    private Path getFile(String[] args) throws Fault {
        Path file;
        if (args.length == 0) {
            throw new Fault(LauncherProperties.Errors.NoArgs);
        }
        try {
            file = Paths.get(args[0], new String[0]);
        }
        catch (InvalidPathException e) {
            throw new Fault(LauncherProperties.Errors.InvalidFilename(args[0]));
        }
        if (!Files.exists(file, new LinkOption[0])) {
            throw new Fault(LauncherProperties.Errors.FileNotFound(file));
        }
        return file;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private JavaFileObject readFile(final Path file) throws Fault {
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(file, new OpenOption[0]));){
            SimpleJavaFileObject simpleJavaFileObject;
            boolean ignoreFirstLine;
            if (file.getFileName().toString().endsWith(".java")) {
                ignoreFirstLine = false;
            } else {
                in.mark(2);
                boolean bl = ignoreFirstLine = in.read() == 35 && in.read() == 33;
                if (!ignoreFirstLine) {
                    in.reset();
                }
            }
            try (BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)in, Charset.defaultCharset()));){
                int n;
                final StringBuilder sb = new StringBuilder();
                if (ignoreFirstLine) {
                    r.readLine();
                    sb.append("\n");
                }
                char[] buf = new char[1024];
                while ((n = r.read(buf, 0, buf.length)) != -1) {
                    sb.append(buf, 0, n);
                }
                simpleJavaFileObject = new SimpleJavaFileObject(file.toUri(), JavaFileObject.Kind.SOURCE){

                    @Override
                    public String getName() {
                        return file.toString();
                    }

                    @Override
                    public CharSequence getCharContent(boolean ignoreEncodingErrors) {
                        return sb;
                    }

                    @Override
                    public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
                        return kind == JavaFileObject.Kind.SOURCE && SourceVersion.isIdentifier(simpleName);
                    }

                    @Override
                    public String toString() {
                        return "JavacSourceLauncher[" + file + "]";
                    }
                };
            }
            return simpleJavaFileObject;
        }
        catch (IOException e) {
            throw new Fault(LauncherProperties.Errors.CantReadFile(file, e));
        }
    }

    private List<String> getJavacOpts(String ... runtimeArgs) throws Fault {
        ArrayList<String> javacOpts = new ArrayList<String>();
        String sourceOpt = System.getProperty("jdk.internal.javac.source");
        if (sourceOpt != null) {
            Source source = Source.lookup(sourceOpt);
            if (source == null) {
                throw new Fault(LauncherProperties.Errors.InvalidValueForSource(sourceOpt));
            }
            javacOpts.addAll(Collections.unmodifiableList(Arrays.asList("--release", sourceOpt)));
        }
        block17: for (int i = 0; i < runtimeArgs.length; ++i) {
            int eq;
            String arg;
            String opt = arg = runtimeArgs[i];
            String value = null;
            if (arg.startsWith("--") && (eq = arg.indexOf(61)) > 0) {
                opt = arg.substring(0, eq);
                value = arg.substring(eq + 1);
            }
            switch (opt) {
                case "--class-path": 
                case "-classpath": 
                case "-cp": 
                case "--module-path": 
                case "-p": 
                case "--add-exports": 
                case "--add-modules": 
                case "--limit-modules": 
                case "--patch-module": 
                case "--upgrade-module-path": {
                    if (value == null) {
                        if (i == runtimeArgs.length - 1) {
                            throw new Fault(LauncherProperties.Errors.NoValueForOption(opt));
                        }
                        value = runtimeArgs[++i];
                    }
                    if (opt.equals("--add-modules") && value.equals("ALL-DEFAULT")) continue block17;
                    javacOpts.add(opt);
                    javacOpts.add(value);
                    continue block17;
                }
                case "--enable-preview": {
                    javacOpts.add(opt);
                    if (sourceOpt != null) continue block17;
                    throw new Fault(LauncherProperties.Errors.EnablePreviewRequiresSource);
                }
                default: {
                    if (!opt.startsWith("-agentlib:jdwp=") && !opt.startsWith("-Xrunjdwp:")) continue block17;
                    javacOpts.add("-g");
                }
            }
        }
        javacOpts.add("-proc:none");
        javacOpts.add("-Xdiags:verbose");
        javacOpts.add("-Xlint:deprecation");
        javacOpts.add("-Xlint:unchecked");
        javacOpts.add("-Xlint:-options");
        return javacOpts;
    }

    private String compile(Path file, List<String> javacOpts, Context context) throws Fault {
        JavaFileObject fo = this.readFile(file);
        JavacTool javaCompiler = JavacTool.create();
        StandardJavaFileManager stdFileMgr = javaCompiler.getStandardFileManager((DiagnosticListener)null, (Locale)null, (Charset)null);
        try {
            stdFileMgr.setLocation(StandardLocation.SOURCE_PATH, Collections.emptyList());
        }
        catch (IOException e) {
            throw new Error("unexpected exception from file manager", e);
        }
        JavaFileManager fm = context.getFileManager(stdFileMgr);
        JavaCompiler.CompilationTask t = javaCompiler.getTask((Writer)this.out, fm, (DiagnosticListener)null, javacOpts, (Iterable)null, Collections.unmodifiableList(Arrays.asList(fo)));
        MainClassListener l = new MainClassListener((JavacTask)t);
        Boolean ok = t.call();
        if (!ok.booleanValue()) {
            throw new Fault(LauncherProperties.Errors.CompilationFailed);
        }
        if (l.mainClass == null) {
            throw new Fault(LauncherProperties.Errors.NoClass);
        }
        String mainClassName = l.mainClass.getQualifiedName().toString();
        return mainClassName;
    }

    private void execute(String mainClassName, String[] appArgs, Context context) throws Fault, InvocationTargetException {
        System.setProperty("jdk.launcher.sourcefile", context.file.toString());
        ClassLoader cl = context.getClassLoader(ToolProvider.class.getClassLoader());
        try {
            Class<?> appClass = Class.forName(mainClassName, true, cl);
            Method main = appClass.getDeclaredMethod("main", String[].class);
            int PUBLIC_STATIC = 9;
            if ((main.getModifiers() & PUBLIC_STATIC) != PUBLIC_STATIC) {
                throw new Fault(LauncherProperties.Errors.MainNotPublicStatic);
            }
            if (!main.getReturnType().equals(Void.TYPE)) {
                throw new Fault(LauncherProperties.Errors.MainNotVoid);
            }
            main.setAccessible(true);
            main.invoke((Object)0, new Object[]{appArgs});
        }
        catch (ClassNotFoundException e) {
            throw new Fault(LauncherProperties.Errors.CantFindClass(mainClassName));
        }
        catch (NoSuchMethodException e) {
            throw new Fault(LauncherProperties.Errors.CantFindMainMethod(mainClassName));
        }
        catch (IllegalAccessException e) {
            throw new Fault(LauncherProperties.Errors.CantAccessMainMethod(mainClassName));
        }
        catch (InvocationTargetException e) {
            int invocationFrames = e.getStackTrace().length;
            Throwable target = e.getCause();
            StackTraceElement[] targetTrace = target.getStackTrace();
            target.setStackTrace(Arrays.copyOfRange(targetTrace, 0, targetTrace.length - invocationFrames));
            throw e;
        }
    }

    private String getMessage(JCDiagnostic.Error error) {
        String key = error.key();
        Object[] args = error.getArgs();
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle(bundleName);
                this.errorPrefix = this.resourceBundle.getString("launcher.error");
            }
            String resource = this.resourceBundle.getString(key);
            String message = MessageFormat.format(resource, args);
            return this.errorPrefix + message;
        }
        catch (MissingResourceException e) {
            return "Cannot access resource; " + key + Arrays.toString(args);
        }
    }

    public class Fault
    extends Exception {
        private static final long serialVersionUID = 1L;

        Fault(JCDiagnostic.Error error) {
            super(Main.this.getMessage(error));
        }
    }

    private static class Context {
        private final Path file;
        private final Map<String, byte[]> inMemoryClasses = new HashMap<String, byte[]>();

        Context(Path file) {
            this.file = file;
        }

        JavaFileManager getFileManager(StandardJavaFileManager delegate) {
            return new MemoryFileManager(this.inMemoryClasses, delegate);
        }

        ClassLoader getClassLoader(ClassLoader parent) {
            return new MemoryClassLoader(this.inMemoryClasses, parent, this.file);
        }
    }

    static class MainClassListener
    implements TaskListener {
        TypeElement mainClass;

        MainClassListener(JavacTask t) {
            t.addTaskListener(this);
        }

        @Override
        public void started(TaskEvent ev) {
            TypeElement te;
            if (ev.getKind() == TaskEvent.Kind.ANALYZE && this.mainClass == null && (te = ev.getTypeElement()).getNestingKind() == NestingKind.TOP_LEVEL) {
                this.mainClass = te;
            }
        }
    }

    private static class MemoryClassLoader
    extends ClassLoader {
        private final Map<String, byte[]> sourceFileClasses;
        private final ProtectionDomain domain;
        private static final int DOT_CLASS_LENGTH = ".class".length();
        private final String PROTOCOL = "sourcelauncher-" + this.getClass().getSimpleName() + this.hashCode();
        private URLStreamHandler handler;

        MemoryClassLoader(Map<String, byte[]> sourceFileClasses, ClassLoader parent, Path file) {
            super(parent);
            CodeSource codeSource;
            this.sourceFileClasses = sourceFileClasses;
            try {
                codeSource = new CodeSource(file.toUri().toURL(), (CodeSigner[])null);
            }
            catch (MalformedURLException e) {
                codeSource = null;
            }
            this.domain = new ProtectionDomain(codeSource, null, this, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Object object = this.getClassLoadingLock(name);
            synchronized (object) {
                Class<?> c = this.findLoadedClass(name);
                if (c == null) {
                    c = this.sourceFileClasses.containsKey(name) ? this.findClass(name) : this.getParent().loadClass(name);
                    if (resolve) {
                        this.resolveClass(c);
                    }
                }
                return c;
            }
        }

        @Override
        public URL getResource(String name) {
            if (this.sourceFileClasses.containsKey(this.toBinaryName(name))) {
                return this.findResource(name);
            }
            return this.getParent().getResource(name);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            URL u = this.findResource(name);
            Enumeration<URL> e = this.getParent().getResources(name);
            if (u == null) {
                return e;
            }
            ArrayList<URL> list = new ArrayList<URL>();
            list.add(u);
            while (e.hasMoreElements()) {
                list.add(e.nextElement());
            }
            return Collections.enumeration(list);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            byte[] bytes = this.sourceFileClasses.get(name);
            if (bytes == null) {
                throw new ClassNotFoundException(name);
            }
            return this.defineClass(name, bytes, 0, bytes.length, this.domain);
        }

        @Override
        public URL findResource(String name) {
            String binaryName = this.toBinaryName(name);
            if (binaryName == null || this.sourceFileClasses.get(binaryName) == null) {
                return null;
            }
            URLStreamHandler handler = this.handler;
            if (handler == null) {
                this.handler = handler = new MemoryURLStreamHandler();
            }
            try {
                return new URL(this.PROTOCOL, null, -1, name, handler);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }

        @Override
        public Enumeration<URL> findResources(final String name) {
            return new Enumeration<URL>(){
                private URL next;
                {
                    this.next = this.findResource(name);
                }

                @Override
                public boolean hasMoreElements() {
                    return this.next != null;
                }

                @Override
                public URL nextElement() {
                    if (this.next == null) {
                        throw new NoSuchElementException();
                    }
                    URL u = this.next;
                    this.next = null;
                    return u;
                }
            };
        }

        private String toBinaryName(String name) {
            if (!name.endsWith(".class")) {
                return null;
            }
            return name.substring(0, name.length() - DOT_CLASS_LENGTH).replace('/', '.');
        }

        private class MemoryURLStreamHandler
        extends URLStreamHandler {
            private MemoryURLStreamHandler() {
            }

            @Override
            public URLConnection openConnection(URL u) {
                if (!u.getProtocol().equalsIgnoreCase(MemoryClassLoader.this.PROTOCOL)) {
                    throw new IllegalArgumentException(u.toString());
                }
                return new MemoryURLConnection(u, (byte[])MemoryClassLoader.this.sourceFileClasses.get(MemoryClassLoader.this.toBinaryName(u.getPath())));
            }
        }

        private static class MemoryURLConnection
        extends URLConnection {
            private byte[] bytes;
            private InputStream in;

            MemoryURLConnection(URL u, byte[] bytes) {
                super(u);
                this.bytes = bytes;
            }

            @Override
            public void connect() throws IOException {
                if (!this.connected) {
                    if (this.bytes == null) {
                        throw new FileNotFoundException(this.getURL().getPath());
                    }
                    this.in = new ByteArrayInputStream(this.bytes);
                    this.connected = true;
                }
            }

            @Override
            public InputStream getInputStream() throws IOException {
                this.connect();
                return this.in;
            }

            @Override
            public long getContentLengthLong() {
                return this.bytes.length;
            }

            @Override
            public String getContentType() {
                return "application/octet-stream";
            }
        }
    }

    private static class MemoryFileManager
    extends ForwardingJavaFileManager<JavaFileManager> {
        private final Map<String, byte[]> map;

        MemoryFileManager(Map<String, byte[]> map, JavaFileManager delegate) {
            super(delegate);
            this.map = map;
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            if (location == StandardLocation.CLASS_OUTPUT && kind == JavaFileObject.Kind.CLASS) {
                return this.createInMemoryClassFile(className);
            }
            return super.getJavaFileForOutput(location, className, kind, sibling);
        }

        private JavaFileObject createInMemoryClassFile(final String className) {
            URI uri = URI.create("memory:///" + className.replace('.', '/') + ".class");
            return new SimpleJavaFileObject(uri, JavaFileObject.Kind.CLASS){

                @Override
                public OutputStream openOutputStream() {
                    return new ByteArrayOutputStream(){

                        @Override
                        public void close() throws IOException {
                            super.close();
                            map.put(className, this.toByteArray());
                        }
                    };
                }
            };
        }
    }
}

