/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.tools.javac.api.Formattable;
import com.sun.tools.javac.api.Messages;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;

public class Tokens {
    private final Names names;
    private Map<String, TokenKind> keywords = new HashMap<String, TokenKind>();
    public static final Context.Key<Tokens> tokensKey = new Context.Key();
    public static final Token DUMMY = new Token(TokenKind.ERROR, 0, 0, null);

    public static Tokens instance(Context context) {
        Tokens instance = context.get(tokensKey);
        if (instance == null) {
            instance = new Tokens(context);
        }
        return instance;
    }

    protected Tokens(Context context) {
        context.put(tokensKey, this);
        this.names = Names.instance(context);
        for (TokenKind t : TokenKind.values()) {
            if (t.name == null) continue;
            this.names.fromString(t.name);
            this.keywords.put(t.name, t);
        }
    }

    TokenKind lookupKind(Name name) {
        TokenKind t = this.keywords.get(name.toString());
        return t != null ? t : TokenKind.IDENTIFIER;
    }

    TokenKind lookupKind(String name) {
        TokenKind t = this.keywords.get(name);
        return t != null ? t : TokenKind.IDENTIFIER;
    }

    public static enum TokenKind implements Formattable,
    Predicate<TokenKind>
    {
        EOF,
        ERROR,
        IDENTIFIER(Token.Tag.NAMED),
        ABSTRACT("abstract"),
        ASSERT("assert", Token.Tag.NAMED),
        BOOLEAN("boolean", Token.Tag.NAMED),
        BREAK("break"),
        BYTE("byte", Token.Tag.NAMED),
        CASE("case"),
        CATCH("catch"),
        CHAR("char", Token.Tag.NAMED),
        CLASS("class"),
        CONST("const"),
        CONTINUE("continue"),
        DEFAULT("default"),
        DO("do"),
        DOUBLE("double", Token.Tag.NAMED),
        ELSE("else"),
        ENUM("enum", Token.Tag.NAMED),
        EXTENDS("extends"),
        FINAL("final"),
        FINALLY("finally"),
        FLOAT("float", Token.Tag.NAMED),
        FOR("for"),
        GOTO("goto"),
        IF("if"),
        IMPLEMENTS("implements"),
        IMPORT("import"),
        INSTANCEOF("instanceof"),
        INT("int", Token.Tag.NAMED),
        INTERFACE("interface"),
        LONG("long", Token.Tag.NAMED),
        NATIVE("native"),
        NEW("new"),
        PACKAGE("package"),
        PRIVATE("private"),
        PROTECTED("protected"),
        PUBLIC("public"),
        RETURN("return"),
        SHORT("short", Token.Tag.NAMED),
        STATIC("static"),
        STRICTFP("strictfp"),
        SUPER("super", Token.Tag.NAMED),
        SWITCH("switch"),
        SYNCHRONIZED("synchronized"),
        THIS("this", Token.Tag.NAMED),
        THROW("throw"),
        THROWS("throws"),
        TRANSIENT("transient"),
        TRY("try"),
        VOID("void", Token.Tag.NAMED),
        VOLATILE("volatile"),
        WHILE("while"),
        INTLITERAL(Token.Tag.NUMERIC),
        LONGLITERAL(Token.Tag.NUMERIC),
        FLOATLITERAL(Token.Tag.NUMERIC),
        DOUBLELITERAL(Token.Tag.NUMERIC),
        CHARLITERAL(Token.Tag.NUMERIC),
        STRINGLITERAL(Token.Tag.STRING),
        TRUE("true", Token.Tag.NAMED),
        FALSE("false", Token.Tag.NAMED),
        NULL("null", Token.Tag.NAMED),
        UNDERSCORE("_", Token.Tag.NAMED),
        ARROW("->"),
        COLCOL("::"),
        LPAREN("("),
        RPAREN(")"),
        LBRACE("{"),
        RBRACE("}"),
        LBRACKET("["),
        RBRACKET("]"),
        SEMI(";"),
        COMMA(","),
        DOT("."),
        ELLIPSIS("..."),
        EQ("="),
        GT(">"),
        LT("<"),
        BANG("!"),
        TILDE("~"),
        QUES("?"),
        COLON(":"),
        EQEQ("=="),
        LTEQ("<="),
        GTEQ(">="),
        BANGEQ("!="),
        AMPAMP("&&"),
        BARBAR("||"),
        PLUSPLUS("++"),
        SUBSUB("--"),
        PLUS("+"),
        SUB("-"),
        STAR("*"),
        SLASH("/"),
        AMP("&"),
        BAR("|"),
        CARET("^"),
        PERCENT("%"),
        LTLT("<<"),
        GTGT(">>"),
        GTGTGT(">>>"),
        PLUSEQ("+="),
        SUBEQ("-="),
        STAREQ("*="),
        SLASHEQ("/="),
        AMPEQ("&="),
        BAREQ("|="),
        CARETEQ("^="),
        PERCENTEQ("%="),
        LTLTEQ("<<="),
        GTGTEQ(">>="),
        GTGTGTEQ(">>>="),
        MONKEYS_AT("@"),
        CUSTOM;

        public final String name;
        public final Token.Tag tag;

        private TokenKind() {
            this(null, Token.Tag.DEFAULT);
        }

        private TokenKind(String name) {
            this(name, Token.Tag.DEFAULT);
        }

        private TokenKind(Token.Tag tag) {
            this(null, tag);
        }

        private TokenKind(String name, Token.Tag tag) {
            this.name = name;
            this.tag = tag;
        }

        public String toString() {
            switch (this) {
                case IDENTIFIER: {
                    return "token.identifier";
                }
                case CHARLITERAL: {
                    return "token.character";
                }
                case STRINGLITERAL: {
                    return "token.string";
                }
                case INTLITERAL: {
                    return "token.integer";
                }
                case LONGLITERAL: {
                    return "token.long-integer";
                }
                case FLOATLITERAL: {
                    return "token.float";
                }
                case DOUBLELITERAL: {
                    return "token.double";
                }
                case ERROR: {
                    return "token.bad-symbol";
                }
                case EOF: {
                    return "token.end-of-input";
                }
                case DOT: 
                case COMMA: 
                case SEMI: 
                case LPAREN: 
                case RPAREN: 
                case LBRACKET: 
                case RBRACKET: 
                case LBRACE: 
                case RBRACE: {
                    return "'" + this.name + "'";
                }
            }
            return this.name;
        }

        @Override
        public String getKind() {
            return "Token";
        }

        @Override
        public String toString(Locale locale, Messages messages) {
            return this.name != null ? this.toString() : messages.getLocalizedString(locale, "compiler.misc." + this.toString(), new Object[0]);
        }

        @Override
        public boolean test(TokenKind that) {
            return this == that;
        }
    }

    public static class Token {
        public final TokenKind kind;
        public final int pos;
        public final int endPos;
        public final List<Comment> comments;

        Token(TokenKind kind, int pos, int endPos, List<Comment> comments) {
            this.kind = kind;
            this.pos = pos;
            this.endPos = endPos;
            this.comments = comments;
            this.checkKind();
        }

        Token[] split(Tokens tokens) {
            if (this.kind.name.length() < 2 || this.kind.tag != Tag.DEFAULT) {
                throw new AssertionError((Object)("Cant split" + this.kind));
            }
            TokenKind t1 = tokens.lookupKind(this.kind.name.substring(0, 1));
            TokenKind t2 = tokens.lookupKind(this.kind.name.substring(1));
            if (t1 == null || t2 == null) {
                throw new AssertionError((Object)"Cant split - bad subtokens");
            }
            return new Token[]{new Token(t1, this.pos, this.pos + t1.name.length(), this.comments), new Token(t2, this.pos + t1.name.length(), this.endPos, null)};
        }

        protected void checkKind() {
            if (this.kind.tag != Tag.DEFAULT) {
                throw new AssertionError((Object)("Bad token kind - expected " + (Object)((Object)Tag.DEFAULT)));
            }
        }

        public Name name() {
            throw new UnsupportedOperationException();
        }

        public String stringVal() {
            throw new UnsupportedOperationException();
        }

        public int radix() {
            throw new UnsupportedOperationException();
        }

        public Comment comment(Comment.CommentStyle style) {
            List<Comment> comments = this.getComments(Comment.CommentStyle.JAVADOC);
            return comments.isEmpty() ? null : (Comment)comments.head;
        }

        public boolean deprecatedFlag() {
            for (Comment c : this.getComments(Comment.CommentStyle.JAVADOC)) {
                if (!c.isDeprecated()) continue;
                return true;
            }
            return false;
        }

        private List<Comment> getComments(Comment.CommentStyle style) {
            if (this.comments == null) {
                return List.nil();
            }
            ListBuffer<Comment> buf = new ListBuffer<Comment>();
            for (Comment c : this.comments) {
                if (c.getStyle() != style) continue;
                buf.add(c);
            }
            return buf.toList();
        }

        static enum Tag {
            DEFAULT,
            NAMED,
            STRING,
            NUMERIC;

        }
    }

    static final class NumericToken
    extends StringToken {
        public final int radix;

        public NumericToken(TokenKind kind, int pos, int endPos, String stringVal, int radix, List<Comment> comments) {
            super(kind, pos, endPos, stringVal, comments);
            this.radix = radix;
        }

        @Override
        protected void checkKind() {
            if (this.kind.tag != Token.Tag.NUMERIC) {
                throw new AssertionError((Object)("Bad token kind - expected " + (Object)((Object)Token.Tag.NUMERIC)));
            }
        }

        @Override
        public int radix() {
            return this.radix;
        }
    }

    static class StringToken
    extends Token {
        public final String stringVal;

        public StringToken(TokenKind kind, int pos, int endPos, String stringVal, List<Comment> comments) {
            super(kind, pos, endPos, comments);
            this.stringVal = stringVal;
        }

        @Override
        protected void checkKind() {
            if (this.kind.tag != Token.Tag.STRING) {
                throw new AssertionError((Object)("Bad token kind - expected " + (Object)((Object)Token.Tag.STRING)));
            }
        }

        @Override
        public String stringVal() {
            return this.stringVal;
        }
    }

    static final class NamedToken
    extends Token {
        public final Name name;

        public NamedToken(TokenKind kind, int pos, int endPos, Name name, List<Comment> comments) {
            super(kind, pos, endPos, comments);
            this.name = name;
        }

        @Override
        protected void checkKind() {
            if (this.kind.tag != Token.Tag.NAMED) {
                throw new AssertionError((Object)("Bad token kind - expected " + (Object)((Object)Token.Tag.NAMED)));
            }
        }

        @Override
        public Name name() {
            return this.name;
        }
    }

    public static interface Comment {
        public String getText();

        public int getSourcePos(int var1);

        public CommentStyle getStyle();

        public boolean isDeprecated();

        public static enum CommentStyle {
            LINE,
            BLOCK,
            JAVADOC;

        }
    }
}

