/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc;

import com.google.common.annotations.VisibleForTesting;
import com.oracle.bmc.Realm;
import com.oracle.bmc.Service;
import com.oracle.bmc.auth.AbstractFederationClientAuthenticationDetailsProviderBuilder;
import com.oracle.bmc.internal.EndpointBuilder;
import com.oracle.bmc.model.RegionSchema;
import com.oracle.bmc.model.internal.JsonConverter;
import com.oracle.bmc.util.internal.FileUtils;
import com.oracle.bmc.util.internal.NameUtils;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Region
implements Serializable,
Comparable<Region> {
    private static final Logger LOG = LoggerFactory.getLogger(Region.class);
    private static final String OCI_REGION_METADATA_ENV_VAR_NAME = "OCI_REGION_METADATA";
    private static final String OCI_DEFAULT_REALM_ENV_VAR_NAME = "OCI_DEFAULT_REALM";
    private static final String REGIONS_CONFIG_FILE_PATH = "~/.oci/regions-config.json";
    private static volatile boolean hasUsedEnvVar = false;
    private static volatile boolean hasUsedConfigFile = false;
    private static final ReentrantLock lock = new ReentrantLock();
    private static volatile boolean hasOptedForInstanceMetadataService = false;
    @VisibleForTesting
    static volatile boolean hasUsedInstanceMetadataService = false;
    private static volatile boolean hasReceivedInstanceMetadataServiceResponse = false;
    private static volatile boolean hasWarnedAboutValuesWithoutInstanceMetadataService = false;
    private static volatile ClientConfig imdsClientConfiguration = new ClientConfig();
    @VisibleForTesting
    static volatile String defaultRealmEnvVar;
    private static final Map<String, Region> KNOWN_REGIONS;
    public static volatile Region regionFromImds;
    public static final Region AP_CHUNCHEON_1;
    public static final Region AP_MELBOURNE_1;
    public static final Region AP_HYDERABAD_1;
    public static final Region AP_MUMBAI_1;
    public static final Region AP_OSAKA_1;
    public static final Region AP_SEOUL_1;
    public static final Region AP_SYDNEY_1;
    public static final Region AP_TOKYO_1;
    public static final Region CA_MONTREAL_1;
    public static final Region CA_TORONTO_1;
    public static final Region EU_AMSTERDAM_1;
    public static final Region EU_FRANKFURT_1;
    public static final Region EU_ZURICH_1;
    public static final Region ME_JEDDAH_1;
    public static final Region ME_DUBAI_1;
    public static final Region SA_SAOPAULO_1;
    public static final Region UK_LONDON_1;
    public static final Region US_ASHBURN_1;
    public static final Region US_PHOENIX_1;
    public static final Region US_SANJOSE_1;
    public static final Region UK_CARDIFF_1;
    public static final Region SA_SANTIAGO_1;
    public static final Region SA_VINHEDO_1;
    public static final Region IL_JERUSALEM_1;
    public static final Region EU_MARSEILLE_1;
    public static final Region AP_SINGAPORE_1;
    public static final Region ME_ABUDHABI_1;
    public static final Region EU_MILAN_1;
    public static final Region EU_STOCKHOLM_1;
    public static final Region AF_JOHANNESBURG_1;
    public static final Region US_LANGLEY_1;
    public static final Region US_LUKE_1;
    public static final Region US_GOV_ASHBURN_1;
    public static final Region US_GOV_CHICAGO_1;
    public static final Region US_GOV_PHOENIX_1;
    public static final Region UK_GOV_LONDON_1;
    public static final Region UK_GOV_CARDIFF_1;
    public static final Region AP_CHIYODA_1;
    public static final Region AP_IBARAKI_1;
    public static final Region ME_DCC_MUSCAT_1;
    public static final Region AP_DCC_CANBERRA_1;
    private static final Map<String, Map<Region, String>> SERVICE_TO_REGION_ENDPOINTS;
    private static final long serialVersionUID = -905384971L;
    private final String regionId;
    private final com.google.common.base.Optional<String> regionCode;
    private final Realm realm;

    private static String getDefaultRealmFromEnv() {
        String defaultRealmEnvVar = System.getenv(OCI_DEFAULT_REALM_ENV_VAR_NAME);
        return defaultRealmEnvVar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Region(@NonNull String regionId, @NonNull com.google.common.base.Optional<String> regionCode, @NonNull Realm realm) {
        if (regionId == null) {
            throw new NullPointerException("regionId is marked non-null but is null");
        }
        if (regionCode == null) {
            throw new NullPointerException("regionCode is marked non-null but is null");
        }
        if (realm == null) {
            throw new NullPointerException("realm is marked non-null but is null");
        }
        this.regionId = regionId;
        this.regionCode = regionCode;
        this.realm = realm;
        Map<String, Region> map = KNOWN_REGIONS;
        synchronized (map) {
            KNOWN_REGIONS.put(NameUtils.canonicalizeForEnumTypes(regionId), this);
        }
    }

    public String getRegionCode() {
        return (String)this.regionCode.or((Object)this.regionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public com.google.common.base.Optional<String> getEndpoint(Service service) {
        Map<String, Map<Region, String>> map = SERVICE_TO_REGION_ENDPOINTS;
        synchronized (map) {
            Map<Object, Object> endpoints;
            if (!SERVICE_TO_REGION_ENDPOINTS.containsKey(service.getServiceName())) {
                endpoints = new HashMap<Region, String>();
                ((HashMap)endpoints).put(this, Region.formatDefaultRegionEndpoint(service, this));
                SERVICE_TO_REGION_ENDPOINTS.put(service.getServiceName(), endpoints);
                LOG.info("Loaded service '{}' endpoint mappings: {}", (Object)service.getServiceName(), endpoints);
            }
            if (!(endpoints = SERVICE_TO_REGION_ENDPOINTS.get(service.getServiceName())).containsKey(this)) {
                endpoints.put(this, Region.formatDefaultRegionEndpoint(service, this));
                LOG.info("Loaded service '{}' endpoint mappings: {}", (Object)service.getServiceName(), endpoints);
            }
            String endpoint = SERVICE_TO_REGION_ENDPOINTS.get(service.getServiceName()).get(this);
            return com.google.common.base.Optional.fromNullable((Object)endpoint);
        }
    }

    @Override
    public int compareTo(Region other) {
        return this.regionId.compareTo(other.regionId);
    }

    public String toString() {
        return NameUtils.canonicalizeForEnumTypes(this.getRegionId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Region[] values() {
        if (!hasUsedInstanceMetadataService && !hasWarnedAboutValuesWithoutInstanceMetadataService) {
            LOG.warn("Call to Regions.values() without having contacted IMDS (Instance Metadata Service, only available on OCI instances); if you do need the region from IMDS, call Region.registerFromInstanceMetadataService before calling Region.values()");
            hasWarnedAboutValuesWithoutInstanceMetadataService = true;
        }
        Region.registerAllRegions();
        Map<String, Region> map = KNOWN_REGIONS;
        synchronized (map) {
            return KNOWN_REGIONS.values().toArray(new Region[0]);
        }
    }

    public static Region valueOf(@NonNull String name) throws IllegalArgumentException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        com.google.common.base.Optional<Region> maybeRegion = Region.getRegionAndRegisterIfNecessary(name);
        if (!maybeRegion.isPresent()) {
            throw new IllegalArgumentException("Unknown region " + name);
        }
        return (Region)maybeRegion.get();
    }

    public static String formatDefaultRegionEndpoint(Service service, Region region) {
        return EndpointBuilder.createEndpoint(service, region);
    }

    public static String formatDefaultRegionEndpoint(Service service, String regionId) {
        com.google.common.base.Optional<Region> maybeRegion = Region.maybeFromRegionId(regionId);
        if (maybeRegion.isPresent()) {
            return Region.formatDefaultRegionEndpoint(service, (Region)maybeRegion.get());
        }
        LOG.debug("Unknown regionId '{}', will assume it's in Realm OC1", (Object)regionId);
        return EndpointBuilder.createEndpoint(service, regionId, Realm.OC1);
    }

    public static Region fromRegionId(String regionId) {
        com.google.common.base.Optional<Region> maybeRegion = Region.maybeFromRegionId(regionId);
        if (maybeRegion.isPresent()) {
            return (Region)maybeRegion.get();
        }
        throw new IllegalArgumentException("Unknown regionId: " + regionId);
    }

    private static com.google.common.base.Optional<Region> maybeFromRegionId(String regionId) {
        return Region.getRegionAndRegisterIfNecessary(regionId);
    }

    public static Region fromRegionCode(String regionCode) {
        com.google.common.base.Optional<Region> maybeRegion = Region.getRegionAndRegisterIfNecessary(regionCode);
        if (!maybeRegion.isPresent()) {
            throw new IllegalArgumentException("Unknown regionCode: " + regionCode);
        }
        return (Region)maybeRegion.get();
    }

    public static Region fromRegionCodeOrId(String regionCodeOrId) {
        com.google.common.base.Optional<Region> maybeRegion = Region.getRegionAndRegisterIfNecessary(regionCodeOrId);
        if (!maybeRegion.isPresent()) {
            throw new IllegalArgumentException("Unknown regionCodeOrId: " + regionCodeOrId);
        }
        return (Region)maybeRegion.get();
    }

    public static Region register(@NonNull String regionId, @NonNull Realm realm) {
        if (regionId == null) {
            throw new NullPointerException("regionId is marked non-null but is null");
        }
        if (realm == null) {
            throw new NullPointerException("realm is marked non-null but is null");
        }
        return Region.register(regionId, realm, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Region register(@NonNull String regionId, @NonNull Realm realm, String regionCode) {
        if (regionId == null) {
            throw new NullPointerException("regionId is marked non-null but is null");
        }
        if (realm == null) {
            throw new NullPointerException("realm is marked non-null but is null");
        }
        if ((regionId = regionId.trim().toLowerCase(Locale.US)).isEmpty()) {
            throw new IllegalArgumentException("Cannot have empty regionId");
        }
        Map<String, Region> map = KNOWN_REGIONS;
        synchronized (map) {
            for (Region region : KNOWN_REGIONS.values()) {
                if (!region.getRegionId().equals(regionId)) continue;
                if (!region.getRealm().equals(realm)) {
                    throw new IllegalArgumentException("Region : " + regionId + " is already registered with " + region.getRealm() + ". It cannot be re-registered with a different realm.");
                }
                return region;
            }
            if (regionCode != null && (regionCode = regionCode.trim().toLowerCase(Locale.US)).isEmpty()) {
                regionCode = null;
            }
            return new Region(regionId, (com.google.common.base.Optional<String>)com.google.common.base.Optional.fromNullable((Object)regionCode), realm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Optional<Region> maybeFromRegionCodeOrIdWithoutRegistering(String regionCodeOrId) {
        Map<String, Region> map = KNOWN_REGIONS;
        synchronized (map) {
            return KNOWN_REGIONS.values().stream().filter(r -> r.getRegionCode().equalsIgnoreCase(regionCodeOrId) || r.regionId.equalsIgnoreCase(regionCodeOrId)).findAny();
        }
    }

    private static void registerAllRegions() {
        if (!hasUsedConfigFile) {
            Region.readConfigFile();
        }
        if (!hasUsedEnvVar) {
            Region.readEnvVar();
        }
    }

    private static com.google.common.base.Optional<Region> getRegionAndRegisterIfNecessary(String regionCodeOrId) {
        Optional<Region> maybeRegion;
        if (regionCodeOrId.contains("_")) {
            regionCodeOrId = NameUtils.decanonicalizeFromEnumTypes(regionCodeOrId);
        }
        if ((maybeRegion = Region.maybeFromRegionCodeOrIdWithoutRegistering(regionCodeOrId)).isPresent()) {
            return com.google.common.base.Optional.fromNullable((Object)maybeRegion.get());
        }
        if (!hasUsedConfigFile) {
            Region.readConfigFile();
            maybeRegion = Region.maybeFromRegionCodeOrIdWithoutRegistering(regionCodeOrId);
            if (maybeRegion.isPresent()) {
                return com.google.common.base.Optional.fromNullable((Object)maybeRegion.get());
            }
        }
        if (!hasUsedEnvVar) {
            Region.readEnvVar();
            maybeRegion = Region.maybeFromRegionCodeOrIdWithoutRegistering(regionCodeOrId);
            if (maybeRegion.isPresent()) {
                return com.google.common.base.Optional.fromNullable((Object)maybeRegion.get());
            }
        }
        if (hasOptedForInstanceMetadataService && !hasUsedInstanceMetadataService) {
            Region.registerFromInstanceMetadataService();
            maybeRegion = Region.maybeFromRegionCodeOrIdWithoutRegistering(regionCodeOrId);
            if (maybeRegion.isPresent()) {
                return com.google.common.base.Optional.fromNullable((Object)maybeRegion.get());
            }
        }
        if (defaultRealmEnvVar != null && !StringUtils.isBlank((CharSequence)defaultRealmEnvVar)) {
            Region.registerRegionWithDefaultRealm(regionCodeOrId);
            maybeRegion = Region.maybeFromRegionCodeOrIdWithoutRegistering(regionCodeOrId);
            if (maybeRegion.isPresent()) {
                return com.google.common.base.Optional.fromNullable((Object)maybeRegion.get());
            }
        }
        return com.google.common.base.Optional.absent();
    }

    private static void readEnvVar() {
        String envVar = System.getenv(OCI_REGION_METADATA_ENV_VAR_NAME);
        RegionSchema regionSchema = null;
        LOG.info("Region metadata schema from OCI_REGION_METADATA env variable is {}", (Object)envVar);
        hasUsedEnvVar = true;
        if (envVar != null) {
            regionSchema = JsonConverter.jsonBlobToObject(envVar, RegionSchema.class);
        }
        if (regionSchema != null && RegionSchema.isValid(regionSchema)) {
            Region.register(regionSchema.getRegionIdentifier(), Realm.register(regionSchema.getRealmKey(), regionSchema.getRealmDomainComponent()), regionSchema.getRegionKey());
        }
    }

    private static void registerRegionWithDefaultRealm(String regionId) {
        LOG.info("Realm domain component from OCI_DEFAULT_REALM env variable is {}", (Object)defaultRealmEnvVar);
        String trimmedDefaultRealm = defaultRealmEnvVar.replaceAll("'", "").replaceAll("\"", "");
        Realm defaultRealmFromEnvVar = Realm.register("defaultRealmFromEnv", trimmedDefaultRealm);
        LOG.info("Unknown regionId '{}', default realm is defined, falling back to '{}'", (Object)regionId, (Object)trimmedDefaultRealm);
        if (defaultRealmFromEnvVar != null) {
            Region.register(regionId, defaultRealmFromEnvVar);
        }
    }

    private static void readConfigFile() {
        hasUsedConfigFile = true;
        try {
            File file = new File(FileUtils.expandUserHome(REGIONS_CONFIG_FILE_PATH));
            if (!file.isFile()) {
                LOG.info("Region config file not found to fetch regions at {} ", (Object)Paths.get(FileUtils.expandUserHome(REGIONS_CONFIG_FILE_PATH), new String[0]));
                return;
            }
            String content = new String(Files.readAllBytes(Paths.get(FileUtils.expandUserHome(REGIONS_CONFIG_FILE_PATH), new String[0])), StandardCharsets.UTF_8);
            LOG.info("Region schemas from regions-config.json are {}", (Object)content);
            if (content.isEmpty()) {
                return;
            }
            RegionSchema[] regionSchemas = JsonConverter.jsonBlobToObject(content, RegionSchema[].class);
            if (regionSchemas != null && regionSchemas.length != 0) {
                for (RegionSchema regionSchema : regionSchemas) {
                    if (regionSchema == null || !RegionSchema.isValid(regionSchema)) continue;
                    Region.register(regionSchema.getRegionIdentifier(), Realm.register(regionSchema.getRealmKey(), regionSchema.getRealmDomainComponent()), regionSchema.getRegionKey());
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Exception in reading or parsing {} to fetch regions ", (Object)Paths.get(FileUtils.expandUserHome(REGIONS_CONFIG_FILE_PATH), new String[0]), (Object)e);
        }
    }

    public static void setInstanceMetadataServiceClientConfig(ClientConfig clientConfig) {
        imdsClientConfiguration = clientConfig;
    }

    public static void enableInstanceMetadataService() {
        hasOptedForInstanceMetadataService = true;
    }

    public static void skipInstanceMetadataService() {
        hasUsedInstanceMetadataService = true;
        hasOptedForInstanceMetadataService = false;
    }

    public static boolean registerFromInstanceMetadataService() {
        if (hasUsedInstanceMetadataService) {
            return hasReceivedInstanceMetadataServiceResponse;
        }
        try {
            RegionSchema regionSchema;
            lock.lock();
            if (hasUsedInstanceMetadataService) {
                boolean bl = hasReceivedInstanceMetadataServiceResponse;
                return bl;
            }
            Region.enableInstanceMetadataService();
            LOG.info("Requesting region metadata blob from IMDS at {}", (Object)"http://169.254.169.254/opc/v2/instance/regionInfo");
            String REGION_INFO = "regionInfo";
            String regionMetadataSchema = (String)AbstractFederationClientAuthenticationDetailsProviderBuilder.simpleRetry(base -> (String)base.path("regionInfo").request(new String[]{"application/json"}).header("Authorization", (Object)"Bearer Oracle").get(String.class), "http://169.254.169.254/opc/v2/", "regionInfo");
            hasReceivedInstanceMetadataServiceResponse = true;
            LOG.info("Region metadata blob from regionInfo service is {}", (Object)regionMetadataSchema);
            if (regionMetadataSchema != null && !regionMetadataSchema.isEmpty() && (regionSchema = JsonConverter.jsonBlobToObject(regionMetadataSchema, RegionSchema.class)) != null && RegionSchema.isValid(regionSchema)) {
                regionFromImds = Region.register(regionSchema.getRegionIdentifier(), Realm.register(regionSchema.getRealmKey(), regionSchema.getRealmDomainComponent()), regionSchema.getRegionKey());
            }
        }
        catch (RuntimeException e) {
            LOG.warn("Rest call to get regionInfo from metadata service failed ", (Throwable)e);
        }
        finally {
            lock.unlock();
            hasUsedInstanceMetadataService = true;
        }
        return hasReceivedInstanceMetadataServiceResponse;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Region)) {
            return false;
        }
        Region other = (Region)o;
        String this$regionId = this.getRegionId();
        String other$regionId = other.getRegionId();
        if (this$regionId == null ? other$regionId != null : !this$regionId.equals(other$regionId)) {
            return false;
        }
        String this$regionCode = this.getRegionCode();
        String other$regionCode = other.getRegionCode();
        if (this$regionCode == null ? other$regionCode != null : !this$regionCode.equals(other$regionCode)) {
            return false;
        }
        Realm this$realm = this.getRealm();
        Realm other$realm = other.getRealm();
        return !(this$realm == null ? other$realm != null : !((Object)this$realm).equals(other$realm));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $regionId = this.getRegionId();
        result = result * 59 + ($regionId == null ? 43 : $regionId.hashCode());
        String $regionCode = this.getRegionCode();
        result = result * 59 + ($regionCode == null ? 43 : $regionCode.hashCode());
        Realm $realm = this.getRealm();
        result = result * 59 + ($realm == null ? 43 : ((Object)$realm).hashCode());
        return result;
    }

    public static Region getRegionFromImds() {
        return regionFromImds;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public Realm getRealm() {
        return this.realm;
    }

    static {
        imdsClientConfiguration = imdsClientConfiguration.property("jersey.config.client.connectTimeout", (Object)30000);
        imdsClientConfiguration = imdsClientConfiguration.property("jersey.config.client.readTimeout", (Object)60000);
        defaultRealmEnvVar = Region.getDefaultRealmFromEnv();
        KNOWN_REGIONS = new LinkedHashMap<String, Region>();
        regionFromImds = null;
        AP_CHUNCHEON_1 = Region.register("ap-chuncheon-1", Realm.OC1, "yny");
        AP_MELBOURNE_1 = Region.register("ap-melbourne-1", Realm.OC1, "mel");
        AP_HYDERABAD_1 = Region.register("ap-hyderabad-1", Realm.OC1, "hyd");
        AP_MUMBAI_1 = Region.register("ap-mumbai-1", Realm.OC1, "bom");
        AP_OSAKA_1 = Region.register("ap-osaka-1", Realm.OC1, "kix");
        AP_SEOUL_1 = Region.register("ap-seoul-1", Realm.OC1, "icn");
        AP_SYDNEY_1 = Region.register("ap-sydney-1", Realm.OC1, "syd");
        AP_TOKYO_1 = Region.register("ap-tokyo-1", Realm.OC1, "nrt");
        CA_MONTREAL_1 = Region.register("ca-montreal-1", Realm.OC1, "yul");
        CA_TORONTO_1 = Region.register("ca-toronto-1", Realm.OC1, "yyz");
        EU_AMSTERDAM_1 = Region.register("eu-amsterdam-1", Realm.OC1, "ams");
        EU_FRANKFURT_1 = Region.register("eu-frankfurt-1", Realm.OC1, "fra");
        EU_ZURICH_1 = Region.register("eu-zurich-1", Realm.OC1, "zrh");
        ME_JEDDAH_1 = Region.register("me-jeddah-1", Realm.OC1, "jed");
        ME_DUBAI_1 = Region.register("me-dubai-1", Realm.OC1, "dxb");
        SA_SAOPAULO_1 = Region.register("sa-saopaulo-1", Realm.OC1, "gru");
        UK_LONDON_1 = Region.register("uk-london-1", Realm.OC1, "lhr");
        US_ASHBURN_1 = Region.register("us-ashburn-1", Realm.OC1, "iad");
        US_PHOENIX_1 = Region.register("us-phoenix-1", Realm.OC1, "phx");
        US_SANJOSE_1 = Region.register("us-sanjose-1", Realm.OC1, "sjc");
        UK_CARDIFF_1 = Region.register("uk-cardiff-1", Realm.OC1, "cwl");
        SA_SANTIAGO_1 = Region.register("sa-santiago-1", Realm.OC1, "scl");
        SA_VINHEDO_1 = Region.register("sa-vinhedo-1", Realm.OC1, "vcp");
        IL_JERUSALEM_1 = Region.register("il-jerusalem-1", Realm.OC1, "mtz");
        EU_MARSEILLE_1 = Region.register("eu-marseille-1", Realm.OC1, "mrs");
        AP_SINGAPORE_1 = Region.register("ap-singapore-1", Realm.OC1, "sin");
        ME_ABUDHABI_1 = Region.register("me-abudhabi-1", Realm.OC1, "auh");
        EU_MILAN_1 = Region.register("eu-milan-1", Realm.OC1, "lin");
        EU_STOCKHOLM_1 = Region.register("eu-stockholm-1", Realm.OC1, "arn");
        AF_JOHANNESBURG_1 = Region.register("af-johannesburg-1", Realm.OC1, "jnb");
        US_LANGLEY_1 = Region.register("us-langley-1", Realm.OC2, "lfi");
        US_LUKE_1 = Region.register("us-luke-1", Realm.OC2, "luf");
        US_GOV_ASHBURN_1 = Region.register("us-gov-ashburn-1", Realm.OC3, "ric");
        US_GOV_CHICAGO_1 = Region.register("us-gov-chicago-1", Realm.OC3, "pia");
        US_GOV_PHOENIX_1 = Region.register("us-gov-phoenix-1", Realm.OC3, "tus");
        UK_GOV_LONDON_1 = Region.register("uk-gov-london-1", Realm.OC4, "ltn");
        UK_GOV_CARDIFF_1 = Region.register("uk-gov-cardiff-1", Realm.OC4, "brs");
        AP_CHIYODA_1 = Region.register("ap-chiyoda-1", Realm.OC8, "nja");
        AP_IBARAKI_1 = Region.register("ap-ibaraki-1", Realm.OC8, "ukb");
        ME_DCC_MUSCAT_1 = Region.register("me-dcc-muscat-1", Realm.OC9, "mct");
        AP_DCC_CANBERRA_1 = Region.register("ap-dcc-canberra-1", Realm.OC10, "wga");
        SERVICE_TO_REGION_ENDPOINTS = new HashMap<String, Map<Region, String>>();
    }
}

