/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.model;

import java.beans.ConstructorProperties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Range {
    private static final Logger LOG = LoggerFactory.getLogger(Range.class);
    private static final String HEADER_VALUE_FORMAT = "bytes=%s-%s";
    private static final String START_ONLY_HEADER_VALUE_FORMAT = "bytes=%s-";
    private static final String END_ONLY_HEADER_VALUE_FORMAT = "bytes=-%s";
    private final Long startByte;
    private final Long endByte;
    private Long contentLength = null;

    public String toString() {
        if (this.startByte != null && this.endByte != null) {
            return String.format(HEADER_VALUE_FORMAT, this.startByte, this.endByte);
        }
        if (this.startByte != null) {
            return String.format(START_ONLY_HEADER_VALUE_FORMAT, this.startByte);
        }
        if (this.endByte != null) {
            return String.format(END_ONLY_HEADER_VALUE_FORMAT, this.endByte);
        }
        LOG.error("Must provide start/end byte for range request: " + this);
        return "";
    }

    public static Range parse(String value) {
        Long endByte;
        LOG.debug("Attempting to parse range: {}", (Object)value);
        value = value.replace("bytes", "").trim();
        String[] parts = value.split("/");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Must provide <range>/<length> format for range request: " + value);
        }
        String byteRangePart = parts[0];
        String contentLengthPart = parts[1];
        Long contentLength = contentLengthPart.equals("*") ? null : Long.valueOf(Long.parseLong(contentLengthPart));
        String[] byteValues = byteRangePart.split("-", -1);
        if (byteValues.length != 2) {
            throw new IllegalArgumentException("Must provide <start>-<end> format for range request: " + value);
        }
        Long startByte = StringUtils.isBlank((CharSequence)byteValues[0]) ? null : Long.valueOf(Long.parseLong(byteValues[0]));
        Long l = endByte = StringUtils.isBlank((CharSequence)byteValues[1]) ? null : Long.valueOf(Long.parseLong(byteValues[1]));
        if (startByte == null && endByte == null) {
            throw new IllegalArgumentException("Must provide start/end byte for range request: " + value);
        }
        Range range = new Range(startByte, endByte);
        range.contentLength = contentLength;
        return range;
    }

    @ConstructorProperties(value={"startByte", "endByte"})
    public Range(Long startByte, Long endByte) {
        this.startByte = startByte;
        this.endByte = endByte;
    }

    public Long getStartByte() {
        return this.startByte;
    }

    public Long getEndByte() {
        return this.endByte;
    }

    public Long getContentLength() {
        return this.contentLength;
    }
}

