/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.classpath;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.classpath.AbstractProjectClassPathImpl;
import org.netbeans.spi.java.classpath.FlaggedClassPathImplementation;
import org.openide.util.Utilities;

final class AnnotationProcClassPathImpl
extends AbstractProjectClassPathImpl
implements FlaggedClassPathImplementation {
    private static final String COMPILER_ARTIFACT_ID = "maven-compiler-plugin";
    private static final String COMPILER_GROUP_ID = "org.apache.maven.plugins";
    private static final String GOAL_COMPILE = "compile";
    private static final String GOAL_TEST_COMPILE = "testCompile";
    private static final String PROPERTY_PATH = "annotationProcessorPaths";
    private static final String PROPERTY_ITEM = "path";
    private final boolean mainCompile;
    private volatile boolean incomplete;

    public AnnotationProcClassPathImpl(NbMavenProjectImpl proj, boolean mainCompile) {
        super(proj);
        this.mainCompile = mainCompile;
    }

    @Override
    URI[] createPath() {
        ArrayList<URI> lst = new ArrayList<URI>();
        boolean broken = AnnotationProcClassPathImpl.getCompileArtifacts(this.getMavenProject(), this.mainCompile ? GOAL_COMPILE : GOAL_TEST_COMPILE, this.getMavenProject().getOriginalMavenProject(), lst);
        if (this.incomplete != broken) {
            this.incomplete = broken;
            this.firePropertyChange("flags", null, null);
        }
        URI[] uris = new URI[lst.size()];
        uris = lst.toArray(uris);
        return uris;
    }

    public Set<ClassPath.Flag> getFlags() {
        return this.incomplete ? EnumSet.of(ClassPath.Flag.INCOMPLETE) : Collections.emptySet();
    }

    static boolean getCompileArtifacts(NbMavenProjectImpl prjImpl, String goal, MavenProject mavenProject, List<URI> lst) {
        PluginPropertyUtils.PluginConfigPathParams query = new PluginPropertyUtils.PluginConfigPathParams(COMPILER_GROUP_ID, COMPILER_ARTIFACT_ID, PROPERTY_PATH, PROPERTY_ITEM);
        query.setDefaultScope("runtime");
        query.setGoal(goal);
        ArrayList<ArtifactResolutionException> errorList = new ArrayList<ArtifactResolutionException>();
        List<Object> arts = Collections.emptyList();
        arts = PluginPropertyUtils.getPluginPathProperty(prjImpl, query, true, errorList);
        if (arts == null) {
            return false;
        }
        boolean broken = false;
        for (Artifact artifact : arts) {
            File f = AnnotationProcClassPathImpl.getFile(artifact);
            if (f != null) {
                lst.add(Utilities.toURI((File)f));
                broken |= !f.exists();
                continue;
            }
            broken = true;
        }
        return broken || !errorList.isEmpty();
    }
}

