/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.netbeans.modules.hudson.api.HudsonInstance;
import org.netbeans.modules.hudson.api.HudsonView;
import org.netbeans.modules.hudson.ui.actions.Bundle;
import org.openide.awt.DynamicMenuContent;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.actions.Presenter;

public class ViewSwitcher
extends AbstractAction
implements ContextAwareAction,
Presenter.Popup {
    private final HudsonInstance instance;

    public ViewSwitcher() {
        this((HudsonInstance)null);
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        Collection instances = actionContext.lookupAll(HudsonInstance.class);
        return new ViewSwitcher(instances.size() == 1 ? (HudsonInstance)instances.iterator().next() : null);
    }

    private ViewSwitcher(HudsonInstance instance) {
        super(Bundle.ViewSwitcher_label());
        this.instance = instance;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        assert (false);
    }

    public JMenuItem getPopupPresenter() {
        return new Menu();
    }

    private class Menu
    extends JMenu
    implements DynamicMenuContent {
        Menu() {
            this.setText(Bundle.ViewSwitcher_label());
        }

        public JComponent[] getMenuPresenters() {
            if (ViewSwitcher.this.instance == null || ViewSwitcher.this.instance.getViews().size() < 2) {
                return new JComponent[0];
            }
            this.removeAll();
            String selectedView = ViewSwitcher.this.instance.prefs().get("view", null);
            String primaryViewName = ViewSwitcher.this.instance.getPrimaryView().getName();
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(primaryViewName);
            item.setSelected(selectedView == null || selectedView.equals(primaryViewName));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ViewSwitcher.this.instance.prefs().remove("view");
                }
            });
            this.add(item);
            this.addSeparator();
            for (HudsonView view : ViewSwitcher.this.instance.getViews()) {
                final String name = view.getName();
                if (name.equals(primaryViewName)) continue;
                item = new JRadioButtonMenuItem(name);
                item.setSelected(name.equals(selectedView));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ViewSwitcher.this.instance.prefs().put("view", name);
                    }
                });
                this.add(item);
            }
            return new JComponent[]{this};
        }

        public JComponent[] synchMenuPresenters(JComponent[] items) {
            return this.getMenuPresenters();
        }
    }
}

