/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.IgnoreError;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class ErrorControlOperatorHint
extends HintRule {
    private static final String HINT_ID = "error.control.operator.hint";
    private static final Set<IgnoreErrorValidator> IGNORE_ERROR_VALIDATORS = new HashSet<IgnoreErrorValidator>();

    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        FileObject fileObject;
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() != null && (fileObject = phpParseResult.getSnapshot().getSource().getFileObject()) != null) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            CheckVisitor checkVisitor = new CheckVisitor(fileObject, context.doc, phpParseResult.getModel());
            phpParseResult.getProgram().accept(checkVisitor);
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            hints.addAll(checkVisitor.getHints());
        }
    }

    public String getId() {
        return HINT_ID;
    }

    public String getDescription() {
        return Bundle.ErrorControlOperatorHintDesc();
    }

    public String getDisplayName() {
        return Bundle.ErrorControlOperatorHintDisp();
    }

    static {
        IGNORE_ERROR_VALIDATORS.add(new FunctionInvocationValidator("fopen"));
        IGNORE_ERROR_VALIDATORS.add(new FunctionInvocationValidator("unlink"));
        IGNORE_ERROR_VALIDATORS.add(new FunctionInvocationValidator("mysql_connect"));
        IGNORE_ERROR_VALIDATORS.add(new FunctionInvocationValidator("ob_end_clean"));
        IGNORE_ERROR_VALIDATORS.add(new FunctionInvocationValidator("ob_end_flush"));
        IGNORE_ERROR_VALIDATORS.add(new FunctionInvocationValidator("mkdir"));
        IGNORE_ERROR_VALIDATORS.add(new FunctionInvocationValidator("iconv"));
        IGNORE_ERROR_VALIDATORS.add(new MethodInvocationValidator(QualifiedName.create("\\DOMDocument"), "loadHTML"));
        IGNORE_ERROR_VALIDATORS.add(new MethodInvocationValidator(QualifiedName.create("\\DOMDocument"), "loadHTMLFile"));
        IGNORE_ERROR_VALIDATORS.add(new MethodInvocationValidator(QualifiedName.create("\\DOMDocument"), "loadXML"));
    }

    private static final class MethodInvocationValidator
    implements IgnoreErrorValidator {
        private final QualifiedName fullyQualifiedTypeName;
        private final String methodName;

        public MethodInvocationValidator(QualifiedName fullyQualifiedTypeName, String methodName) {
            assert (fullyQualifiedTypeName != null);
            assert (fullyQualifiedTypeName.getKind().isFullyQualified());
            assert (methodName != null);
            this.fullyQualifiedTypeName = fullyQualifiedTypeName;
            this.methodName = methodName;
        }

        @Override
        public boolean isValid(IgnoreError node, Model model) {
            assert (node != null);
            assert (model != null);
            boolean result = false;
            Expression expression = node.getExpression();
            if (expression instanceof MethodInvocation) {
                result = this.isValid((MethodInvocation)expression, model);
            }
            return result;
        }

        private boolean isValid(MethodInvocation methodInvocation, Model model) {
            Collection<? extends TypeScope> types;
            TypeScope type;
            boolean result = false;
            String methodInvocationName = CodeUtils.extractFunctionName(methodInvocation.getMethod());
            if (this.methodName.equals(methodInvocationName) && (type = ModelUtils.getFirst(types = ModelUtils.resolveType(model, methodInvocation))) != null) {
                result = this.fullyQualifiedTypeName.equals(type.getFullyQualifiedName());
            }
            return result;
        }
    }

    private static final class FunctionInvocationValidator
    implements IgnoreErrorValidator {
        private final String functionName;

        public FunctionInvocationValidator(String functionName) {
            assert (functionName != null);
            this.functionName = functionName.toLowerCase();
        }

        @Override
        public boolean isValid(IgnoreError node, Model model) {
            assert (node != null);
            assert (model != null);
            boolean result = false;
            Expression expression = node.getExpression();
            if (expression instanceof FunctionInvocation) {
                result = this.isValid((FunctionInvocation)expression);
            }
            return result;
        }

        private boolean isValid(FunctionInvocation functionInvocation) {
            boolean result = false;
            String functionInvocationName = CodeUtils.extractFunctionName(functionInvocation);
            if (functionInvocationName != null) {
                result = this.functionName.equals(functionInvocationName.toLowerCase());
            }
            return result;
        }
    }

    private static interface IgnoreErrorValidator {
        public boolean isValid(IgnoreError var1, Model var2);
    }

    private static final class Fix
    implements HintFix {
        private static final String ERROR_CONTROL_OPERATOR = "@";
        private final IgnoreError node;
        private final BaseDocument baseDocument;

        private Fix(IgnoreError node, BaseDocument baseDocument) {
            this.node = node;
            this.baseDocument = baseDocument;
        }

        public String getDescription() {
            return Bundle.ErrorControlOperatorHintFix();
        }

        public void implement() throws Exception {
            EditList editList = new EditList(this.baseDocument);
            editList.replace(this.node.getStartOffset(), ERROR_CONTROL_OPERATOR.length(), "", true, 0);
            editList.apply();
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private final class CheckVisitor
    extends DefaultVisitor {
        private final FileObject fileObject;
        private final BaseDocument baseDocument;
        private final Model model;
        private final List<Hint> hints;

        private CheckVisitor(FileObject fileObject, BaseDocument baseDocument, Model model) {
            this.fileObject = fileObject;
            this.baseDocument = baseDocument;
            this.model = model;
            this.hints = new ArrayList<Hint>();
        }

        private Collection<? extends Hint> getHints() {
            return this.hints;
        }

        @Override
        public void visit(IgnoreError node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            super.visit(node);
            if (!this.isValidCase(node)) {
                this.createHint(node);
            }
        }

        private void createHint(IgnoreError node) {
            OffsetRange offsetRange = new OffsetRange(node.getStartOffset(), node.getEndOffset());
            if (ErrorControlOperatorHint.this.showHint(offsetRange, this.baseDocument)) {
                this.hints.add(new Hint((Rule)ErrorControlOperatorHint.this, Bundle.ErrorControlOperatorHintText(), this.fileObject, offsetRange, Collections.singletonList(new Fix(node, this.baseDocument)), 500));
            }
        }

        private boolean isValidCase(IgnoreError node) {
            boolean result = false;
            for (IgnoreErrorValidator ignoreErrorValidator : IGNORE_ERROR_VALIDATORS) {
                if (!ignoreErrorValidator.isValid(node, this.model)) continue;
                result = true;
                break;
            }
            return result;
        }
    }
}

