/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.GroupUseStatementPart;
import org.netbeans.modules.php.editor.parser.astnodes.SingleUseStatementPart;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.netbeans.modules.php.editor.verification.UnhandledErrorRule;
import org.netbeans.modules.php.editor.verification.VerificationError;
import org.openide.filesystems.FileObject;

public class PHP72UnhandledError
extends UnhandledErrorRule {
    public String getDisplayName() {
        return Bundle.PHP72UnhandledError_displayName();
    }

    @Override
    public void invoke(PHPRuleContext context, List<Error> errors) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileObject fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileObject != null && PHP72UnhandledError.appliesTo(fileObject)) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            CheckVisitor checkVisitor = new CheckVisitor(fileObject);
            phpParseResult.getProgram().accept(checkVisitor);
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            errors.addAll(checkVisitor.getErrors());
        }
    }

    private static boolean appliesTo(FileObject fileObject) {
        return CodeUtils.isPhpVersionLessThan(fileObject, PhpVersion.PHP_72);
    }

    private static final class PHP72VersionError
    extends VerificationError {
        private static final String KEY = "Php.Version.72";

        private PHP72VersionError(FileObject fileObject, int startOffset, int endOffset) {
            super(fileObject, startOffset, endOffset);
        }

        public String getDisplayName() {
            return Bundle.PHP72VersionError_displayName();
        }

        public String getDescription() {
            return Bundle.PHP72VersionError_description();
        }

        public String getKey() {
            return KEY;
        }
    }

    private static final class CheckVisitor
    extends DefaultVisitor {
        private final List<VerificationError> errors = new ArrayList<VerificationError>();
        private final List<SingleUseStatementPart> lastUseStatementParts = new ArrayList<SingleUseStatementPart>();
        private final FileObject fileObject;

        public CheckVisitor(FileObject fileObject) {
            this.fileObject = fileObject;
        }

        public Collection<VerificationError> getErrors() {
            this.checkGroupUseTrailingCommas();
            return Collections.unmodifiableCollection(this.errors);
        }

        @Override
        public void visit(GroupUseStatementPart node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            List<SingleUseStatementPart> items = node.getItems();
            if (!items.isEmpty()) {
                this.lastUseStatementParts.add(items.get(items.size() - 1));
            }
            super.visit(node);
        }

        private void checkGroupUseTrailingCommas() {
            if (!this.lastUseStatementParts.isEmpty()) {
                BaseDocument document = GsfUtilities.getDocument((FileObject)this.fileObject, (boolean)true);
                if (document == null) {
                    return;
                }
                document.readLock();
                try {
                    TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)document, 0);
                    if (ts == null) {
                        return;
                    }
                    this.lastUseStatementParts.forEach(lastUseStatementPart -> {
                        if (CancelSupport.getDefault().isCancelled()) {
                            return;
                        }
                        ts.move(lastUseStatementPart.getEndOffset());
                        if (ts.moveNext()) {
                            Token<? extends PHPTokenId> token = LexUtilities.findNext((TokenSequence<? extends PHPTokenId>)ts, Arrays.asList(PHPTokenId.WHITESPACE));
                            if (token == null) {
                                return;
                            }
                            if (token.id() == PHPTokenId.PHP_TOKEN && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)",")) {
                                this.createError((ASTNode)lastUseStatementPart);
                            }
                        }
                    });
                }
                finally {
                    document.readUnlock();
                    this.lastUseStatementParts.clear();
                }
            }
        }

        private void createError(int startOffset, int endOffset) {
            this.errors.add(new PHP72VersionError(this.fileObject, startOffset, endOffset));
        }

        private void createError(ASTNode node) {
            this.createError(node.getStartOffset(), node.getEndOffset());
        }
    }
}

