/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.java.lsp.server.input.QuickPickItem;
import org.netbeans.modules.java.lsp.server.input.ShowInputBoxParams;
import org.netbeans.modules.java.lsp.server.input.ShowMutliStepInputParams;
import org.netbeans.modules.java.lsp.server.input.ShowQuickPickParams;
import org.netbeans.modules.java.lsp.server.protocol.HtmlPageParams;
import org.netbeans.modules.java.lsp.server.protocol.ShowStatusMessageParams;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Lookup;

public abstract class UIContext {
    private static Reference<UIContext> lastCtx = new WeakReference<Object>(null);

    @NonNull
    public static synchronized UIContext find(Lookup lkp) {
        UIContext ctx = (UIContext)lkp.lookup(UIContext.class);
        if (ctx != null) {
            return ctx;
        }
        Lookup def = Lookup.getDefault();
        if (lkp != def) {
            ctx = (UIContext)def.lookup(UIContext.class);
        }
        if (ctx == null && (ctx = lastCtx.get()) != null && !ctx.isValid()) {
            lastCtx.clear();
            ctx = null;
        }
        if (ctx == null) {
            ctx = LogImpl.DEFAULT;
        } else if (lastCtx.get() != ctx) {
            lastCtx = new WeakReference<UIContext>(ctx);
        }
        return ctx;
    }

    @NonNull
    public static synchronized UIContext find() {
        return UIContext.find(Lookup.getDefault());
    }

    public abstract boolean isValid();

    public abstract void showMessage(MessageParams var1);

    public CompletableFuture<String> showHtmlPage(HtmlPageParams msg) {
        this.showMessage(new MessageParams(MessageType.Log, msg.getUri()));
        return CompletableFuture.completedFuture(null);
    }

    public abstract CompletableFuture<MessageActionItem> showMessageRequest(ShowMessageRequestParams var1);

    public abstract void logMessage(MessageParams var1);

    public abstract StatusDisplayer.Message showStatusMessage(ShowStatusMessageParams var1);

    public CompletableFuture<String> showInputBox(ShowInputBoxParams params) {
        throw new AbstractMethodError();
    }

    public CompletableFuture<List<QuickPickItem>> showQuickPick(ShowQuickPickParams params) {
        throw new AbstractMethodError();
    }

    public CompletableFuture<Map<String, Either<List<QuickPickItem>, String>>> showMultiStepInput(ShowMutliStepInputParams params) {
        throw new AbstractMethodError();
    }

    private static final class LogImpl
    extends UIContext {
        static final LogImpl DEFAULT = new LogImpl();

        private LogImpl() {
        }

        @Override
        public CompletableFuture<MessageActionItem> showMessageRequest(ShowMessageRequestParams msg) {
            System.err.println(msg.getType() + ": " + msg.getMessage());
            CompletableFuture<Object> ai = CompletableFuture.completedFuture(null);
            return ai;
        }

        @Override
        public void showMessage(MessageParams msg) {
            System.err.println(msg.getType() + ": " + msg.getMessage());
        }

        @Override
        public void logMessage(MessageParams msg) {
            System.err.println(msg.getType() + ": " + msg.getMessage());
        }

        @Override
        public StatusDisplayer.Message showStatusMessage(ShowStatusMessageParams msg) {
            System.out.println(msg.getType() + ": " + msg.getMessage());
            return timeInMillis -> {};
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public CompletableFuture<String> showHtmlPage(HtmlPageParams msg) {
            System.out.println("Open in browser: " + msg.getUri());
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public CompletableFuture<String> showInputBox(ShowInputBoxParams params) {
            System.err.println("input: " + params.getPrompt());
            CompletableFuture<Object> ai = CompletableFuture.completedFuture(null);
            return ai;
        }

        @Override
        public CompletableFuture<List<QuickPickItem>> showQuickPick(ShowQuickPickParams params) {
            System.err.println("quickPick: " + params.getPlaceHolder());
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
    }
}

