/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.wizards.shortcut;

import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.wizards.shortcut.ShortcutIterator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataShadow;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class ShortcutWizard
extends WizardDescriptor {
    private static final Logger LOG = Logger.getLogger(ShortcutWizard.class.getName());
    private static final String PROP_CONTENTS = "wizdata.contents";
    static final String PROP_DISPLAY_NAME = "wizdata.displayName";
    static final String PROP_SHOW_CUST = "wizdata.show.cust";
    static final String PROP_SHOW_MENU = "wizdata.show.menu";
    static final String PROP_SHOW_TOOL = "wizdata.show.tool";
    static final String PROP_SHOW_KEYB = "wizdata.show.keyb";
    static final String PROP_FOLDER_MENU = "wizdata.folder.menu";
    static final String PROP_FOLDER_TOOL = "wizdata.folder.tool";
    static final String PROP_STROKE = "wizdata.stroke";
    private final AntProjectCookie project;
    private final Element target;
    private final ShortcutIterator it;

    public static void show(AntProjectCookie project, Element target) {
        ShortcutWizard wiz = new ShortcutWizard(project, target, new ShortcutIterator());
        DialogDisplayer.getDefault().createDialog((DialogDescriptor)wiz).setVisible(true);
        if (wiz.getValue().equals(WizardDescriptor.FINISH_OPTION)) {
            try {
                wiz.finish();
            }
            catch (IOException ioe) {
                AntModule.err.notify((Throwable)ioe);
            }
        }
    }

    public static void remove(AntProjectCookie project, Element element) {
        File file;
        FileObject build = FileUtil.getConfigFile((String)"Actions/Build");
        if (build != null && (file = project.getFile()) != null) {
            for (FileObject kid : build.getChildren()) {
                if (!ShortcutWizard.isAntScript(kid)) continue;
                try {
                    Element ael;
                    Document doc = XMLUtil.parse((InputSource)new InputSource(kid.toURL().toString()), (boolean)false, (boolean)false, null, null);
                    NodeList nl = doc.getElementsByTagName("ant");
                    if (nl.getLength() != 1 || !(ael = (Element)nl.item(0)).getAttribute("antfile").equals(file.getAbsolutePath()) || !ael.getAttribute("target").equals(element.getAttribute("name"))) continue;
                    ShortcutWizard.doRemove(kid);
                    return;
                }
                catch (Exception x) {
                    LOG.log(Level.INFO, "Failed to parse or remove " + kid, x);
                }
            }
            String message = NbBundle.getMessage(ShortcutWizard.class, (String)"MSG_delete_all_shortcuts");
            String title = NbBundle.getMessage(ShortcutWizard.class, (String)"TITLE_delete_all_shortcuts");
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)message, title, 2)).equals(NotifyDescriptor.OK_OPTION)) {
                for (FileObject kid : build.getChildren()) {
                    if (!ShortcutWizard.isAntScript(kid)) continue;
                    try {
                        ShortcutWizard.doRemove(kid);
                    }
                    catch (IOException x) {
                        LOG.log(Level.INFO, "Failed to remove " + kid, x);
                    }
                }
            }
            return;
        }
        Toolkit.getDefaultToolkit().beep();
    }

    private static boolean isAntScript(FileObject f) {
        try {
            return DataObject.find((FileObject)f).getLookup().lookup(AntProjectCookie.class) != null;
        }
        catch (DataObjectNotFoundException x) {
            return f.hasExt("xml");
        }
    }

    private static void doRemove(FileObject shortcut) throws IOException {
        for (String place : new String[]{"Menu", "Toolbars", "Shortcuts", "Keymaps"}) {
            FileObject top = FileUtil.getConfigFile((String)place);
            if (top == null) continue;
            for (FileObject f : NbCollections.iterable((Enumeration)top.getChildren(true))) {
                DataObject d;
                try {
                    d = DataObject.find((FileObject)f);
                }
                catch (DataObjectNotFoundException x) {
                    LOG.log(Level.INFO, "Loading " + f, x);
                    continue;
                }
                if (!(d instanceof DataShadow) || ((DataShadow)d).getOriginal().getPrimaryFile() != shortcut) continue;
                ShortcutWizard.delete(f);
            }
        }
        ShortcutWizard.delete(shortcut);
    }

    private static void delete(FileObject file) throws IOException {
        if (!file.canRevert()) {
            throw new IOException("Could not delete " + file);
        }
        file.revert();
    }

    ShortcutWizard(AntProjectCookie project, Element target, ShortcutIterator it) {
        this.project = project;
        this.target = target;
        this.it = it;
        it.initialize(this);
        this.setPanelsAndSettings(it, (Object)this);
        this.setTitle(NbBundle.getMessage(ShortcutWizard.class, (String)"TITLE_wizard"));
        this.putProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
        this.putProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
        this.putProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        String desc = target.getAttribute("description");
        this.putProperty(PROP_DISPLAY_NAME, desc);
    }

    String getContents() {
        String c = (String)this.getProperty(PROP_CONTENTS);
        if (c == null) {
            c = this.generateContents();
            this.putContents(c);
        }
        return c;
    }

    void putContents(String c) {
        this.putProperty(PROP_CONTENTS, c);
    }

    private String generateContents() {
        try {
            Document doc = XMLUtil.createDocument((String)"project", null, null, null);
            Element pel = doc.getDocumentElement();
            String displayName = (String)this.getProperty(PROP_DISPLAY_NAME);
            if (displayName != null && displayName.length() > 0) {
                pel.setAttribute("name", displayName);
            }
            pel.setAttribute("default", "run");
            Element tel = doc.createElement("target");
            tel.setAttribute("name", "run");
            Element ael = doc.createElement("ant");
            ael.setAttribute("antfile", this.project.getFile().getAbsolutePath());
            ael.setAttribute("inheritall", "false");
            ael.setAttribute("target", this.target.getAttribute("name"));
            tel.appendChild(ael);
            pel.appendChild(tel);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
            XMLUtil.write((Document)doc, (OutputStream)baos, (String)"UTF-8");
            return baos.toString("UTF-8");
        }
        catch (IOException e) {
            AntModule.err.notify((Throwable)e);
            return "";
        }
    }

    void finish() throws IOException {
        final FileObject actionsBuild = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)"Actions/Build");
        actionsBuild.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                String fname = FileUtil.findFreeFileName((FileObject)actionsBuild, (String)ShortcutWizard.this.getTargetBaseName(), (String)"xml") + ".xml";
                FileObject shortcut = actionsBuild.createData(fname);
                try (OutputStream os = shortcut.getOutputStream();){
                    os.write(ShortcutWizard.this.getContents().getBytes(StandardCharsets.UTF_8));
                }
                DataObject shortcutFO = DataObject.find((FileObject)shortcut);
                if (ShortcutWizard.this.it.showing(ShortcutWizard.PROP_SHOW_MENU)) {
                    ShortcutWizard.this.makeShadow((DataFolder)ShortcutWizard.this.getProperty(ShortcutWizard.PROP_FOLDER_MENU), shortcutFO);
                }
                if (ShortcutWizard.this.it.showing(ShortcutWizard.PROP_SHOW_TOOL)) {
                    ShortcutWizard.this.makeShadow((DataFolder)ShortcutWizard.this.getProperty(ShortcutWizard.PROP_FOLDER_TOOL), shortcutFO);
                }
                if (ShortcutWizard.this.it.showing(ShortcutWizard.PROP_SHOW_KEYB)) {
                    FileObject currentKeymapDir = FileUtil.getConfigFile((String)"Shortcuts");
                    String stroke = Utilities.keyToString((KeyStroke)((KeyStroke)ShortcutWizard.this.getProperty(ShortcutWizard.PROP_STROKE)));
                    DataShadow.create((DataFolder)DataFolder.findFolder((FileObject)currentKeymapDir), (String)stroke, (DataObject)shortcutFO);
                }
            }
        });
    }

    private void makeShadow(DataFolder folder, DataObject shortcutFO) throws IOException {
        DataShadow shadow = DataShadow.create((DataFolder)folder, (DataObject)shortcutFO);
        assert (shadow.getFolder() == folder);
        ArrayList<DataObject> children = new ArrayList<DataObject>(Arrays.asList(folder.getChildren()));
        if (children.remove(shadow)) {
            children.add((DataObject)shadow);
            folder.setOrder(children.toArray(new DataObject[children.size()]));
        } else {
            LOG.warning("#175981: could not find " + shadow + " among " + children);
        }
    }

    String getTargetBaseName() {
        String projname = "";
        Document doc = this.project.getDocument();
        if (doc != null) {
            projname = doc.getDocumentElement().getAttribute("name");
        }
        return (projname + '-' + this.target.getAttribute("name")).replaceAll("[^a-zA-Z0-9_-]", "-");
    }
}

