/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.api;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.j2ee.common.FileSearchUtility;
import org.netbeans.modules.j2ee.common.ProjectUtil;
import org.netbeans.modules.j2ee.common.SharabilityUtility;
import org.netbeans.modules.j2ee.common.dd.DDHelper;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.api.web.WelcomeFileList;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.ui.PlatformUiSupport;
import org.netbeans.modules.javaee.project.api.ant.DeployOnSaveUtils;
import org.netbeans.modules.javaee.project.api.ant.ui.J2EEProjectProperties;
import org.netbeans.modules.web.project.ProjectWebModule;
import org.netbeans.modules.web.project.Utils;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.api.WebProjectCreateData;
import org.netbeans.spi.java.project.support.PreferredProjectPlatform;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ProjectGenerator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WebProjectUtilities {
    public static final String SRC_STRUCT_BLUEPRINTS = "BluePrints";
    public static final String SRC_STRUCT_JAKARTA = "Jakarta";
    private static final String DEFAULT_DOC_BASE_FOLDER = "web";
    private static final String DEFAULT_SRC_FOLDER = "src";
    private static final String DEFAULT_RESOURCE_FOLDER = "setup";
    private static final String DEFAULT_JAVA_FOLDER = "java";
    private static final String DEFAULT_CONF_FOLDER = "conf";
    private static final String DEFAULT_BUILD_DIR = "build";
    private static final String DEFAULT_TEST_FOLDER = "test";
    private static final String WEB_INF = "WEB-INF";
    private static final String SOURCE_ROOT_REF = "${source.root}";
    public static final String MINIMUM_ANT_VERSION = "1.6.5";
    private static final Logger LOGGER = Logger.getLogger(WebProjectUtilities.class.getName());
    private static String RESOURCE_FOLDER = "/org/netbeans/modules/web/project/ui/resources/";

    private WebProjectUtilities() {
    }

    @Deprecated
    public static AntProjectHelper createProject(File dir, String name, String serverInstanceID, String sourceStructure, String j2eeLevel, String contextPath) throws IOException {
        WebProjectCreateData createData = new WebProjectCreateData();
        createData.setProjectDir(dir);
        createData.setName(name);
        createData.setServerInstanceID(serverInstanceID);
        createData.setSourceStructure(sourceStructure);
        createData.setJavaEEVersion(j2eeLevel);
        createData.setContextPath(contextPath);
        return WebProjectUtilities.createProject(createData);
    }

    public static AntProjectHelper createProject(final WebProjectCreateData createData) throws IOException {
        final AntProjectHelper[] h = new AntProjectHelper[1];
        File dir = createData.getProjectDir();
        assert (dir != null) : "Project folder can't be null";
        final FileObject projectDir = FileUtil.createFolder((File)dir);
        FileSystem fs = projectDir.getFileSystem();
        fs.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                AntProjectHelper helper;
                h[0] = helper = WebProjectUtilities.createProjectImpl(createData, projectDir);
            }
        });
        return h[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AntProjectHelper createProjectImpl(final WebProjectCreateData createData, FileObject projectDir) throws IOException {
        JavaPlatform jp;
        String name = createData.getName();
        String serverInstanceID = createData.getServerInstanceID();
        String sourceStructure = createData.getSourceStructure();
        Profile j2eeProfile = createData.getJavaEEProfile();
        String contextPath = createData.getContextPath();
        String javaPlatformName = createData.getJavaPlatformName();
        String sourceLevel = createData.getSourceLevel();
        assert (name != null) : "Project name can't be null";
        assert (serverInstanceID != null) : "Server instance ID can't be null";
        assert (sourceStructure != null) : "Source structure can't be null";
        assert (j2eeProfile != null) : "Java EE version can't be null";
        if (javaPlatformName == null && (jp = PreferredProjectPlatform.getPreferredPlatform((String)JavaPlatform.getDefault().getSpecification().getName())) != null) {
            javaPlatformName = jp.getDisplayName();
        }
        boolean createBluePrintsStruct = SRC_STRUCT_BLUEPRINTS.equals(sourceStructure);
        boolean createJakartaStructure = SRC_STRUCT_JAKARTA.equals(sourceStructure);
        final AntProjectHelper h = WebProjectUtilities.setupProject(projectDir, name, serverInstanceID, j2eeProfile, createData.getLibrariesDefinition(), createData.skipTests());
        FileObject srcFO = projectDir.createFolder(DEFAULT_SRC_FOLDER);
        FileObject confFolderFO = null;
        if (createBluePrintsStruct) {
            srcFO.createFolder(DEFAULT_JAVA_FOLDER);
            confFolderFO = srcFO.createFolder(DEFAULT_CONF_FOLDER);
        }
        if (createJakartaStructure) {
            confFolderFO = projectDir.createFolder(DEFAULT_CONF_FOLDER);
        }
        if (confFolderFO != null) {
            String manifestText = WebProjectUtilities.readResource(WebProjectUtilities.class.getResourceAsStream(RESOURCE_FOLDER + "MANIFEST.MF"));
            FileObject manifest = FileUtil.createData((FileObject)confFolderFO, (String)"MANIFEST.MF");
            FileLock lock = manifest.lock();
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(manifest.getOutputStream(lock), FileEncodingQuery.getEncoding((FileObject)manifest)));
            try {
                bw.write(manifestText);
            }
            finally {
                bw.close();
                lock.releaseLock();
            }
        }
        if (!createData.skipTests()) {
            FileUtil.createFolder((FileObject)projectDir, (String)DEFAULT_TEST_FOLDER);
        }
        FileObject webFO = projectDir.createFolder(DEFAULT_DOC_BASE_FOLDER);
        FileObject webInfFO = webFO.createFolder(WEB_INF);
        DDHelper.createWebXml((Profile)j2eeProfile, (boolean)createData.isWebXmlRequired(), (FileObject)webInfFO);
        if (createData.isCDIEnabled()) {
            DDHelper.createBeansXml((Profile)j2eeProfile, (FileObject)webInfFO);
        }
        EditableProperties ep = h.getProperties("nbproject/project.properties");
        Element data = h.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Element sourceRoots = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "source-roots");
        Element rootSrc = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "root");
        rootSrc.setAttribute("id", "src.dir");
        rootSrc.setAttribute("name", NbBundle.getMessage(WebProjectUtilities.class, (String)"NAME_src.dir"));
        sourceRoots.appendChild(rootSrc);
        if (createBluePrintsStruct) {
            ep.setProperty("src.dir", "src/java");
        } else {
            ep.setProperty("src.dir", DEFAULT_SRC_FOLDER);
        }
        data.appendChild(sourceRoots);
        Element testRoots = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "test-roots");
        Element rootTest = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "root");
        rootTest.setAttribute("id", "test.src.dir");
        rootTest.setAttribute("name", NbBundle.getMessage(WebProjectUtilities.class, (String)"NAME_test.src.dir"));
        testRoots.appendChild(rootTest);
        ep.setProperty("test.src.dir", DEFAULT_TEST_FOLDER);
        data.appendChild(testRoots);
        h.putPrimaryConfigurationData(data, true);
        ep.put("source.root", createBluePrintsStruct ? DEFAULT_SRC_FOLDER : ".");
        ep.setProperty("web.docbase.dir", DEFAULT_DOC_BASE_FOLDER);
        if (createBluePrintsStruct) {
            ep.setProperty("src.dir", "${source.root}/java");
            ep.setProperty("conf.dir", "${source.root}/conf");
        } else {
            ep.setProperty("src.dir", DEFAULT_SRC_FOLDER);
        }
        if (createJakartaStructure) {
            ep.setProperty("conf.dir", DEFAULT_CONF_FOLDER);
        }
        ep.setProperty("persistence.xml.dir", "${conf.dir}");
        ep.setProperty("resource.dir", DEFAULT_RESOURCE_FOLDER);
        ep.setProperty("lib.dir", "${web.docbase.dir}/WEB-INF/lib");
        ep.setProperty("webinf.dir", "web/WEB-INF");
        ep.setProperty("dist.archive.excludes", "");
        ep.setComment("dist.archive.excludes", new String[]{"# " + NbBundle.getMessage(WebProject.class, (String)"COMMENT_dist.archive.excludes")}, false);
        WebProject p = (WebProject)ProjectManager.getDefault().findProject(h.getProjectDirectory());
        UpdateHelper updateHelper = p.getUpdateHelper();
        if (sourceLevel == null) {
            sourceLevel = "1.6";
        }
        PlatformUiSupport.storePlatform((EditableProperties)ep, (UpdateHelper)updateHelper, (String)"http://www.netbeans.org/ns/web-project/3", (String)javaPlatformName, (SpecificationVersion)new SpecificationVersion(sourceLevel));
        h.putProperties("nbproject/project.properties", ep);
        ProjectManager.getDefault().saveProject((Project)p);
        final ReferenceHelper refHelper = p.getReferenceHelper();
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    WebProjectUtilities.copyRequiredLibraries(h, refHelper, createData);
                    return null;
                }
            });
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex.getException());
        }
        ProjectWebModule pwm = (ProjectWebModule)p.getLookup().lookup(ProjectWebModule.class);
        if (pwm != null) {
            pwm.setContextPath(contextPath);
        }
        ProjectUtils.getSources((Project)p).getSourceGroups(DEFAULT_JAVA_FOLDER);
        return h;
    }

    public static Set<FileObject> ensureWelcomePage(FileObject webRoot, FileObject dd) throws IOException {
        return WebProjectUtilities.ensureWelcomePage(webRoot, dd, null);
    }

    public static Set<FileObject> ensureWelcomePage(FileObject webRoot, FileObject dd, Profile profile) throws IOException {
        HashSet<FileObject> resultSet = new HashSet<FileObject>();
        if (dd == null) {
            FileObject indexFile = WebProjectUtilities.createWelcomeFile(webRoot, profile);
            if (indexFile != null) {
                resultSet.add(indexFile);
            }
            return resultSet;
        }
        try {
            FileObject indexFo;
            WebApp ddRoot = DDProvider.getDefault().getDDRoot(dd);
            WelcomeFileList welcomeFiles = ddRoot.getSingleWelcomeFileList();
            if (welcomeFiles == null) {
                welcomeFiles = (WelcomeFileList)ddRoot.createBean("WelcomeFileList");
                ddRoot.setWelcomeFileList(welcomeFiles);
            }
            if (welcomeFiles.sizeWelcomeFile() == 0 && (indexFo = WebProjectUtilities.createWelcomeFile(webRoot, profile)) != null) {
                resultSet.add(indexFo);
                welcomeFiles.addWelcomeFile(indexFo.getNameExt());
                ddRoot.write(dd);
            }
        }
        catch (ClassNotFoundException cnfe) {
            LOGGER.log(Level.SEVERE, cnfe.getLocalizedMessage(), cnfe);
        }
        return resultSet;
    }

    private static FileObject createWelcomeFile(FileObject webFolder, Profile profile) throws IOException {
        FileObject template;
        FileObject fileObject = template = profile != null && profile.isAtLeast(Profile.JAVA_EE_7_WEB) ? FileUtil.getConfigFile((String)"Templates/JSP_Servlet/Html.html") : FileUtil.getConfigFile((String)"Templates/JSP_Servlet/JSP.jsp");
        if (template == null) {
            return null;
        }
        DataObject mt = DataObject.find((FileObject)template);
        DataFolder webDf = DataFolder.findFolder((FileObject)webFolder);
        return mt.createFromTemplate(webDf, "index").getPrimaryFile();
    }

    @Deprecated
    public static AntProjectHelper importProject(File dir, String name, FileObject wmFO, FileObject javaRoot, FileObject docBase, FileObject libFolder, String j2eeLevel, String serverInstanceID, String buildfile) throws IOException {
        WebProjectCreateData createData = new WebProjectCreateData();
        createData.setProjectDir(dir);
        createData.setName(name);
        createData.setWebModuleFO(wmFO);
        createData.setSourceFolders(new File[]{FileUtil.toFile((FileObject)javaRoot)});
        createData.setTestFolders(null);
        createData.setDocBase(docBase);
        createData.setLibFolder(libFolder);
        createData.setJavaEEVersion(j2eeLevel);
        createData.setServerInstanceID(serverInstanceID);
        createData.setBuildfile(buildfile);
        return WebProjectUtilities.importProject(createData);
    }

    @Deprecated
    public static AntProjectHelper importProject(File dir, String name, FileObject wmFO, File[] sourceFolders, File[] tstFolders, FileObject docBase, FileObject libFolder, String j2eeLevel, String serverInstanceID, String buildfile) throws IOException {
        WebProjectCreateData createData = new WebProjectCreateData();
        createData.setProjectDir(dir);
        createData.setName(name);
        createData.setWebModuleFO(wmFO);
        createData.setSourceFolders(sourceFolders);
        createData.setTestFolders(tstFolders);
        createData.setDocBase(docBase);
        createData.setLibFolder(libFolder);
        createData.setJavaEEVersion(j2eeLevel);
        createData.setServerInstanceID(serverInstanceID);
        createData.setBuildfile(buildfile);
        return WebProjectUtilities.importProject(createData);
    }

    public static AntProjectHelper importProject(final WebProjectCreateData createData) throws IOException {
        final AntProjectHelper[] h = new AntProjectHelper[1];
        File dir = createData.getProjectDir();
        assert (dir != null) : "Project folder can't be null";
        final FileObject projectDir = FileUtil.createFolder((File)dir);
        FileSystem fs = projectDir.getFileSystem();
        fs.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                AntProjectHelper helper;
                h[0] = helper = WebProjectUtilities.importProjectImpl(createData, projectDir);
            }
        });
        return h[0];
    }

    private static AntProjectHelper importProjectImpl(final WebProjectCreateData createData, FileObject projectDir) throws IOException {
        int i;
        String name = createData.getName();
        FileObject wmFO = createData.getWebModuleFO();
        final File[] sourceFolders = createData.getSourceFolders();
        File[] tstFolders = createData.getTestFolders();
        FileObject docBase = createData.getDocBase();
        FileObject libFolder = createData.getLibFolder();
        Profile j2eeProfile = createData.getJavaEEProfile();
        String serverInstanceID = createData.getServerInstanceID();
        String buildfile = createData.getBuildfile();
        String javaPlatformName = createData.getJavaPlatformName();
        String sourceLevel = createData.getSourceLevel();
        boolean javaSourceBased = createData.getJavaSourceBased();
        FileObject webInfFolder = createData.getWebInfFolder();
        assert (name != null) : "Project name can't be null";
        assert (wmFO != null) : "File object representation of the imported web project location can't be null";
        assert (sourceFolders != null) : "Source package root can't be null";
        assert (docBase != null) : "Web Pages folder can't be null";
        assert (serverInstanceID != null) : "Server instance ID can't be null";
        assert (j2eeProfile != null) : "Java EE version can't be null";
        final AntProjectHelper antProjectHelper = WebProjectUtilities.setupProject(projectDir, name, serverInstanceID, j2eeProfile, createData.getLibrariesDefinition(), createData.skipTests());
        final WebProject p = (WebProject)ProjectManager.getDefault().findProject(antProjectHelper.getProjectDirectory());
        final ReferenceHelper referenceHelper = p.getReferenceHelper();
        EditableProperties ep = new EditableProperties(true);
        if (FileUtil.isParentOf((FileObject)projectDir, (FileObject)wmFO) || projectDir.equals(wmFO)) {
            ep.setProperty("source.root", ".");
        } else {
            ep.setProperty("source.root", referenceHelper.createForeignFileReference(FileUtil.toFile((FileObject)wmFO), null));
        }
        ep.setProperty("web.docbase.dir", WebProjectUtilities.createFileReference(referenceHelper, projectDir, wmFO, docBase));
        final File[] testFolders = tstFolders;
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    EditableProperties props;
                    int i;
                    Element data = antProjectHelper.getPrimaryConfigurationData(true);
                    Document doc = data.getOwnerDocument();
                    Element sourceRoots = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "source-roots");
                    data.appendChild(sourceRoots);
                    Element testRoots = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "test-roots");
                    data.appendChild(testRoots);
                    NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "source-roots");
                    assert (nl.getLength() == 1);
                    sourceRoots = (Element)nl.item(0);
                    nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "test-roots");
                    assert (nl.getLength() == 1);
                    testRoots = (Element)nl.item(0);
                    for (i = 0; i < sourceFolders.length; ++i) {
                        String propName = "src.dir" + (i == 0 ? "" : Integer.toString(i + 1));
                        String srcReference = referenceHelper.createForeignFileReference(sourceFolders[i], WebProjectUtilities.DEFAULT_JAVA_FOLDER);
                        Element root = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "root");
                        root.setAttribute("id", propName);
                        root.setAttribute("name", NbBundle.getMessage(WebProjectUtilities.class, (String)"NAME_src.dir"));
                        sourceRoots.appendChild(root);
                        props = antProjectHelper.getProperties("nbproject/project.properties");
                        props.put(propName, srcReference);
                        antProjectHelper.putProperties("nbproject/project.properties", props);
                    }
                    if (testFolders == null || testFolders.length == 0) {
                        EditableProperties props2 = antProjectHelper.getProperties("nbproject/project.properties");
                        props2.put("test.src.dir", "");
                        antProjectHelper.putProperties("nbproject/project.properties", props2);
                    } else {
                        for (i = 0; i < testFolders.length; ++i) {
                            if (!testFolders[i].exists()) {
                                FileUtil.createFolder((File)testFolders[i]);
                            }
                            String name = testFolders[i].getName();
                            String propName = "test." + name + ".dir";
                            int rootIndex = 1;
                            props = antProjectHelper.getProperties("nbproject/project.properties");
                            while (props.containsKey((Object)propName)) {
                                propName = "test." + name + ++rootIndex + ".dir";
                            }
                            String testReference = referenceHelper.createForeignFileReference(testFolders[i], WebProjectUtilities.DEFAULT_JAVA_FOLDER);
                            Element root = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "root");
                            root.setAttribute("id", propName);
                            root.setAttribute("name", NbBundle.getMessage(WebProjectUtilities.class, (String)"NAME_test.src.dir"));
                            testRoots.appendChild(root);
                            props = antProjectHelper.getProperties("nbproject/project.properties");
                            props.put(propName, testReference);
                            antProjectHelper.putProperties("nbproject/project.properties", props);
                        }
                    }
                    antProjectHelper.putPrimaryConfigurationData(data, true);
                    ProjectManager.getDefault().saveProject((Project)p);
                    WebProjectUtilities.copyRequiredLibraries(antProjectHelper, referenceHelper, createData);
                    return null;
                }
            });
        }
        catch (MutexException me) {
            throw new IOException("project creation failed", me);
        }
        if (libFolder != null) {
            ep.setProperty("lib.dir", WebProjectUtilities.createFileReference(referenceHelper, projectDir, wmFO, libFolder));
            if (libFolder.isFolder()) {
                FileObject[] children = libFolder.getChildren();
                LinkedList<URL> libs = new LinkedList<URL>();
                for (i = 0; i < children.length; ++i) {
                    if (!FileUtil.isArchiveFile((FileObject)children[i])) continue;
                    libs.add(URLMapper.findURL((FileObject)FileUtil.getArchiveRoot((FileObject)children[i]), (int)1));
                }
                p.getClassPathModifier().getClassPathModifier().addRoots(libs.toArray(new URL[libs.size()]), "javac.classpath");
            }
        }
        if (!"build.xml".equals(buildfile)) {
            ep.setProperty("buildfile", buildfile);
        }
        Enumeration ch = FileSearchUtility.getChildrenToDepth((FileObject)projectDir, (int)4, (boolean)true);
        String confDir = "";
        while (ch.hasMoreElements()) {
            FileObject f = (FileObject)ch.nextElement();
            if (!f.isFolder() || !f.getName().equalsIgnoreCase(DEFAULT_CONF_FOLDER)) continue;
            confDir = FileUtil.getRelativePath((FileObject)projectDir, (FileObject)f);
            break;
        }
        if (confDir.equals("")) {
            projectDir.createFolder(DEFAULT_CONF_FOLDER);
            ep.setProperty("conf.dir", DEFAULT_CONF_FOLDER);
        } else {
            ep.setProperty("conf.dir", confDir);
        }
        ep.setProperty("persistence.xml.dir", "${conf.dir}");
        for (i = 0; i < sourceFolders.length; ++i) {
            if (!new File(sourceFolders[i], "META-INF" + File.separatorChar + "persistence.xml").exists()) continue;
            ep.setProperty("persistence.xml.dir", "${src.dir}" + (i == 0 ? "" : Integer.toString(i + 1)) + "/META-INF");
            break;
        }
        ep.setProperty("resource.dir", DEFAULT_RESOURCE_FOLDER);
        String webInfDir = webInfFolder != null ? WebProjectUtilities.createFileReference(referenceHelper, projectDir, wmFO, webInfFolder) : "web/WEB-INF";
        ep.setProperty("webinf.dir", webInfDir);
        ep.setProperty("java.source.based", javaSourceBased + "");
        UpdateHelper updateHelper = p.getUpdateHelper();
        PlatformUiSupport.storePlatform((EditableProperties)ep, (UpdateHelper)updateHelper, (String)"http://www.netbeans.org/ns/web-project/3", (String)javaPlatformName, (SpecificationVersion)(sourceLevel != null ? new SpecificationVersion(sourceLevel) : null));
        Utils.updateProperties(antProjectHelper, "nbproject/project.properties", ep);
        ProjectManager.getDefault().saveProject((Project)p);
        return antProjectHelper;
    }

    private static void copyRequiredLibraries(AntProjectHelper h, ReferenceHelper rh, WebProjectCreateData data) throws IOException {
        if (!h.isSharableProject()) {
            return;
        }
        if (!data.skipTests() && rh.getProjectLibraryManager().getLibrary("junit") == null && LibraryManager.getDefault().getLibrary("junit") != null) {
            rh.copyLibrary(LibraryManager.getDefault().getLibrary("junit"));
        }
        if (!data.skipTests() && rh.getProjectLibraryManager().getLibrary("junit_4") == null && LibraryManager.getDefault().getLibrary("junit_4") != null) {
            rh.copyLibrary(LibraryManager.getDefault().getLibrary("junit_4"));
        }
        Profile j2eeProfile = data.getJavaEEProfile();
        String libraryName = null;
        if (j2eeProfile.equals(Profile.JAVA_EE_6_FULL) || j2eeProfile.equals(Profile.JAVA_EE_6_WEB)) {
            libraryName = "javaee-endorsed-api-6.0";
        }
        if (j2eeProfile.equals(Profile.JAVA_EE_7_FULL) || j2eeProfile.equals(Profile.JAVA_EE_7_WEB)) {
            libraryName = "javaee-endorsed-api-7.0";
        }
        if (libraryName != null && rh.getProjectLibraryManager().getLibrary(libraryName) == null) {
            Library library = LibraryManager.getDefault().getLibrary(libraryName);
            if (library != null) {
                rh.copyLibrary(library);
            } else {
                LOGGER.log(Level.INFO, "Library not found for {0}", libraryName);
            }
        }
        SharabilityUtility.makeSureProjectHasCopyLibsLibrary((AntProjectHelper)h, (ReferenceHelper)rh);
    }

    private static String createFileReference(ReferenceHelper refHelper, FileObject projectFO, FileObject sourceprojectFO, FileObject referencedFO) {
        if (FileUtil.isParentOf((FileObject)projectFO, (FileObject)referencedFO)) {
            return WebProjectUtilities.relativePath(projectFO, referencedFO);
        }
        if (FileUtil.isParentOf((FileObject)sourceprojectFO, (FileObject)referencedFO)) {
            String s = WebProjectUtilities.relativePath(sourceprojectFO, referencedFO);
            return s.length() > 0 ? "${source.root}/" + s : SOURCE_ROOT_REF;
        }
        return refHelper.createForeignFileReference(FileUtil.toFile((FileObject)referencedFO), null);
    }

    private static String relativePath(FileObject parent, FileObject child) {
        if (child.equals(parent)) {
            return "";
        }
        if (!FileUtil.isParentOf((FileObject)parent, (FileObject)child)) {
            throw new IllegalArgumentException("Cannot find relative path, " + parent + " is not parent of " + child);
        }
        return child.getPath().substring(parent.getPath().length() + 1);
    }

    private static AntProjectHelper setupProject(FileObject dirFO, String name, String serverInstanceID, Profile j2eeProfile, String librariesDefinition, boolean skipTests) throws IOException {
        String[] stringArray;
        Utils.logUI(NbBundle.getBundle(WebProjectUtilities.class), "UI_WEB_PROJECT_CREATE_SHARABILITY", new Object[]{librariesDefinition != null, Boolean.FALSE});
        AntProjectHelper h = ProjectGenerator.createProject((FileObject)dirFO, (String)"org.netbeans.modules.web.project", (String)librariesDefinition);
        Element data = h.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Element nameEl = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "name");
        nameEl.appendChild(doc.createTextNode(name));
        data.appendChild(nameEl);
        Element minant = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "minimum-ant-version");
        minant.appendChild(doc.createTextNode(MINIMUM_ANT_VERSION));
        data.appendChild(minant);
        Element wmLibs = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "web-module-libraries");
        data.appendChild(wmLibs);
        Element addLibs = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "web-module-additional-libraries");
        data.appendChild(addLibs);
        h.putPrimaryConfigurationData(data, true);
        EditableProperties ep = h.getProperties("nbproject/project.properties");
        EditableProperties epPriv = h.getProperties("nbproject/private/private.properties");
        ep.setProperty("annotation.processing.enabled", "true");
        ep.setProperty("annotation.processing.enabled.in.editor", "true");
        ep.setProperty("annotation.processing.run.all.processors", "true");
        ep.setProperty("annotation.processing.processors.list", "");
        ep.setProperty("annotation.processing.source.output", "${build.generated.sources.dir}/ap-source-output");
        ep.setProperty("dist.dir", "dist");
        ep.setProperty("dist.war", "${dist.dir}/${war.name}");
        ep.setProperty("dist.ear.war", "${dist.dir}/${war.ear.name}");
        ep.setProperty("javac.classpath", "");
        J2EEProjectProperties.setServerProperties((EditableProperties)ep, (EditableProperties)epPriv, null, null, (String)serverInstanceID, (Profile)j2eeProfile, (J2eeModule.Type)J2eeModule.Type.WAR);
        ep.setProperty("javac.processorpath", new String[]{"${javac.classpath}"});
        ep.setProperty("javac.test.processorpath", new String[]{"${javac.test.classpath}"});
        ep.setProperty("j2ee.platform", j2eeProfile.toPropertiesString());
        ep.setProperty("war.name", PropertyUtils.getUsablePropertyName((String)name) + ".war");
        ep.setProperty("war.ear.name", "${war.name}");
        ep.setProperty("jar.compress", "false");
        ep.setProperty("war.content.additional", "");
        ep.setProperty("client.urlPart", "");
        ep.setProperty("display.browser", "true");
        ep.setProperty("j2ee.compile.on.save", "true");
        ep.setProperty("j2ee.deploy.on.save", DeployOnSaveUtils.isDeployOnSaveSupported((String)serverInstanceID));
        ep.setProperty("javac.debug", "true");
        ep.setProperty("javac.deprecation", "false");
        ep.setProperty("javac.compilerargs", "");
        ep.setComment("javac.compilerargs", new String[]{"# " + NbBundle.getMessage(WebProjectUtilities.class, (String)"COMMENT_javac.compilerargs")}, false);
        if (skipTests) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "${javac.classpath}:";
            stringArray = stringArray2;
            stringArray2[1] = "${build.classes.dir}";
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = "${javac.classpath}:";
            stringArray3[1] = "${build.classes.dir}:";
            stringArray3[2] = "${libs.junit.classpath}:";
            stringArray = stringArray3;
            stringArray3[3] = "${libs.junit_4.classpath}";
        }
        ep.setProperty("javac.test.classpath", stringArray);
        ep.setProperty("run.test.classpath", new String[]{"${javac.test.classpath}:", "${build.test.classes.dir}"});
        ep.setProperty("debug.test.classpath", new String[]{"${run.test.classpath}"});
        ep.setProperty("build.dir", DEFAULT_BUILD_DIR);
        ep.setProperty("build.test.classes.dir", "${build.dir}/test/classes");
        ep.setProperty("build.test.results.dir", "${build.dir}/test/results");
        ep.setProperty("build.web.dir", "${build.dir}/web");
        ep.setProperty("build.generated.dir", "${build.dir}/generated");
        ep.setProperty("build.classes.dir", "${build.web.dir}/WEB-INF/classes");
        ep.setProperty("build.generated.sources.dir", "${build.dir}/generated-sources");
        ep.setProperty("build.classes.excludes", "**/*.java,**/*.form");
        ep.setProperty("build.web.excludes", "${build.classes.excludes}");
        ep.setProperty("dist.javadoc.dir", "${dist.dir}/javadoc");
        ep.setProperty("no.dependencies", "false");
        ep.setProperty("platform.active", "default_platform");
        ep.setProperty("debug.classpath", Utils.getDefaultDebugClassPath());
        ep.setProperty("runmain.jvmargs", "");
        ep.setComment("runmain.jvmargs", new String[]{"# " + NbBundle.getMessage(WebProjectUtilities.class, (String)"COMMENT_runmain.jvmargs"), "# " + NbBundle.getMessage(WebProjectUtilities.class, (String)"COMMENT_runmain.jvmargs_2")}, false);
        ep.setProperty("javadoc.private", "false");
        ep.setProperty("javadoc.notree", "false");
        ep.setProperty("javadoc.use", "true");
        ep.setProperty("javadoc.nonavbar", "false");
        ep.setProperty("javadoc.noindex", "false");
        ep.setProperty("javadoc.splitindex", "true");
        ep.setProperty("javadoc.author", "false");
        ep.setProperty("javadoc.version", "false");
        ep.setProperty("javadoc.windowtitle", "");
        ep.setProperty("javadoc.encoding", "${source.encoding}");
        ep.setProperty("javadoc.preview", "true");
        ep.setProperty("javadoc.additionalparam", "");
        ep.setProperty("compile.jsps", "false");
        Charset enc = FileEncodingQuery.getDefaultEncoding();
        ep.setProperty("source.encoding", enc.name());
        if (j2eeProfile.equals(Profile.JAVA_EE_6_FULL) || j2eeProfile.equals(Profile.JAVA_EE_6_WEB)) {
            ep.setProperty("endorsed.classpath", new String[]{"${libs.javaee-endorsed-api-6.0.classpath}"});
        }
        if (j2eeProfile.equals(Profile.JAVA_EE_7_FULL) || j2eeProfile.equals(Profile.JAVA_EE_7_WEB)) {
            ep.setProperty("endorsed.classpath", new String[]{"${libs.javaee-endorsed-api-7.0.classpath}"});
        }
        J2EEProjectProperties.createDeploymentScript((FileObject)dirFO, (EditableProperties)ep, (EditableProperties)epPriv, (String)serverInstanceID, (J2eeModule.Type)J2eeModule.Type.WAR);
        h.putProperties("nbproject/project.properties", ep);
        h.putProperties("nbproject/private/private.properties", epPriv);
        return h;
    }

    public static void upgradeJ2EEProfile(WebProject project) {
        if (Profile.JAVA_EE_6_WEB.equals(project.getAPIEjbJar().getJ2eeProfile()) || Profile.JAVA_EE_7_WEB.equals(project.getAPIEjbJar().getJ2eeProfile())) {
            Boolean isFullRequired = Boolean.FALSE;
            try {
                isFullRequired = (Boolean)project.getAPIEjbJar().getMetadataModel().runReadActionWhenReady((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, Boolean>(){

                    public Boolean run(EjbJarMetadata metadata) {
                        EnterpriseBeans enterpriseBeans;
                        EjbJar ejbJar = metadata.getRoot();
                        if (ejbJar != null && (enterpriseBeans = ejbJar.getEnterpriseBeans()) != null) {
                            if (enterpriseBeans.getMessageDriven().length > 0 || enterpriseBeans.getEntity().length > 0) {
                                return Boolean.TRUE;
                            }
                            for (Session session : enterpriseBeans.getSession()) {
                                if (session.getRemote() == null) continue;
                                return Boolean.TRUE;
                            }
                        }
                        return Boolean.FALSE;
                    }
                }).get();
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            if (isFullRequired.booleanValue()) {
                boolean ee7 = false;
                if (Profile.JAVA_EE_7_WEB.equals(project.getAPIEjbJar().getJ2eeProfile())) {
                    ee7 = true;
                }
                if (ee7 && ProjectUtil.getSupportedProfiles((Project)project).contains(Profile.JAVA_EE_7_FULL) || !ee7 && ProjectUtil.getSupportedProfiles((Project)project).contains(Profile.JAVA_EE_6_FULL)) {
                    UpdateHelper helper = project.getUpdateHelper();
                    EditableProperties projectProps = helper.getProperties("nbproject/project.properties");
                    projectProps.setProperty("j2ee.platform", ee7 ? Profile.JAVA_EE_7_FULL.toPropertiesString() : Profile.JAVA_EE_6_FULL.toPropertiesString());
                    helper.putProperties("nbproject/project.properties", projectProps);
                    try {
                        ProjectManager.getDefault().saveProject((Project)project);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (IllegalArgumentException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readResource(InputStream is) throws IOException {
        StringBuilder sb = new StringBuilder();
        String lineSep = System.getProperty("line.separator");
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                sb.append(lineSep);
                line = br.readLine();
            }
        }
        return sb.toString();
    }
}

