/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.apisupport;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.spi.PlatformJarProvider;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.apisupport.Bundle;
import org.netbeans.modules.maven.apisupport.MavenNbModuleImpl;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;

public class MavenPlatformJarProvider
implements PlatformJarProvider {
    private final Project project;

    public MavenPlatformJarProvider(Project project) {
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<File> getPlatformJars() throws IOException {
        NbMavenProject app;
        NbMavenProject nbmp = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        if (nbmp == null) {
            return Collections.emptySet();
        }
        assert (!EventQueue.isDispatchThread()) : "should not be called from EQ";
        if (nbmp.getPackagingType().equals("nbm")) {
            Project parent = MavenNbModuleImpl.findAppProject(this.project);
            NbMavenProject nbMavenProject = app = parent != null ? (NbMavenProject)parent.getLookup().lookup(NbMavenProject.class) : null;
            if (app == null) {
                File ide = MavenNbModuleImpl.findIDEInstallation(this.project);
                return ide != null ? this.allModulesIn(ide) : Collections.emptySet();
            }
        } else {
            app = nbmp;
        }
        MavenEmbedder online = EmbedderFactory.getOnlineEmbedder();
        MavenProject mp = app.getMavenProject();
        ArrayList<Artifact> arts = new ArrayList<Artifact>();
        for (Artifact dep : mp.getArtifacts()) {
            String type = dep.getType();
            if ("jar".equals(type)) {
                if (dep.isSnapshot()) continue;
                arts.add(dep);
                continue;
            }
            if (!"nbm-file".equals(type)) continue;
            arts.add(online.createArtifact(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), "jar"));
        }
        try {
            this.download(arts, online, mp.getRemoteArtifactRepositories());
        }
        finally {
            LinkedHashSet<File> jars = new LinkedHashSet<File>();
            for (Artifact art : arts) {
                if (art.getFile() == null || !art.getFile().exists()) continue;
                jars.add(FileUtil.normalizeFile((File)art.getFile()));
            }
            return jars;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(List<Artifact> arts, MavenEmbedder online, List<ArtifactRepository> remoteRepos) throws IOException {
        ArrayList<Artifact> toDownload = new ArrayList<Artifact>();
        for (Artifact art : arts) {
            File jar = art.getFile();
            if (jar != null && jar.exists()) continue;
            toDownload.add(art);
        }
        if (!toDownload.isEmpty()) {
            int cnt = 0;
            final AtomicBoolean canceled = new AtomicBoolean();
            ProgressHandle h = ProgressHandleFactory.createHandle((String)Bundle.MavenPlatformJarProvider_downloading(), (Cancellable)new Cancellable(){

                public boolean cancel() {
                    canceled.set(true);
                    return true;
                }
            });
            h.start(toDownload.size());
            try {
                for (Artifact art : toDownload) {
                    if (canceled.get()) {
                        throw new IOException("download canceled");
                    }
                    try {
                        online.resolve(art, remoteRepos, online.getLocalRepository());
                    }
                    catch (ThreadDeath threadDeath) {
                    }
                    catch (IllegalStateException ise) {
                        if (!(ise.getCause() instanceof ThreadDeath)) {
                            throw ise;
                        }
                    }
                    catch (AbstractArtifactResolutionException x) {
                        throw new IOException(x);
                    }
                    File jar = art.getFile();
                    if (jar == null || !jar.exists()) {
                        throw new IOException("failed to download " + art);
                    }
                    h.progress(art.toString(), ++cnt);
                }
            }
            finally {
                h.finish();
            }
        }
    }

    private Set<File> allModulesIn(File ide) {
        HashSet<File> jars = new HashSet<File>();
        File[] clusters = ide.listFiles();
        if (clusters != null) {
            for (File cluster : clusters) {
                File[] modules = new File(cluster, "modules").listFiles();
                if (modules == null) continue;
                for (File module : modules) {
                    if (!module.getName().endsWith(".jar")) continue;
                    jars.add(module);
                }
            }
        }
        return jars;
    }
}

