/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import org.openide.util.Utilities;

public class DialogBoundsPreserver
implements WindowListener {
    private static final String DELIMITER = "#";
    private Preferences preferences;
    private String key;

    public DialogBoundsPreserver(Preferences preferences, String key) {
        this.preferences = preferences;
        this.key = key;
    }

    @Override
    public void windowOpened(WindowEvent evt) {
        Rectangle r = this.getDialogBounds();
        if (r != null && this.checkBounds(r)) {
            evt.getWindow().setBounds(r);
        }
    }

    @Override
    public void windowClosing(WindowEvent evt) {
    }

    @Override
    public void windowClosed(WindowEvent evt) {
        Rectangle r = evt.getWindow().getBounds();
        if (this.checkBounds(r)) {
            this.setDialogBounds(r);
        }
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    private boolean checkBounds(Rectangle r) {
        Rectangle[] screens;
        for (Rectangle screen : screens = this.getScreenBounds()) {
            if (!(r.getX() >= screen.getX()) || !(r.getY() >= screen.getY()) || !(r.getX() + r.getWidth() < screen.getX() + screen.getWidth()) || !(r.getY() + r.getHeight() < screen.getY() + screen.getHeight())) continue;
            return true;
        }
        return false;
    }

    private void setDialogBounds(Rectangle r) {
        this.preferences.put(this.key, r.getX() + DELIMITER + r.getY() + DELIMITER + r.getWidth() + DELIMITER + r.getHeight());
    }

    private Rectangle getDialogBounds() {
        String size = this.preferences.get(this.key, DELIMITER);
        if (size != null) {
            String[] dim = size.split(DELIMITER);
            if (dim.length != 4 || dim[0].trim().equals("") || dim[1].trim().equals("") || dim[2].trim().equals("") || dim[3].trim().equals("")) {
                return null;
            }
            Rectangle r = new Rectangle();
            r.setRect(Double.parseDouble(dim[0]), Double.parseDouble(dim[1]), Double.parseDouble(dim[2]), Double.parseDouble(dim[3]));
            return r;
        }
        return null;
    }

    private Rectangle[] getScreenBounds() {
        GraphicsDevice[] gds = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        ArrayList<Rectangle> rects = new ArrayList<Rectangle>(gds.length);
        for (GraphicsDevice gd : gds) {
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            rects.add(Utilities.getUsableScreenBounds((GraphicsConfiguration)gc));
        }
        return rects.toArray(new Rectangle[rects.size()]);
    }
}

