/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.devops.model.FileDiffResponse;
import com.oracle.bmc.devops.requests.GetFileDiffRequest;
import com.oracle.bmc.devops.responses.GetFileDiffResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetFileDiffConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetFileDiffConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetFileDiffRequest interceptRequest(GetFileDiffRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetFileDiffRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getFilePath(), (String)"filePath must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getBaseVersion(), (String)"baseVersion is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getTargetVersion(), (String)"targetVersion is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20210630").path("repositories").path(HttpUtils.encodePathSegment((String)request.getRepositoryId())).path("diffs").path(HttpUtils.encodePathSegment((String)request.getFilePath()));
        target = target.queryParam("baseVersion", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getBaseVersion())});
        target = target.queryParam("targetVersion", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTargetVersion())});
        if (request.getIsComparisonFromMergeBase() != null) {
            target = target.queryParam("isComparisonFromMergeBase", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getIsComparisonFromMergeBase())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, GetFileDiffResponse> fromResponse() {
        Function<Response, GetFileDiffResponse> transformer = new Function<Response, GetFileDiffResponse>(){

            public GetFileDiffResponse apply(Response rawResponse) {
                Optional sunsetHeader;
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.devops.responses.GetFileDiffResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(FileDiffResponse.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetFileDiffResponse.Builder builder = GetFileDiffResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.fileDiffResponse((FileDiffResponse)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((sunsetHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"Sunset")).isPresent()) {
                    builder.sunset((String)HeaderUtils.toValue((String)"Sunset", (String)((String)((List)sunsetHeader.get()).get(0)), String.class));
                }
                GetFileDiffResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

