/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.devops.model.RepositoryCommitCollection;
import com.oracle.bmc.devops.requests.ListCommitsRequest;
import com.oracle.bmc.devops.responses.ListCommitsResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListCommitsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListCommitsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListCommitsRequest interceptRequest(ListCommitsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListCommitsRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20210630").path("repositories").path(HttpUtils.encodePathSegment((String)request.getRepositoryId())).path("commits");
        if (request.getRefName() != null) {
            target = target.queryParam("refName", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getRefName())});
        }
        if (request.getExcludeRefName() != null) {
            target = target.queryParam("excludeRefName", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getExcludeRefName())});
        }
        if (request.getFilePath() != null) {
            target = target.queryParam("filePath", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getFilePath())});
        }
        if (request.getTimestampGreaterThanOrEqualTo() != null) {
            target = target.queryParam("timestampGreaterThanOrEqualTo", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimestampGreaterThanOrEqualTo())});
        }
        if (request.getTimestampLessThanOrEqualTo() != null) {
            target = target.queryParam("timestampLessThanOrEqualTo", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimestampLessThanOrEqualTo())});
        }
        if (request.getCommitMessage() != null) {
            target = target.queryParam("commitMessage", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCommitMessage())});
        }
        if (request.getAuthorName() != null) {
            target = target.queryParam("authorName", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getAuthorName())});
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, ListCommitsResponse> fromResponse() {
        Function<Response, ListCommitsResponse> transformer = new Function<Response, ListCommitsResponse>(){

            public ListCommitsResponse apply(Response rawResponse) {
                Optional opcNextPageHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.devops.responses.ListCommitsResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(RepositoryCommitCollection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListCommitsResponse.Builder builder = ListCommitsResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.repositoryCommitCollection((RepositoryCommitCollection)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page")).isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                ListCommitsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

