/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class GetMirrorRecordRequest
extends BmcRequest<Void> {
    private String repositoryId;
    private MirrorRecordType mirrorRecordType;
    private String opcRequestId;

    @ConstructorProperties(value={"repositoryId", "mirrorRecordType", "opcRequestId"})
    GetMirrorRecordRequest(String repositoryId, MirrorRecordType mirrorRecordType, String opcRequestId) {
        this.repositoryId = repositoryId;
        this.mirrorRecordType = mirrorRecordType;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().repositoryId(this.repositoryId).mirrorRecordType(this.mirrorRecordType).opcRequestId(this.opcRequestId);
    }

    public String toString() {
        return "GetMirrorRecordRequest(super=" + super.toString() + ", repositoryId=" + this.getRepositoryId() + ", mirrorRecordType=" + (Object)((Object)this.getMirrorRecordType()) + ", opcRequestId=" + this.getOpcRequestId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetMirrorRecordRequest)) {
            return false;
        }
        GetMirrorRecordRequest other = (GetMirrorRecordRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$repositoryId = this.getRepositoryId();
        String other$repositoryId = other.getRepositoryId();
        if (this$repositoryId == null ? other$repositoryId != null : !this$repositoryId.equals(other$repositoryId)) {
            return false;
        }
        MirrorRecordType this$mirrorRecordType = this.getMirrorRecordType();
        MirrorRecordType other$mirrorRecordType = other.getMirrorRecordType();
        if (this$mirrorRecordType == null ? other$mirrorRecordType != null : !((Object)((Object)this$mirrorRecordType)).equals((Object)other$mirrorRecordType)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        return !(this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetMirrorRecordRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $repositoryId = this.getRepositoryId();
        result = result * 59 + ($repositoryId == null ? 43 : $repositoryId.hashCode());
        MirrorRecordType $mirrorRecordType = this.getMirrorRecordType();
        result = result * 59 + ($mirrorRecordType == null ? 43 : ((Object)((Object)$mirrorRecordType)).hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        return result;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public MirrorRecordType getMirrorRecordType() {
        return this.mirrorRecordType;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetMirrorRecordRequest, Void> {
        private String repositoryId;
        private MirrorRecordType mirrorRecordType;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetMirrorRecordRequest o) {
            this.repositoryId(o.getRepositoryId());
            this.mirrorRecordType(o.getMirrorRecordType());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetMirrorRecordRequest build() {
            GetMirrorRecordRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            return this;
        }

        public Builder mirrorRecordType(MirrorRecordType mirrorRecordType) {
            this.mirrorRecordType = mirrorRecordType;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetMirrorRecordRequest buildWithoutInvocationCallback() {
            return new GetMirrorRecordRequest(this.repositoryId, this.mirrorRecordType, this.opcRequestId);
        }

        public String toString() {
            return "GetMirrorRecordRequest.Builder(repositoryId=" + this.repositoryId + ", mirrorRecordType=" + (Object)((Object)this.mirrorRecordType) + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum MirrorRecordType {
        Current("current"),
        LastSuccessful("lastSuccessful");

        private final String value;
        private static Map<String, MirrorRecordType> map;

        private MirrorRecordType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static MirrorRecordType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid MirrorRecordType: " + key);
        }

        static {
            map = new HashMap<String, MirrorRecordType>();
            for (MirrorRecordType v : MirrorRecordType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

