/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.nette.tester.ui.customizer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.nette.tester.preferences.TesterPreferences;
import org.netbeans.modules.php.nette.tester.preferences.TesterPreferencesValidator;
import org.netbeans.modules.php.nette.tester.ui.customizer.Bundle;
import org.netbeans.modules.php.nette.tester.util.TesterUtils;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomizerTester
extends JPanel
implements HelpCtx.Provider {
    private final ProjectCustomizer.Category category;
    private final PhpModule phpModule;
    private JCheckBox binaryExecutableCheckBox;
    private JComboBox<String> binaryExecutableComboBox;
    private JLabel binaryExecutableLabel;
    private JButton coverageSrcBrowseButton;
    private JCheckBox coverageSrcCheckBox;
    private JLabel coverageSrcLabel;
    private JTextField coverageSrcTextField;
    private JLabel infoLabel;
    private JLabel noteLabel;
    private JButton phpIniBrowseButton;
    private JCheckBox phpIniCheckBox;
    private JLabel phpIniLabel;
    private JTextField phpIniTextField;
    private JButton testerBrowseButton;
    private JCheckBox testerCheckBox;
    private JLabel testerLabel;
    private JTextField testerTextField;

    public CustomizerTester(ProjectCustomizer.Category category, PhpModule phpModule) {
        assert (category != null);
        assert (phpModule != null);
        this.category = category;
        this.phpModule = phpModule;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.initFile(TesterPreferences.isPhpIniEnabled(this.phpModule), TesterPreferences.getPhpIniPath(this.phpModule), this.phpIniCheckBox, this.phpIniTextField);
        this.initFile(TesterPreferences.isTesterEnabled(this.phpModule), TesterPreferences.getTesterPath(this.phpModule), this.testerCheckBox, this.testerTextField);
        this.initBinaryExecutable();
        this.initFile(TesterPreferences.isCoverageSourcePathEnabled(this.phpModule), TesterPreferences.getCoverageSourcePath(this.phpModule), this.coverageSrcCheckBox, this.coverageSrcTextField);
        this.enableComponents(this.phpIniCheckBox.isSelected(), this.phpIniLabel, this.phpIniTextField, this.phpIniBrowseButton);
        this.enableComponents(this.testerCheckBox.isSelected(), this.testerLabel, this.testerTextField, this.testerBrowseButton);
        this.enableComponents(this.binaryExecutableCheckBox.isSelected(), this.binaryExecutableLabel, this.binaryExecutableComboBox);
        this.enableComponents(this.coverageSrcCheckBox.isSelected(), this.coverageSrcLabel, this.coverageSrcTextField, this.coverageSrcBrowseButton);
        this.addListeners();
        this.validateData();
        this.category.setStoreListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomizerTester.this.storeData();
            }
        });
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.php.nette.tester.ui.customizer.CustomizerTester");
    }

    void enableComponents(boolean enabled, JComponent ... components) {
        for (JComponent component : components) {
            component.setEnabled(enabled);
        }
    }

    void validateData() {
        ValidationResult result = new TesterPreferencesValidator().validatePhpIni(this.phpIniCheckBox.isSelected(), this.phpIniTextField.getText()).validateTester(this.testerCheckBox.isSelected(), this.testerTextField.getText()).validateCoverageSourcePath(this.coverageSrcCheckBox.isSelected(), this.coverageSrcTextField.getText()).getResult();
        Iterator iterator = result.getErrors().iterator();
        if (iterator.hasNext()) {
            ValidationResult.Message message = (ValidationResult.Message)iterator.next();
            this.category.setErrorMessage(message.getMessage());
            this.category.setValid(false);
            return;
        }
        iterator = result.getWarnings().iterator();
        if (iterator.hasNext()) {
            ValidationResult.Message message = (ValidationResult.Message)iterator.next();
            this.category.setErrorMessage(message.getMessage());
            this.category.setValid(true);
            return;
        }
        this.category.setErrorMessage(null);
        this.category.setValid(true);
    }

    void storeData() {
        TesterPreferences.setPhpIniEnabled(this.phpModule, this.phpIniCheckBox.isSelected());
        TesterPreferences.setPhpIniPath(this.phpModule, this.phpIniTextField.getText());
        TesterPreferences.setTesterEnabled(this.phpModule, this.testerCheckBox.isSelected());
        TesterPreferences.setTesterPath(this.phpModule, this.testerTextField.getText());
        TesterPreferences.setBinaryEnabled(this.phpModule, this.binaryExecutableCheckBox.isSelected());
        TesterPreferences.setBinaryExecutable(this.phpModule, (String)this.binaryExecutableComboBox.getSelectedItem());
        TesterPreferences.setCoverageSourcePathEnabled(this.phpModule, this.coverageSrcCheckBox.isSelected());
        TesterPreferences.setCoverageSourcePath(this.phpModule, this.coverageSrcTextField.getText());
    }

    private void initFile(boolean enabled, String file, JCheckBox checkBox, JTextField textField) {
        checkBox.setSelected(enabled);
        textField.setText(file);
    }

    private void initBinaryExecutable() {
        this.binaryExecutableCheckBox.setSelected(TesterPreferences.isBinaryEnabled(this.phpModule));
        for (String binaryExecutable : TesterUtils.BINARY_EXECUTABLES) {
            this.binaryExecutableComboBox.addItem(binaryExecutable);
        }
        this.binaryExecutableComboBox.setSelectedItem(TesterPreferences.getBinaryExecutable(this.phpModule));
    }

    private void addListeners() {
        DefaultDocumentListener defaultDocumentListener = new DefaultDocumentListener();
        DefaultActionListener defaultActionListener = new DefaultActionListener();
        this.phpIniCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CustomizerTester.this.enableComponents(e.getStateChange() == 1, CustomizerTester.this.phpIniLabel, CustomizerTester.this.phpIniTextField, CustomizerTester.this.phpIniBrowseButton);
                CustomizerTester.this.validateData();
            }
        });
        this.phpIniTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.testerCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CustomizerTester.this.enableComponents(e.getStateChange() == 1, CustomizerTester.this.testerLabel, CustomizerTester.this.testerTextField, CustomizerTester.this.testerBrowseButton);
                CustomizerTester.this.validateData();
            }
        });
        this.testerTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.binaryExecutableCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CustomizerTester.this.enableComponents(e.getStateChange() == 1, CustomizerTester.this.binaryExecutableLabel, CustomizerTester.this.binaryExecutableComboBox);
                CustomizerTester.this.validateData();
            }
        });
        this.binaryExecutableComboBox.addActionListener(defaultActionListener);
        this.coverageSrcCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CustomizerTester.this.enableComponents(e.getStateChange() == 1, CustomizerTester.this.coverageSrcLabel, CustomizerTester.this.coverageSrcTextField, CustomizerTester.this.coverageSrcBrowseButton);
                CustomizerTester.this.validateData();
            }
        });
        this.coverageSrcTextField.getDocument().addDocumentListener(defaultDocumentListener);
    }

    private File getDefaultDirectory() {
        File defaultDirectory;
        FileObject testDirectory = this.phpModule.getTestDirectory(null);
        if (testDirectory != null) {
            defaultDirectory = FileUtil.toFile((FileObject)testDirectory);
        } else {
            FileObject sourcesDirectory = this.phpModule.getSourceDirectory();
            assert (sourcesDirectory != null);
            defaultDirectory = FileUtil.toFile((FileObject)sourcesDirectory);
        }
        assert (defaultDirectory != null);
        return defaultDirectory;
    }

    private void initComponents() {
        this.phpIniCheckBox = new JCheckBox();
        this.phpIniLabel = new JLabel();
        this.phpIniTextField = new JTextField();
        this.phpIniBrowseButton = new JButton();
        this.testerCheckBox = new JCheckBox();
        this.testerLabel = new JLabel();
        this.testerTextField = new JTextField();
        this.testerBrowseButton = new JButton();
        this.binaryExecutableCheckBox = new JCheckBox();
        this.binaryExecutableLabel = new JLabel();
        this.binaryExecutableComboBox = new JComboBox();
        this.noteLabel = new JLabel();
        this.infoLabel = new JLabel();
        this.coverageSrcCheckBox = new JCheckBox();
        this.coverageSrcLabel = new JLabel();
        this.coverageSrcTextField = new JTextField();
        this.coverageSrcBrowseButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.phpIniCheckBox, (String)NbBundle.getMessage(CustomizerTester.class, (String)"CustomizerTester.phpIniCheckBox.text"));
        this.phpIniLabel.setLabelFor(this.phpIniTextField);
        Mnemonics.setLocalizedText((JLabel)this.phpIniLabel, (String)NbBundle.getMessage(CustomizerTester.class, (String)"CustomizerTester.phpIniLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.phpIniBrowseButton, (String)NbBundle.getMessage(CustomizerTester.class, (String)"CustomizerTester.phpIniBrowseButton.text"));
        this.phpIniBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerTester.this.phpIniBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.testerCheckBox, (String)NbBundle.getMessage(CustomizerTester.class, (String)"CustomizerTester.testerCheckBox.text"));
        this.testerLabel.setLabelFor(this.testerTextField);
        Mnemonics.setLocalizedText((JLabel)this.testerLabel, (String)NbBundle.getMessage(CustomizerTester.class, (String)"CustomizerTester.testerLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.testerBrowseButton, (String)NbBundle.getMessage(CustomizerTester.class, (String)"CustomizerTester.testerBrowseButton.text"));
        this.testerBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerTester.this.testerBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.binaryExecutableCheckBox, (String)NbBundle.getMessage(CustomizerTester.class, (String)"CustomizerTester.binaryExecutableCheckBox.text"));
        this.binaryExecutableLabel.setLabelFor(this.binaryExecutableComboBox);
        Mnemonics.setLocalizedText((JLabel)this.binaryExecutableLabel, (String)NbBundle.getMessage(CustomizerTester.class, (String)"CustomizerTester.binaryExecutableLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.noteLabel, (String)NbBundle.getMessage(CustomizerTester.class, (String)"CustomizerTester.noteLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.infoLabel, (String)NbBundle.getMessage(CustomizerTester.class, (String)"CustomizerTester.infoLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.coverageSrcCheckBox, (String)NbBundle.getMessage(CustomizerTester.class, (String)"CustomizerTester.coverageSrcCheckBox.text"));
        this.coverageSrcLabel.setLabelFor(this.coverageSrcTextField);
        Mnemonics.setLocalizedText((JLabel)this.coverageSrcLabel, (String)NbBundle.getMessage(CustomizerTester.class, (String)"CustomizerTester.coverageSrcLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.coverageSrcBrowseButton, (String)NbBundle.getMessage(CustomizerTester.class, (String)"CustomizerTester.coverageSrcBrowseButton.text"));
        this.coverageSrcBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerTester.this.coverageSrcBrowseButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.phpIniCheckBox).addComponent(this.testerCheckBox).addComponent(this.binaryExecutableCheckBox).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.binaryExecutableLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.binaryExecutableComboBox, -2, -1, -2)).addComponent(this.noteLabel, -2, -1, -2).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.infoLabel)).addComponent(this.coverageSrcCheckBox).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.phpIniLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.phpIniTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.phpIniBrowseButton)).addGroup(layout.createSequentialGroup().addComponent(this.testerLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.testerTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.testerBrowseButton)).addGroup(layout.createSequentialGroup().addComponent(this.coverageSrcLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.coverageSrcTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.coverageSrcBrowseButton)))));
        layout.linkSize(0, this.coverageSrcBrowseButton, this.phpIniBrowseButton, this.testerBrowseButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.phpIniCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.phpIniLabel).addComponent(this.phpIniTextField, -2, -1, -2).addComponent(this.phpIniBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.testerCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.testerLabel).addComponent(this.testerTextField, -2, -1, -2).addComponent(this.testerBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.binaryExecutableCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.binaryExecutableLabel).addComponent(this.binaryExecutableComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.coverageSrcCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.coverageSrcLabel).addComponent(this.coverageSrcTextField, -2, -1, -2).addComponent(this.coverageSrcBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.noteLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.infoLabel).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void phpIniBrowseButtonActionPerformed(ActionEvent evt) {
        File file = new FileChooserBuilder(CustomizerTester.class).setTitle(Bundle.CustomizerTester_chooser_php_ini()).setApproveText(Bundle.CustomizerTester_chooser_php_ini_ok()).setDefaultWorkingDirectory(this.getDefaultDirectory()).forceUseOfDefaultWorkingDirectory(true).showOpenDialog();
        if (file != null) {
            this.phpIniTextField.setText(file.getAbsolutePath());
        }
    }

    private void testerBrowseButtonActionPerformed(ActionEvent evt) {
        File file = new FileChooserBuilder(CustomizerTester.class).setTitle(Bundle.CustomizerTester_chooser_tester()).setFilesOnly(true).setDefaultWorkingDirectory(this.getDefaultDirectory()).forceUseOfDefaultWorkingDirectory(true).showOpenDialog();
        if (file != null) {
            this.testerTextField.setText(file.getAbsolutePath());
        }
    }

    private void coverageSrcBrowseButtonActionPerformed(ActionEvent evt) {
        File file = new FileChooserBuilder(CustomizerTester.class).setTitle(Bundle.CustomizerTester_chooser_coverage_src_path()).setDirectoriesOnly(true).setDefaultWorkingDirectory(FileUtil.toFile((FileObject)this.phpModule.getSourceDirectory())).forceUseOfDefaultWorkingDirectory(true).showOpenDialog();
        if (file != null) {
            this.coverageSrcTextField.setText(file.getAbsolutePath());
        }
    }

    private final class DefaultActionListener
    implements ActionListener {
        private DefaultActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CustomizerTester.this.validateData();
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            CustomizerTester.this.validateData();
        }
    }
}

