/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.config;

public class ArgumentException
extends RuntimeException {
    private final String argumentName;
    private final String otherArgumentName;
    protected final String msg;

    public ArgumentException(String argumentName, String msg) {
        this(null, argumentName, null, msg);
    }

    public ArgumentException(String argumentName, String otherArgumentName, String msg) {
        this(null, argumentName, otherArgumentName, msg);
    }

    public ArgumentException(Throwable cause, String msg) {
        this(cause, null, null, msg);
    }

    public ArgumentException(Throwable cause, String argumentName, String msg) {
        this(cause, argumentName, null, msg);
    }

    public ArgumentException(Throwable cause, String argumentName, String otherArgumentName, String msg) {
        super(cause);
        this.argumentName = argumentName;
        this.otherArgumentName = otherArgumentName;
        this.msg = msg;
    }

    @Deprecated
    public String getMsg() {
        return this.msg;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        if (this.argumentName != null && !this.argumentName.isEmpty()) {
            sb.append("Argument: ");
            sb.append(this.argumentName);
            sb.append(", ");
        }
        if (this.otherArgumentName != null && !this.otherArgumentName.isEmpty()) {
            sb.append("Other argument: ");
            sb.append(this.otherArgumentName);
            sb.append(", ");
        }
        sb.append(this.msg);
        return sb.toString();
    }

    public String getArgument() {
        return this.otherArgumentName;
    }

    @Override
    public String toString() {
        if (this.argumentName != null) {
            if (this.otherArgumentName != null) {
                return "Argument Exception argument:'" + this.argumentName + "' other argument:'" + this.otherArgumentName + "' - " + this.msg + '\n' + super.toString();
            }
            return "Argument Exception argument:'" + this.argumentName + "' - " + this.msg + '\n' + super.toString();
        }
        return "Argument Exception - " + this.msg + '\n' + super.toString();
    }
}

