/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.config.xml;

import com.oracle.labs.mlrg.olcut.config.SerializedObject;
import com.oracle.labs.mlrg.olcut.config.io.ConfigWriter;
import com.oracle.labs.mlrg.olcut.config.io.ConfigWriterException;
import com.oracle.labs.mlrg.olcut.config.property.ListProperty;
import com.oracle.labs.mlrg.olcut.config.property.MapProperty;
import com.oracle.labs.mlrg.olcut.config.property.Property;
import com.oracle.labs.mlrg.olcut.config.property.SimpleProperty;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XMLConfigWriter
implements ConfigWriter {
    private final XMLStreamWriter writer;

    public XMLConfigWriter(XMLStreamWriter writer) {
        this.writer = writer;
    }

    @Override
    public void writeStartDocument() throws ConfigWriterException {
        try {
            this.writer.writeStartDocument("utf-8", "1.0");
            this.writer.writeCharacters(System.lineSeparator());
            this.writer.writeComment("OLCUT configuration file");
            this.writer.writeCharacters(System.lineSeparator());
            this.writer.writeStartElement("config");
            this.writer.writeCharacters(System.lineSeparator());
        }
        catch (XMLStreamException e) {
            throw new ConfigWriterException(e);
        }
    }

    @Override
    public void writeEndDocument() throws ConfigWriterException {
        try {
            this.writer.writeEndDocument();
        }
        catch (XMLStreamException e) {
            throw new ConfigWriterException(e);
        }
    }

    @Override
    public void writeGlobalProperties(Map<String, String> props) throws ConfigWriterException {
        try {
            for (Map.Entry<String, String> e : props.entrySet()) {
                this.writer.writeEmptyElement("property");
                this.writer.writeAttribute("name", e.getKey());
                this.writer.writeAttribute("value", e.getValue());
                this.writer.writeCharacters(System.lineSeparator());
            }
        }
        catch (XMLStreamException e) {
            throw new ConfigWriterException(e);
        }
    }

    @Override
    public void writeSerializedObjects(Map<String, SerializedObject> map) throws ConfigWriterException {
        try {
            for (Map.Entry<String, SerializedObject> e : map.entrySet()) {
                this.writer.writeEmptyElement("serialized");
                this.writer.writeAttribute("name", e.getValue().getName());
                this.writer.writeAttribute("type", e.getValue().getClassName());
                this.writer.writeAttribute("location", e.getValue().getLocation());
                this.writer.writeCharacters(System.lineSeparator());
            }
        }
        catch (XMLStreamException e) {
            throw new ConfigWriterException(e);
        }
    }

    @Override
    public void writeStartComponents() throws ConfigWriterException {
    }

    @Override
    public void writeComponent(Map<String, String> attributes, Map<String, Property> properties) {
        try {
            if (!properties.isEmpty()) {
                this.writer.writeStartElement("component");
                this.writer.writeAttribute("name", attributes.get("name"));
                this.writer.writeAttribute("type", attributes.get("type"));
                this.writer.writeAttribute("export", attributes.get("export"));
                this.writer.writeAttribute("import", attributes.get("import"));
                if (attributes.containsKey("entries")) {
                    this.writer.writeAttribute("entries", attributes.get("entries"));
                }
                if (attributes.containsKey("leasetime")) {
                    this.writer.writeAttribute("leasetime", attributes.get("leasetime"));
                }
                if (attributes.containsKey("serialized")) {
                    this.writer.writeAttribute("serialized", attributes.get("serialized"));
                }
                this.writer.writeCharacters(System.lineSeparator());
                for (Map.Entry<String, Property> property : properties.entrySet()) {
                    String key = property.getKey();
                    Property value = property.getValue();
                    if (value instanceof ListProperty) {
                        this.writer.writeCharacters("\t");
                        this.writer.writeStartElement("propertylist");
                        this.writer.writeAttribute("name", key);
                        this.writer.writeCharacters(System.lineSeparator());
                        for (SimpleProperty simpleProperty : ((ListProperty)value).getSimpleList()) {
                            this.writer.writeCharacters("\t\t");
                            this.writer.writeStartElement("item");
                            this.writer.writeCharacters(simpleProperty.getValue());
                            this.writer.writeEndElement();
                            this.writer.writeCharacters(System.lineSeparator());
                        }
                        for (Class clazz : ((ListProperty)value).getClassList()) {
                            this.writer.writeCharacters("\t\t");
                            this.writer.writeStartElement("type");
                            this.writer.writeCharacters(clazz.getName());
                            this.writer.writeEndElement();
                            this.writer.writeCharacters(System.lineSeparator());
                        }
                        this.writer.writeCharacters("\t");
                        this.writer.writeEndElement();
                        this.writer.writeCharacters(System.lineSeparator());
                        continue;
                    }
                    if (value instanceof MapProperty) {
                        this.writer.writeCharacters("\t");
                        this.writer.writeStartElement("propertymap");
                        this.writer.writeAttribute("name", key);
                        this.writer.writeCharacters(System.lineSeparator());
                        for (Map.Entry entry : ((MapProperty)value).getMap().entrySet()) {
                            this.writer.writeCharacters("\t\t");
                            this.writer.writeEmptyElement("entry");
                            this.writer.writeAttribute("key", (String)entry.getKey());
                            this.writer.writeAttribute("value", ((SimpleProperty)entry.getValue()).getValue());
                            this.writer.writeCharacters(System.lineSeparator());
                        }
                        this.writer.writeCharacters("\t");
                        this.writer.writeEndElement();
                        this.writer.writeCharacters(System.lineSeparator());
                        continue;
                    }
                    this.writer.writeCharacters("\t");
                    this.writer.writeEmptyElement("property");
                    this.writer.writeAttribute("name", key);
                    this.writer.writeAttribute("value", value.toString());
                    this.writer.writeCharacters(System.lineSeparator());
                }
                this.writer.writeEndElement();
            } else {
                this.writer.writeEmptyElement("component");
                this.writer.writeAttribute("name", attributes.get("name"));
                this.writer.writeAttribute("type", attributes.get("type"));
                this.writer.writeAttribute("export", attributes.get("export"));
                this.writer.writeAttribute("import", attributes.get("import"));
                if (attributes.containsKey("entries")) {
                    this.writer.writeAttribute("entries", attributes.get("entries"));
                }
                if (attributes.containsKey("leasetime")) {
                    this.writer.writeAttribute("leasetime", attributes.get("leasetime"));
                }
                if (attributes.containsKey("serialized")) {
                    this.writer.writeAttribute("serialized", attributes.get("serialized"));
                }
            }
            this.writer.writeCharacters(System.lineSeparator());
        }
        catch (XMLStreamException e) {
            throw new ConfigWriterException(e);
        }
    }

    @Override
    public void writeEndComponents() throws ConfigWriterException {
    }

    @Override
    public void close() throws ConfigWriterException {
        try {
            this.writer.close();
        }
        catch (XMLStreamException e) {
            throw new ConfigWriterException(e);
        }
    }
}

