/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.provenance;

import com.oracle.labs.mlrg.olcut.config.ConfigurationData;
import com.oracle.labs.mlrg.olcut.config.ConfigurationManager;
import com.oracle.labs.mlrg.olcut.config.property.ListProperty;
import com.oracle.labs.mlrg.olcut.config.property.MapProperty;
import com.oracle.labs.mlrg.olcut.config.property.SimpleProperty;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.ListProvenance;
import com.oracle.labs.mlrg.olcut.provenance.MapProvenance;
import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.PrimitiveProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenancable;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import com.oracle.labs.mlrg.olcut.provenance.ProvenanceException;
import com.oracle.labs.mlrg.olcut.provenance.impl.NullConfiguredProvenance;
import com.oracle.labs.mlrg.olcut.provenance.io.FlatMarshalledProvenance;
import com.oracle.labs.mlrg.olcut.provenance.io.ListMarshalledProvenance;
import com.oracle.labs.mlrg.olcut.provenance.io.MapMarshalledProvenance;
import com.oracle.labs.mlrg.olcut.provenance.io.ObjectMarshalledProvenance;
import com.oracle.labs.mlrg.olcut.provenance.io.SimpleMarshalledProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.EnumProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.HashProvenance;
import com.oracle.labs.mlrg.olcut.util.IOUtil;
import com.oracle.labs.mlrg.olcut.util.Pair;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.jar.JarEntry;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ProvenanceUtil {
    private static final Logger logger = Logger.getLogger(ProvenanceUtil.class.getName());
    private static final char[] hexCharacterArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private ProvenanceUtil() {
    }

    public static String bytesToHexString(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j << 1] = hexCharacterArray[v >>> 4];
            hexChars[(j << 1) + 1] = hexCharacterArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String hashList(HashType hashType, List<String> list) {
        MessageDigest md = hashType.getDigest();
        for (String curString : list) {
            md.update(curString.getBytes(StandardCharsets.UTF_8));
        }
        return ProvenanceUtil.bytesToHexString(md.digest());
    }

    public static String hashResource(HashType hashType, Path path) {
        return ProvenanceUtil.hashResource(hashType, path.toFile());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String hashResource(HashType hashType, File file) {
        MessageDigest md = hashType.getDigest();
        byte[] buffer = new byte[16384];
        try (BufferedInputStream bis = IOUtil.getInputStream(file);){
            int count;
            while ((count = ((InputStream)bis).read(buffer)) > 0) {
                md.update(buffer, 0, count);
            }
            String string = ProvenanceUtil.bytesToHexString(md.digest());
            return string;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "IOException when reading from file " + file);
            return ProvenanceUtil.bytesToHexString(md.digest());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String hashResource(HashType hashType, URL file) {
        MessageDigest md = hashType.getDigest();
        if (IOUtil.isDisallowedProtocol(file)) {
            logger.severe("Tried to read disallowed URL protocol: '" + file.toString() + "'");
            return ProvenanceUtil.bytesToHexString(md.digest(file.toString().getBytes(StandardCharsets.UTF_8)));
        }
        byte[] buffer = new byte[16384];
        try (BufferedInputStream bis = new BufferedInputStream(file.openStream());){
            int count;
            while ((count = ((InputStream)bis).read(buffer)) > 0) {
                md.update(buffer, 0, count);
            }
            String string = ProvenanceUtil.bytesToHexString(md.digest());
            return string;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "IOException when reading from file " + file);
            return ProvenanceUtil.bytesToHexString(md.digest());
        }
    }

    public static String hashArray(HashType hashType, byte[] input) {
        MessageDigest md = hashType.getDigest();
        md.update(input);
        return ProvenanceUtil.bytesToHexString(md.digest());
    }

    public static <T, U extends PrimitiveProvenance<T>> List<T> unwrap(ListProvenance<U> listProvenance) {
        ArrayList output = new ArrayList();
        for (PrimitiveProvenance p : listProvenance) {
            output.add(p.getValue());
        }
        return output;
    }

    public static <T, U extends PrimitiveProvenance<T>> Map<String, T> unwrap(MapProvenance<U> mapProvenance) {
        HashMap output = new HashMap();
        for (Map.Entry<String, U> p : mapProvenance.getMap().entrySet()) {
            output.put(p.getKey(), ((PrimitiveProvenance)p.getValue()).getValue());
        }
        return output;
    }

    public static Optional<OffsetDateTime> getModifiedTime(URL url) {
        String protocol = url.getProtocol();
        try {
            JarURLConnection jarCon;
            JarEntry entry;
            URLConnection con;
            if (protocol.equals("file")) {
                File f = new File(url.toURI());
                long modifiedTime = f.lastModified();
                if (modifiedTime != 0L) {
                    OffsetDateTime time = OffsetDateTime.ofInstant(Instant.ofEpochMilli(modifiedTime), ZoneId.systemDefault());
                    return Optional.of(time);
                }
            } else if (protocol.equals("jar") && (con = url.openConnection()) instanceof JarURLConnection && (entry = (jarCon = (JarURLConnection)con).getJarEntry()) != null) {
                FileTime modifiedTime = entry.getLastModifiedTime();
                if (modifiedTime != null) {
                    OffsetDateTime time = OffsetDateTime.ofInstant(modifiedTime.toInstant(), ZoneId.systemDefault());
                    return Optional.of(time);
                }
                FileTime creationTime = entry.getCreationTime();
                if (creationTime != null) {
                    OffsetDateTime time = OffsetDateTime.ofInstant(creationTime.toInstant(), ZoneId.systemDefault());
                    return Optional.of(time);
                }
            }
        }
        catch (URISyntaxException e) {
            logger.log(Level.WARNING, "Error parsing supplied url, failed to find modified time for " + url, e);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "IOException when connecting to jar url, failed to find modified time for " + url, e);
        }
        return Optional.empty();
    }

    public static String formattedProvenanceString(ObjectProvenance prov) {
        return ProvenanceUtil.formattedProvenanceString(prov, 0);
    }

    private static String formattedProvenanceString(ObjectProvenance prov, int depth) {
        String className = prov.getClassName();
        String shortClassName = className.substring(className.lastIndexOf(".") + 1);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            builder.append('\t');
            builder.append('\t');
        }
        String tabs = builder.toString();
        builder.setLength(0);
        builder.append(shortClassName);
        builder.append("(\n");
        for (Pair p : prov) {
            builder.append(tabs);
            builder.append('\t');
            builder.append((String)p.getA());
            builder.append(" = ");
            Provenance innerProv = (Provenance)p.getB();
            ProvenanceUtil.formatProvenance(innerProv, builder, tabs, depth);
            builder.append('\n');
        }
        builder.append(tabs);
        builder.append(')');
        return builder.toString();
    }

    private static void formatProvenance(Provenance innerProv, StringBuilder builder, String tabs, int depth) {
        if (innerProv instanceof PrimitiveProvenance) {
            builder.append(((PrimitiveProvenance)innerProv).getValue().toString());
        } else if (innerProv instanceof ListProvenance) {
            ListProvenance listProv = (ListProvenance)innerProv;
            if (listProv.getList().isEmpty()) {
                builder.append("List[]");
            } else {
                builder.append("List[\n");
                for (Provenance provElem : listProv) {
                    builder.append(tabs);
                    builder.append("\t\t");
                    ProvenanceUtil.formatProvenance(provElem, builder, tabs, depth + 1);
                    builder.append('\n');
                }
                builder.append(tabs);
                builder.append("\t]");
            }
        } else if (innerProv instanceof MapProvenance) {
            MapProvenance mapProv = (MapProvenance)innerProv;
            if (mapProv.getMap().isEmpty()) {
                builder.append("Map{}");
            } else {
                builder.append("Map{\n");
                for (Pair provElem : mapProv) {
                    builder.append(tabs);
                    builder.append("\t\t");
                    builder.append(provElem.getA());
                    builder.append('=');
                    ProvenanceUtil.formatProvenance((Provenance)provElem.getB(), builder, tabs, depth + 1);
                    builder.append('\n');
                }
                builder.append(tabs);
                builder.append("\t}");
            }
        } else if (innerProv instanceof ObjectProvenance) {
            String innerProvString = ProvenanceUtil.formattedProvenanceString((ObjectProvenance)innerProv, depth + 1);
            builder.append(innerProvString);
        } else {
            throw new IllegalStateException("Unrecognised provenance base type " + innerProv.getClass());
        }
    }

    public static Map<String, Object> convertToMap(ObjectProvenance prov) {
        HashMap<String, Object> output = new HashMap<String, Object>();
        for (Pair p : prov) {
            String key = (String)p.getA();
            Provenance innerProv = (Provenance)p.getB();
            Object value = ProvenanceUtil.innerConvertToMap(innerProv);
            output.put(key, value);
        }
        return Collections.unmodifiableMap(output);
    }

    private static Object innerConvertToMap(Provenance prov) {
        if (prov instanceof PrimitiveProvenance) {
            return ((PrimitiveProvenance)prov).getValue().toString();
        }
        if (prov instanceof ListProvenance) {
            ListProvenance listProv = (ListProvenance)prov;
            if (listProv.getList().isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Object> list = new ArrayList<Object>();
            for (Provenance provElem : listProv) {
                list.add(ProvenanceUtil.innerConvertToMap(provElem));
            }
            return Collections.unmodifiableList(list);
        }
        if (prov instanceof MapProvenance) {
            MapProvenance mapProv = (MapProvenance)prov;
            if (mapProv.getMap().isEmpty()) {
                return Collections.emptyMap();
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Pair provElem : mapProv) {
                String newKey = provElem.getA();
                Object newValue = ProvenanceUtil.innerConvertToMap((Provenance)provElem.getB());
                map.put(newKey, newValue);
            }
            return Collections.unmodifiableMap(map);
        }
        if (prov instanceof ObjectProvenance) {
            return ProvenanceUtil.convertToMap((ObjectProvenance)prov);
        }
        throw new IllegalStateException("Unrecognised provenance base type " + prov.getClass());
    }

    public static List<ConfigurationData> extractConfiguration(ObjectProvenance provenance) {
        ProvenanceOrdering ordering = ProvenanceUtil.orderProvenances(provenance);
        return ProvenanceUtil.extractConfigurationFromOrdering(ordering);
    }

    public static ProvenanceOrdering orderProvenances(ObjectProvenance provenance) {
        IdentityHashMap<ConfiguredObjectProvenance, Integer> provenanceTracker = new IdentityHashMap<ConfiguredObjectProvenance, Integer>(30);
        ArrayList<ConfiguredObjectProvenance> traversalOrder = new ArrayList<ConfiguredObjectProvenance>();
        int counter = 0;
        ArrayDeque<ObjectProvenance> processingQueue = new ArrayDeque<ObjectProvenance>();
        processingQueue.add(provenance);
        while (!processingQueue.isEmpty()) {
            ObjectProvenance curProv = (ObjectProvenance)processingQueue.poll();
            if (curProv instanceof NullConfiguredProvenance) continue;
            if (curProv instanceof ConfiguredObjectProvenance && !provenanceTracker.containsKey((ConfiguredObjectProvenance)curProv)) {
                provenanceTracker.put((ConfiguredObjectProvenance)curProv, counter);
                traversalOrder.add((ConfiguredObjectProvenance)curProv);
                ++counter;
            }
            ProvenanceUtil.extractProvenanceToQueue(processingQueue, curProv);
        }
        return new ProvenanceOrdering(traversalOrder, provenanceTracker);
    }

    public static List<ConfigurationData> extractConfigurationFromOrdering(ProvenanceOrdering ordering) {
        ArrayList<ConfigurationData> output = new ArrayList<ConfigurationData>();
        for (int i = 0; i < ordering.traversalOrder.size(); ++i) {
            ConfiguredObjectProvenance curProv = ordering.traversalOrder.get(i);
            output.add(ProvenanceUtil.extractSingleConfiguration(curProv, ProvenanceUtil.computeName(curProv, i), ordering.provenanceTracker));
        }
        return output;
    }

    private static ConfigurationData extractSingleConfiguration(ConfiguredObjectProvenance obj, String objName, Map<ConfiguredObjectProvenance, Integer> map) {
        ConfigurationData data = new ConfigurationData(objName, obj.getClassName());
        for (Map.Entry<String, Provenance> e : obj.getConfiguredParameters().entrySet()) {
            Provenance prov = e.getValue();
            if (prov instanceof ListProvenance) {
                ArrayList<SimpleProperty> list = new ArrayList<SimpleProperty>();
                for (Provenance p : (ListProvenance)prov) {
                    if (p instanceof ConfiguredObjectProvenance) {
                        if (p instanceof NullConfiguredProvenance) continue;
                        list.add(new SimpleProperty(ProvenanceUtil.computeName((ConfiguredObjectProvenance)p, map.get(p))));
                        continue;
                    }
                    list.add(new SimpleProperty(p.toString()));
                }
                data.add(e.getKey(), new ListProperty(list));
                continue;
            }
            if (prov instanceof MapProvenance) {
                HashMap<String, SimpleProperty> propMap = new HashMap<String, SimpleProperty>();
                for (Pair pair : (MapProvenance)prov) {
                    Provenance valueProv = (Provenance)pair.getB();
                    if (valueProv instanceof ConfiguredObjectProvenance) {
                        if (valueProv instanceof NullConfiguredProvenance) continue;
                        propMap.put((String)pair.getA(), new SimpleProperty(ProvenanceUtil.computeName((ConfiguredObjectProvenance)valueProv, map.get(valueProv))));
                        continue;
                    }
                    propMap.put((String)pair.getA(), new SimpleProperty(valueProv.toString()));
                }
                data.add(e.getKey(), new MapProperty(propMap));
                continue;
            }
            if (prov instanceof ConfiguredObjectProvenance) {
                if (prov instanceof NullConfiguredProvenance) continue;
                data.add(e.getKey(), new SimpleProperty(ProvenanceUtil.computeName((ConfiguredObjectProvenance)prov, map.get(prov))));
                continue;
            }
            data.add(e.getKey(), new SimpleProperty(prov.toString()));
        }
        return data;
    }

    public static String computeName(ObjectProvenance obj, int number) {
        String className = obj.getClassName();
        int lastDot = className.lastIndexOf(".");
        if (lastDot != -1) {
            className = className.substring(lastDot + 1);
        }
        return className.toLowerCase() + "-" + number;
    }

    public static List<ObjectMarshalledProvenance> marshalProvenance(ObjectProvenance provenance) {
        LinkedHashMap<ObjectProvenance, Integer> provenanceTracker = new LinkedHashMap<ObjectProvenance, Integer>();
        int counter = 0;
        ArrayDeque<ObjectProvenance> processingQueue = new ArrayDeque<ObjectProvenance>();
        processingQueue.add(provenance);
        while (!processingQueue.isEmpty()) {
            ObjectProvenance curProv = (ObjectProvenance)processingQueue.poll();
            provenanceTracker.put(curProv, counter);
            ++counter;
            ProvenanceUtil.extractProvenanceToQueue(processingQueue, curProv);
        }
        ArrayList<ObjectMarshalledProvenance> output = new ArrayList<ObjectMarshalledProvenance>();
        for (Map.Entry e : provenanceTracker.entrySet()) {
            output.add(ProvenanceUtil.marshalSingleProvenance((ObjectProvenance)e.getKey(), ProvenanceUtil.computeName((ObjectProvenance)e.getKey(), (Integer)e.getValue()), provenanceTracker));
        }
        return output;
    }

    private static ObjectMarshalledProvenance marshalSingleProvenance(ObjectProvenance provenance, String name, Map<ObjectProvenance, Integer> map) {
        HashMap<String, FlatMarshalledProvenance> outputMap = new HashMap<String, FlatMarshalledProvenance>();
        for (Pair e : provenance) {
            String key = (String)e.getA();
            Provenance prov = (Provenance)e.getB();
            FlatMarshalledProvenance marshalledProvenance = ProvenanceUtil.flattenSingleProvenance(prov, key, map);
            outputMap.put(key, marshalledProvenance);
        }
        return new ObjectMarshalledProvenance(name, outputMap, provenance.getClassName(), provenance.getClass().getName());
    }

    private static FlatMarshalledProvenance flattenSingleProvenance(Provenance prov, String key, Map<ObjectProvenance, Integer> map) {
        if (prov instanceof ListProvenance) {
            ArrayList<FlatMarshalledProvenance> list = new ArrayList<FlatMarshalledProvenance>();
            for (Provenance p : (ListProvenance)prov) {
                list.add(ProvenanceUtil.flattenSingleProvenance(p, key, map));
            }
            return new ListMarshalledProvenance(list);
        }
        if (prov instanceof MapProvenance) {
            HashMap<String, FlatMarshalledProvenance> propMap = new HashMap<String, FlatMarshalledProvenance>();
            for (Pair pair : (MapProvenance)prov) {
                propMap.put(pair.getA(), ProvenanceUtil.flattenSingleProvenance((Provenance)pair.getB(), pair.getA(), map));
            }
            return new MapMarshalledProvenance(propMap);
        }
        if (prov instanceof ObjectProvenance) {
            ObjectProvenance objProv = (ObjectProvenance)prov;
            return new SimpleMarshalledProvenance(key, ProvenanceUtil.computeName(objProv, map.get(objProv)), objProv);
        }
        if (prov instanceof HashProvenance) {
            return new SimpleMarshalledProvenance((HashProvenance)prov);
        }
        if (prov instanceof EnumProvenance) {
            return new SimpleMarshalledProvenance((EnumProvenance)prov);
        }
        if (prov instanceof PrimitiveProvenance) {
            return new SimpleMarshalledProvenance((PrimitiveProvenance)prov);
        }
        throw new ProvenanceException("Unexpected Provenance subclass - found " + prov.getClass().getName() + " expected {ListProvenance, MapProvenance, PrimitiveProvenance, ObjectProvenance}");
    }

    private static void extractProvenanceToQueue(Queue<ObjectProvenance> processingQueue, ObjectProvenance curProv) {
        for (Pair p : curProv) {
            Provenance prov = (Provenance)p.getB();
            if (prov instanceof ObjectProvenance) {
                processingQueue.add((ObjectProvenance)prov);
                continue;
            }
            if (prov instanceof ListProvenance) {
                for (Provenance listElement : (ListProvenance)prov) {
                    if (!(listElement instanceof ObjectProvenance)) continue;
                    processingQueue.add((ObjectProvenance)listElement);
                }
                continue;
            }
            if (!(prov instanceof MapProvenance)) continue;
            for (Pair mapElement : (MapProvenance)prov) {
                if (!(mapElement.getB() instanceof ObjectProvenance)) continue;
                processingQueue.add((ObjectProvenance)mapElement.getB());
            }
        }
    }

    public static ObjectProvenance unmarshalProvenance(List<ObjectMarshalledProvenance> marshalledProvenance) {
        HashMap<String, ObjectProvenance> unmarshalledObjects = new HashMap<String, ObjectProvenance>();
        HashMap<String, ObjectMarshalledProvenance> marshalledObjects = new HashMap<String, ObjectMarshalledProvenance>();
        for (ObjectMarshalledProvenance o : marshalledProvenance) {
            marshalledObjects.put(o.getName(), o);
        }
        return ProvenanceUtil.unmarshalProvenance(marshalledProvenance.get(0), unmarshalledObjects, marshalledObjects);
    }

    private static ObjectProvenance unmarshalProvenance(ObjectMarshalledProvenance curProv, Map<String, ObjectProvenance> unmarshalledObjects, Map<String, ObjectMarshalledProvenance> marshalledObjects) throws ProvenanceException {
        String provenanceClassName = curProv.getProvenanceClassName();
        try {
            Class<?> provenanceClass = Class.forName(provenanceClassName);
            if (!ObjectProvenance.class.isAssignableFrom(provenanceClass)) {
                throw new ProvenanceException("ObjectMarshalledProvenance " + curProv + " does not represent a class which implements ObjectProvenance, found " + provenanceClass.getName());
            }
            HashMap<String, Provenance> arguments = new HashMap<String, Provenance>();
            for (Map.Entry<String, FlatMarshalledProvenance> e : curProv.getMap().entrySet()) {
                Provenance extractedProv = ProvenanceUtil.unmarshalFlat(curProv.getName(), e.getValue(), unmarshalledObjects, marshalledObjects);
                arguments.put(e.getKey(), extractedProv);
            }
            Constructor<?> provenanceConstructor = provenanceClass.getConstructor(Map.class);
            ObjectProvenance provenance = (ObjectProvenance)provenanceConstructor.newInstance(arguments);
            return provenance;
        }
        catch (InstantiationException e) {
            throw new ProvenanceException("Failed to instantiate " + provenanceClassName, e);
        }
        catch (InvocationTargetException e) {
            throw new ProvenanceException("Exception thrown by " + provenanceClassName + " constructor", e);
        }
        catch (NoSuchMethodException e) {
            throw new ProvenanceException("No constructor ObjectProvenance(Map<String,Provenance>) found in " + provenanceClassName, e);
        }
        catch (IllegalAccessException e) {
            throw new ProvenanceException("The ObjectProvenance subclass " + provenanceClassName + " doesn't contain a public constructor which accepts a Map", e);
        }
        catch (ClassNotFoundException e) {
            throw new ProvenanceException("Failed to find a class called " + provenanceClassName);
        }
    }

    private static Provenance unmarshalFlat(String hostProvName, FlatMarshalledProvenance fmp, Map<String, ObjectProvenance> unmarshalledObjects, Map<String, ObjectMarshalledProvenance> marshalledObjects) {
        if (fmp instanceof SimpleMarshalledProvenance) {
            SimpleMarshalledProvenance smp = (SimpleMarshalledProvenance)fmp;
            if (smp.isReference()) {
                String refName = smp.getValue();
                if (unmarshalledObjects.containsKey(refName)) {
                    return unmarshalledObjects.get(refName);
                }
                if (marshalledObjects.containsKey(refName)) {
                    ObjectMarshalledProvenance omp = marshalledObjects.remove(refName);
                    ObjectProvenance unmarshalled = ProvenanceUtil.unmarshalProvenance(omp, unmarshalledObjects, marshalledObjects);
                    unmarshalledObjects.put(refName, unmarshalled);
                    return unmarshalled;
                }
                throw new ProvenanceException("Invalid provenance object " + hostProvName + " refers to an object called " + refName + " which is not present (or forms a cycle).");
            }
            return smp.unmarshallPrimitive();
        }
        if (fmp instanceof ListMarshalledProvenance) {
            ListMarshalledProvenance lmp = (ListMarshalledProvenance)fmp;
            ArrayList<Provenance> convertedList = new ArrayList<Provenance>();
            for (FlatMarshalledProvenance smp : lmp) {
                convertedList.add(ProvenanceUtil.unmarshalFlat(hostProvName, smp, unmarshalledObjects, marshalledObjects));
            }
            return new ListProvenance(convertedList);
        }
        if (fmp instanceof MapMarshalledProvenance) {
            MapMarshalledProvenance mmp = (MapMarshalledProvenance)fmp;
            HashMap<String, Provenance> convertedMap = new HashMap<String, Provenance>();
            for (Pair<String, FlatMarshalledProvenance> tuple : mmp) {
                convertedMap.put(tuple.getA(), ProvenanceUtil.unmarshalFlat(hostProvName, tuple.getB(), unmarshalledObjects, marshalledObjects));
            }
            return new MapProvenance(convertedMap);
        }
        throw new ProvenanceException("Unexpected FlatMarshalledProvenance subclass, found " + fmp.getClass().getName());
    }

    public static void writeObject(Provenancable<? extends ConfiguredObjectProvenance> provenancable, ObjectOutputStream outputStream) throws IOException {
        ObjectProvenance provenance = provenancable.getProvenance();
        outputStream.writeObject(provenance);
    }

    public static Provenancable<? extends ConfiguredObjectProvenance> readObject(ObjectInputStream inputStream) throws ClassNotFoundException, IOException {
        ConfiguredObjectProvenance provenance = (ConfiguredObjectProvenance)inputStream.readObject();
        List<ConfigurationData> configurationData = ProvenanceUtil.extractConfiguration(provenance);
        String componentName = configurationData.get(0).getName();
        ConfigurationManager cm = new ConfigurationManager();
        cm.addConfiguration(configurationData);
        Provenancable provenancable = (Provenancable)((Object)cm.lookup(componentName));
        cm.close();
        return provenancable;
    }

    public static final class ProvenanceOrdering {
        public final List<ConfiguredObjectProvenance> traversalOrder;
        public final Map<ConfiguredObjectProvenance, Integer> provenanceTracker;

        ProvenanceOrdering(List<ConfiguredObjectProvenance> traversalOrder, IdentityHashMap<ConfiguredObjectProvenance, Integer> provenanceTracker) {
            this.traversalOrder = Collections.unmodifiableList(traversalOrder);
            this.provenanceTracker = Collections.unmodifiableMap(provenanceTracker);
        }
    }

    public static enum HashType {
        SHA1("SHA1"),
        SHA256("SHA-256"),
        SHA512("SHA-512"),
        MD5("MD5");

        public final String name;

        private HashType(String name) {
            this.name = name;
        }

        public MessageDigest getDigest() {
            try {
                return MessageDigest.getInstance(this.name);
            }
            catch (NoSuchAlgorithmException e) {
                throw new ProvenanceException("Unable to construct MessageDigest for HashType " + this.name, e);
            }
        }
    }
}

