/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data.columnar.processors.field;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.tribuo.data.columnar.ColumnarFeature;
import org.tribuo.data.columnar.FieldProcessor;

public class RegexFieldProcessor
implements FieldProcessor {
    private static final Logger logger = Logger.getLogger(RegexFieldProcessor.class.getName());
    private Pattern regex;
    @Config(mandatory=true, description="Regex to apply to the field.")
    private String regexString;
    @Config(mandatory=true, description="The field name to read.")
    private String fieldName;
    @Config(mandatory=true, description="Matching mode.")
    private EnumSet<Mode> modes;

    private RegexFieldProcessor() {
    }

    public RegexFieldProcessor(String fieldName, Pattern regex, EnumSet<Mode> modes) {
        this.regex = regex;
        this.fieldName = fieldName;
        this.regexString = regex.pattern();
        this.modes = modes;
    }

    public RegexFieldProcessor(String fieldName, String regex, EnumSet<Mode> modes) {
        this(fieldName, Pattern.compile(regex), modes);
    }

    public void postConfig() {
        this.regex = Pattern.compile(this.regexString);
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public List<ColumnarFeature> process(String value) {
        ArrayList<ColumnarFeature> features = new ArrayList<ColumnarFeature>();
        Matcher m = this.regex.matcher(value);
        for (Mode mode : this.modes) {
            switch (mode) {
                case MATCH_ALL: {
                    if (!m.matches()) break;
                    features.add(new ColumnarFeature(this.fieldName, "MATCHES_ALL", 1.0));
                    break;
                }
                case MATCH_CONTAINS: {
                    if (!m.find()) break;
                    features.add(new ColumnarFeature(this.fieldName, "CONTAINS_MATCH", 1.0));
                    break;
                }
                case GROUPS: {
                    int i = 0;
                    while (m.find()) {
                        features.add(new ColumnarFeature(this.fieldName, "GROUPS(" + m.group(++i) + ")", 1.0));
                    }
                    break;
                }
            }
        }
        return features;
    }

    @Override
    public FieldProcessor.GeneratedFeatureType getFeatureType() {
        return FieldProcessor.GeneratedFeatureType.CATEGORICAL;
    }

    @Override
    public RegexFieldProcessor copy(String newFieldName) {
        return new RegexFieldProcessor(newFieldName, this.regex, EnumSet.copyOf(this.modes));
    }

    public String toString() {
        return "RegexFieldProcessor(fieldName=" + this.getFieldName() + ",modes=" + this.modes.stream().map(Enum::name).sorted().collect(Collectors.joining(":")) + ')';
    }

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "FieldProcessor");
    }

    public static enum Mode {
        MATCH_ALL,
        MATCH_CONTAINS,
        GROUPS;

    }
}

