/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data.columnar.processors.response;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.config.ConfigurableName;
import com.oracle.labs.mlrg.olcut.config.PropertyException;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.tribuo.Output;
import org.tribuo.OutputFactory;
import org.tribuo.data.columnar.ResponseProcessor;

public class BinaryResponseProcessor<T extends Output<T>>
implements ResponseProcessor<T> {
    @Config(description="The field name to read, you should use only one of this or fieldNames")
    @Deprecated
    private String fieldName;
    @Config(description="The string which triggers a positive response.")
    private String positiveResponse;
    @Config(mandatory=true, description="Output factory to use to create the response.")
    private OutputFactory<T> outputFactory;
    public static final String POSITIVE_NAME = "1";
    public static final String NEGATIVE_NAME = "0";
    @Config(description="The positive response to emit.")
    private String positiveName = "1";
    @Config(description="The negative response to emit.")
    private String negativeName = "0";
    @Config(description="A list of field names to read, you should use only one of this or fieldName.")
    private List<String> fieldNames;
    @Config(description="A list of strings that trigger positive responses; it should be the same length as fieldNames or empty")
    private List<String> positiveResponses;
    @Config(description="Whether to display field names as part of the generated output, defaults to false")
    private boolean displayField;
    @ConfigurableName
    private String configName;

    public void postConfig() {
        boolean singlePositiveResponsePopulated;
        boolean bothFieldNamesPopulated = this.fieldName != null && this.fieldNames != null;
        boolean neitherFieldNamesPopulated = this.fieldName == null && this.fieldNames == null;
        boolean multipleFieldNamesPopulated = this.fieldNames != null;
        boolean singleFieldNamePopulated = this.fieldName != null;
        boolean bothPositiveResponsesPopulated = this.positiveResponses != null && this.positiveResponse != null;
        boolean neitherPositiveResponsesPopulated = this.positiveResponse == null && this.positiveResponses == null;
        boolean multiplePositiveResponsesPopulated = this.positiveResponses != null;
        boolean bl = singlePositiveResponsePopulated = this.positiveResponse != null;
        if (bothFieldNamesPopulated || neitherFieldNamesPopulated) {
            throw new PropertyException(this.configName, "fieldName, FieldNames", "exactly one of fieldName or fieldNames must be populated");
        }
        if (bothPositiveResponsesPopulated || neitherPositiveResponsesPopulated) {
            throw new PropertyException(this.configName, "positiveResponse, positiveResponses", "exactly one of positiveResponse or positiveResponses must be populated");
        }
        if (multipleFieldNamesPopulated && multiplePositiveResponsesPopulated && this.fieldNames.size() != this.positiveResponses.size()) {
            throw new PropertyException(this.configName, "positiveResponses", "must match the length of fieldNames");
        }
        if (multipleFieldNamesPopulated && singlePositiveResponsePopulated) {
            this.positiveResponses = Collections.nCopies(this.fieldNames.size(), this.positiveResponse);
            this.positiveResponse = null;
        } else {
            if (singleFieldNamePopulated && multiplePositiveResponsesPopulated) {
                throw new PropertyException(this.configName, "positiveResponses", "if fieldName is populated, positiveResponses must be blank");
            }
            if (singleFieldNamePopulated && singlePositiveResponsePopulated) {
                this.fieldNames = Collections.singletonList(this.fieldName);
                this.fieldName = null;
                this.positiveResponses = Collections.singletonList(this.positiveResponse);
                this.positiveResponse = null;
            }
        }
    }

    private BinaryResponseProcessor() {
    }

    public BinaryResponseProcessor(String fieldName, String positiveResponse, OutputFactory<T> outputFactory) {
        this(Collections.singletonList(fieldName), positiveResponse, outputFactory);
    }

    public BinaryResponseProcessor(List<String> fieldNames, String positiveResponse, OutputFactory<T> outputFactory) {
        this(fieldNames, Collections.nCopies(fieldNames.size(), positiveResponse), outputFactory);
    }

    public BinaryResponseProcessor(List<String> fieldNames, List<String> positiveResponses, OutputFactory<T> outputFactory) {
        this(fieldNames, positiveResponses, outputFactory, false);
    }

    public BinaryResponseProcessor(List<String> fieldNames, List<String> positiveResponses, OutputFactory<T> outputFactory, boolean displayField) {
        this(fieldNames, positiveResponses, outputFactory, POSITIVE_NAME, NEGATIVE_NAME, displayField);
    }

    public BinaryResponseProcessor(List<String> fieldNames, List<String> positiveResponses, OutputFactory<T> outputFactory, String positiveName, String negativeName, boolean displayField) {
        if (fieldNames.size() != positiveResponses.size()) {
            throw new IllegalArgumentException("fieldNames and positiveResponses must be the same length");
        }
        this.fieldNames = fieldNames;
        this.positiveResponses = positiveResponses;
        this.outputFactory = outputFactory;
        this.positiveName = positiveName;
        this.negativeName = negativeName;
        this.displayField = displayField;
    }

    @Override
    public OutputFactory<T> getOutputFactory() {
        return this.outputFactory;
    }

    @Override
    @Deprecated
    public String getFieldName() {
        return this.fieldNames.get(0);
    }

    @Override
    @Deprecated
    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    @Deprecated
    public Optional<T> process(String value) {
        return this.process(Collections.singletonList(value));
    }

    @Override
    public Optional<T> process(List<String> values) {
        if (values.size() != this.fieldNames.size()) {
            throw new IllegalArgumentException("values must have the same length as fieldNames. Got values: " + values.size() + " fieldNames: " + this.fieldNames.size());
        }
        ArrayList<String> responses = new ArrayList<String>();
        String prefix = "";
        for (int i = 0; i < this.fieldNames.size(); ++i) {
            if (this.displayField) {
                prefix = this.fieldNames.get(i) + "=";
            }
            responses.add(prefix + (this.positiveResponses.get(i).equals(values.get(i)) ? this.positiveName : this.negativeName));
        }
        return Optional.of(this.outputFactory.generateOutput(this.fieldNames.size() == 1 ? responses.get(0) : responses));
    }

    @Override
    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public String toString() {
        return "BinaryResponseProcessor(fieldNames=" + this.fieldNames.toString() + ", positiveResponses=" + this.positiveResponses.toString() + ", positiveName=" + this.positiveName + ", negativeName=" + this.negativeName + ")";
    }

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "ResponseProcessor");
    }
}

