/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data.sql;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.config.PropertyException;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenancable;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class SQLDBConfig
implements Configurable,
Provenancable<ConfiguredObjectProvenance> {
    @Config(description="Connection string, including host, port and db.")
    private String connectionString;
    @Config(description="Database username.", redact=true)
    private String username;
    @Config(description="Database password.", redact=true)
    private String password;
    @Config(description="Properties to pass to java.sql.DriverManager, username and password will be removed and populated to their fields. If specified both on the map and in the fields, the fields will be used")
    private Map<String, String> propMap = new HashMap<String, String>();
    @Config(description="Hostname of the database machine.")
    private String host;
    @Config(description="Port number.")
    private String port;
    @Config(description="Database name.")
    private String db;
    @Config(description="Size of batches to fetch from DB for queries")
    private int fetchSize = 1000;

    private SQLDBConfig() {
    }

    public SQLDBConfig(String connectionString, String username, String password, Map<String, String> properties) {
        this(connectionString, properties);
        this.username = username;
        this.password = password;
    }

    public SQLDBConfig(String host, String port, String db, String username, String password, Map<String, String> properties) {
        this(SQLDBConfig.makeConnectionString(host, port, db), properties);
        this.host = host;
        this.port = port;
        this.db = db;
        this.username = username;
        this.password = password;
    }

    public SQLDBConfig(String connectionString, Map<String, String> properties) {
        this.connectionString = connectionString;
        this.propMap = properties;
    }

    private static String makeConnectionString(String host, String port, String db) {
        return "jdbc:oracle:thin:@" + host + ":" + port + "/" + db;
    }

    public void postConfig() {
        if (this.propMap.containsKey("user")) {
            if (this.username == null) {
                this.username = this.propMap.remove("user");
            } else {
                this.propMap.remove("user");
            }
        }
        if (this.propMap.containsKey("password")) {
            if (this.password == null) {
                this.password = this.propMap.remove("password");
            } else {
                this.propMap.remove("password");
            }
        }
        if (this.connectionString == null) {
            if (this.host != null && this.port != null && this.db != null) {
                this.connectionString = SQLDBConfig.makeConnectionString(this.host, this.port, this.db);
            } else {
                throw new PropertyException(SQLDBConfig.class.getName(), "connectionString", "All of host, port, and db must be specified if connectionString is null");
            }
        }
    }

    public Connection getConnection() throws SQLException {
        Properties props = new Properties();
        props.putAll(this.propMap);
        if (this.username != null && this.password != null) {
            props.put("user", this.username);
            props.put("password", this.password);
        }
        return DriverManager.getConnection(this.connectionString, props);
    }

    public Statement getStatement() throws SQLException {
        Statement stmt = this.getConnection().createStatement();
        stmt.setFetchSize(this.fetchSize);
        stmt.setFetchDirection(1000);
        return stmt;
    }

    public String toString() {
        if (this.connectionString != null) {
            return "SQLDBConfig(connectionString=" + this.connectionString + ")";
        }
        return "SQLDBConfig(host=" + this.host + ",port=" + this.port + ",db=" + this.db + ")";
    }

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "SQL-DB-Config");
    }
}

