/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.unflattener;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.eclipsesource.json.PrettyPrint;
import com.eclipsesource.json.WriterConfig;
import com.github.wnameless.json.flattener.FlattenMode;
import com.github.wnameless.json.flattener.KeyTransformer;
import com.github.wnameless.json.flattener.PrintMode;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;

public final class JsonUnflattener {
    private final JsonValue root;
    private FlattenMode flattenMode = FlattenMode.NORMAL;
    private Character separator = Character.valueOf('.');
    private Character leftBracket = Character.valueOf('[');
    private Character rightBracket = Character.valueOf(']');
    private PrintMode printMode = PrintMode.MINIMAL;
    private KeyTransformer keyTrans = null;

    public static String unflatten(String json) {
        return new JsonUnflattener(json).unflatten();
    }

    public JsonUnflattener(String json) {
        this.root = Json.parse((String)json);
    }

    public JsonUnflattener(Reader jsonReader) throws IOException {
        this.root = Json.parse((Reader)jsonReader);
    }

    private String arrayIndex() {
        return Pattern.quote(this.leftBracket.toString()) + "\\s*\\d+\\s*" + Pattern.quote(this.rightBracket.toString());
    }

    private String objectComplexKey() {
        return Pattern.quote(this.leftBracket.toString()) + "\\s*\".+?\"\\s*" + Pattern.quote(this.rightBracket.toString());
    }

    private String objectKey() {
        return "[^" + Pattern.quote(this.separator.toString()) + Pattern.quote(this.leftBracket.toString()) + Pattern.quote(this.rightBracket.toString()) + "]+";
    }

    private Pattern keyPartPattern() {
        if (this.flattenMode.equals((Object)FlattenMode.MONGODB)) {
            return Pattern.compile("[^" + Pattern.quote(this.separator.toString()) + "]+");
        }
        return Pattern.compile(this.arrayIndex() + "|" + this.objectComplexKey() + "|" + this.objectKey());
    }

    public JsonUnflattener withFlattenMode(FlattenMode flattenMode) {
        this.flattenMode = (FlattenMode)((Object)Validate.notNull((Object)((Object)flattenMode)));
        return this;
    }

    public JsonUnflattener withSeparator(char separator) {
        Validate.isTrue((!Character.toString(separator).matches("[\"\\s]") ? 1 : 0) != 0, (String)"Separator contains illegal chracter(%s)", (Object[])new Object[]{Character.toString(separator)});
        Validate.isTrue((!this.leftBracket.equals(Character.valueOf(separator)) && !this.rightBracket.equals(Character.valueOf(separator)) ? 1 : 0) != 0, (String)"Separator(%s) is already used in brackets", (Object[])new Object[]{Character.toString(separator)});
        this.separator = Character.valueOf(separator);
        return this;
    }

    private String illegalBracketsRegex() {
        return "[\"\\s" + Pattern.quote(this.separator.toString()) + "]";
    }

    public JsonUnflattener withLeftAndRightBrackets(char leftBracket, char rightBracket) {
        Validate.isTrue((leftBracket != rightBracket ? 1 : 0) != 0, (String)"Both brackets cannot be the same", (Object[])new Object[0]);
        Validate.isTrue((!Character.toString(leftBracket).matches(this.illegalBracketsRegex()) ? 1 : 0) != 0, (String)"Left bracket contains illegal chracter(%s)", (Object[])new Object[]{Character.toString(leftBracket)});
        Validate.isTrue((!Character.toString(rightBracket).matches(this.illegalBracketsRegex()) ? 1 : 0) != 0, (String)"Right bracket contains illegal chracter(%s)", (Object[])new Object[]{Character.toString(rightBracket)});
        this.leftBracket = Character.valueOf(leftBracket);
        this.rightBracket = Character.valueOf(rightBracket);
        return this;
    }

    public JsonUnflattener withPrintMode(PrintMode printMode) {
        this.printMode = (PrintMode)((Object)Validate.notNull((Object)((Object)printMode)));
        return this;
    }

    public JsonUnflattener withKeyTransformer(KeyTransformer keyTrans) {
        this.keyTrans = (KeyTransformer)Validate.notNull((Object)keyTrans);
        return this;
    }

    private WriterConfig getWriterConfig() {
        switch (this.printMode) {
            case REGULAR: {
                return PrettyPrint.singleLine();
            }
            case PRETTY: {
                return WriterConfig.PRETTY_PRINT;
            }
        }
        return WriterConfig.MINIMAL;
    }

    public String unflatten() {
        StringWriter sw = new StringWriter();
        if (this.root.isArray()) {
            try {
                this.unflattenArray(this.root.asArray()).writeTo((Writer)sw, this.getWriterConfig());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return sw.toString();
        }
        if (!this.root.isObject()) {
            return this.root.toString();
        }
        JsonObject flattened = this.root.asObject();
        JsonObject unflattened = flattened.names().isEmpty() ? Json.object() : null;
        for (String key : flattened.names()) {
            JsonObject currentVal = unflattened;
            String objKey = null;
            Integer aryIdx = null;
            Matcher matcher = this.keyPartPattern().matcher(key);
            while (matcher.find()) {
                String keyPart = matcher.group();
                if (objKey != null ^ aryIdx != null) {
                    if (this.isJsonArray(keyPart)) {
                        currentVal = this.findOrCreateJsonArray((JsonValue)currentVal, objKey, aryIdx);
                        objKey = null;
                        aryIdx = this.extractIndex(keyPart);
                    } else {
                        if (flattened.get(key).isArray()) {
                            flattened.set(key, (JsonValue)this.unflattenArray(flattened.get(key).asArray()));
                        }
                        currentVal = this.findOrCreateJsonObject((JsonValue)currentVal, objKey, aryIdx);
                        objKey = this.extractKey(keyPart);
                        aryIdx = null;
                    }
                }
                if (objKey == null && aryIdx == null) {
                    if (this.isJsonArray(keyPart)) {
                        aryIdx = this.extractIndex(keyPart);
                        if (currentVal == null) {
                            currentVal = Json.array();
                        }
                    } else {
                        objKey = this.extractKey(keyPart);
                        if (currentVal == null) {
                            currentVal = Json.object();
                        }
                    }
                }
                if (unflattened != null) continue;
                unflattened = currentVal;
            }
            this.setUnflattenedValue(flattened, key, (JsonValue)currentVal, objKey, aryIdx);
        }
        try {
            unflattened.writeTo((Writer)sw, this.getWriterConfig());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }

    private JsonArray unflattenArray(JsonArray array) {
        JsonArray unflattenArray = Json.array().asArray();
        for (JsonValue value : array) {
            if (value.isArray()) {
                unflattenArray.add((JsonValue)this.unflattenArray(value.asArray()));
                continue;
            }
            if (value.isObject()) {
                unflattenArray.add(Json.parse((String)new JsonUnflattener(value.toString()).withSeparator(this.separator.charValue()).unflatten()));
                continue;
            }
            unflattenArray.add(value);
        }
        return unflattenArray;
    }

    private String extractKey(String keyPart) {
        if (keyPart.matches(this.objectComplexKey())) {
            keyPart = keyPart.replaceAll("^" + Pattern.quote(this.leftBracket.toString()) + "\\s*\"", "");
            keyPart = keyPart.replaceAll("\"\\s*" + Pattern.quote(this.rightBracket.toString()) + "$", "");
        }
        return this.keyTrans != null ? this.keyTrans.transform(keyPart) : keyPart;
    }

    private Integer extractIndex(String keyPart) {
        if (this.flattenMode.equals((Object)FlattenMode.MONGODB)) {
            return Integer.valueOf(keyPart);
        }
        return Integer.valueOf(keyPart.replaceAll("[" + Pattern.quote(this.leftBracket.toString()) + Pattern.quote(this.rightBracket.toString()) + "\\s]", ""));
    }

    private boolean isJsonArray(String keyPart) {
        return keyPart.matches(this.arrayIndex()) || this.flattenMode.equals((Object)FlattenMode.MONGODB) && keyPart.matches("\\d+");
    }

    private JsonValue findOrCreateJsonArray(JsonValue currentVal, String objKey, Integer aryIdx) {
        if (objKey != null) {
            JsonObject jsonObj = currentVal.asObject();
            if (jsonObj.get(objKey) == null) {
                JsonArray ary = Json.array();
                jsonObj.add(objKey, (JsonValue)ary);
                return ary;
            }
            return jsonObj.get(objKey);
        }
        JsonArray jsonAry = currentVal.asArray();
        if (jsonAry.size() <= aryIdx || jsonAry.get(aryIdx.intValue()).equals((Object)Json.NULL)) {
            JsonArray ary = Json.array();
            this.assureJsonArraySize(jsonAry, aryIdx);
            jsonAry.set(aryIdx.intValue(), (JsonValue)ary);
            return ary;
        }
        return jsonAry.get(aryIdx.intValue());
    }

    private JsonValue findOrCreateJsonObject(JsonValue currentVal, String objKey, Integer aryIdx) {
        if (objKey != null) {
            JsonObject jsonObj = currentVal.asObject();
            if (jsonObj.get(objKey) == null) {
                JsonObject obj = Json.object();
                jsonObj.add(objKey, (JsonValue)obj);
                return obj;
            }
            return jsonObj.get(objKey);
        }
        JsonArray jsonAry = currentVal.asArray();
        if (jsonAry.size() <= aryIdx || jsonAry.get(aryIdx.intValue()).equals((Object)Json.NULL)) {
            JsonObject obj = Json.object();
            this.assureJsonArraySize(jsonAry, aryIdx);
            jsonAry.set(aryIdx.intValue(), (JsonValue)obj);
            return obj;
        }
        return jsonAry.get(aryIdx.intValue());
    }

    private void setUnflattenedValue(JsonObject flattened, String key, JsonValue currentVal, String objKey, Integer aryIdx) {
        JsonValue val = flattened.get(key);
        if (objKey != null) {
            if (val.isArray()) {
                JsonArray jsonArray = Json.array();
                for (JsonValue arrayVal : val.asArray()) {
                    jsonArray.asArray().add(Json.parse((String)this.newJsonUnflattener(arrayVal.toString()).unflatten()));
                }
                currentVal.asObject().add(objKey, (JsonValue)jsonArray);
            } else {
                currentVal.asObject().add(objKey, val);
            }
        } else {
            this.assureJsonArraySize(currentVal.asArray(), aryIdx);
            currentVal.asArray().set(aryIdx.intValue(), val);
        }
    }

    private JsonUnflattener newJsonUnflattener(String json) {
        JsonUnflattener jf = new JsonUnflattener(json);
        if (this.flattenMode != null) {
            jf.withFlattenMode(this.flattenMode);
        }
        if (this.keyTrans != null) {
            jf.withKeyTransformer(this.keyTrans);
        }
        if (this.leftBracket != null && this.rightBracket != null) {
            jf.withLeftAndRightBrackets(this.leftBracket.charValue(), this.rightBracket.charValue());
        }
        if (this.separator != null) {
            jf.withSeparator(this.separator.charValue());
        }
        return jf;
    }

    private void assureJsonArraySize(JsonArray jsonArray, Integer index) {
        while (index >= jsonArray.size()) {
            jsonArray.add(Json.NULL);
        }
    }

    public int hashCode() {
        int result = 27;
        result = 31 * result + this.root.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsonUnflattener)) {
            return false;
        }
        return this.root.equals((Object)((JsonUnflattener)o).root);
    }

    public String toString() {
        return "JsonUnflattener{root=" + this.root + "}";
    }
}

