/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.io.IOException;
import java.util.List;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.nodes.BaseNodesResponse;
import org.opensearch.ad.transport.ADStatsNodeResponse;
import org.opensearch.cluster.ClusterName;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;

public class ADStatsNodesResponse
extends BaseNodesResponse<ADStatsNodeResponse>
implements ToXContentObject {
    private static final String NODES_KEY = "nodes";

    public ADStatsNodesResponse(StreamInput in) throws IOException {
        super(new ClusterName(in), in.readList(ADStatsNodeResponse::readStats), in.readList(FailedNodeException::new));
    }

    public ADStatsNodesResponse(ClusterName clusterName, List<ADStatsNodeResponse> nodes, List<FailedNodeException> failures) {
        super(clusterName, nodes, failures);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
    }

    public void writeNodesTo(StreamOutput out, List<ADStatsNodeResponse> nodes) throws IOException {
        out.writeList(nodes);
    }

    public List<ADStatsNodeResponse> readNodesFrom(StreamInput in) throws IOException {
        return in.readList(ADStatsNodeResponse::readStats);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NODES_KEY);
        for (ADStatsNodeResponse adStats : this.getNodes()) {
            DiscoveryNode node = adStats.getNode();
            String nodeId = node.getId();
            builder.startObject(nodeId);
            adStats.toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }
}

