/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.node;

import java.util.Map;
import java.util.function.Supplier;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionResponse;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.TransportAction;
import org.opensearch.client.Client;
import org.opensearch.client.support.AbstractClient;
import org.opensearch.common.io.stream.NamedWriteableRegistry;
import org.opensearch.common.settings.Settings;
import org.opensearch.tasks.Task;
import org.opensearch.tasks.TaskListener;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.RemoteClusterService;

public class NodeClient
extends AbstractClient {
    private Map<ActionType, TransportAction> actions;
    private Supplier<String> localNodeId;
    private RemoteClusterService remoteClusterService;
    private NamedWriteableRegistry namedWriteableRegistry;

    public NodeClient(Settings settings, ThreadPool threadPool) {
        super(settings, threadPool);
    }

    public void initialize(Map<ActionType, TransportAction> actions, Supplier<String> localNodeId, RemoteClusterService remoteClusterService, NamedWriteableRegistry namedWriteableRegistry) {
        this.actions = actions;
        this.localNodeId = localNodeId;
        this.remoteClusterService = remoteClusterService;
        this.namedWriteableRegistry = namedWriteableRegistry;
    }

    @Override
    public void close() {
    }

    @Override
    public <Request extends ActionRequest, Response extends ActionResponse> void doExecute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        this.executeLocally(action, request, listener);
    }

    public <Request extends ActionRequest, Response extends ActionResponse> Task executeLocally(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        return this.transportAction(action).execute(request, listener);
    }

    public <Request extends ActionRequest, Response extends ActionResponse> Task executeLocally(ActionType<Response> action, Request request, TaskListener<Response> listener) {
        return this.transportAction(action).execute(request, listener);
    }

    public String getLocalNodeId() {
        return this.localNodeId.get();
    }

    private <Request extends ActionRequest, Response extends ActionResponse> TransportAction<Request, Response> transportAction(ActionType<Response> action) {
        if (this.actions == null) {
            throw new IllegalStateException("NodeClient has not been initialized");
        }
        TransportAction transportAction = this.actions.get(action);
        if (transportAction == null) {
            throw new IllegalStateException("failed to find action [" + action + "] to execute");
        }
        return transportAction;
    }

    @Override
    public Client getRemoteClusterClient(String clusterAlias) {
        return this.remoteClusterService.getRemoteClusterClient(this.threadPool(), clusterAlias);
    }

    public NamedWriteableRegistry getNamedWriteableRegistry() {
        return this.namedWriteableRegistry;
    }
}

