/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.settings;

import joptsimple.OptionSet;
import org.opensearch.cli.Terminal;
import org.opensearch.cli.UserException;
import org.opensearch.common.settings.BaseKeyStoreCommand;
import org.opensearch.common.settings.KeyStoreWrapper;
import org.opensearch.common.settings.SecureString;
import org.opensearch.env.Environment;

class ChangeKeyStorePasswordCommand
extends BaseKeyStoreCommand {
    ChangeKeyStorePasswordCommand() {
        super("Changes the password of a keystore", true);
    }

    @Override
    protected void executeCommand(Terminal terminal, OptionSet options, Environment env) throws Exception {
        try (SecureString newPassword = ChangeKeyStorePasswordCommand.readPassword(terminal, true);){
            KeyStoreWrapper keyStore = this.getKeyStore();
            keyStore.save(env.configFile(), newPassword.getChars());
            terminal.println("OpenSearch keystore password changed successfully.");
        }
        catch (SecurityException e) {
            throw new UserException(65, e.getMessage());
        }
    }
}

