/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store;

import java.io.IOException;
import java.util.function.Supplier;
import org.apache.lucene.store.Directory;
import org.opensearch.common.blobstore.BlobContainer;
import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.shard.ShardPath;
import org.opensearch.index.store.RemoteDirectory;
import org.opensearch.index.store.RemoteSegmentStoreDirectory;
import org.opensearch.plugins.IndexStorePlugin;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.repositories.Repository;
import org.opensearch.repositories.RepositoryMissingException;
import org.opensearch.repositories.blobstore.BlobStoreRepository;

public class RemoteSegmentStoreDirectoryFactory
implements IndexStorePlugin.RemoteDirectoryFactory {
    private final Supplier<RepositoriesService> repositoriesService;

    public RemoteSegmentStoreDirectoryFactory(Supplier<RepositoriesService> repositoriesService) {
        this.repositoriesService = repositoriesService;
    }

    @Override
    public Directory newDirectory(String repositoryName, IndexSettings indexSettings, ShardPath path) throws IOException {
        RemoteSegmentStoreDirectory remoteSegmentStoreDirectory;
        block9: {
            Repository repository = this.repositoriesService.get().repository(repositoryName);
            try {
                assert (repository instanceof BlobStoreRepository) : "repository should be instance of BlobStoreRepository";
                BlobPath commonBlobPath = ((BlobStoreRepository)repository).basePath();
                commonBlobPath = commonBlobPath.add(indexSettings.getIndex().getUUID()).add(String.valueOf(path.getShardId().getId())).add("segments");
                RemoteDirectory dataDirectory = this.createRemoteDirectory(repository, commonBlobPath, "data");
                RemoteDirectory metadataDirectory = this.createRemoteDirectory(repository, commonBlobPath, "metadata");
                remoteSegmentStoreDirectory = new RemoteSegmentStoreDirectory(dataDirectory, metadataDirectory);
                if (repository == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (repository != null) {
                        try {
                            repository.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RepositoryMissingException e) {
                    throw new IllegalArgumentException("Repository should be created before creating index with remote_store enabled setting", e);
                }
            }
            repository.close();
        }
        return remoteSegmentStoreDirectory;
    }

    private RemoteDirectory createRemoteDirectory(Repository repository, BlobPath commonBlobPath, String extention) {
        BlobPath extendedPath = commonBlobPath.add(extention);
        BlobContainer dataBlobContainer = ((BlobStoreRepository)repository).blobStore().blobContainer(extendedPath);
        return new RemoteDirectory(dataBlobContainer);
    }
}

