/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication.checkpoint;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.common.Nullable;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.index.shard.ShardId;

public class ReplicationCheckpoint
implements Writeable,
Comparable<ReplicationCheckpoint> {
    private final ShardId shardId;
    private final long primaryTerm;
    private final long segmentsGen;
    private final long seqNo;
    private final long segmentInfosVersion;

    public static ReplicationCheckpoint empty(ShardId shardId) {
        return new ReplicationCheckpoint(shardId);
    }

    private ReplicationCheckpoint(ShardId shardId) {
        this.shardId = shardId;
        this.primaryTerm = 0L;
        this.segmentsGen = -1L;
        this.seqNo = -1L;
        this.segmentInfosVersion = -1L;
    }

    public ReplicationCheckpoint(ShardId shardId, long primaryTerm, long segmentsGen, long seqNo, long segmentInfosVersion) {
        this.shardId = shardId;
        this.primaryTerm = primaryTerm;
        this.segmentsGen = segmentsGen;
        this.seqNo = seqNo;
        this.segmentInfosVersion = segmentInfosVersion;
    }

    public ReplicationCheckpoint(StreamInput in) throws IOException {
        this.shardId = new ShardId(in);
        this.primaryTerm = in.readLong();
        this.segmentsGen = in.readLong();
        this.seqNo = in.readLong();
        this.segmentInfosVersion = in.readLong();
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public long getSegmentsGen() {
        return this.segmentsGen;
    }

    public long getSegmentInfosVersion() {
        return this.segmentInfosVersion;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.shardId.writeTo(out);
        out.writeLong(this.primaryTerm);
        out.writeLong(this.segmentsGen);
        out.writeLong(this.seqNo);
        out.writeLong(this.segmentInfosVersion);
    }

    @Override
    public int compareTo(ReplicationCheckpoint other) {
        return this.isAheadOf(other) ? -1 : 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationCheckpoint that = (ReplicationCheckpoint)o;
        return this.primaryTerm == that.primaryTerm && this.segmentsGen == that.segmentsGen && this.seqNo == that.seqNo && this.segmentInfosVersion == that.segmentInfosVersion && Objects.equals(this.shardId, that.shardId);
    }

    public int hashCode() {
        return Objects.hash(this.shardId, this.primaryTerm, this.segmentsGen, this.seqNo);
    }

    public boolean isAheadOf(@Nullable ReplicationCheckpoint other) {
        return other == null || this.primaryTerm > other.getPrimaryTerm() || this.primaryTerm == other.getPrimaryTerm() && this.segmentInfosVersion > other.getSegmentInfosVersion();
    }

    public String toString() {
        return "ReplicationCheckpoint{shardId=" + this.shardId + ", primaryTerm=" + this.primaryTerm + ", segmentsGen=" + this.segmentsGen + ", seqNo=" + this.seqNo + ", version=" + this.segmentInfosVersion + "}";
    }
}

