/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.script;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.index.query.IntervalFilterScript;
import org.opensearch.plugins.ScriptPlugin;
import org.opensearch.script.AggregationScript;
import org.opensearch.script.BucketAggregationScript;
import org.opensearch.script.BucketAggregationSelectorScript;
import org.opensearch.script.FieldScript;
import org.opensearch.script.FilterScript;
import org.opensearch.script.IngestConditionalScript;
import org.opensearch.script.IngestScript;
import org.opensearch.script.NumberSortScript;
import org.opensearch.script.ScoreScript;
import org.opensearch.script.ScriptContext;
import org.opensearch.script.ScriptEngine;
import org.opensearch.script.ScriptService;
import org.opensearch.script.ScriptedMetricAggContexts;
import org.opensearch.script.SignificantTermsHeuristicScoreScript;
import org.opensearch.script.SimilarityScript;
import org.opensearch.script.SimilarityWeightScript;
import org.opensearch.script.StringSortScript;
import org.opensearch.script.TemplateScript;
import org.opensearch.script.TermsSetQueryScript;
import org.opensearch.script.UpdateScript;
import org.opensearch.search.aggregations.pipeline.MovingFunctionScript;

public class ScriptModule {
    public static final Map<String, ScriptContext<?>> CORE_CONTEXTS = Stream.of(FieldScript.CONTEXT, AggregationScript.CONTEXT, ScoreScript.CONTEXT, NumberSortScript.CONTEXT, StringSortScript.CONTEXT, TermsSetQueryScript.CONTEXT, UpdateScript.CONTEXT, BucketAggregationScript.CONTEXT, BucketAggregationSelectorScript.CONTEXT, SignificantTermsHeuristicScoreScript.CONTEXT, IngestScript.CONTEXT, IngestConditionalScript.CONTEXT, FilterScript.CONTEXT, SimilarityScript.CONTEXT, SimilarityWeightScript.CONTEXT, TemplateScript.CONTEXT, MovingFunctionScript.CONTEXT, ScriptedMetricAggContexts.InitScript.CONTEXT, ScriptedMetricAggContexts.MapScript.CONTEXT, ScriptedMetricAggContexts.CombineScript.CONTEXT, ScriptedMetricAggContexts.ReduceScript.CONTEXT, IntervalFilterScript.CONTEXT).collect(Collectors.toMap(c -> c.name, Function.identity()));
    public final Map<String, ScriptEngine> engines;
    public final Map<String, ScriptContext<?>> contexts;

    public ScriptModule(Settings settings, List<ScriptPlugin> scriptPlugins) {
        HashMap<String, ScriptEngine> engines = new HashMap<String, ScriptEngine>();
        HashMap contexts = new HashMap(CORE_CONTEXTS);
        for (ScriptPlugin plugin : scriptPlugins) {
            for (ScriptContext<?> context : plugin.getContexts()) {
                ScriptContext<?> oldContext = contexts.put(context.name, context);
                if (oldContext == null) continue;
                throw new IllegalArgumentException("Context name [" + context.name + "] defined twice");
            }
        }
        for (ScriptPlugin plugin : scriptPlugins) {
            ScriptEngine existing;
            ScriptEngine engine = plugin.getScriptEngine(settings, contexts.values());
            if (engine == null || (existing = engines.put(engine.getType(), engine)) == null) continue;
            throw new IllegalArgumentException("scripting language [" + engine.getType() + "] defined for engine [" + existing.getClass().getName() + "] and [" + engine.getClass().getName());
        }
        this.engines = Collections.unmodifiableMap(engines);
        this.contexts = Collections.unmodifiableMap(contexts);
    }

    public void registerClusterSettingsListeners(ScriptService scriptService, ClusterSettings clusterSettings) {
        scriptService.registerClusterSettingsListeners(clusterSettings);
    }
}

