/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.metrics.CompensatedSum;
import org.opensearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.opensearch.search.aggregations.metrics.Stats;

public class InternalStats
extends InternalNumericMetricsAggregation.MultiValue
implements Stats {
    protected final long count;
    protected final double min;
    protected final double max;
    protected final double sum;

    public InternalStats(String name, long count, double sum, double min, double max, DocValueFormat formatter, Map<String, Object> metadata) {
        super(name, metadata);
        this.count = count;
        this.sum = sum;
        this.min = min;
        this.max = max;
        this.format = formatter;
    }

    public InternalStats(StreamInput in) throws IOException {
        super(in);
        this.format = in.readNamedWriteable(DocValueFormat.class);
        this.count = in.readVLong();
        this.min = in.readDouble();
        this.max = in.readDouble();
        this.sum = in.readDouble();
    }

    @Override
    protected final void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.format);
        out.writeVLong(this.count);
        out.writeDouble(this.min);
        out.writeDouble(this.max);
        out.writeDouble(this.sum);
        this.writeOtherStatsTo(out);
    }

    protected void writeOtherStatsTo(StreamOutput out) throws IOException {
    }

    @Override
    public String getWriteableName() {
        return "stats";
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public double getMin() {
        return this.min;
    }

    @Override
    public double getMax() {
        return this.max;
    }

    @Override
    public double getAvg() {
        return this.sum / (double)this.count;
    }

    @Override
    public double getSum() {
        return this.sum;
    }

    @Override
    public String getMinAsString() {
        return this.valueAsString(Metrics.min.name());
    }

    @Override
    public String getMaxAsString() {
        return this.valueAsString(Metrics.max.name());
    }

    @Override
    public String getAvgAsString() {
        return this.valueAsString(Metrics.avg.name());
    }

    @Override
    public String getSumAsString() {
        return this.valueAsString(Metrics.sum.name());
    }

    @Override
    public double value(String name) {
        Metrics metrics = Metrics.valueOf(name);
        switch (metrics) {
            case min: {
                return this.min;
            }
            case max: {
                return this.max;
            }
            case avg: {
                return this.getAvg();
            }
            case count: {
                return this.count;
            }
            case sum: {
                return this.sum;
            }
        }
        throw new IllegalArgumentException("Unknown value [" + name + "] in common stats aggregation");
    }

    @Override
    public InternalStats reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        long count = 0L;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        CompensatedSum kahanSummation = new CompensatedSum(0.0, 0.0);
        for (InternalAggregation aggregation : aggregations) {
            InternalStats stats = (InternalStats)aggregation;
            count += stats.getCount();
            min = Math.min(min, stats.getMin());
            max = Math.max(max, stats.getMax());
            kahanSummation.add(stats.getSum());
        }
        return new InternalStats(this.name, count, kahanSummation.value(), min, max, this.format, this.getMetadata());
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("count", this.count);
        if (this.count != 0L) {
            builder.field("min", this.min);
            builder.field("max", this.max);
            builder.field("avg", this.getAvg());
            builder.field("sum", this.sum);
            if (this.format != DocValueFormat.RAW) {
                builder.field("min_as_string", this.format.format(this.min));
                builder.field("max_as_string", this.format.format(this.max));
                builder.field("avg_as_string", this.format.format(this.getAvg()));
                builder.field("sum_as_string", this.format.format(this.sum));
            }
        } else {
            builder.nullField("min");
            builder.nullField("max");
            builder.nullField("avg");
            builder.field("sum", 0.0);
        }
        this.otherStatsToXContent(builder, params);
        return builder;
    }

    protected XContentBuilder otherStatsToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.count, this.min, this.max, this.sum);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalStats other = (InternalStats)obj;
        return this.count == other.count && Double.compare(this.min, other.min) == 0 && Double.compare(this.max, other.max) == 0 && Double.compare(this.sum, other.sum) == 0;
    }

    static enum Metrics {
        count,
        sum,
        min,
        max,
        avg;


        public static Metrics resolve(String name) {
            return Metrics.valueOf(name);
        }
    }

    static class Fields {
        public static final String COUNT = "count";
        public static final String MIN = "min";
        public static final String MIN_AS_STRING = "min_as_string";
        public static final String MAX = "max";
        public static final String MAX_AS_STRING = "max_as_string";
        public static final String AVG = "avg";
        public static final String AVG_AS_STRING = "avg_as_string";
        public static final String SUM = "sum";
        public static final String SUM_AS_STRING = "sum_as_string";

        Fields() {
        }
    }
}

