/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.pipeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.opensearch.common.ParsingException;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.script.Script;
import org.opensearch.search.aggregations.PipelineAggregationBuilder;
import org.opensearch.search.aggregations.pipeline.AbstractPipelineAggregationBuilder;
import org.opensearch.search.aggregations.pipeline.BucketHelpers;
import org.opensearch.search.aggregations.pipeline.BucketSelectorPipelineAggregator;
import org.opensearch.search.aggregations.pipeline.PipelineAggregator;

public class BucketSelectorPipelineAggregationBuilder
extends AbstractPipelineAggregationBuilder<BucketSelectorPipelineAggregationBuilder> {
    public static final String NAME = "bucket_selector";
    private final Map<String, String> bucketsPathsMap;
    private final Script script;
    private BucketHelpers.GapPolicy gapPolicy = BucketHelpers.GapPolicy.SKIP;

    public BucketSelectorPipelineAggregationBuilder(String name, Map<String, String> bucketsPathsMap, Script script) {
        super(name, NAME, new TreeMap<String, String>(bucketsPathsMap).values().toArray(new String[bucketsPathsMap.size()]));
        this.bucketsPathsMap = bucketsPathsMap;
        this.script = script;
    }

    public BucketSelectorPipelineAggregationBuilder(String name, Script script, String ... bucketsPaths) {
        this(name, BucketSelectorPipelineAggregationBuilder.convertToBucketsPathMap(bucketsPaths), script);
    }

    public BucketSelectorPipelineAggregationBuilder(StreamInput in) throws IOException {
        super(in, NAME);
        this.bucketsPathsMap = in.readMap(StreamInput::readString, StreamInput::readString);
        this.script = new Script(in);
        this.gapPolicy = BucketHelpers.GapPolicy.readFrom(in);
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeMap(this.bucketsPathsMap, StreamOutput::writeString, StreamOutput::writeString);
        this.script.writeTo(out);
        this.gapPolicy.writeTo(out);
    }

    private static Map<String, String> convertToBucketsPathMap(String[] bucketsPaths) {
        HashMap<String, String> bucketsPathsMap = new HashMap<String, String>();
        for (int i = 0; i < bucketsPaths.length; ++i) {
            bucketsPathsMap.put("_value" + i, bucketsPaths[i]);
        }
        return bucketsPathsMap;
    }

    public BucketSelectorPipelineAggregationBuilder gapPolicy(BucketHelpers.GapPolicy gapPolicy) {
        if (gapPolicy == null) {
            throw new IllegalArgumentException("[gapPolicy] must not be null: [" + this.name + "]");
        }
        this.gapPolicy = gapPolicy;
        return this;
    }

    public BucketHelpers.GapPolicy gapPolicy() {
        return this.gapPolicy;
    }

    @Override
    protected PipelineAggregator createInternal(Map<String, Object> metadata) {
        return new BucketSelectorPipelineAggregator(this.name, this.bucketsPathsMap, this.script, this.gapPolicy, metadata);
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(PipelineAggregator.Parser.BUCKETS_PATH.getPreferredName(), this.bucketsPathsMap);
        builder.field(Script.SCRIPT_PARSE_FIELD.getPreferredName(), (ToXContent)this.script);
        builder.field(PipelineAggregator.Parser.GAP_POLICY.getPreferredName(), this.gapPolicy.getName());
        return builder;
    }

    public static BucketSelectorPipelineAggregationBuilder parse(String reducerName, XContentParser parser) throws IOException {
        XContentParser.Token token;
        Script script = null;
        String currentFieldName = null;
        HashMap<Object, String> bucketsPathsMap = null;
        BucketHelpers.GapPolicy gapPolicy = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (PipelineAggregator.Parser.BUCKETS_PATH.match(currentFieldName, parser.getDeprecationHandler())) {
                    bucketsPathsMap = new HashMap<Object, String>();
                    bucketsPathsMap.put("_value", parser.text());
                    continue;
                }
                if (PipelineAggregator.Parser.GAP_POLICY.match(currentFieldName, parser.getDeprecationHandler())) {
                    gapPolicy = BucketHelpers.GapPolicy.parse(parser.text(), parser.getTokenLocation());
                    continue;
                }
                if (Script.SCRIPT_PARSE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    script = Script.parse(parser);
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + token + " in [" + reducerName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (PipelineAggregator.Parser.BUCKETS_PATH.match(currentFieldName, parser.getDeprecationHandler())) {
                    ArrayList<String> paths = new ArrayList<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        String path = parser.text();
                        paths.add(path);
                    }
                    bucketsPathsMap = new HashMap();
                    for (int i = 0; i < paths.size(); ++i) {
                        bucketsPathsMap.put("_value" + i, (String)paths.get(i));
                    }
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + token + " in [" + reducerName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (Script.SCRIPT_PARSE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    script = Script.parse(parser);
                    continue;
                }
                if (PipelineAggregator.Parser.BUCKETS_PATH.match(currentFieldName, parser.getDeprecationHandler())) {
                    Map map = parser.map();
                    bucketsPathsMap = new HashMap();
                    for (Map.Entry entry : map.entrySet()) {
                        bucketsPathsMap.put((String)entry.getKey(), String.valueOf(entry.getValue()));
                    }
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + token + " in [" + reducerName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + token + " in [" + reducerName + "].", new Object[0]);
        }
        if (bucketsPathsMap == null) {
            throw new ParsingException(parser.getTokenLocation(), "Missing required field [" + PipelineAggregator.Parser.BUCKETS_PATH.getPreferredName() + "] for bucket_selector aggregation [" + reducerName + "]", new Object[0]);
        }
        if (script == null) {
            throw new ParsingException(parser.getTokenLocation(), "Missing required field [" + Script.SCRIPT_PARSE_FIELD.getPreferredName() + "] for bucket_selector aggregation [" + reducerName + "]", new Object[0]);
        }
        BucketSelectorPipelineAggregationBuilder factory = new BucketSelectorPipelineAggregationBuilder(reducerName, bucketsPathsMap, script);
        if (gapPolicy != null) {
            factory.gapPolicy(gapPolicy);
        }
        return factory;
    }

    @Override
    protected void validate(PipelineAggregationBuilder.ValidationContext context) {
        context.validateHasParent(NAME, this.name);
    }

    @Override
    protected boolean overrideBucketsPath() {
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.bucketsPathsMap, this.script, this.gapPolicy);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BucketSelectorPipelineAggregationBuilder other = (BucketSelectorPipelineAggregationBuilder)obj;
        return Objects.equals(this.bucketsPathsMap, other.bucketsPathsMap) && Objects.equals(this.script, other.script) && Objects.equals(this.gapPolicy, other.gapPolicy);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }
}

