/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.Weight;
import org.opensearch.common.lucene.MinimumScoreCollector;
import org.opensearch.common.lucene.search.FilteredCollector;
import org.opensearch.search.profile.query.InternalProfileCollector;
import org.opensearch.search.profile.query.InternalProfileCollectorManager;
import org.opensearch.search.query.EarlyTerminatingCollector;
import org.opensearch.search.query.EarlyTerminatingCollectorManager;
import org.opensearch.search.query.FilteredCollectorManager;
import org.opensearch.search.query.MinimumCollectorManager;
import org.opensearch.search.query.QueryCollectorManagerContext;
import org.opensearch.search.query.QuerySearchResult;
import org.opensearch.search.query.ReduceableSearchResult;

public abstract class QueryCollectorContext {
    private static final Collector EMPTY_COLLECTOR = new SimpleCollector(){

        public void collect(int doc) {
        }

        public ScoreMode scoreMode() {
            return ScoreMode.COMPLETE_NO_SCORES;
        }
    };
    private String profilerName;

    QueryCollectorContext(String profilerName) {
        this.profilerName = profilerName;
    }

    abstract Collector create(Collector var1) throws IOException;

    abstract CollectorManager<?, ReduceableSearchResult> createManager(CollectorManager<?, ReduceableSearchResult> var1) throws IOException;

    protected InternalProfileCollector createWithProfiler(InternalProfileCollector in) throws IOException {
        Collector collector = this.create(in);
        return new InternalProfileCollector(collector, this.profilerName, in != null ? Collections.singletonList(in) : Collections.emptyList());
    }

    protected InternalProfileCollectorManager createWithProfiler(InternalProfileCollectorManager in) throws IOException {
        CollectorManager<?, ReduceableSearchResult> manager = this.createManager(in);
        return new InternalProfileCollectorManager(manager, this.profilerName, in != null ? Collections.singletonList(in) : Collections.emptyList());
    }

    void postProcess(QuerySearchResult result) throws IOException {
    }

    static Collector createQueryCollector(List<QueryCollectorContext> collectors) throws IOException {
        Collector collector = null;
        for (QueryCollectorContext ctx : collectors) {
            collector = ctx.create(collector);
        }
        return collector;
    }

    static InternalProfileCollector createQueryCollectorWithProfiler(List<QueryCollectorContext> collectors) throws IOException {
        InternalProfileCollector collector = null;
        for (QueryCollectorContext ctx : collectors) {
            collector = ctx.createWithProfiler(collector);
        }
        return collector;
    }

    static QueryCollectorContext createMinScoreCollectorContext(final float minScore) {
        return new QueryCollectorContext("search_min_score"){

            @Override
            Collector create(Collector in) {
                return new MinimumScoreCollector(in, minScore);
            }

            @Override
            CollectorManager<?, ReduceableSearchResult> createManager(CollectorManager<?, ReduceableSearchResult> in) throws IOException {
                return new MinimumCollectorManager(in, minScore);
            }
        };
    }

    static QueryCollectorContext createFilteredCollectorContext(final IndexSearcher searcher, final Query query) {
        return new QueryCollectorContext("search_post_filter"){

            @Override
            Collector create(Collector in) throws IOException {
                Weight filterWeight = searcher.createWeight(searcher.rewrite(query), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
                return new FilteredCollector(in, filterWeight);
            }

            @Override
            CollectorManager<?, ReduceableSearchResult> createManager(CollectorManager<?, ReduceableSearchResult> in) throws IOException {
                Weight filterWeight = searcher.createWeight(searcher.rewrite(query), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
                return new FilteredCollectorManager(in, filterWeight);
            }
        };
    }

    static QueryCollectorContext createMultiCollectorContext(final Collection<CollectorManager<? extends Collector, ReduceableSearchResult>> subs) {
        return new QueryCollectorContext("search_multi"){

            @Override
            Collector create(Collector in) throws IOException {
                ArrayList<Collector> subCollectors = new ArrayList<Collector>();
                subCollectors.add(in);
                for (CollectorManager manager : subs) {
                    subCollectors.add(manager.newCollector());
                }
                return MultiCollector.wrap(subCollectors);
            }

            @Override
            protected InternalProfileCollector createWithProfiler(InternalProfileCollector in) throws IOException {
                ArrayList<InternalProfileCollector> subCollectors = new ArrayList<InternalProfileCollector>();
                subCollectors.add(in);
                for (CollectorManager manager : subs) {
                    Collector collector = manager.newCollector();
                    if (!(collector instanceof InternalProfileCollector)) {
                        throw new IllegalArgumentException("non-profiling collector");
                    }
                    subCollectors.add((InternalProfileCollector)collector);
                }
                Collector collector = MultiCollector.wrap(subCollectors);
                return new InternalProfileCollector(collector, "search_multi", subCollectors);
            }

            CollectorManager<? extends Collector, ReduceableSearchResult> createManager(CollectorManager<? extends Collector, ReduceableSearchResult> in) throws IOException {
                ArrayList<CollectorManager<? extends Collector, ReduceableSearchResult>> managers = new ArrayList<CollectorManager<? extends Collector, ReduceableSearchResult>>();
                managers.add(in);
                managers.addAll(subs);
                return QueryCollectorManagerContext.createOpaqueCollectorManager(managers);
            }
        };
    }

    static QueryCollectorContext createEarlyTerminationCollectorContext(final int numHits) {
        return new QueryCollectorContext("search_terminate_after_count"){
            private Collector collector;

            @Override
            Collector create(Collector in) {
                assert (this.collector == null);
                ArrayList<EarlyTerminatingCollector> subCollectors = new ArrayList<EarlyTerminatingCollector>();
                subCollectors.add(new EarlyTerminatingCollector(EMPTY_COLLECTOR, numHits, true));
                subCollectors.add((EarlyTerminatingCollector)in);
                this.collector = MultiCollector.wrap(subCollectors);
                return this.collector;
            }

            CollectorManager<? extends Collector, ReduceableSearchResult> createManager(CollectorManager<? extends Collector, ReduceableSearchResult> in) throws IOException {
                return new EarlyTerminatingCollectorManager<Collector>(in, numHits, true);
            }
        };
    }
}

